#!/usr/bin/env node

import {spawnSync} from "node:child_process"
import path, {dirname} from "node:path";
import {fileURLToPath} from "node:url";

const [, , ...args] = process.argv;
const fileDir = dirname(fileURLToPath(import.meta.url))
const manifestPath = path.join(fileDir, "Cargo.toml")

spawnSync("cargo ")

// FIXME windows
// this is run in the directory of dependent project and we do want to run the end program there but we need to invoke cargo in the directory where wasm-pack is
// fortunately the target dir is resolved relative to the manifest path, not next to the cwd so this is enough.
const result = spawnSync("cargo", ["run", "--manifest-path", manifestPath, "--", ...args], {cwd: process.cwd(), stdio: "inherit"})

if (result.error) {
	console.error(result.error);
	process.exit(1);
}

process.exit(result.status);