"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./lodash");
function proxySafeCloneDeepWith(thing, callback) {
    return lodash_1.default.cloneDeepWith(thing, (val, key, obj, stack) => {
        if (isSafeWithProxy(key)) {
            return callback(val, key, obj, stack);
        }
    });
}
exports.default = proxySafeCloneDeepWith;
function isSafeWithProxy(key) {
    return key &&
        key !== 'constructor' &&
        (!key.toString || key.toString() !== 'Symbol(Symbol.toStringTag)');
}
