"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ensure_promise_1 = require("../log/ensure-promise");
function chainStubbing(double, completeStubbing) {
    return {
        thenReturn(...stubbedValues) {
            completeStubbing('thenReturn', stubbedValues);
            return double.fake;
        },
        thenCallback(...stubbedValues) {
            completeStubbing('thenCallback', stubbedValues);
            return double.fake;
        },
        thenDo(...stubbedActions) {
            completeStubbing('thenDo', stubbedActions);
            return double.fake;
        },
        thenThrow(...stubbedErrors) {
            completeStubbing('thenThrow', stubbedErrors);
            return double.fake;
        },
        thenResolve(...stubbedValues) {
            (0, ensure_promise_1.default)('warn');
            completeStubbing('thenResolve', stubbedValues);
            return double.fake;
        },
        thenReject(...stubbedErrors) {
            (0, ensure_promise_1.default)('warn');
            completeStubbing('thenReject', stubbedErrors);
            return double.fake;
        }
    };
}
exports.default = chainStubbing;
