"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const pop_demonstration_1 = require("./pop-demonstration");
const did_call_occur_1 = require("./did-call-occur");
const notify_satisfied_matchers_1 = require("./notify-satisfied-matchers");
const warn_if_also_stubbed_1 = require("./warn-if-also-stubbed");
const fail_1 = require("./fail");
function verify(__userInvokesDemonstrationHere__, config) {
    const { double, call } = (0, pop_demonstration_1.default)();
    if ((0, did_call_occur_1.default)(double, call, config)) {
        (0, notify_satisfied_matchers_1.default)(double, call, config);
        (0, warn_if_also_stubbed_1.default)(double, call, config);
    }
    else {
        (0, fail_1.default)(double, call, config);
    }
}
exports.default = verify;
