"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../wrap/lodash");
const is_matcher_1 = require("../matchers/is-matcher");
const stringifyObject = require("stringify-object-es5");
exports.default = (anything) => {
    if (lodash_1.default.isString(anything)) {
        return stringifyString(anything);
    }
    else if ((0, is_matcher_1.default)(anything)) {
        return anything.__name;
    }
    else if (anything && anything[Symbol('__is_proxy')]) {
        return anything.toString();
    }
    else {
        return stringifyObject(anything, {
            indent: '  ',
            singleQuotes: false,
            inlineCharacterLimit: 65,
            transform(obj, prop, originalResult) {
                if ((0, is_matcher_1.default)(obj[prop])) {
                    return obj[prop].__name;
                }
                else {
                    return originalResult;
                }
            }
        });
    }
};
const stringifyString = (string) => lodash_1.default.includes(string, '\n')
    ? `"""\n${string}\n"""`
    : `"${string.replace(/"/g, '\\"')}"`;
