"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../wrap/lodash");
const events_1 = require("events");
const storeEmitter = new events_1.EventEmitter();
let globalStore = [];
const store = {
    onReset(func) {
        storeEmitter.on('reset', func);
    },
    reset() {
        globalStore = [];
        storeEmitter.emit('reset');
    },
    for(testDouble, createIfNew = true) {
        const entry = lodash_1.default.find(globalStore, e => testDouble === e.testDouble || testDouble === e.alias);
        if (entry) {
            return entry;
        }
        else if (createIfNew) {
            return lodash_1.default.tap({
                testDouble,
                stubbings: [],
                calls: [],
                verifications: []
            }, function (newEntry) {
                return globalStore.push(newEntry);
            });
        }
    },
    registerAlias(testDouble, alias) {
        store.for(testDouble).alias = alias;
    }
};
exports.default = store;
