"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../wrap/lodash");
const args_match_1 = require("../args-match");
const clone_deep_if_possible_1 = require("../clone-deep-if-possible");
const index_1 = require("./index");
let callHistory = []; // <-- remember this to pop our DSL of when(<call>)/verify(<call>)
index_1.default.onReset(() => { callHistory = []; });
exports.default = {
    log(testDouble, args, context) {
        index_1.default.for(testDouble).calls.push({ args, context, cloneArgs: (0, clone_deep_if_possible_1.default)(args) });
        return callHistory.push({ testDouble, args, context });
    },
    pop() {
        return lodash_1.default.tap(callHistory.pop(), function (call) {
            if (call != null) {
                index_1.default.for(call.testDouble).calls.pop();
            }
        });
    },
    wasInvoked(testDouble, args, config) {
        const matchingInvocationCount = this.where(testDouble, args, config).length;
        if (config.times != null) {
            return matchingInvocationCount === config.times;
        }
        else {
            return matchingInvocationCount > 0;
        }
    },
    where(testDouble, args, config) {
        return lodash_1.default.filter(index_1.default.for(testDouble).calls, function (call) {
            const pastArgs = config.cloneArgs ? call.cloneArgs : call.args;
            return (0, args_match_1.default)(args, pastArgs, config);
        });
    },
    for(testDouble) {
        return index_1.default.for(testDouble).calls;
    }
};
