"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = require("../config");
const ensure_promise_1 = require("../log/ensure-promise");
const call_later_1 = require("../share/call-later");
function createPromise(stubbing, willResolve) {
    const Promise = (0, config_1.default)().promiseConstructor;
    (0, ensure_promise_1.default)('error');
    const value = stubbing.currentOutcome;
    return new Promise((resolve, reject) => {
        (0, call_later_1.default)(() => willResolve ? resolve(value) : reject(value), [value], stubbing.options.defer, stubbing.options.delay);
    });
}
exports.default = createPromise;
