"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../wrap/lodash");
function callLater(func, args, defer, delay) {
    if (delay) {
        lodash_1.default.delay(func, delay, ...args);
    }
    else if (defer) {
        lodash_1.default.defer(func, ...args);
    }
    else {
        func(...args);
    }
}
exports.default = callLater;
