"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../wrap/lodash");
const is_callback_1 = require("../matchers/is-callback");
const call_later_1 = require("../share/call-later");
function invokeCallbacks(stubbing, call) {
    lodash_1.default.each(stubbing.args, (stubbingArg, i) => {
        if ((0, is_callback_1.default)(stubbingArg)) {
            const actualCallback = call.args[i];
            (0, call_later_1.default)(actualCallback, callbackArgs(stubbing, stubbingArg), stubbing.options.defer, stubbing.options.delay);
        }
    });
}
exports.default = invokeCallbacks;
function callbackArgs(stubbing, callbackMatcher) {
    if (callbackMatcher.args != null) {
        return callbackMatcher.args;
    }
    else if (stubbing.type === 'thenCallback') {
        return stubbing.outcomes;
    }
    else {
        return [];
    }
}
