"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const find_last_stubbing_match_1 = require("./find-last-stubbing-match");
const invoke_callbacks_1 = require("./invoke-callbacks");
const notify_after_satisfaction_1 = require("../matchers/notify-after-satisfaction");
const deliver_outcome_1 = require("./deliver-outcome");
function satisfy(double, call) {
    const stubbing = (0, find_last_stubbing_match_1.default)(double, call);
    if (stubbing) {
        stubbing.addSatisfyingCall(call);
        (0, invoke_callbacks_1.default)(stubbing, call);
        (0, notify_after_satisfaction_1.default)(stubbing.args, call.args);
        return (0, deliver_outcome_1.default)(stubbing, call);
    }
}
exports.default = satisfy;
