"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./wrap/lodash");
const quibble = require("quibble");
const store_1 = require("./store");
const onResetHandlers = [];
let onNextResetHandlers = [];
exports.default = lodash_1.default.tap(() => {
    store_1.default.reset();
    quibble.reset();
    lodash_1.default.each(onResetHandlers, (resetHandler) => resetHandler());
    lodash_1.default.each(onNextResetHandlers, (resetHandler) => resetHandler());
    onNextResetHandlers = [];
}, (reset) => {
    reset.onReset = (func) => onResetHandlers.push(func);
    reset.onNextReset = (func) => onNextResetHandlers.push(func);
});
