"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceEsModule = void 0;
const quibble = require("quibble");
const imitate_1 = require("../../imitate");
const jest_module_1 = require("./jest-module");
const require_actual_1 = require("./require-actual");
const fake_name_1 = require("./fake-name");
quibble.ignoreCallsFromThisFile();
function replaceCjsModule(path, stub) {
    if (typeof jest === 'object')
        return (0, jest_module_1.default)(...arguments);
    if (arguments.length > 1) {
        return quibble(path, stub);
    }
    const realThing = (0, require_actual_1.default)(path);
    const fakeThing = (0, imitate_1.default)(realThing, (0, fake_name_1.default)(path, realThing));
    quibble(path, fakeThing);
    return fakeThing;
}
exports.default = replaceCjsModule;
async function replaceEsModule(path, namedExportsStub, defaultExportStub) {
    if (typeof jest === 'object') {
        throw new Error(`stubbing ES modules (${path}) under Jest is not yet supported`);
    }
    if (arguments.length > 1) {
        return quibble.esm(path, namedExportsStub, defaultExportStub);
    }
    const { modulePath, module } = await quibble.esmImportWithPath(path);
    const _a = (0, imitate_1.default)(module, (0, fake_name_1.default)(path, module)), { default: fakeDefaultExport = undefined } = _a, fakeNamedExports = __rest(_a, ["default"]);
    await quibble.esm(modulePath, fakeNamedExports, fakeDefaultExport);
    return Object.assign({ default: fakeDefaultExport }, fakeNamedExports);
}
exports.replaceEsModule = replaceEsModule;
