"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceEsm = void 0;
const lodash_1 = require("../wrap/lodash");
const quibble = require("quibble");
const module_1 = require("./module");
const property_1 = require("./property");
const can_register_loader_1 = require("../can-register-loader");
quibble.ignoreCallsFromThisFile();
function default_1(target) {
    if (lodash_1.default.isString(target)) {
        return (0, module_1.default)(...arguments);
    }
    else {
        return (0, property_1.default)(...arguments);
    }
}
exports.default = default_1;
function replaceEsm(_modulePath, _namedExportReplacement, _defaultExportReplacement) {
    if (!(0, can_register_loader_1.canRegisterLoader)() && !quibble.isLoaderLoaded()) {
        throw new Error('testdouble ESM loader not loaded. You cannot replace ES modules without a loader. Run node with `--loader=testdouble`.');
    }
    // Sending arguments instead of the above arguments is crucial because `replaceEsModule`
    // uses arguments.length to figure out what to do.
    return (0, module_1.replaceEsModule)(...arguments);
}
exports.replaceEsm = replaceEsm;
