"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../wrap/lodash");
const arguments_1 = require("../stringify/arguments");
exports.default = config => (...matcherArgs) => lodash_1.default.tap({
    __name: nameFor(config, matcherArgs),
    __matches(actualArg) {
        return config.matches(matcherArgs, actualArg);
    }
}, (matcherInstance) => {
    matcherInstance.__matches.afterSatisfaction = (actualArg) => {
        lodash_1.default.invoke(config, 'afterSatisfaction', matcherArgs, actualArg);
    };
    lodash_1.default.invoke(config, 'onCreate', matcherInstance, matcherArgs);
});
const nameFor = (config, matcherArgs) => {
    if (lodash_1.default.isFunction(config.name)) {
        return config.name(matcherArgs);
    }
    else if (config.name != null) {
        return `${config.name}(${(0, arguments_1.default)(matcherArgs)})`;
    }
    else {
        return `[Matcher for (${(0, arguments_1.default)(matcherArgs)})]`;
    }
};
