"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../../wrap/lodash");
const create_1 = require("../create");
const arguments_1 = require("../../stringify/arguments");
exports.default = (0, create_1.default)({
    name(matcherArgs) {
        const desc = lodash_1.default.get(matcherArgs[0], 'name') || (0, arguments_1.default)(matcherArgs);
        return `isA(${desc})`;
    },
    matches(matcherArgs, actual) {
        const type = matcherArgs[0];
        if (type === Number) {
            return lodash_1.default.isNumber(actual);
        }
        else if (type === String) {
            return lodash_1.default.isString(actual);
        }
        else if (type === Boolean) {
            return lodash_1.default.isBoolean(actual);
        }
        else {
            return actual instanceof type;
        }
    }
});
