"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = require("../config");
const log_1 = require("../log");
const MESSAGES = {
    warn: `\
no promise constructor is set, so this \`thenResolve\` or \`thenReject\` stubbing
will fail if it's satisfied by an invocation on the test double. You can tell
testdouble.js which promise constructor to use with \`td.config\`, like so:`,
    error: `\
no promise constructor is set (perhaps this runtime lacks a native Promise
function?), which means this stubbing can't return a promise to your
subject under test, resulting in this error. To resolve the issue, set
a promise constructor with \`td.config\`, like this:`
};
function ensurePromise(level) {
    if ((0, config_1.default)().promiseConstructor == null) {
        log_1.default[level]('td.when', `\
${MESSAGES[level]}

  td.config({
    promiseConstructor: require('bluebird')
  })\
`);
    }
}
exports.default = ensurePromise;
