"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = require("./config");
exports.default = {
    warn(func, msg, url) {
        if (!(0, config_1.default)().ignoreWarnings && typeof console === 'object' && console.warn) {
            console.warn(`Warning: testdouble.js - ${func} - ${msg}${withUrl(url)}`);
        }
    },
    error(func, msg, url) {
        if (!(0, config_1.default)().suppressErrors) {
            throw new Error(`Error: testdouble.js - ${func} - ${msg}${withUrl(url)}`);
        }
    },
    fail(msg) {
        throw new Error(msg);
    }
};
const withUrl = (url) => url != null
    ? ` (see: ${url} )`
    : '';
