"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("../../wrap/lodash");
const is_fakeable_1 = require("./is-fakeable");
const gather_props_1 = require("./gather-props");
const copy_props_1 = require("./copy-props");
const chain_prototype_1 = require("./chain-prototype");
exports.default = (original, target, overwriteChild) => {
    if (!(0, is_fakeable_1.default)(target))
        return;
    if (lodash_1.default.isArray(target)) {
        lodash_1.default.each(original, (item, index) => target.push(overwriteChild(item, `[${index}]`)));
    }
    else {
        (0, copy_props_1.default)(target, (0, gather_props_1.default)(original), (name, originalValue) => (0, chain_prototype_1.default)(original, target, name, originalValue, overwriteChild(originalValue, `.${name}`)));
    }
};
