"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const is_fakeable_1 = require("./is-fakeable");
const is_native_prototype_1 = require("./is-native-prototype");
function gatherProps(thing) {
    const props = {};
    while ((0, is_fakeable_1.default)(thing) && !(0, is_native_prototype_1.default)(thing)) {
        Object.getOwnPropertyNames(thing).forEach((propName) => {
            if (!props[propName] && propName !== 'constructor') {
                props[propName] = Object.getOwnPropertyDescriptor(thing, propName);
            }
        });
        thing = Object.getPrototypeOf(thing);
    }
    return props;
}
exports.default = gatherProps;
