"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const initialize_names_1 = require("./initialize-names");
const create_imitation_1 = require("./create-imitation");
const overwrite_children_1 = require("./overwrite-children");
function imitate(original, names, encounteredObjects = new Map()) {
    if (encounteredObjects.has(original))
        return encounteredObjects.get(original);
    names = (0, initialize_names_1.default)(original, names);
    const target = (0, create_imitation_1.default)(original, names);
    encounteredObjects.set(original, target);
    (0, overwrite_children_1.default)(original, target, (originalValue, name) => imitate(originalValue, names.concat(name), encounteredObjects));
    return target;
}
exports.default = imitate;
