"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./wrap/lodash");
const calls_1 = require("./store/calls");
const store_1 = require("./store");
const stubbings_1 = require("./store/stubbings");
const imitate_1 = require("./imitate");
function func(nameOrFunc, __optionalName) {
    return lodash_1.default.isFunction(nameOrFunc)
        ? (0, imitate_1.default)(nameOrFunc)
        : createTestDoubleNamed(nameOrFunc || __optionalName);
}
exports.default = func;
const createTestDoubleNamed = function (name) {
    return lodash_1.default.tap(createTestDoubleFunction(), (testDouble) => {
        const entry = store_1.default.for(testDouble, true);
        if (name != null) {
            entry.name = name;
            testDouble.toString = () => `[test double for "${name}"]`;
        }
        else {
            testDouble.toString = () => '[test double (unnamed)]';
        }
    });
};
const createTestDoubleFunction = function () {
    return function testDouble(...args) {
        calls_1.default.log(testDouble, args, this);
        return stubbings_1.default.invoke(testDouble, args, this);
    };
};
