"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./wrap/lodash");
const function_1 = require("./function");
const imitate_1 = require("./imitate");
exports.default = (typeOrNames) => lodash_1.default.isFunction(typeOrNames)
    ? (0, imitate_1.default)(typeOrNames)
    : fakeConstructorFromNames(typeOrNames);
const fakeConstructorFromNames = (funcNames) => {
    return lodash_1.default.tap((0, function_1.default)('(unnamed constructor)'), (fakeConstructor) => {
        fakeConstructor.prototype.toString = () => '[test double instance of constructor]';
        lodash_1.default.each(funcNames, (funcName) => {
            fakeConstructor.prototype[funcName] = (0, function_1.default)(`#${String(funcName)}`);
        });
    });
};
