"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./wrap/lodash");
const log_1 = require("./log");
const anything_1 = require("./stringify/anything");
const DEFAULTS = {
    ignoreWarnings: false,
    promiseConstructor: Promise,
    suppressErrors: false
};
const DELETED_OPTIONS = ['extendWhenReplacingConstructors'];
let configData = lodash_1.default.extend({}, DEFAULTS);
exports.default = lodash_1.default.tap((overrides) => {
    deleteDeletedOptions(overrides);
    ensureOverridesExist(overrides);
    return lodash_1.default.extend(configData, overrides);
}, (config) => {
    config.reset = () => {
        configData = lodash_1.default.extend({}, DEFAULTS);
    };
});
const deleteDeletedOptions = (overrides) => {
    lodash_1.default.each(overrides, (val, key) => {
        if (lodash_1.default.includes(DELETED_OPTIONS, key)) {
            log_1.default.warn('td.config', `"${key}" is no longer a valid configuration key. Remove it from your calls to td.config() or it may throw an error in the future. For more information, try hunting around our GitHub repo for it:\n\n  https://github.com/testdouble/testdouble.js/search?q=${key}`);
            delete overrides[key];
        }
    });
};
const ensureOverridesExist = (overrides) => {
    lodash_1.default.each(overrides, (val, key) => {
        if (!Object.prototype.hasOwnProperty.call(configData, key)) {
            log_1.default.error('td.config', `"${key}" is not a valid configuration key (valid keys are: ${(0, anything_1.default)(lodash_1.default.keys(configData))})`);
        }
    });
};
