"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./wrap/lodash");
const create_1 = require("./matchers/create");
const callback = (0, create_1.default)({
    name: 'callback',
    matches(matcherArgs, actual) {
        return lodash_1.default.isFunction(actual);
    },
    onCreate(matcherInstance, matcherArgs) {
        matcherInstance.args = matcherArgs;
        matcherInstance.__testdouble_callback = true;
    }
});
// Make callback itself quack like a matcher for its non-invoked use case.
callback.__name = 'callback';
callback.__matches = lodash_1.default.isFunction;
exports.default = callback;
