"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("./wrap/lodash");
const is_matcher_1 = require("./matchers/is-matcher");
exports.default = (expectedArgs, actualArgs, config = {}) => {
    if (arityMismatch(expectedArgs, actualArgs, config)) {
        return false;
    }
    else if (config.allowMatchers !== false) {
        return equalsWithMatchers(expectedArgs, actualArgs);
    }
    else {
        return lodash_1.default.isEqual(expectedArgs, actualArgs);
    }
};
const arityMismatch = (expectedArgs, actualArgs, config) => expectedArgs.length !== actualArgs.length && !config.ignoreExtraArgs;
const equalsWithMatchers = (expectedArgs, actualArgs) => lodash_1.default.every(expectedArgs, (expectedArg, key) => argumentMatchesExpectation(expectedArg, actualArgs[key]));
const argumentMatchesExpectation = (expectedArg, actualArg) => {
    if ((0, is_matcher_1.default)(expectedArg)) {
        return matcherTestFor(expectedArg)(actualArg);
    }
    else {
        return lodash_1.default.isEqualWith(expectedArg, actualArg, (expectedEl, actualEl) => {
            if ((0, is_matcher_1.default)(expectedEl)) {
                return matcherTestFor(expectedEl)(actualEl);
            }
        });
    }
};
const matcherTestFor = (matcher) => matcher.__matches;
