import { __commonJS, __toESM } from "./shared/chunk--iN_1bjD.mjs";
import { PluginContextData, bindingifyPlugin, init_bindingify_plugin, init_plugin_context_data } from "./shared/src-Cv4_zurW.mjs";
import { require_binding } from "./shared/parse-ast-index-BHkdbivO.mjs";
import "./shared/misc-DGAe2XOW.mjs";
import { parentPort, workerData } from "node:worker_threads";

//#region src/parallel-plugin-worker.ts
var require_parallel_plugin_worker = __commonJS({ "src/parallel-plugin-worker.ts"() {
	var import_binding = __toESM(require_binding());
	init_bindingify_plugin();
	init_plugin_context_data();
	const { registryId, pluginInfos, threadNumber } = workerData;
	(async () => {
		try {
			const plugins = await Promise.all(pluginInfos.map(async (pluginInfo) => {
				const pluginModule = await import(pluginInfo.fileUrl);
				const definePluginImpl = pluginModule.default;
				const plugin = await definePluginImpl(pluginInfo.options, { threadNumber });
				return {
					index: pluginInfo.index,
					plugin: bindingifyPlugin(plugin, {}, {}, new PluginContextData(), [], () => {}, "info", false)
				};
			}));
			(0, import_binding.registerPlugins)(registryId, plugins);
			parentPort.postMessage({ type: "success" });
		} catch (error) {
			parentPort.postMessage({
				type: "error",
				error
			});
		} finally {
			parentPort.unref();
		}
	})();
} });

//#endregion
export default require_parallel_plugin_worker();
