<!--meta-description
List of especially notable contributors to Mithril.js
-->

# Credits

Mithril.js was originally written by Leo Horie, but it is where it is today thanks to the hard work and great ideas of many people.

Special thanks to:

- Pat Cavit, who exposed most of the public API for Mithril.js 1.0, brought in test coverage and automated the publishing process
- Claudia Meadows, who brought in linting, modernized the test suite and has been a strong voice in design discussions
- Zoli Kahan, who replaced the original Promise implementation with one that actually worked properly
- Alec Embke, who single-handedly wrote the JSON-P implementation
- Barney Carroll, who suggested many great ideas and relentlessly pushed Mithril.js to the limit to uncover design issues prior to Mithril.js 1.0
- Dominic Gannaway, who offered insanely meticulous technical insight into rendering performance
- Boris Letocha, whose search space reduction algorithm is the basis for Mithril.js' virtual DOM engine
- Joel Richard, whose monomorphic virtual DOM structure is the basis for Mithril.js' vnode implementation
- Simon Friis Vindum, whose open source work was an inspiration to many design decisions for Mithril.js 1.0
- Boris Kaul, for his awesome work on the benchmarking tools used to develop Mithril.js
- Leon Sorokin, for writing a DOM instrumentation tool that helped improve performance in Mithril.js 1.0
- Jordan Walke, whose work on React was prior art to the implementation of keys in Mithril.js
- Pierre-Yves Gérardy, who consistently makes high quality contributions
- Gyandeep Singh, who contributed significant IE performance improvements

Other people who also deserve recognition:

- Arthur Clemens - creator of [Polythene](https://github.com/ArthurClemens/Polythene) and the [HTML-to-Mithril converter](https://arthurclemens.github.io/mithril-template-converter/index.html)
- Stephan Hoyer - creator of [mithril-node-render](https://github.com/StephanHoyer/mithril-node-render), [mithril-query](https://github.com/StephanHoyer/mithril-query) and [mithril-source-hint](https://github.com/StephanHoyer/mithril-source-hint)
- the countless people who have reported and fixed bugs, participated in discussions, and helped promote Mithril.js
