# Mithril.js

[![npm Version](https://img.shields.io/npm/v/mithril.svg)](https://www.npmjs.com/package/mithril) &nbsp;
[![License](https://img.shields.io/npm/l/mithril.svg)](https://github.com/MithrilJS/mithril.js/blob/next/LICENSE) &nbsp;
[![npm Downloads](https://img.shields.io/npm/dm/mithril.svg)](https://www.npmjs.com/package/mithril) &nbsp;
[![Build Status](https://img.shields.io/travis/MithrilJS/mithril.js/next.svg?colorB=brightgreen)](https://www.npmjs.com/package/mithril) &nbsp;
[![Donate at OpenCollective](https://img.shields.io/opencollective/all/mithriljs.svg?colorB=brightgreen)](https://opencollective.com/mithriljs) &nbsp;
[![Zulip, join chat](https://img.shields.io/badge/zulip-join_chat-brightgreen.svg)](https://mithril.zulipchat.com/)

- [What is Mithril.js?](#what-is-mithriljs?)
- [Installation](#installation)
- [Documentation](#documentation)
- [Getting Help](#getting-help)
- [Contributing](#contributing)

## What is Mithril.js?

A modern client-side JavaScript framework for building Single Page Applications. It's small (<!-- size -->10.05 KB<!-- /size --> gzipped), fast and provides routing and XHR utilities out of the box.

Mithril.js is used by companies like Vimeo and Nike, and open source platforms like Lichess 👍.

Mithril.js supports IE11, Firefox ESR, and the last two versions of Firefox, Edge, Safari, and Chrome. No polyfills required. 👌

## Installation

### CDN

```html
<!-- Development: whichever you prefer -->
<script src="https://unpkg.com/mithril/mithril.js"></script>
<script src="https://cdn.jsdelivr.net/npm/mithril/mithril.js"></script>

<!-- Production: whichever you prefer -->
<script src="https://unpkg.com/mithril/mithril.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/mithril/mithril.min.js"></script>
```

### npm

```bash
npm install mithril --save
```

The ["Getting started" guide](https://mithril.js.org/#getting-started) is a good place to start learning how to use Mithril.js.

TypeScript type definitions are available from DefinitelyTyped. They can be installed with:

```bash
$ npm install @types/mithril --save-dev
```

## Documentation

Documentation lives on [mithril.js.org](https://mithril.js.org).

You may be interested in the [API Docs](https://mithril.js.org/api.html), a [Simple Application](https://mithril.js.org/simple-application.html), or perhaps some [Examples](https://mithril.js.org/examples.html).

## Getting Help

Mithril.js has an active & welcoming community on [Zulip](https://mithril.zulipchat.com/), or feel free to ask questions on [Stack Overflow](https://stackoverflow.com/questions/tagged/mithril.js) using the `mithril.js` tag.

## Contributing

There's a [Contributing FAQ](https://mithril.js.org/contributing.html) on the Mithril.js site that hopefully helps, but if not definitely hop into the [Zulip stream](https://mithril.zulipchat.com/) and ask away!

---

Thanks for reading!

🎁
