import { PropertyType } from "./enums";
/**
 * A property inside the MSG file
 */
export declare class Property {
    id: number;
    type: PropertyType;
    _flags: number;
    _multiValue: boolean;
    _data: Uint8Array;
    constructor(obj: {
        id: number;
        type: PropertyType;
        data: Uint8Array;
        multiValue?: boolean;
        flags?: number;
    });
    name(): string;
    shortName(): string;
    flagsCollection(): Array<number>;
    asInt(): number;
    asSingle(): number;
    asDouble(): number;
    asDecimal(): number;
    asDateTime(): Date;
    asBool(): boolean;
    asLong(): number;
    asString(): string;
    asGuid(): Uint8Array;
    asBinary(): Uint8Array;
}
