import { RfcMailAddress } from "./rfc_mail_address";
import { Received } from "./received";
import { ContentTransferEncoding, MailPriority } from "../../enums";
import type { ContentDisposition, ContentType } from "./header_field_parser";
declare type HeaderDict = Record<string, Array<string>>;
export declare function parseMessageHeaders(rawHeaders: string): HeaderDict;
export declare class MessageHeader {
    /**    Contains all the headers as a map */
    raw: HeaderDict;
    custom: HeaderDict;
    contentDescription: string | null | undefined;
    contentId: string | null | undefined;
    keywords: Array<string>;
    dispositionNotificationTo: Array<RfcMailAddress>;
    received: Array<Received>;
    importance: MailPriority;
    contentTransferEncoding: ContentTransferEncoding;
    to: Array<RfcMailAddress>;
    cc: Array<RfcMailAddress>;
    bcc: Array<RfcMailAddress>;
    from: RfcMailAddress;
    replyTo: RfcMailAddress;
    inReplyTo: Array<string>;
    references: Array<string>;
    sender: RfcMailAddress;
    contentType: ContentType;
    contentDisposition: ContentDisposition;
    date: string;
    dateSent: number;
    messageId: string;
    mimeVersion: string;
    returnPath: RfcMailAddress;
    subject: string;
    _clear(): void;
    constructor(rawHeaders: HeaderDict);
    _parseHeaders(raw: HeaderDict): void;
    _parseHeader(name: string, value: string): void;
}
export {};
