import { CFBStorage } from "./cfb_storage";
import { MessageClass, MessageIconIndex } from "./enums";
import type { PropertyTag } from "./property_tags";
import { TopLevelProperties } from "./streams/top_level_properties";
import { NamedProperties } from "./streams/named_properties";
/**
 * base class for all MSG files
 */
export declare class Message {
    _saved: boolean;
    iconIndex: MessageIconIndex;
    _topLevelProperties: TopLevelProperties;
    _namedProperties: NamedProperties;
    _storage: CFBStorage;
    _messageClass: MessageClass;
    _messageSize: number;
    constructor();
    _save(): void;
    /**
     * writes the Message to an underlying CFB
     * structure and returns a serialized
     * representation
     *
     */
    saveToBuffer(): Uint8Array;
    addProperty(propertyTag: PropertyTag, value: any, flags?: number): void;
}
