import { Message } from "./message";
import { Recipients } from "./address/recipients";
import { MessageImportance, MessageEditorFormat, MessagePriority } from "./enums";
import { Receiving } from "./address/receiving";
import type { MessageHeader } from "./mime/header/message_header";
import { Sender } from "./address/sender";
import { Representing } from "./address/representing";
import { Attachments } from "./attachments";
import { ReceivingRepresenting } from "./address/receiving_representing";
import { Attachment } from "./attachment";
export declare type Recipient = {
    address: string;
    name?: string;
};
export declare class Email extends Message {
    recipients: Recipients;
    replyToRecipients: Recipients;
    attachments: Attachments;
    _subject: string;
    _sender: Sender;
    _representing: Representing;
    _receiving: Receiving;
    _receivingRepresenting: ReceivingRepresenting;
    subjectPrefix: string;
    _subjectNormalized: string;
    priority: MessagePriority;
    importance: MessageImportance;
    _bodyText: string;
    _bodyHtml: string;
    _bodyRtf: string;
    bodyRtfCompressed: boolean;
    _sentOn: Date | null | undefined;
    _receivedOn: Date | null | undefined;
    internetMessageId: string;
    internetReferences: string;
    inReplyToId: string;
    transportMessageHeadersText: string | null | undefined;
    transportMessageHeaders: MessageHeader | null | undefined;
    draft: boolean;
    readReceipt: boolean;
    messageEditorFormat: MessageEditorFormat;
    constructor(draft?: boolean, readReceipt?: boolean);
    sender(address: string, displayName?: string): Email;
    bodyHtml(html: string): Email;
    bodyText(txt: string): Email;
    bodyFormat(fmt: MessageEditorFormat): Email;
    subject(subject: string): Email;
    to(address: string, displayName?: string): Email;
    cc(address: string, displayName?: string): Email;
    bcc(address: string, displayName?: string): Email;
    replyTo(address: string, displayName?: string): Email;
    tos(recipients: Array<Recipient>): Email;
    ccs(recipients: Array<Recipient>): Email;
    bccs(recipients: Array<Recipient>): Email;
    replyTos(recipients: Array<Recipient>): Email;
    sentOn(when: Date | null | undefined): Email;
    receivedOn(when: Date | null | undefined): Email;
    attach(attachment: Attachment): Email;
    /**
     * the raw transport headers
     * @param headers
     */
    headers(headers: string): Email;
    msg(): Uint8Array;
    _setSubject(): void;
    /**
     * write to the cfb of the underlying message
     */
    _writeToStorage(): void;
}
