/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { depthwiseConv2d } from '../../ops/depthwise_conv2d';
import { getGlobalTensorClass } from '../../tensor';
getGlobalTensorClass().prototype.depthwiseConv2d =
    function (filter, strides, pad, dataFormat, dilations, dimRoundingMode) {
        this.throwIfDisposed();
        return depthwiseConv2d(this, filter, strides, pad, dataFormat, dilations, dimRoundingMode);
    };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwdGh3aXNlX2NvbnYyZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3RmanMtY29yZS9zcmMvcHVibGljL2NoYWluZWRfb3BzL2RlcHRod2lzZV9jb252MmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7Ozs7Ozs7Ozs7OztHQWVHO0FBQ0gsT0FBTyxFQUFDLGVBQWUsRUFBQyxNQUFNLDRCQUE0QixDQUFDO0FBQzNELE9BQU8sRUFBQyxvQkFBb0IsRUFBcUIsTUFBTSxjQUFjLENBQUM7QUFhdEUsb0JBQW9CLEVBQUUsQ0FBQyxTQUFTLENBQUMsZUFBZTtJQUM1QyxVQUNJLE1BQTZCLEVBQUUsT0FBZ0MsRUFDL0QsR0FBMEIsRUFBRSxVQUEwQixFQUN0RCxTQUFtQyxFQUNuQyxlQUF3QztRQUM5QyxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7UUFDdkIsT0FBTyxlQUFlLENBQ1gsSUFBSSxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLFVBQVUsRUFBRSxTQUFTLEVBQ2pELGVBQWUsQ0FBTSxDQUFDO0lBQ25DLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCAyMDIwIEdvb2dsZSBMTEMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpO1xuICogeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuICogWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG4gKlxuICogaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuICogZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuICogV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gKiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gKiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqID09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09XG4gKi9cbmltcG9ydCB7ZGVwdGh3aXNlQ29udjJkfSBmcm9tICcuLi8uLi9vcHMvZGVwdGh3aXNlX2NvbnYyZCc7XG5pbXBvcnQge2dldEdsb2JhbFRlbnNvckNsYXNzLCBUZW5zb3IzRCwgVGVuc29yNER9IGZyb20gJy4uLy4uL3RlbnNvcic7XG5pbXBvcnQge1JhbmssIFRlbnNvckxpa2U0RH0gZnJvbSAnLi4vLi4vdHlwZXMnO1xuXG5kZWNsYXJlIG1vZHVsZSAnLi4vLi4vdGVuc29yJyB7XG4gIGludGVyZmFjZSBUZW5zb3I8UiBleHRlbmRzIFJhbmsgPSBSYW5rPiB7XG4gICAgZGVwdGh3aXNlQ29udjJkPFQgZXh0ZW5kcyBUZW5zb3IzRHxUZW5zb3I0RD4oXG4gICAgICAgIGZpbHRlcjogVGVuc29yNER8VGVuc29yTGlrZTRELCBzdHJpZGVzOiBbbnVtYmVyLCBudW1iZXJdfG51bWJlcixcbiAgICAgICAgcGFkOiAndmFsaWQnfCdzYW1lJ3xudW1iZXIsIGRhdGFGb3JtYXQ/OiAnTkhXQyd8J05DSFcnLFxuICAgICAgICBkaWxhdGlvbnM/OiBbbnVtYmVyLCBudW1iZXJdfG51bWJlcixcbiAgICAgICAgZGltUm91bmRpbmdNb2RlPzogJ2Zsb29yJ3wncm91bmQnfCdjZWlsJyk6IFQ7XG4gIH1cbn1cblxuZ2V0R2xvYmFsVGVuc29yQ2xhc3MoKS5wcm90b3R5cGUuZGVwdGh3aXNlQ29udjJkID1cbiAgICBmdW5jdGlvbjxUIGV4dGVuZHMgVGVuc29yM0R8VGVuc29yNEQ+KFxuICAgICAgICBmaWx0ZXI6IFRlbnNvcjREfFRlbnNvckxpa2U0RCwgc3RyaWRlczogW251bWJlciwgbnVtYmVyXXxudW1iZXIsXG4gICAgICAgIHBhZDogJ3ZhbGlkJ3wnc2FtZSd8bnVtYmVyLCBkYXRhRm9ybWF0PzogJ05IV0MnfCdOQ0hXJyxcbiAgICAgICAgZGlsYXRpb25zPzogW251bWJlciwgbnVtYmVyXXxudW1iZXIsXG4gICAgICAgIGRpbVJvdW5kaW5nTW9kZT86ICdmbG9vcid8J3JvdW5kJ3wnY2VpbCcpOiBUIHtcbiAgdGhpcy50aHJvd0lmRGlzcG9zZWQoKTtcbiAgcmV0dXJuIGRlcHRod2lzZUNvbnYyZChcbiAgICAgICAgICAgICB0aGlzLCBmaWx0ZXIsIHN0cmlkZXMsIHBhZCwgZGF0YUZvcm1hdCwgZGlsYXRpb25zLFxuICAgICAgICAgICAgIGRpbVJvdW5kaW5nTW9kZSkgYXMgVDtcbn07XG4iXX0=