/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { RaggedTensorToTensor } from '@tensorflow/tfjs-core';
import { raggedTensorToTensorImplCPU } from '../kernel_utils/shared';
export function raggedTensorToTensor(args) {
    const { inputs, backend, attrs } = args;
    const { shape, values, defaultValue, rowPartitionTensors } = inputs;
    const { rowPartitionTypes } = attrs;
    const $shape = backend.readSync(shape.dataId);
    const $values = backend.readSync(values.dataId);
    const $defaultValue = backend.readSync(defaultValue.dataId);
    const $rowPartitionValues = rowPartitionTensors.map(t => backend.readSync(t.dataId));
    const rowPartitionValuesShapes = rowPartitionTensors.map(t => t.shape);
    const [outputShape, output] = raggedTensorToTensorImplCPU($shape, shape.shape, $values, values.shape, values.dtype, $defaultValue, defaultValue.shape, $rowPartitionValues, rowPartitionValuesShapes, rowPartitionTypes);
    return backend.makeTensorInfo(outputShape, values.dtype, output);
}
export const raggedTensorToTensorConfig = {
    kernelName: RaggedTensorToTensor,
    backendName: 'webgl',
    kernelFunc: raggedTensorToTensor,
};
//# sourceMappingURL=data:application/json;base64,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