/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
/// <amd-module name="@tensorflow/tfjs-backend-webgl/dist/kernel_utils/shared" />
import * as shared from '@tensorflow/tfjs-backend-cpu/dist/shared';
import { SimpleBinaryKernelImpl } from '@tensorflow/tfjs-backend-cpu/dist/shared';
import { SimpleUnaryImpl } from '@tensorflow/tfjs-backend-cpu/dist/utils/unary_types';
export type SimpleBinaryKernelImplCPU = SimpleBinaryKernelImpl;
export type SimpleUnaryKernelImplCPU = SimpleUnaryImpl;
declare const addImplCPU: shared.SimpleBinaryKernelImpl, bincountImplCPU: typeof shared.bincountImpl, bincountReduceImplCPU: typeof shared.bincountReduceImpl, bitwiseAndImplCPU: shared.SimpleBinaryKernelImpl, castImplCPU: typeof shared.castImpl, ceilImplCPU: SimpleUnaryImpl<number, number>, concatImplCPU: typeof shared.concatImpl, equalImplCPU: shared.SimpleBinaryKernelImpl, expImplCPU: SimpleUnaryImpl<number, number>, expm1ImplCPU: SimpleUnaryImpl<number, number>, floorImplCPU: SimpleUnaryImpl<number, number>, gatherNdImplCPU: typeof shared.gatherNdImpl, gatherV2ImplCPU: typeof shared.gatherV2Impl, greaterImplCPU: shared.SimpleBinaryKernelImpl, greaterEqualImplCPU: shared.SimpleBinaryKernelImpl, lessImplCPU: shared.SimpleBinaryKernelImpl, lessEqualImplCPU: shared.SimpleBinaryKernelImpl, linSpaceImplCPU: typeof shared.linSpaceImpl, logImplCPU: SimpleUnaryImpl<number, number>, maxImplCPU: typeof shared.maxImpl, maximumImplCPU: shared.SimpleBinaryKernelImpl, minimumImplCPU: shared.SimpleBinaryKernelImpl, multiplyImplCPU: shared.SimpleBinaryKernelImpl, negImplCPU: typeof shared.negImpl, notEqualImplCPU: shared.SimpleBinaryKernelImpl, prodImplCPU: typeof shared.prodImpl, raggedGatherImplCPU: typeof shared.raggedGatherImpl, raggedRangeImplCPU: typeof shared.raggedRangeImpl, raggedTensorToTensorImplCPU: typeof shared.raggedTensorToTensorImpl, rangeImplCPU: typeof shared.rangeImpl, rsqrtImplCPU: SimpleUnaryImpl<number, number>, scatterImplCPU: typeof shared.scatterImpl, sigmoidImplCPU: SimpleUnaryImpl<number, number>, simpleAbsImplCPU: typeof shared.simpleAbsImpl, sliceImplCPU: typeof shared.sliceImpl, sparseFillEmptyRowsImplCPU: typeof shared.sparseFillEmptyRowsImpl, sparseReshapeImplCPU: typeof shared.sparseReshapeImpl, sparseSegmentReductionImplCPU: typeof shared.sparseSegmentReductionImpl, sqrtImplCPU: SimpleUnaryImpl<number, number>, staticRegexReplaceImplCPU: SimpleUnaryImpl<string, string>, stridedSliceImplCPU: typeof shared.stridedSliceImpl, stringNGramsImplCPU: typeof shared.stringNGramsImpl, stringSplitImplCPU: typeof shared.stringSplitImpl, stringToHashBucketFastImplCPU: typeof shared.stringToHashBucketFastImpl, subImplCPU: shared.SimpleBinaryKernelImpl, tileImplCPU: typeof shared.tileImpl, topKImplCPU: typeof shared.topKImpl, transposeImplCPU: typeof shared.transposeImpl, uniqueImplCPU: typeof shared.uniqueImpl;
export { addImplCPU, bincountImplCPU, bincountReduceImplCPU, bitwiseAndImplCPU, castImplCPU, ceilImplCPU, concatImplCPU, equalImplCPU, expImplCPU, expm1ImplCPU, floorImplCPU, gatherNdImplCPU, gatherV2ImplCPU, greaterEqualImplCPU, greaterImplCPU, lessEqualImplCPU, lessImplCPU, linSpaceImplCPU, logImplCPU, maxImplCPU, maximumImplCPU, minimumImplCPU, multiplyImplCPU, negImplCPU, notEqualImplCPU, prodImplCPU, raggedGatherImplCPU, raggedRangeImplCPU, raggedTensorToTensorImplCPU, scatterImplCPU, sigmoidImplCPU, simpleAbsImplCPU, sliceImplCPU, sparseFillEmptyRowsImplCPU, sparseReshapeImplCPU, sparseSegmentReductionImplCPU, sqrtImplCPU, staticRegexReplaceImplCPU, stridedSliceImplCPU, stringNGramsImplCPU, stringSplitImplCPU, stringToHashBucketFastImplCPU, subImplCPU, rangeImplCPU, rsqrtImplCPU, tileImplCPU, topKImplCPU, transposeImplCPU, uniqueImplCPU, };
