/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

/** OneOf type helpers */
type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };
type XOR<T, U> = T | U extends object
  ? (Without<T, U> & U) | (Without<U, T> & T)
  : T | U;
type OneOf<T extends any[]> = T extends [infer Only]
  ? Only
  : T extends [infer A, infer B, ...infer Rest]
    ? OneOf<[XOR<A, B>, ...Rest]>
    : never;

export type paths = Record<string, never>;

export interface webhooks {
  "branch-protection-configuration-disabled": {
    /**
     * This event occurs when there is a change to branch protection configurations for a repository.
     * For more information, see "[About protected branches](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/defining-the-mergeability-of-pull-requests/about-protected-branches)."
     * For information about using the APIs to manage branch protection rules, see "[Branch protection rule](https://docs.github.com/graphql/reference/objects#branchprotectionrule)" in the GraphQL documentation or "[Branch protection](https://docs.github.com/rest/branches/branch-protection)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository permission.
     * @description All branch protections were disabled for a repository.
     */
    post: operations["branch-protection-configuration/disabled"];
  };
  "branch-protection-configuration-enabled": {
    /**
     * This event occurs when there is a change to branch protection configurations for a repository.
     * For more information, see "[About protected branches](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/defining-the-mergeability-of-pull-requests/about-protected-branches)."
     * For information about using the APIs to manage branch protection rules, see "[Branch protection rule](https://docs.github.com/graphql/reference/objects#branchprotectionrule)" in the GraphQL documentation or "[Branch protection](https://docs.github.com/rest/branches/branch-protection)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository permission.
     * @description All branch protections were enabled for a repository.
     */
    post: operations["branch-protection-configuration/enabled"];
  };
  "branch-protection-rule-created": {
    /**
     * This event occurs when there is activity relating to branch protection rules. For more information, see "[About protected branches](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/defining-the-mergeability-of-pull-requests/about-protected-branches)." For information about the APIs to manage branch protection rules, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#branchprotectionrule) or "[Branch protection](https://docs.github.com/rest/branches/branch-protection)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository permission.
     * @description A branch protection rule was created.
     */
    post: operations["branch-protection-rule/created"];
  };
  "branch-protection-rule-deleted": {
    /**
     * This event occurs when there is activity relating to branch protection rules. For more information, see "[About protected branches](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/defining-the-mergeability-of-pull-requests/about-protected-branches)." For information about the APIs to manage branch protection rules, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#branchprotectionrule) or "[Branch protection](https://docs.github.com/rest/branches/branch-protection)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository permission.
     * @description A branch protection rule was deleted.
     */
    post: operations["branch-protection-rule/deleted"];
  };
  "branch-protection-rule-edited": {
    /**
     * This event occurs when there is activity relating to branch protection rules. For more information, see "[About protected branches](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/defining-the-mergeability-of-pull-requests/about-protected-branches)." For information about the APIs to manage branch protection rules, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#branchprotectionrule) or "[Branch protection](https://docs.github.com/rest/branches/branch-protection)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository permission.
     * @description A branch protection rule was edited.
     */
    post: operations["branch-protection-rule/edited"];
  };
  "check-run-completed": {
    /**
     * This event occurs when there is activity relating to a check run. For information about check runs, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check runs, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checkrun) or "[Check Runs](https://docs.github.com/rest/checks/runs)" in the REST API documentation.
     *
     * For activity relating to check suites, use the `check-suite` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" repository permission. To receive the `rerequested` and `requested_action` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `created` and `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check run was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description A check run was completed, and a conclusion is available.
     */
    post: operations["check-run/completed"];
  };
  "check-run-created": {
    /**
     * This event occurs when there is activity relating to a check run. For information about check runs, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check runs, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checkrun) or "[Check Runs](https://docs.github.com/rest/checks/runs)" in the REST API documentation.
     *
     * For activity relating to check suites, use the `check-suite` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" repository permission. To receive the `rerequested` and `requested_action` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `created` and `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check run was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description A new check run was created.
     */
    post: operations["check-run/created"];
  };
  "check-run-requested-action": {
    /**
     * This event occurs when there is activity relating to a check run. For information about check runs, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check runs, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checkrun) or "[Check Runs](https://docs.github.com/rest/checks/runs)" in the REST API documentation.
     *
     * For activity relating to check suites, use the `check-suite` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" repository permission. To receive the `rerequested` and `requested_action` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `created` and `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check run was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description A check run completed, and someone requested a followup action that your app provides. Only the GitHub App someone requests to perform an action will receive the `requested_action` payload. For more information, see "[Creating CI tests with the Checks API](https://docs.github.com/developers/apps/guides/creating-ci-tests-with-the-checks-api)."
     */
    post: operations["check-run/requested-action"];
  };
  "check-run-rerequested": {
    /**
     * This event occurs when there is activity relating to a check run. For information about check runs, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check runs, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checkrun) or "[Check Runs](https://docs.github.com/rest/checks/runs)" in the REST API documentation.
     *
     * For activity relating to check suites, use the `check-suite` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" repository permission. To receive the `rerequested` and `requested_action` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `created` and `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check run was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description Someone requested to re-run a check run. Only the GitHub App that someone requests to re-run the check will receive the `rerequested` payload.
     */
    post: operations["check-run/rerequested"];
  };
  "check-suite-completed": {
    /**
     * This event occurs when there is activity relating to a check suite. For information about check suites, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check suites, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checksuite) or "[Check Suites](https://docs.github.com/rest/checks/suites)" in the REST API documentation.
     *
     * For activity relating to check runs, use the `check_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" permission. To receive the `requested` and `rerequested` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check suite was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description All check runs in a check suite have completed, and a conclusion is available.
     */
    post: operations["check-suite/completed"];
  };
  "check-suite-requested": {
    /**
     * This event occurs when there is activity relating to a check suite. For information about check suites, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check suites, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checksuite) or "[Check Suites](https://docs.github.com/rest/checks/suites)" in the REST API documentation.
     *
     * For activity relating to check runs, use the `check_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" permission. To receive the `requested` and `rerequested` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check suite was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description Someone requested to run a check suite. By default, check suites are automatically created when you create a check run. For more information, see [the GraphQL API documentation for creating a check run](https://docs.github.com/graphql/reference/mutations#createcheckrun) or "[Create a check run](https://docs.github.com/rest/checks/runs#create-a-check-run)" in the REST API documentation.
     */
    post: operations["check-suite/requested"];
  };
  "check-suite-rerequested": {
    /**
     * This event occurs when there is activity relating to a check suite. For information about check suites, see "[Getting started with the Checks API](https://docs.github.com/rest/guides/getting-started-with-the-checks-api)." For information about the APIs to manage check suites, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#checksuite) or "[Check Suites](https://docs.github.com/rest/checks/suites)" in the REST API documentation.
     *
     * For activity relating to check runs, use the `check_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Checks" permission. To receive the `requested` and `rerequested` event types, the app must have at least write-level access for the "Checks" permission. GitHub Apps with write-level access for the "Checks" permission are automatically subscribed to this webhook event.
     *
     * Repository and organization webhooks only receive payloads for the `completed` event types in repositories.
     *
     * > [!NOTE]
     * > The API only looks for pushes in the repository where the check suite was created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     * @description Someone requested to re-run the check runs in a check suite. For more information, see [the GraphQL API documentation for creating a check suite](https://docs.github.com/graphql/reference/mutations#createchecksuite) or "[Create a check suite](https://docs.github.com/rest/checks/suites#create-a-check-suite)" in the REST API documentation.
     */
    post: operations["check-suite/rerequested"];
  };
  "code-scanning-alert-appeared-in-branch": {
    /**
     * This event occurs when there is activity relating to code scanning alerts in a repository. For more information, see "[About code scanning](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning)" and "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts)." For information about the API to manage code scanning, see "[Code scanning](https://docs.github.com/rest/code-scanning)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Code scanning alerts" repository permission.
     * @description A previously created code scanning alert appeared in another branch. This can happen when a branch is merged into or created from a branch with a pre-existing code scanning alert.
     */
    post: operations["code-scanning-alert/appeared-in-branch"];
  };
  "code-scanning-alert-closed-by-user": {
    /**
     * This event occurs when there is activity relating to code scanning alerts in a repository. For more information, see "[About code scanning](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning)" and "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts)." For information about the API to manage code scanning, see "[Code scanning](https://docs.github.com/rest/code-scanning)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Code scanning alerts" repository permission.
     * @description Someone closed a code scanning alert.
     */
    post: operations["code-scanning-alert/closed-by-user"];
  };
  "code-scanning-alert-created": {
    /**
     * This event occurs when there is activity relating to code scanning alerts in a repository. For more information, see "[About code scanning](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning)" and "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts)." For information about the API to manage code scanning, see "[Code scanning](https://docs.github.com/rest/code-scanning)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Code scanning alerts" repository permission.
     * @description A code scanning alert was created in a repository.
     */
    post: operations["code-scanning-alert/created"];
  };
  "code-scanning-alert-fixed": {
    /**
     * This event occurs when there is activity relating to code scanning alerts in a repository. For more information, see "[About code scanning](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning)" and "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts)." For information about the API to manage code scanning, see "[Code scanning](https://docs.github.com/rest/code-scanning)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Code scanning alerts" repository permission.
     * @description A code scanning alert was fixed in a branch by a commit.
     */
    post: operations["code-scanning-alert/fixed"];
  };
  "code-scanning-alert-reopened": {
    /**
     * This event occurs when there is activity relating to code scanning alerts in a repository. For more information, see "[About code scanning](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning)" and "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts)." For information about the API to manage code scanning, see "[Code scanning](https://docs.github.com/rest/code-scanning)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Code scanning alerts" repository permission.
     * @description A previously fixed code scanning alert reappeared in a branch.
     */
    post: operations["code-scanning-alert/reopened"];
  };
  "code-scanning-alert-reopened-by-user": {
    /**
     * This event occurs when there is activity relating to code scanning alerts in a repository. For more information, see "[About code scanning](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning)" and "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/automatically-scanning-your-code-for-vulnerabilities-and-errors/about-code-scanning-alerts)." For information about the API to manage code scanning, see "[Code scanning](https://docs.github.com/rest/code-scanning)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Code scanning alerts" repository permission.
     * @description Someone reopened a code scanning alert.
     */
    post: operations["code-scanning-alert/reopened-by-user"];
  };
  "commit-comment-created": {
    /**
     * This event occurs when there is activity relating to commit comments. For more information about commit comments, see "[Commenting on a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/commenting-on-a-pull-request)." For information about the APIs to manage commit comments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#commitcomment) or "[Commit comments](https://docs.github.com/rest/commits/comments)" in the REST API documentation.
     *
     * For activity relating to comments on pull request reviews, use the `pull_request_review_comment` event. For activity relating to issue comments, use the `issue_comment` event. For activity relating to discussion comments, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description Someone commented on a commit.
     */
    post: operations["commit-comment/created"];
  };
  create: {
    /**
     * This event occurs when a Git branch or tag is created.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     *
     * **Notes**:
     * - This event will not occur when more than three tags are created at once.
     * - Payloads are capped at 25 MB. If an event generates a larger payload, GitHub will not deliver a payload for that webhook event. This may happen, for example, if many branches or tags are pushed at once. We suggest monitoring your payload size to ensure delivery.
     */
    post: operations["create"];
  };
  "custom-property-created": {
    /**
     * This event occurs when there is activity relating to a custom property.
     *
     * For more information, see "[Managing custom properties for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-custom-properties-for-repositories-in-your-organization)". For information about the APIs to manage custom properties, see "[Custom properties](https://docs.github.com/rest/orgs/custom-properties)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Custom properties" organization permission.
     * @description A new custom property was created.
     */
    post: operations["custom-property/created"];
  };
  "custom-property-deleted": {
    /**
     * This event occurs when there is activity relating to a custom property.
     *
     * For more information, see "[Managing custom properties for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-custom-properties-for-repositories-in-your-organization)". For information about the APIs to manage custom properties, see "[Custom properties](https://docs.github.com/rest/orgs/custom-properties)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Custom properties" organization permission.
     * @description A custom property was deleted.
     */
    post: operations["custom-property/deleted"];
  };
  "custom-property-promoted-to-enterprise": {
    /**
     * This event occurs when there is activity relating to a custom property.
     *
     * For more information, see "[Managing custom properties for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-custom-properties-for-repositories-in-your-organization)". For information about the APIs to manage custom properties, see "[Custom properties](https://docs.github.com/rest/orgs/custom-properties)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Custom properties" organization permission.
     * @description A custom property was promoted to an enterprise.
     */
    post: operations["custom-property/promote-to-enterprise"];
  };
  "custom-property-updated": {
    /**
     * This event occurs when there is activity relating to a custom property.
     *
     * For more information, see "[Managing custom properties for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-custom-properties-for-repositories-in-your-organization)". For information about the APIs to manage custom properties, see "[Custom properties](https://docs.github.com/rest/orgs/custom-properties)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Custom properties" organization permission.
     * @description A custom property was updated.
     */
    post: operations["custom-property/updated"];
  };
  "custom-property-values-updated": {
    /**
     * This event occurs when there is activity relating to custom property values for a repository.
     *
     * For more information, see "[Managing custom properties for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-custom-properties-for-repositories-in-your-organization)". For information about the APIs to manage custom properties for a repository, see "[Custom properties](https://docs.github.com/rest/repos/custom-properties)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Custom properties" organization permission.
     * @description The custom property values of a repository were updated.
     */
    post: operations["custom-property-values/updated"];
  };
  delete: {
    /**
     * This event occurs when a Git branch or tag is deleted. To subscribe to all pushes to a repository, including
     * branch and tag deletions, use the [`push`](#push) webhook event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     *
     * > [!NOTE]
     * > This event will not occur when more than three tags are deleted at once.
     */
    post: operations["delete"];
  };
  "dependabot-alert-auto-dismissed": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A Dependabot alert was automatically closed by a Dependabot auto-triage rule.
     */
    post: operations["dependabot-alert/auto-dismissed"];
  };
  "dependabot-alert-auto-reopened": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A Dependabot alert, that had been automatically closed by a Dependabot auto-triage rule, was automatically reopened because the alert metadata or rule changed.
     */
    post: operations["dependabot-alert/auto-reopened"];
  };
  "dependabot-alert-created": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A manifest file change introduced a vulnerable dependency, or a GitHub Security Advisory was published and an existing dependency was found to be vulnerable.
     */
    post: operations["dependabot-alert/created"];
  };
  "dependabot-alert-dismissed": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A Dependabot alert was manually closed.
     */
    post: operations["dependabot-alert/dismissed"];
  };
  "dependabot-alert-fixed": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A manifest file change removed a vulnerability.
     */
    post: operations["dependabot-alert/fixed"];
  };
  "dependabot-alert-reintroduced": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A manifest file change introduced a vulnerable dependency that had previously been fixed.
     */
    post: operations["dependabot-alert/reintroduced"];
  };
  "dependabot-alert-reopened": {
    /**
     * This event occurs when there is activity relating to Dependabot alerts.
     *
     * For more information about Dependabot alerts, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)." For information about the API to manage Dependabot alerts, see "[Dependabot alerts](https://docs.github.com/rest/dependabot/alerts)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Dependabot alerts" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for Dependabot alerts are currently in public preview and subject to change.
     * @description A Dependabot alert was manually reopened.
     */
    post: operations["dependabot-alert/reopened"];
  };
  "deploy-key-created": {
    /**
     * This event occurs when there is activity relating to deploy keys. For more information, see "[Managing deploy keys](https://docs.github.com/developers/overview/managing-deploy-keys)." For information about the APIs to manage deploy keys, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deploykey) or "[Deploy keys](https://docs.github.com/rest/deploy-keys)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deploy key was created.
     */
    post: operations["deploy-key/created"];
  };
  "deploy-key-deleted": {
    /**
     * This event occurs when there is activity relating to deploy keys. For more information, see "[Managing deploy keys](https://docs.github.com/developers/overview/managing-deploy-keys)." For information about the APIs to manage deploy keys, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deploykey) or "[Deploy keys](https://docs.github.com/rest/deploy-keys)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deploy key was deleted.
     */
    post: operations["deploy-key/deleted"];
  };
  "deployment-created": {
    /**
     * This event occurs when there is activity relating to deployments. For more information, see "[About deployments](https://docs.github.com/actions/deployment/about-deployments)." For information about the APIs to manage deployments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deployment) or "[Deployments](https://docs.github.com/rest/deployments/deployments)" in the REST API documentation.
     *
     * For activity relating to deployment status, use the `deployment_status` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deployment was created.
     */
    post: operations["deployment/created"];
  };
  "deployment-protection-rule-requested": {
    /**
     * This event occurs when there is activity relating to deployment protection rules. For more information, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment#environment-protection-rules)." For information about the API to manage deployment protection rules, see [the REST API documentation](https://docs.github.com/rest/deployments/environments).
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deployment protection rule was requested for an environment.
     */
    post: operations["deployment-protection-rule/requested"];
  };
  "deployment-review-approved": {
    /**
     * This event occurs when there is activity relating to deployment reviews. For more information, see "[About deployments](https://docs.github.com/actions/deployment/about-deployments)." For information about the APIs to manage deployments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deployment) or "[Deployments](https://docs.github.com/rest/deployments/deployments)" in the REST API documentation.
     *
     * For activity relating to deployment creation or deployment status, use the `deployment` or `deployment_status` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deployment review was approved.
     */
    post: operations["deployment-review/approved"];
  };
  "deployment-review-rejected": {
    /**
     * This event occurs when there is activity relating to deployment reviews. For more information, see "[About deployments](https://docs.github.com/actions/deployment/about-deployments)." For information about the APIs to manage deployments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deployment) or "[Deployments](https://docs.github.com/rest/deployments/deployments)" in the REST API documentation.
     *
     * For activity relating to deployment creation or deployment status, use the `deployment` or `deployment_status` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deployment review was rejected.
     */
    post: operations["deployment-review/rejected"];
  };
  "deployment-review-requested": {
    /**
     * This event occurs when there is activity relating to deployment reviews. For more information, see "[About deployments](https://docs.github.com/actions/deployment/about-deployments)." For information about the APIs to manage deployments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deployment) or "[Deployments](https://docs.github.com/rest/deployments/deployments)" in the REST API documentation.
     *
     * For activity relating to deployment creation or deployment status, use the `deployment` or `deployment_status` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     * @description A deployment review was requested.
     */
    post: operations["deployment-review/requested"];
  };
  "deployment-status-created": {
    /**
     * This event occurs when there is activity relating to deployment statuses. For more information, see "[About deployments](https://docs.github.com/actions/deployment/about-deployments)." For information about the APIs to manage deployments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#deployment) or "[Deployments](https://docs.github.com/rest/deployments/deployments)" in the REST API documentation.
     *
     * For activity relating to deployment creation, use the `deployment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Deployments" repository permission.
     *
     * > [!NOTE]
     * > A webhook event is not fired for deployment statuses with an `inactive` state.
     * @description A new deployment status was created.
     */
    post: operations["deployment-status/created"];
  };
  "discussion-answered": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A comment on the discussion was marked as the answer.
     */
    post: operations["discussion/answered"];
  };
  "discussion-category-changed": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description The category of a discussion was changed.
     */
    post: operations["discussion/category-changed"];
  };
  "discussion-closed": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was closed.
     */
    post: operations["discussion/closed"];
  };
  "discussion-comment-created": {
    /**
     * This event occurs when there is activity relating to a comment on a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a discussion as opposed to comments on a discussion, use the `discussion` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A comment on a discussion was created.
     */
    post: operations["discussion-comment/created"];
  };
  "discussion-comment-deleted": {
    /**
     * This event occurs when there is activity relating to a comment on a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a discussion as opposed to comments on a discussion, use the `discussion` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A comment on a discussion was deleted.
     */
    post: operations["discussion-comment/deleted"];
  };
  "discussion-comment-edited": {
    /**
     * This event occurs when there is activity relating to a comment on a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a discussion as opposed to comments on a discussion, use the `discussion` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A comment on a discussion was edited.
     */
    post: operations["discussion-comment/edited"];
  };
  "discussion-created": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was created.
     */
    post: operations["discussion/created"];
  };
  "discussion-deleted": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was deleted.
     */
    post: operations["discussion/deleted"];
  };
  "discussion-edited": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description The title or body on a discussion was edited, or the category of the discussion was changed.
     */
    post: operations["discussion/edited"];
  };
  "discussion-labeled": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A label was added to a discussion.
     */
    post: operations["discussion/labeled"];
  };
  "discussion-locked": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was locked.
     */
    post: operations["discussion/locked"];
  };
  "discussion-pinned": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was pinned.
     */
    post: operations["discussion/pinned"];
  };
  "discussion-reopened": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was reopened.
     */
    post: operations["discussion/reopened"];
  };
  "discussion-transferred": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was transferred to another repository.
     */
    post: operations["discussion/transferred"];
  };
  "discussion-unanswered": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A comment on the discussion was unmarked as the answer.
     */
    post: operations["discussion/unanswered"];
  };
  "discussion-unlabeled": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A label was removed from a discussion.
     */
    post: operations["discussion/unlabeled"];
  };
  "discussion-unlocked": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was unlocked.
     */
    post: operations["discussion/unlocked"];
  };
  "discussion-unpinned": {
    /**
     * This event occurs when there is activity relating to a discussion. For more information about discussions, see "[GitHub Discussions](https://docs.github.com/discussions)." For information about the API to manage discussions, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#discussion).
     *
     * For activity relating to a comment on a discussion, use the `discussion_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Discussions" repository permission.
     *
     * > [!NOTE]
     * > Webhook events for GitHub Discussions are currently in public preview and subject to change.
     * @description A discussion was unpinned.
     */
    post: operations["discussion/unpinned"];
  };
  fork: {
    /**
     * This event occurs when someone forks a repository. For more information, see "[Fork a repo](https://docs.github.com/get-started/quickstart/fork-a-repo)." For information about the API to manage forks, see "[Forks](https://docs.github.com/rest/repos/forks)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     */
    post: operations["fork"];
  };
  "github-app-authorization-revoked": {
    /**
     * This event occurs when a user revokes their authorization of a GitHub App. For more information, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the API to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     *
     * A GitHub App receives this webhook by default and cannot unsubscribe from this event.
     *
     * Anyone can revoke their authorization of a GitHub App from their [GitHub account settings page](https://github.com/settings/apps/authorizations). Revoking the authorization of a GitHub App does not uninstall the GitHub App. You should program your GitHub App so that when it receives this webhook, it stops calling the API on behalf of the person who revoked the token. If your GitHub App continues to use a revoked access token, it will receive the `401 Bad Credentials` error. For details about requests with a user access token, which require GitHub App authorization, see "[Authenticating with a GitHub App on behalf of a user](https://docs.github.com/apps/creating-github-apps/authenticating-with-a-github-app/authenticating-with-a-github-app-on-behalf-of-a-user)."
     * @description Someone revoked their authorization of a GitHub App.
     */
    post: operations["github-app-authorization/revoked"];
  };
  gollum: {
    /**
     * This event occurs when someone creates or updates a wiki page. For more information, see "[About wikis](https://docs.github.com/communities/documenting-your-project-with-wikis/about-wikis)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     */
    post: operations["gollum"];
  };
  "installation-created": {
    /**
     * This event occurs when there is activity relating to a GitHub App installation. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description Someone installed a GitHub App on a user or organization account.
     */
    post: operations["installation/created"];
  };
  "installation-deleted": {
    /**
     * This event occurs when there is activity relating to a GitHub App installation. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description Someone uninstalled a GitHub App from their user or organization account.
     */
    post: operations["installation/deleted"];
  };
  "installation-new-permissions-accepted": {
    /**
     * This event occurs when there is activity relating to a GitHub App installation. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description Someone granted new permissions to a GitHub App.
     */
    post: operations["installation/new-permissions-accepted"];
  };
  "installation-repositories-added": {
    /**
     * This event occurs when there is activity relating to which repositories a GitHub App installation can access. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description A GitHub App installation was granted access to one or more repositories.
     */
    post: operations["installation-repositories/added"];
  };
  "installation-repositories-removed": {
    /**
     * This event occurs when there is activity relating to which repositories a GitHub App installation can access. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description Access to one or more repositories was revoked for a GitHub App installation.
     */
    post: operations["installation-repositories/removed"];
  };
  "installation-suspend": {
    /**
     * This event occurs when there is activity relating to a GitHub App installation. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description Someone blocked access by a GitHub App to their user or organization account.
     */
    post: operations["installation/suspend"];
  };
  "installation-target-renamed": {
    /**
     * This event occurs when there is activity relating to the user or organization account that a GitHub App is installed on. For more information, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description Somebody renamed the user or organization account that a GitHub App is installed on.
     */
    post: operations["installation-target/renamed"];
  };
  "installation-unsuspend": {
    /**
     * This event occurs when there is activity relating to a GitHub App installation. All GitHub Apps receive this event by default. You cannot manually subscribe to this event.
     *
     * For more information about GitHub Apps, see "[About apps](https://docs.github.com/developers/apps/getting-started-with-apps/about-apps#about-github-apps)." For information about the APIs to manage GitHub Apps, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#app) or "[Apps](https://docs.github.com/rest/apps)" in the REST API documentation.
     * @description A GitHub App that was blocked from accessing a user or organization account was given access the account again.
     */
    post: operations["installation/unsuspend"];
  };
  "issue-comment-created": {
    /**
     * This event occurs when there is activity relating to a comment on an issue or pull request. For more information about issues and pull requests, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)" and "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage issue comments, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issuecomment) or "[Issue comments](https://docs.github.com/rest/issues/comments)" in the REST API documentation.
     *
     * For activity relating to an issue as opposed to comments on an issue, use the `issue` event. For activity related to pull request reviews or pull request review comments, use the `pull_request_review` or `pull_request_review_comment` events. For more information about the different types of pull request comments, see "[Working with comments](https://docs.github.com/rest/guides/working-with-comments)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A comment on an issue or pull request was created.
     */
    post: operations["issue-comment/created"];
  };
  "issue-comment-deleted": {
    /**
     * This event occurs when there is activity relating to a comment on an issue or pull request. For more information about issues and pull requests, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)" and "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage issue comments, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issuecomment) or "[Issue comments](https://docs.github.com/rest/issues/comments)" in the REST API documentation.
     *
     * For activity relating to an issue as opposed to comments on an issue, use the `issue` event. For activity related to pull request reviews or pull request review comments, use the `pull_request_review` or `pull_request_review_comment` events. For more information about the different types of pull request comments, see "[Working with comments](https://docs.github.com/rest/guides/working-with-comments)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A comment on an issue or pull request was deleted.
     */
    post: operations["issue-comment/deleted"];
  };
  "issue-comment-edited": {
    /**
     * This event occurs when there is activity relating to a comment on an issue or pull request. For more information about issues and pull requests, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)" and "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage issue comments, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issuecomment) or "[Issue comments](https://docs.github.com/rest/issues/comments)" in the REST API documentation.
     *
     * For activity relating to an issue as opposed to comments on an issue, use the `issue` event. For activity related to pull request reviews or pull request review comments, use the `pull_request_review` or `pull_request_review_comment` events. For more information about the different types of pull request comments, see "[Working with comments](https://docs.github.com/rest/guides/working-with-comments)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A comment on an issue or pull request was edited.
     */
    post: operations["issue-comment/edited"];
  };
  "issues-assigned": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was assigned to a user.
     */
    post: operations["issues/assigned"];
  };
  "issues-closed": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was closed.
     */
    post: operations["issues/closed"];
  };
  "issues-deleted": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was deleted.
     */
    post: operations["issues/deleted"];
  };
  "issues-demilestoned": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was removed from a milestone.
     */
    post: operations["issues/demilestoned"];
  };
  "issues-edited": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description The title or body on an issue was edited.
     */
    post: operations["issues/edited"];
  };
  "issues-labeled": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A label was added to an issue.
     */
    post: operations["issues/labeled"];
  };
  "issues-locked": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description Conversation on an issue was locked. For more information, see "[Locking conversations](https://docs.github.com/communities/moderating-comments-and-conversations/locking-conversations)."
     */
    post: operations["issues/locked"];
  };
  "issues-milestoned": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was added to a milestone.
     */
    post: operations["issues/milestoned"];
  };
  "issues-opened": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was created. When a closed issue is reopened, the action will be `reopened` instead.
     */
    post: operations["issues/opened"];
  };
  "issues-pinned": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was pinned to a repository. For more information, see "[Pinning an issue to your repository](https://docs.github.com/issues/tracking-your-work-with-issues/pinning-an-issue-to-your-repository)."
     */
    post: operations["issues/pinned"];
  };
  "issues-reopened": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A closed issue was reopened.
     */
    post: operations["issues/reopened"];
  };
  "issues-transferred": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was transferred to another repository. For more information, see "[Transferring an issue to another repository](https://docs.github.com/issues/tracking-your-work-with-issues/transferring-an-issue-to-another-repository)."
     */
    post: operations["issues/transferred"];
  };
  "issues-typed": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue type was added to an issue.
     */
    post: operations["issues/typed"];
  };
  "issues-unassigned": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A user was unassigned from an issue.
     */
    post: operations["issues/unassigned"];
  };
  "issues-unlabeled": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description A label was removed from an issue.
     */
    post: operations["issues/unlabeled"];
  };
  "issues-unlocked": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description Conversation on an issue was locked. For more information, see "[Locking conversations](https://docs.github.com/communities/moderating-comments-and-conversations/locking-conversations)."
     */
    post: operations["issues/unlocked"];
  };
  "issues-unpinned": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue was unpinned from a repository. For more information, see "[Pinning an issue to your repository](https://docs.github.com/issues/tracking-your-work-with-issues/pinning-an-issue-to-your-repository)."
     */
    post: operations["issues/unpinned"];
  };
  "issues-untyped": {
    /**
     * This event occurs when there is activity relating to an issue. For more information about issues, see "[About issues](https://docs.github.com/issues/tracking-your-work-with-issues/about-issues)." For information about the APIs to manage issues, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#issue) or "[Issues](https://docs.github.com/rest/issues)" in the REST API documentation.
     *
     * For activity relating to a comment on an issue, use the `issue_comment` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permission.
     * @description An issue type was removed from an issue.
     */
    post: operations["issues/untyped"];
  };
  "label-created": {
    /**
     * This event occurs when there is activity relating to labels. For more information, see "[Managing labels](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/managing-labels)." For information about the APIs to manage labels, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#label) or "[Labels](https://docs.github.com/rest/issues/labels)" in the REST API documentation.
     *
     * If you want to receive an event when a label is added to or removed from an issue, pull request, or discussion, use the `labeled` or `unlabeled` action type for the `issues`, `pull_request`, or `discussion` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A label was created.
     */
    post: operations["label/created"];
  };
  "label-deleted": {
    /**
     * This event occurs when there is activity relating to labels. For more information, see "[Managing labels](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/managing-labels)." For information about the APIs to manage labels, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#label) or "[Labels](https://docs.github.com/rest/issues/labels)" in the REST API documentation.
     *
     * If you want to receive an event when a label is added to or removed from an issue, pull request, or discussion, use the `labeled` or `unlabeled` action type for the `issues`, `pull_request`, or `discussion` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A label was deleted.
     */
    post: operations["label/deleted"];
  };
  "label-edited": {
    /**
     * This event occurs when there is activity relating to labels. For more information, see "[Managing labels](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/managing-labels)." For information about the APIs to manage labels, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#label) or "[Labels](https://docs.github.com/rest/issues/labels)" in the REST API documentation.
     *
     * If you want to receive an event when a label is added to or removed from an issue, pull request, or discussion, use the `labeled` or `unlabeled` action type for the `issues`, `pull_request`, or `discussion` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A label's name, description, or color was changed.
     */
    post: operations["label/edited"];
  };
  "marketplace-purchase-cancelled": {
    /**
     * This event occurs when there is activity relating to a GitHub Marketplace purchase. For more information, see "[GitHub Marketplace](https://docs.github.com/marketplace)." For information about the APIs to manage GitHub Marketplace listings, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#marketplacelisting) or "[GitHub Marketplace](https://docs.github.com/rest/apps/marketplace)" in the REST API documentation.
     * @description Someone cancelled a GitHub Marketplace plan, and the last billing cycle has ended. The change will take effect on the account immediately.
     */
    post: operations["marketplace-purchase/cancelled"];
  };
  "marketplace-purchase-changed": {
    /**
     * This event occurs when there is activity relating to a GitHub Marketplace purchase. For more information, see "[GitHub Marketplace](https://docs.github.com/marketplace)." For information about the APIs to manage GitHub Marketplace listings, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#marketplacelisting) or "[GitHub Marketplace](https://docs.github.com/rest/apps/marketplace)" in the REST API documentation.
     * @description Someone upgraded or downgraded a GitHub Marketplace plan, and the last billing cycle has ended. The change will take effect on the account immediately.
     */
    post: operations["marketplace-purchase/changed"];
  };
  "marketplace-purchase-pending-change": {
    /**
     * This event occurs when there is activity relating to a GitHub Marketplace purchase. For more information, see "[GitHub Marketplace](https://docs.github.com/marketplace)." For information about the APIs to manage GitHub Marketplace listings, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#marketplacelisting) or "[GitHub Marketplace](https://docs.github.com/rest/apps/marketplace)" in the REST API documentation.
     * @description Someone downgraded or cancelled a GitHub Marketplace plan. The new plan or cancellation will take effect at the end of the current billing cycle. When the change takes effect, the `changed` or `cancelled` event will be sent.
     */
    post: operations["marketplace-purchase/pending-change"];
  };
  "marketplace-purchase-pending-change-cancelled": {
    /**
     * This event occurs when there is activity relating to a GitHub Marketplace purchase. For more information, see "[GitHub Marketplace](https://docs.github.com/marketplace)." For information about the APIs to manage GitHub Marketplace listings, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#marketplacelisting) or "[GitHub Marketplace](https://docs.github.com/rest/apps/marketplace)" in the REST API documentation.
     * @description Someone cancelled a pending change to a GitHub Marketplace plan. Pending changes include plan cancellations and downgrades that will take effect at the end of a billing cycle.
     */
    post: operations["marketplace-purchase/pending-change-cancelled"];
  };
  "marketplace-purchase-purchased": {
    /**
     * This event occurs when there is activity relating to a GitHub Marketplace purchase. For more information, see "[GitHub Marketplace](https://docs.github.com/marketplace)." For information about the APIs to manage GitHub Marketplace listings, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#marketplacelisting) or "[GitHub Marketplace](https://docs.github.com/rest/apps/marketplace)" in the REST API documentation.
     * @description Someone purchased a GitHub Marketplace plan. The change will take effect on the account immediately.
     */
    post: operations["marketplace-purchase/purchased"];
  };
  "member-added": {
    /**
     * This event occurs when there is activity relating to collaborators in a repository. For more information, see "[Adding outside collaborators to repositories in your organization](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/adding-outside-collaborators-to-repositories-in-your-organization)." For more information about the API to manage repository collaborators, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#repositorycollaboratorconnection) or "[Collaborators](https://docs.github.com/rest/collaborators/collaborators)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A GitHub user accepted an invitation to a repository.
     */
    post: operations["member/added"];
  };
  "member-edited": {
    /**
     * This event occurs when there is activity relating to collaborators in a repository. For more information, see "[Adding outside collaborators to repositories in your organization](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/adding-outside-collaborators-to-repositories-in-your-organization)." For more information about the API to manage repository collaborators, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#repositorycollaboratorconnection) or "[Collaborators](https://docs.github.com/rest/collaborators/collaborators)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description Permissions were changed for a collaborator on a repository.
     */
    post: operations["member/edited"];
  };
  "member-removed": {
    /**
     * This event occurs when there is activity relating to collaborators in a repository. For more information, see "[Adding outside collaborators to repositories in your organization](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/adding-outside-collaborators-to-repositories-in-your-organization)." For more information about the API to manage repository collaborators, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#repositorycollaboratorconnection) or "[Collaborators](https://docs.github.com/rest/collaborators/collaborators)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A collaborator was removed from a repository.
     */
    post: operations["member/removed"];
  };
  "membership-added": {
    /**
     * This event occurs when there is activity relating to team membership. For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)." For more information about the APIs to manage team memberships, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#team) or "[Team members](https://docs.github.com/rest/teams/members)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description An organization member was added to a team.
     */
    post: operations["membership/added"];
  };
  "membership-removed": {
    /**
     * This event occurs when there is activity relating to team membership. For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)." For more information about the APIs to manage team memberships, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#team) or "[Team members](https://docs.github.com/rest/teams/members)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description An organization member was removed from a team.
     */
    post: operations["membership/removed"];
  };
  "merge-group-checks-requested": {
    /**
     * This event occurs when there is activity relating to a merge group in a merge queue. For more information, see "[Managing a merge queue](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/configuring-pull-request-merges/managing-a-merge-queue)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Merge queues" repository permission.
     * @description Status checks were requested for a merge group. This happens when a merge group is created or added to by the merge queue because a pull request was queued.
     *
     * When you receive this event, you should perform checks on the head SHA and report status back using check runs or commit statuses.
     */
    post: operations["merge-group/checks-requested"];
  };
  "merge-group-destroyed": {
    /**
     * This event occurs when there is activity relating to a merge group in a merge queue. For more information, see "[Managing a merge queue](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/configuring-pull-request-merges/managing-a-merge-queue)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Merge queues" repository permission.
     * @description The merge queue groups pull requests together to be merged. This event indicates that one of those merge groups was destroyed. This happens when a pull request is removed from the queue: any group containing that pull request is also destroyed.
     *
     * When you receive this event, you may want to cancel any checks that are running on the head SHA to avoid wasting computing resources on a merge group that will not be used.
     */
    post: operations["merge-group/destroyed"];
  };
  "meta-deleted": {
    /**
     * This event occurs when there is activity relating to a webhook itself.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Meta" app permission.
     * @description The webhook was deleted.
     */
    post: operations["meta/deleted"];
  };
  "milestone-closed": {
    /**
     * This event occurs when there is activity relating to milestones. For more information, see "[About milestones](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/about-milestones)." For information about the APIs to manage milestones, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#milestone) or "[Milestones](https://docs.github.com/rest/issues/milestones)" in the REST API documentation.
     *
     * If you want to receive an event when an issue or pull request is added to or removed from a milestone, use the `milestoned` or `demilestoned` action type for the `issues` or `pull_request` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" or "Pull requests" repository permissions.
     * @description A milestone was closed.
     */
    post: operations["milestone/closed"];
  };
  "milestone-created": {
    /**
     * This event occurs when there is activity relating to milestones. For more information, see "[About milestones](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/about-milestones)." For information about the APIs to manage milestones, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#milestone) or "[Milestones](https://docs.github.com/rest/issues/milestones)" in the REST API documentation.
     *
     * If you want to receive an event when an issue or pull request is added to or removed from a milestone, use the `milestoned` or `demilestoned` action type for the `issues` or `pull_request` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" or "Pull requests" repository permissions.
     * @description A milestone was created.
     */
    post: operations["milestone/created"];
  };
  "milestone-deleted": {
    /**
     * This event occurs when there is activity relating to milestones. For more information, see "[About milestones](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/about-milestones)." For information about the APIs to manage milestones, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#milestone) or "[Milestones](https://docs.github.com/rest/issues/milestones)" in the REST API documentation.
     *
     * If you want to receive an event when an issue or pull request is added to or removed from a milestone, use the `milestoned` or `demilestoned` action type for the `issues` or `pull_request` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" or "Pull requests" repository permissions.
     * @description A milestone was deleted.
     */
    post: operations["milestone/deleted"];
  };
  "milestone-edited": {
    /**
     * This event occurs when there is activity relating to milestones. For more information, see "[About milestones](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/about-milestones)." For information about the APIs to manage milestones, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#milestone) or "[Milestones](https://docs.github.com/rest/issues/milestones)" in the REST API documentation.
     *
     * If you want to receive an event when an issue or pull request is added to or removed from a milestone, use the `milestoned` or `demilestoned` action type for the `issues` or `pull_request` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" or "Pull requests" repository permissions.
     * @description A milestone was edited.
     */
    post: operations["milestone/edited"];
  };
  "milestone-opened": {
    /**
     * This event occurs when there is activity relating to milestones. For more information, see "[About milestones](https://docs.github.com/issues/using-labels-and-milestones-to-track-work/about-milestones)." For information about the APIs to manage milestones, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#milestone) or "[Milestones](https://docs.github.com/rest/issues/milestones)" in the REST API documentation.
     *
     * If you want to receive an event when an issue or pull request is added to or removed from a milestone, use the `milestoned` or `demilestoned` action type for the `issues` or `pull_request` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" or "Pull requests" repository permissions.
     * @description A milestone was opened.
     */
    post: operations["milestone/opened"];
  };
  "org-block-blocked": {
    /**
     * This event occurs when organization owners or moderators block or unblock a non-member from collaborating on the organization's repositories. For more information, see "[Blocking a user from your organization](https://docs.github.com/communities/maintaining-your-safety-on-github/blocking-a-user-from-your-organization)." For information about the APIs to manage blocked users, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#userblockedevent) or "[Blocking users](https://docs.github.com/rest/orgs/blocking)" in the REST API documentation.
     *
     * If you want to receive an event when members are added or removed from an organization, use the `organization` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" organization permission.
     * @description A user was blocked from the organization.
     */
    post: operations["org-block/blocked"];
  };
  "org-block-unblocked": {
    /**
     * This event occurs when organization owners or moderators block or unblock a non-member from collaborating on the organization's repositories. For more information, see "[Blocking a user from your organization](https://docs.github.com/communities/maintaining-your-safety-on-github/blocking-a-user-from-your-organization)." For information about the APIs to manage blocked users, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#userblockedevent) or "[Blocking users](https://docs.github.com/rest/orgs/blocking)" in the REST API documentation.
     *
     * If you want to receive an event when members are added or removed from an organization, use the `organization` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" organization permission.
     * @description A previously blocked user was unblocked from the organization.
     */
    post: operations["org-block/unblocked"];
  };
  "organization-deleted": {
    /**
     * This event occurs when there is activity relating to an organization and its members. For more information, see "[About organizations](https://docs.github.com/organizations/collaborating-with-groups-in-organizations/about-organizations)." For information about the APIs to manage organizations, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#organization) or "[Organizations](https://docs.github.com/rest/orgs)" in the REST API documentation.
     *
     * If you want to receive an event when a non-member is blocked or unblocked from an organization, use the `org_block` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description An organization was deleted.
     */
    post: operations["organization/deleted"];
  };
  "organization-member-added": {
    /**
     * This event occurs when there is activity relating to an organization and its members. For more information, see "[About organizations](https://docs.github.com/organizations/collaborating-with-groups-in-organizations/about-organizations)." For information about the APIs to manage organizations, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#organization) or "[Organizations](https://docs.github.com/rest/orgs)" in the REST API documentation.
     *
     * If you want to receive an event when a non-member is blocked or unblocked from an organization, use the `org_block` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A member accepted an invitation to join an organization.
     */
    post: operations["organization/member-added"];
  };
  "organization-member-invited": {
    /**
     * This event occurs when there is activity relating to an organization and its members. For more information, see "[About organizations](https://docs.github.com/organizations/collaborating-with-groups-in-organizations/about-organizations)." For information about the APIs to manage organizations, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#organization) or "[Organizations](https://docs.github.com/rest/orgs)" in the REST API documentation.
     *
     * If you want to receive an event when a non-member is blocked or unblocked from an organization, use the `org_block` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A member was invited to join the organization.
     */
    post: operations["organization/member-invited"];
  };
  "organization-member-removed": {
    /**
     * This event occurs when there is activity relating to an organization and its members. For more information, see "[About organizations](https://docs.github.com/organizations/collaborating-with-groups-in-organizations/about-organizations)." For information about the APIs to manage organizations, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#organization) or "[Organizations](https://docs.github.com/rest/orgs)" in the REST API documentation.
     *
     * If you want to receive an event when a non-member is blocked or unblocked from an organization, use the `org_block` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A member was removed from the organization.
     */
    post: operations["organization/member-removed"];
  };
  "organization-renamed": {
    /**
     * This event occurs when there is activity relating to an organization and its members. For more information, see "[About organizations](https://docs.github.com/organizations/collaborating-with-groups-in-organizations/about-organizations)." For information about the APIs to manage organizations, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#organization) or "[Organizations](https://docs.github.com/rest/orgs)" in the REST API documentation.
     *
     * If you want to receive an event when a non-member is blocked or unblocked from an organization, use the `org_block` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description The name of an organization was changed.
     */
    post: operations["organization/renamed"];
  };
  "package-published": {
    /**
     * This event occurs when there is activity relating to GitHub Packages. For more information, see "[Introduction to GitHub Packages](https://docs.github.com/packages/learn-github-packages/introduction-to-github-packages)." For information about the APIs to manage GitHub Packages, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#package) or "[Packages](https://docs.github.com/rest/packages)" in the REST API documentation.
     *
     * To install this event on a GitHub App, the app must have at least read-level access for the "Packages" repository permission.
     * @description A package was published to a registry.
     */
    post: operations["package/published"];
  };
  "package-updated": {
    /**
     * This event occurs when there is activity relating to GitHub Packages. For more information, see "[Introduction to GitHub Packages](https://docs.github.com/packages/learn-github-packages/introduction-to-github-packages)." For information about the APIs to manage GitHub Packages, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#package) or "[Packages](https://docs.github.com/rest/packages)" in the REST API documentation.
     *
     * To install this event on a GitHub App, the app must have at least read-level access for the "Packages" repository permission.
     * @description A previously published package was updated.
     */
    post: operations["package/updated"];
  };
  "page-build": {
    /**
     * This event occurs when there is an attempted build of a GitHub Pages site. This event occurs regardless of whether the build is successful. For more information, see "[Configuring a publishing source for your GitHub Pages site](https://docs.github.com/pages/getting-started-with-github-pages/configuring-a-publishing-source-for-your-github-pages-site)." For information about the API to manage GitHub Pages, see "[Pages](https://docs.github.com/rest/pages)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pages" repository permission.
     */
    post: operations["page-build"];
  };
  "personal-access-token-request-approved": {
    /**
     * This event occurs when there is activity relating to a request for a fine-grained personal access token to access resources that belong to a resource owner that requires approval for token access. For more information, see "[Creating a personal access token](https://docs.github.com/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Personal access token requests" organization permission.
     * @description A fine-grained personal access token request was approved.
     */
    post: operations["personal-access-token-request/approved"];
  };
  "personal-access-token-request-cancelled": {
    /**
     * This event occurs when there is activity relating to a request for a fine-grained personal access token to access resources that belong to a resource owner that requires approval for token access. For more information, see "[Creating a personal access token](https://docs.github.com/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Personal access token requests" organization permission.
     * @description A fine-grained personal access token request was cancelled by the requester.
     */
    post: operations["personal-access-token-request/cancelled"];
  };
  "personal-access-token-request-created": {
    /**
     * This event occurs when there is activity relating to a request for a fine-grained personal access token to access resources that belong to a resource owner that requires approval for token access. For more information, see "[Creating a personal access token](https://docs.github.com/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Personal access token requests" organization permission.
     * @description A fine-grained personal access token request was created.
     */
    post: operations["personal-access-token-request/created"];
  };
  "personal-access-token-request-denied": {
    /**
     * This event occurs when there is activity relating to a request for a fine-grained personal access token to access resources that belong to a resource owner that requires approval for token access. For more information, see "[Creating a personal access token](https://docs.github.com/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Personal access token requests" organization permission.
     * @description A fine-grained personal access token request was denied.
     */
    post: operations["personal-access-token-request/denied"];
  };
  ping: {
    /** This event occurs when you create a new webhook. The ping event is a confirmation from GitHub that you configured the webhook correctly. */
    post: operations["ping"];
  };
  "project-card-converted": {
    /**
     * This event occurs when there is activity relating to a card on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a column on a project (classic), use the `project` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A note in a project (classic) was converted to an issue.
     */
    post: operations["project-card/converted"];
  };
  "project-card-created": {
    /**
     * This event occurs when there is activity relating to a card on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a column on a project (classic), use the `project` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A card was added to a project (classic).
     */
    post: operations["project-card/created"];
  };
  "project-card-deleted": {
    /**
     * This event occurs when there is activity relating to a card on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a column on a project (classic), use the `project` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A card on a project (classic) was deleted.
     */
    post: operations["project-card/deleted"];
  };
  "project-card-edited": {
    /**
     * This event occurs when there is activity relating to a card on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a column on a project (classic), use the `project` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A note on a project (classic) was edited.
     */
    post: operations["project-card/edited"];
  };
  "project-card-moved": {
    /**
     * This event occurs when there is activity relating to a card on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a column on a project (classic), use the `project` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A card on a project (classic) was moved to another column or to another position in its column.
     */
    post: operations["project-card/moved"];
  };
  "project-closed": {
    /**
     * This event occurs when there is activity relating to a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a card or column on a project (classic), use the `project_card` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A project (classic) was closed.
     */
    post: operations["project/closed"];
  };
  "project-column-created": {
    /**
     * This event occurs when there is activity relating to a column on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a card on a project (classic), use the `project` and `project_card` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A column was added to a project (classic).
     */
    post: operations["project-column/created"];
  };
  "project-column-deleted": {
    /**
     * This event occurs when there is activity relating to a column on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a card on a project (classic), use the `project` and `project_card` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A column was deleted from a project (classic).
     */
    post: operations["project-column/deleted"];
  };
  "project-column-edited": {
    /**
     * This event occurs when there is activity relating to a column on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a card on a project (classic), use the `project` and `project_card` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description The name of a column on a project (classic) was changed.
     */
    post: operations["project-column/edited"];
  };
  "project-column-moved": {
    /**
     * This event occurs when there is activity relating to a column on a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a project (classic) or a card on a project (classic), use the `project` and `project_card` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A column was moved to a new position on a project (classic).
     */
    post: operations["project-column/moved"];
  };
  "project-created": {
    /**
     * This event occurs when there is activity relating to a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a card or column on a project (classic), use the `project_card` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A project (classic) was created.
     */
    post: operations["project/created"];
  };
  "project-deleted": {
    /**
     * This event occurs when there is activity relating to a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a card or column on a project (classic), use the `project_card` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A project (classic) was deleted.
     */
    post: operations["project/deleted"];
  };
  "project-edited": {
    /**
     * This event occurs when there is activity relating to a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a card or column on a project (classic), use the `project_card` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description The name or description of a project (classic) was changed.
     */
    post: operations["project/edited"];
  };
  "project-reopened": {
    /**
     * This event occurs when there is activity relating to a project (classic). For more information, see "[About projects (classic)](https://docs.github.com/issues/organizing-your-work-with-project-boards/managing-project-boards/about-project-boards)." For information about the API to manage classic projects, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#project) or "[Projects (classic)](https://docs.github.com/rest/projects)" in the REST API documentation.
     *
     * For activity relating to a card or column on a project (classic), use the `project_card` and `project_column` event.
     *
     * This event relates to projects (classic) only. For activity relating to the new Projects experience, use the `projects_v2` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" repository or organization permission.
     * @description A project (classic) was closed.
     */
    post: operations["project/reopened"];
  };
  "projects-v2-closed": {
    /**
     * This event occurs when there is activity relating to an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2).
     *
     * For activity relating to a item on a project, use the `projects_v2_item` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A project in the organization was closed.
     */
    post: operations["projects-v2/closed"];
  };
  "projects-v2-created": {
    /**
     * This event occurs when there is activity relating to an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2).
     *
     * For activity relating to a item on a project, use the `projects_v2_item` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A project in the organization was created.
     */
    post: operations["projects-v2/created"];
  };
  "projects-v2-deleted": {
    /**
     * This event occurs when there is activity relating to an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2).
     *
     * For activity relating to a item on a project, use the `projects_v2_item` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A project in the organization was deleted.
     */
    post: operations["projects-v2/deleted"];
  };
  "projects-v2-edited": {
    /**
     * This event occurs when there is activity relating to an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2).
     *
     * For activity relating to a item on a project, use the `projects_v2_item` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description The title, description, or README of a project in the organization was changed.
     */
    post: operations["projects-v2/edited"];
  };
  "projects-v2-item-archived": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description An item on an organization project was archived. For more information, see "[Archiving items from your project](https://docs.github.com/issues/planning-and-tracking-with-projects/managing-items-in-your-project/archiving-items-from-your-project)."
     */
    post: operations["projects-v2-item/archived"];
  };
  "projects-v2-item-converted": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A draft issue in an organization project was converted to an issue.
     */
    post: operations["projects-v2-item/converted"];
  };
  "projects-v2-item-created": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description An item was added to a project in the organization.
     */
    post: operations["projects-v2-item/created"];
  };
  "projects-v2-item-deleted": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description An item was deleted from a project in the organization.
     */
    post: operations["projects-v2-item/deleted"];
  };
  "projects-v2-item-edited": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description The values or state of an item in an organization project were changed. For example, the value of a field was updated, the body of a draft issue was changed, or a draft issue was converted to an issue.
     */
    post: operations["projects-v2-item/edited"];
  };
  "projects-v2-item-reordered": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description The position of an item in an organization project was changed. For example, an item was moved above or below another item in the table or board layout.
     */
    post: operations["projects-v2-item/reordered"];
  };
  "projects-v2-item-restored": {
    /**
     * This event occurs when there is activity relating to an item on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2item).
     *
     * For activity relating to a project (instead of an item on a project), use the `projects_v2` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description An archived item on an organization project was restored from the archive. For more information, see "[Archiving items from your project](https://docs.github.com/issues/planning-and-tracking-with-projects/managing-items-in-your-project/archiving-items-from-your-project)."
     */
    post: operations["projects-v2-item/restored"];
  };
  "projects-v2-reopened": {
    /**
     * This event occurs when there is activity relating to an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)." For information about the Projects API, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#projectv2).
     *
     * For activity relating to a item on a project, use the `projects_v2_item` event. For activity relating to Projects (classic), use the `project`, `project_card`, and `project_column` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > Webhook events for projects are currently in public preview and subject to change. To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A project in the organization was reopened.
     */
    post: operations["projects-v2/reopened"];
  };
  "projects-v2-status-update-created": {
    /**
     * This event occurs when there is activity relating to a status update on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)."
     *
     * For activity relating to a project, use the `projects_v2` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A status update was added to a project in the organization.
     */
    post: operations["projects-v2-status-update/created"];
  };
  "projects-v2-status-update-deleted": {
    /**
     * This event occurs when there is activity relating to a status update on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)."
     *
     * For activity relating to a project, use the `projects_v2` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A status update was removed from a project in the organization.
     */
    post: operations["projects-v2-status-update/deleted"];
  };
  "projects-v2-status-update-edited": {
    /**
     * This event occurs when there is activity relating to a status update on an organization-level project. For more information, see "[About Projects](https://docs.github.com/issues/planning-and-tracking-with-projects/learning-about-projects/about-projects)."
     *
     * For activity relating to a project, use the `projects_v2` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Projects" organization permission.
     *
     * > [!NOTE]
     * > To share feedback about projects webhooks with GitHub, see the [Projects webhook feedback discussion](https://github.com/orgs/community/discussions/17405).
     * @description A status update was edited on a project in the organization.
     */
    post: operations["projects-v2-status-update/edited"];
  };
  public: {
    /**
     * This event occurs when repository visibility changes from private to public. For more information, see "[Setting repository visibility](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/managing-repository-settings/setting-repository-visibility)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     */
    post: operations["public"];
  };
  "pull-request-assigned": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was assigned to a user.
     */
    post: operations["pull-request/assigned"];
  };
  "pull-request-auto-merge-disabled": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description Auto merge was disabled for a pull request. For more information, see "[Automatically merging a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/incorporating-changes-from-a-pull-request/automatically-merging-a-pull-request)."
     */
    post: operations["pull-request/auto-merge-disabled"];
  };
  "pull-request-auto-merge-enabled": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description Auto merge was enabled for a pull request. For more information, see "[Automatically merging a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/incorporating-changes-from-a-pull-request/automatically-merging-a-pull-request)."
     */
    post: operations["pull-request/auto-merge-enabled"];
  };
  "pull-request-closed": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was closed. If `merged` is false in the webhook payload, the pull request was closed with unmerged commits. If `merged` is true in the webhook payload, the pull request was merged.
     */
    post: operations["pull-request/closed"];
  };
  "pull-request-converted-to-draft": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was converted to a draft. For more information, see "[Changing the stage of a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/changing-the-stage-of-a-pull-request)."
     */
    post: operations["pull-request/converted-to-draft"];
  };
  "pull-request-demilestoned": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was removed from a milestone.
     */
    post: operations["pull-request/demilestoned"];
  };
  "pull-request-dequeued": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was removed from the merge queue.
     */
    post: operations["pull-request/dequeued"];
  };
  "pull-request-edited": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description The title or body of a pull request was edited, or the base branch of a pull request was changed.
     */
    post: operations["pull-request/edited"];
  };
  "pull-request-enqueued": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was added to the merge queue.
     */
    post: operations["pull-request/enqueued"];
  };
  "pull-request-labeled": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A label was added to a pull request.
     */
    post: operations["pull-request/labeled"];
  };
  "pull-request-locked": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description Conversation on a pull request was locked. For more information, see "[Locking conversations](https://docs.github.com/communities/moderating-comments-and-conversations/locking-conversations)."
     */
    post: operations["pull-request/locked"];
  };
  "pull-request-milestoned": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was added to a milestone.
     */
    post: operations["pull-request/milestoned"];
  };
  "pull-request-opened": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request was created
     */
    post: operations["pull-request/opened"];
  };
  "pull-request-ready-for-review": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A draft pull request was marked as ready for review. For more information, see "[Changing the stage of a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/changing-the-stage-of-a-pull-request)."
     */
    post: operations["pull-request/ready-for-review"];
  };
  "pull-request-reopened": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A previously closed pull request was reopened.
     */
    post: operations["pull-request/reopened"];
  };
  "pull-request-review-comment-created": {
    /**
     * This event occurs when there is activity relating to a pull request review comment. A pull request review comment is a comment on a pull request's diff. For more information, see "[Commenting on a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)." For information about the APIs to manage pull request review comments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreviewcomment) or "[Pull request review comments](https://docs.github.com/rest/pulls/comments)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request comments, or pull request review threads, use the `pull_request_review`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A comment on a pull request diff was created.
     */
    post: operations["pull-request-review-comment/created"];
  };
  "pull-request-review-comment-deleted": {
    /**
     * This event occurs when there is activity relating to a pull request review comment. A pull request review comment is a comment on a pull request's diff. For more information, see "[Commenting on a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)." For information about the APIs to manage pull request review comments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreviewcomment) or "[Pull request review comments](https://docs.github.com/rest/pulls/comments)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request comments, or pull request review threads, use the `pull_request_review`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A comment on a pull request diff was deleted.
     */
    post: operations["pull-request-review-comment/deleted"];
  };
  "pull-request-review-comment-edited": {
    /**
     * This event occurs when there is activity relating to a pull request review comment. A pull request review comment is a comment on a pull request's diff. For more information, see "[Commenting on a pull request](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)." For information about the APIs to manage pull request review comments, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreviewcomment) or "[Pull request review comments](https://docs.github.com/rest/pulls/comments)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request comments, or pull request review threads, use the `pull_request_review`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description The content of a comment on a pull request diff was changed.
     */
    post: operations["pull-request-review-comment/edited"];
  };
  "pull-request-review-dismissed": {
    /**
     * This event occurs when there is activity relating to a pull request review. A pull request review is a group of pull request review comments in addition to a body comment and a state. For more information, see "[About pull request reviews](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/about-pull-request-reviews)." For information about the APIs to manage pull request reviews, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreview) or "[Pull request reviews](https://docs.github.com/rest/pulls/reviews)" in the REST API documentation.
     *
     * For activity related to pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A review on a pull request was dismissed.
     */
    post: operations["pull-request-review/dismissed"];
  };
  "pull-request-review-edited": {
    /**
     * This event occurs when there is activity relating to a pull request review. A pull request review is a group of pull request review comments in addition to a body comment and a state. For more information, see "[About pull request reviews](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/about-pull-request-reviews)." For information about the APIs to manage pull request reviews, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreview) or "[Pull request reviews](https://docs.github.com/rest/pulls/reviews)" in the REST API documentation.
     *
     * For activity related to pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description The body comment on a pull request review was edited.
     */
    post: operations["pull-request-review/edited"];
  };
  "pull-request-review-request-removed": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A request for review by a person or team was removed from a pull request.
     */
    post: operations["pull-request/review-request-removed"];
  };
  "pull-request-review-requested": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description Review by a person or team was requested for a pull request. For more information, see "[Requesting a pull request review](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/requesting-a-pull-request-review)."
     */
    post: operations["pull-request/review-requested"];
  };
  "pull-request-review-submitted": {
    /**
     * This event occurs when there is activity relating to a pull request review. A pull request review is a group of pull request review comments in addition to a body comment and a state. For more information, see "[About pull request reviews](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/about-pull-request-reviews)." For information about the APIs to manage pull request reviews, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreview) or "[Pull request reviews](https://docs.github.com/rest/pulls/reviews)" in the REST API documentation.
     *
     * For activity related to pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A review on a pull request was submitted.
     */
    post: operations["pull-request-review/submitted"];
  };
  "pull-request-review-thread-resolved": {
    /**
     * This event occurs when there is activity relating to a comment thread on a pull request. For more information, see "[About pull request reviews](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/about-pull-request-reviews)." For information about the APIs to manage pull request reviews, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreviewthread) or "[Pull request review comments](https://docs.github.com/rest/pulls/comments)" in the REST API documentation.
     *
     * For activity related to pull request review comments, pull request comments, or pull request reviews, use the `pull_request_review_comment`, `issue_comment`, or `pull_request_review` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A comment thread on a pull request was marked as resolved.
     */
    post: operations["pull-request-review-thread/resolved"];
  };
  "pull-request-review-thread-unresolved": {
    /**
     * This event occurs when there is activity relating to a comment thread on a pull request. For more information, see "[About pull request reviews](https://docs.github.com/pull-requests/collaborating-with-pull-requests/reviewing-changes-in-pull-requests/about-pull-request-reviews)." For information about the APIs to manage pull request reviews, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequestreviewthread) or "[Pull request review comments](https://docs.github.com/rest/pulls/comments)" in the REST API documentation.
     *
     * For activity related to pull request review comments, pull request comments, or pull request reviews, use the `pull_request_review_comment`, `issue_comment`, or `pull_request_review` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A previously resolved comment thread on a pull request was marked as unresolved.
     */
    post: operations["pull-request-review-thread/unresolved"];
  };
  "pull-request-synchronize": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A pull request's head branch was updated. For example, the head branch was updated from the base branch or new commits were pushed to the head branch.
     */
    post: operations["pull-request/synchronize"];
  };
  "pull-request-unassigned": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A user was unassigned from a pull request.
     */
    post: operations["pull-request/unassigned"];
  };
  "pull-request-unlabeled": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description A label was removed from a pull request.
     */
    post: operations["pull-request/unlabeled"];
  };
  "pull-request-unlocked": {
    /**
     * This event occurs when there is activity on a pull request. For more information, see "[About pull requests](https://docs.github.com/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)." For information about the APIs to manage pull requests, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#pullrequest) or "[Pulls](https://docs.github.com/rest/pulls/pulls)" in the REST API documentation.
     *
     * For activity related to pull request reviews, pull request review comments, pull request comments, or pull request review threads, use the `pull_request_review`, `pull_request_review_comment`, `issue_comment`, or `pull_request_review_thread` events instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Pull requests" repository permission.
     * @description Conversation on a pull request was unlocked. For more information, see "[Locking conversations](https://docs.github.com/communities/moderating-comments-and-conversations/locking-conversations)."
     */
    post: operations["pull-request/unlocked"];
  };
  push: {
    /**
     * This event occurs when there is a push to a repository branch. This includes when a commit is pushed, when a commit tag is pushed,
     * when a branch is deleted, when a tag is deleted, or when a repository is created from a template. To subscribe to only branch
     * and tag deletions, use the [`delete`](#delete) webhook event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     *
     * > [!NOTE]
     * > Events will not be created if more than 5000 branches are pushed at once. Events will not be created for tags when more than three tags are pushed at once.
     */
    post: operations["push"];
  };
  "registry-package-published": {
    /**
     * This event occurs when there is activity relating to GitHub Packages. For more information, see "[Introduction to GitHub Packages](https://docs.github.com/packages/learn-github-packages/introduction-to-github-packages)." For information about the APIs to manage GitHub Packages, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#package) or "[Packages](https://docs.github.com/rest/packages)" in the REST API documentation.
     *
     * To install this event on a GitHub App, the app must have at least read-level access for the "Packages" repository permission.
     *
     * > [!NOTE]
     * > GitHub recommends that you use the newer `package` event instead.
     * @description A package was published to a registry.
     */
    post: operations["registry-package/published"];
  };
  "registry-package-updated": {
    /**
     * This event occurs when there is activity relating to GitHub Packages. For more information, see "[Introduction to GitHub Packages](https://docs.github.com/packages/learn-github-packages/introduction-to-github-packages)." For information about the APIs to manage GitHub Packages, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#package) or "[Packages](https://docs.github.com/rest/packages)" in the REST API documentation.
     *
     * To install this event on a GitHub App, the app must have at least read-level access for the "Packages" repository permission.
     *
     * > [!NOTE]
     * > GitHub recommends that you use the newer `package` event instead.
     * @description A package that was previously published to a registry was updated.
     */
    post: operations["registry-package/updated"];
  };
  "release-created": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description A draft was saved, or a release or pre-release was published without previously being saved as a draft.
     */
    post: operations["release/created"];
  };
  "release-deleted": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description A release, pre-release, or draft release was deleted.
     */
    post: operations["release/deleted"];
  };
  "release-edited": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description The details of a release, pre-release, or draft release were edited. For more information, see "[Managing releases in a repository](https://docs.github.com/repositories/releasing-projects-on-github/managing-releases-in-a-repository#editing-a-release)."
     */
    post: operations["release/edited"];
  };
  "release-prereleased": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description A release was created and identified as a pre-release. A pre-release is a release that is not ready for production and may be unstable.
     */
    post: operations["release/prereleased"];
  };
  "release-published": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description A release, pre-release, or draft of a release was published.
     */
    post: operations["release/published"];
  };
  "release-released": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description A release was published, or a pre-release was changed to a release.
     */
    post: operations["release/released"];
  };
  "release-unpublished": {
    /**
     * This event occurs when there is activity relating to releases. For more information, see "[About releases](https://docs.github.com/repositories/releasing-projects-on-github/about-releases)." For information about the APIs to manage releases, see [the GraphQL API documentation](https://docs.github.com/graphql/reference/objects#release) or "[Releases](https://docs.github.com/rest/releases)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     * @description A release or pre-release was unpublished.
     */
    post: operations["release/unpublished"];
  };
  "repository-advisory-published": {
    /**
     * This event occurs when there is activity relating to a repository security advisory. For more information about repository security advisories, see "[About GitHub Security Advisories for repositories](https://docs.github.com/code-security/repository-security-advisories/about-github-security-advisories-for-repositories)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Repository security advisories" permission.
     * @description A repository security advisory was published.
     */
    post: operations["repository-advisory/published"];
  };
  "repository-advisory-reported": {
    /**
     * This event occurs when there is activity relating to a repository security advisory. For more information about repository security advisories, see "[About GitHub Security Advisories for repositories](https://docs.github.com/code-security/repository-security-advisories/about-github-security-advisories-for-repositories)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Repository security advisories" permission.
     * @description A private vulnerability report was submitted.
     */
    post: operations["repository-advisory/reported"];
  };
  "repository-archived": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A repository was archived.
     */
    post: operations["repository/archived"];
  };
  "repository-created": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A repository was created.
     */
    post: operations["repository/created"];
  };
  "repository-deleted": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A repository was deleted. GitHub Apps and repository webhooks will not receive this event.
     */
    post: operations["repository/deleted"];
  };
  "repository-dispatch-sample.collected": {
    /**
     * This event occurs when a GitHub App sends a `POST` request to `/repos/{owner}/{repo}/dispatches`. For more information, see [the REST API documentation for creating a repository dispatch event](https://docs.github.com/rest/repos/repos#create-a-repository-dispatch-event). In the payload, the `action` will be the `event_type` that was specified in the `POST /repos/{owner}/{repo}/dispatches` request body.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     */
    post: operations["repository-dispatch/sample.collected"];
  };
  "repository-edited": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description The topics, default branch, description, or homepage of a repository was changed.
     */
    post: operations["repository/edited"];
  };
  "repository-import": {
    /** This event occurs when a repository is imported to GitHub. For more information, see "[Importing a repository with GitHub Importer](https://docs.github.com/get-started/importing-your-projects-to-github/importing-source-code-to-github/importing-a-repository-with-github-importer)." For more information about the API to manage imports, see [the REST API documentation](https://docs.github.com/rest/migrations/source-imports). */
    post: operations["repository-import"];
  };
  "repository-privatized": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description The visibility of a repository was changed to `private`.
     */
    post: operations["repository/privatized"];
  };
  "repository-publicized": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description The visibility of a repository was changed to `public`.
     */
    post: operations["repository/publicized"];
  };
  "repository-renamed": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description The name of a repository was changed.
     */
    post: operations["repository/renamed"];
  };
  "repository-ruleset-created": {
    /**
     * This event occurs when there is activity relating to repository rulesets.
     * For more information about repository rulesets, see "[Managing rulesets](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets)."
     * For more information on managing rulesets via the APIs, see [Repository ruleset](https://docs.github.com/graphql/reference/objects#repositoryruleset) in the GraphQL documentation or "[Repository rules](https://docs.github.com/rest/repos/rules)" and "[Organization rules](https://docs.github.com/rest/orgs/rules) in the REST API documentation."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository or organization permission.
     * @description A repository ruleset was created.
     */
    post: operations["repository-ruleset/created"];
  };
  "repository-ruleset-deleted": {
    /**
     * This event occurs when there is activity relating to repository rulesets.
     * For more information about repository rulesets, see "[Managing rulesets](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets)."
     * For more information on managing rulesets via the APIs, see [Repository ruleset](https://docs.github.com/graphql/reference/objects#repositoryruleset) in the GraphQL documentation or "[Repository rules](https://docs.github.com/rest/repos/rules)" and "[Organization rules](https://docs.github.com/rest/orgs/rules) in the REST API documentation."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository or organization permission.
     * @description A repository ruleset was deleted.
     */
    post: operations["repository-ruleset/deleted"];
  };
  "repository-ruleset-edited": {
    /**
     * This event occurs when there is activity relating to repository rulesets.
     * For more information about repository rulesets, see "[Managing rulesets](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets)."
     * For more information on managing rulesets via the APIs, see [Repository ruleset](https://docs.github.com/graphql/reference/objects#repositoryruleset) in the GraphQL documentation or "[Repository rules](https://docs.github.com/rest/repos/rules)" and "[Organization rules](https://docs.github.com/rest/orgs/rules) in the REST API documentation."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository or organization permission.
     * @description A repository ruleset was edited.
     */
    post: operations["repository-ruleset/edited"];
  };
  "repository-transferred": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description Ownership of the repository was transferred to a user or organization account. This event is only sent to the account where the ownership is transferred. To receive the `repository.transferred` event, the new owner account must have the GitHub App installed, and the App must be subscribed to "Repository" events.
     */
    post: operations["repository/transferred"];
  };
  "repository-unarchived": {
    /**
     * This event occurs when there is activity relating to repositories. For more information, see "[About repositories](https://docs.github.com/repositories/creating-and-managing-repositories/about-repositories)." For information about the APIs to manage repositories, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#repository) or "[Repositories](https://docs.github.com/rest/repos)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description A previously archived repository was unarchived.
     */
    post: operations["repository/unarchived"];
  };
  "repository-vulnerability-alert-create": {
    /**
     * This event occurs when there is activity relating to a security vulnerability alert in a repository.
     *
     * > [!WARNING]
     * > **Closing down notice:** This event is closing down. Use the `dependabot_alert` event instead.
     * @description A repository vulnerability alert was created.
     */
    post: operations["repository-vulnerability-alert/create"];
  };
  "repository-vulnerability-alert-dismiss": {
    /**
     * This event occurs when there is activity relating to a security vulnerability alert in a repository.
     *
     * > [!WARNING]
     * > **Closing down notice:** This event is closing down. Use the `dependabot_alert` event instead.
     * @description A repository vulnerability alert was dismissed.
     */
    post: operations["repository-vulnerability-alert/dismiss"];
  };
  "repository-vulnerability-alert-reopen": {
    /**
     * This event occurs when there is activity relating to a security vulnerability alert in a repository.
     *
     * > [!WARNING]
     * > **Closing down notice:** This event is closing down. Use the `dependabot_alert` event instead.
     * @description A previously dismissed or resolved repository vulnerability alert was reopened.
     */
    post: operations["repository-vulnerability-alert/reopen"];
  };
  "repository-vulnerability-alert-resolve": {
    /**
     * This event occurs when there is activity relating to a security vulnerability alert in a repository.
     *
     * > [!WARNING]
     * > **Closing down notice:** This event is closing down. Use the `dependabot_alert` event instead.
     * @description A repository vulnerability alert was marked as resolved.
     */
    post: operations["repository-vulnerability-alert/resolve"];
  };
  "secret-scanning-alert-created": {
    /**
     * This event occurs when there is activity relating to a secret scanning alert. For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)." For information about the API to manage secret scanning alerts, see "[Secret scanning](https://docs.github.com/rest/secret-scanning)" in the REST API documentation.
     *
     * For activity relating to secret scanning alert locations, use the `secret_scanning_alert_location` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A secret scanning alert was created.
     */
    post: operations["secret-scanning-alert/created"];
  };
  "secret-scanning-alert-location-created": {
    /**
     * This event occurs when there is activity relating to the locations of a secret in a secret scanning alert.
     *
     * For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)." For information about the API to manage secret scanning alerts, see "[Secret scanning](https://docs.github.com/rest/secret-scanning)" in the REST API documentation.
     *
     * For activity relating to secret scanning alerts, use the `secret_scanning_alert` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A new instance of a previously detected secret was detected in a repository, and the location of the secret was added to the existing alert.
     */
    post: operations["secret-scanning-alert-location/created"];
  };
  "secret-scanning-alert-publicly-leaked": {
    /**
     * This event occurs when there is activity relating to a secret scanning alert. For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)." For information about the API to manage secret scanning alerts, see "[Secret scanning](https://docs.github.com/rest/secret-scanning)" in the REST API documentation.
     *
     * For activity relating to secret scanning alert locations, use the `secret_scanning_alert_location` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A secret scanning alert was detected in a public repo.
     */
    post: operations["secret-scanning-alert/publicly-leaked"];
  };
  "secret-scanning-alert-reopened": {
    /**
     * This event occurs when there is activity relating to a secret scanning alert. For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)." For information about the API to manage secret scanning alerts, see "[Secret scanning](https://docs.github.com/rest/secret-scanning)" in the REST API documentation.
     *
     * For activity relating to secret scanning alert locations, use the `secret_scanning_alert_location` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A previously closed secret scanning alert was reopened.
     */
    post: operations["secret-scanning-alert/reopened"];
  };
  "secret-scanning-alert-resolved": {
    /**
     * This event occurs when there is activity relating to a secret scanning alert. For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)." For information about the API to manage secret scanning alerts, see "[Secret scanning](https://docs.github.com/rest/secret-scanning)" in the REST API documentation.
     *
     * For activity relating to secret scanning alert locations, use the `secret_scanning_alert_location` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A secret scanning alert was closed.
     */
    post: operations["secret-scanning-alert/resolved"];
  };
  "secret-scanning-alert-validated": {
    /**
     * This event occurs when there is activity relating to a secret scanning alert. For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)." For information about the API to manage secret scanning alerts, see "[Secret scanning](https://docs.github.com/rest/secret-scanning)" in the REST API documentation.
     *
     * For activity relating to secret scanning alert locations, use the `secret_scanning_alert_location` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A secret scanning alert was validated.
     */
    post: operations["secret-scanning-alert/validated"];
  };
  "secret-scanning-scan-completed": {
    /**
     * This event occurs when secret scanning completes certain scans on a repository. For more information about secret scanning, see "[About secret scanning](https://docs.github.com/code-security/secret-scanning/about-secret-scanning)."
     *
     * Scans can originate from multiple events such as updates to a custom pattern, a push to a repository, or updates
     * to patterns from partners. For more information on custom patterns, see "[About custom patterns](https://docs.github.com/code-security/secret-scanning/using-advanced-secret-scanning-and-push-protection-features/custom-patterns)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Secret scanning alerts" repository permission.
     * @description A secret scanning scan was completed.
     */
    post: operations["secret-scanning-scan/completed"];
  };
  "security-advisory-published": {
    /**
     * This event occurs when there is activity relating to a global security advisory that was reviewed by GitHub. A GitHub-reviewed global security advisory provides information about security vulnerabilities or malware that have been mapped to packages in ecosystems we support. For more information about global security advisories, see "[About global security advisories](https://docs.github.com/code-security/security-advisories/working-with-global-security-advisories-from-the-github-advisory-database/about-global-security-advisories)." For information about the API to manage security advisories, see [the REST API documentation](https://docs.github.com/rest/security-advisories/global-advisories) or [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#securityadvisory).
     *
     * GitHub Dependabot alerts are also powered by the security advisory dataset. For more information, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)."
     * @description A security advisory was published to the GitHub community.
     */
    post: operations["security-advisory/published"];
  };
  "security-advisory-updated": {
    /**
     * This event occurs when there is activity relating to a global security advisory that was reviewed by GitHub. A GitHub-reviewed global security advisory provides information about security vulnerabilities or malware that have been mapped to packages in ecosystems we support. For more information about global security advisories, see "[About global security advisories](https://docs.github.com/code-security/security-advisories/working-with-global-security-advisories-from-the-github-advisory-database/about-global-security-advisories)." For information about the API to manage security advisories, see [the REST API documentation](https://docs.github.com/rest/security-advisories/global-advisories) or [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#securityadvisory).
     *
     * GitHub Dependabot alerts are also powered by the security advisory dataset. For more information, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)."
     * @description The metadata or description of a security advisory was changed.
     */
    post: operations["security-advisory/updated"];
  };
  "security-advisory-withdrawn": {
    /**
     * This event occurs when there is activity relating to a global security advisory that was reviewed by GitHub. A GitHub-reviewed global security advisory provides information about security vulnerabilities or malware that have been mapped to packages in ecosystems we support. For more information about global security advisories, see "[About global security advisories](https://docs.github.com/code-security/security-advisories/working-with-global-security-advisories-from-the-github-advisory-database/about-global-security-advisories)." For information about the API to manage security advisories, see [the REST API documentation](https://docs.github.com/rest/security-advisories/global-advisories) or [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#securityadvisory).
     *
     * GitHub Dependabot alerts are also powered by the security advisory dataset. For more information, see "[About Dependabot alerts](https://docs.github.com/code-security/dependabot/dependabot-alerts/about-dependabot-alerts)."
     * @description A previously published security advisory was withdrawn.
     */
    post: operations["security-advisory/withdrawn"];
  };
  "security-and-analysis": {
    /**
     * This event occurs when code security and analysis features are enabled or disabled for a repository. For more information, see "[GitHub security features](https://docs.github.com/code-security/getting-started/github-security-features)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Administration" repository permission.
     */
    post: operations["security-and-analysis"];
  };
  "sponsorship-cancelled": {
    /**
     * This event occurs when there is activity relating to a sponsorship listing. For more information, see "[About GitHub Sponsors](https://docs.github.com/sponsors/getting-started-with-github-sponsors/about-github-sponsors)." For information about the API to manage sponsors, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#sponsorship).
     *
     * You can only create a sponsorship webhook on GitHub.com. For more information, see "[Configuring webhooks for events in your sponsored account](https://docs.github.com/sponsors/integrating-with-github-sponsors/configuring-webhooks-for-events-in-your-sponsored-account)."
     * @description A sponsorship was cancelled and the last billing cycle has ended.
     *
     * This event is only sent when a recurring (monthly) sponsorship is cancelled; it is not sent for one-time sponsorships.
     */
    post: operations["sponsorship/cancelled"];
  };
  "sponsorship-created": {
    /**
     * This event occurs when there is activity relating to a sponsorship listing. For more information, see "[About GitHub Sponsors](https://docs.github.com/sponsors/getting-started-with-github-sponsors/about-github-sponsors)." For information about the API to manage sponsors, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#sponsorship).
     *
     * You can only create a sponsorship webhook on GitHub.com. For more information, see "[Configuring webhooks for events in your sponsored account](https://docs.github.com/sponsors/integrating-with-github-sponsors/configuring-webhooks-for-events-in-your-sponsored-account)."
     * @description A sponsor created a sponsorship for a sponsored account. This event occurs once the payment is successfully processed.
     */
    post: operations["sponsorship/created"];
  };
  "sponsorship-edited": {
    /**
     * This event occurs when there is activity relating to a sponsorship listing. For more information, see "[About GitHub Sponsors](https://docs.github.com/sponsors/getting-started-with-github-sponsors/about-github-sponsors)." For information about the API to manage sponsors, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#sponsorship).
     *
     * You can only create a sponsorship webhook on GitHub.com. For more information, see "[Configuring webhooks for events in your sponsored account](https://docs.github.com/sponsors/integrating-with-github-sponsors/configuring-webhooks-for-events-in-your-sponsored-account)."
     * @description A monthly sponsor changed who can see their sponsorship. If you recognize your sponsors publicly, you may want to update your sponsor recognition to reflect the change when this event occurs.
     */
    post: operations["sponsorship/edited"];
  };
  "sponsorship-pending-cancellation": {
    /**
     * This event occurs when there is activity relating to a sponsorship listing. For more information, see "[About GitHub Sponsors](https://docs.github.com/sponsors/getting-started-with-github-sponsors/about-github-sponsors)." For information about the API to manage sponsors, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#sponsorship).
     *
     * You can only create a sponsorship webhook on GitHub.com. For more information, see "[Configuring webhooks for events in your sponsored account](https://docs.github.com/sponsors/integrating-with-github-sponsors/configuring-webhooks-for-events-in-your-sponsored-account)."
     * @description A sponsor scheduled a cancellation for their sponsorship. The cancellation will become effective on their next billing date.
     *
     * This event is only sent when a recurring (monthly) sponsorship is cancelled; it is not sent for one-time sponsorships.
     */
    post: operations["sponsorship/pending-cancellation"];
  };
  "sponsorship-pending-tier-change": {
    /**
     * This event occurs when there is activity relating to a sponsorship listing. For more information, see "[About GitHub Sponsors](https://docs.github.com/sponsors/getting-started-with-github-sponsors/about-github-sponsors)." For information about the API to manage sponsors, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#sponsorship).
     *
     * You can only create a sponsorship webhook on GitHub.com. For more information, see "[Configuring webhooks for events in your sponsored account](https://docs.github.com/sponsors/integrating-with-github-sponsors/configuring-webhooks-for-events-in-your-sponsored-account)."
     * @description A sponsor scheduled a downgrade to a lower sponsorship tier. The new tier will become effective on their next billing date.
     */
    post: operations["sponsorship/pending-tier-change"];
  };
  "sponsorship-tier-changed": {
    /**
     * This event occurs when there is activity relating to a sponsorship listing. For more information, see "[About GitHub Sponsors](https://docs.github.com/sponsors/getting-started-with-github-sponsors/about-github-sponsors)." For information about the API to manage sponsors, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#sponsorship).
     *
     * You can only create a sponsorship webhook on GitHub.com. For more information, see "[Configuring webhooks for events in your sponsored account](https://docs.github.com/sponsors/integrating-with-github-sponsors/configuring-webhooks-for-events-in-your-sponsored-account)."
     * @description A sponsor changed the tier of their sponsorship and the change has taken effect. If a sponsor upgraded their tier, the change took effect immediately. If a sponsor downgraded their tier, the change took effect at the beginning of the sponsor's next billing cycle.
     */
    post: operations["sponsorship/tier-changed"];
  };
  "star-created": {
    /**
     * This event occurs when there is activity relating to repository stars. For more information about stars, see "[Saving repositories with stars](https://docs.github.com/get-started/exploring-projects-on-github/saving-repositories-with-stars)." For information about the APIs to manage stars, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#starredrepositoryconnection) or "[Starring](https://docs.github.com/rest/activity/starring)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description Someone starred a repository.
     */
    post: operations["star/created"];
  };
  "star-deleted": {
    /**
     * This event occurs when there is activity relating to repository stars. For more information about stars, see "[Saving repositories with stars](https://docs.github.com/get-started/exploring-projects-on-github/saving-repositories-with-stars)." For information about the APIs to manage stars, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#starredrepositoryconnection) or "[Starring](https://docs.github.com/rest/activity/starring)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description Someone unstarred the repository.
     */
    post: operations["star/deleted"];
  };
  status: {
    /**
     * This event occurs when the status of a Git commit changes. For example, commits can be marked as `error`, `failure`, `pending`, or `success`. For more information, see "[About status checks](https://docs.github.com/pull-requests/collaborating-with-pull-requests/collaborating-on-repositories-with-code-quality-features/about-status-checks)." For information about the APIs to manage commit statuses, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#status) or "[Commit statuses](https://docs.github.com/rest/commits/statuses)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Commit statuses" repository permission.
     */
    post: operations["status"];
  };
  "sub-issues-parent-issue-added": {
    /**
     * This event occurs when there is activity relating to sub-issues.
     *
     * For activity relating to issues more generally, use the `issues` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permissions.
     * @description A parent issue was added to an issue.
     */
    post: operations["sub-issues/parent-issue-added"];
  };
  "sub-issues-parent-issue-removed": {
    /**
     * This event occurs when there is activity relating to sub-issues.
     *
     * For activity relating to issues more generally, use the `issues` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permissions.
     * @description A parent issue was removed from an issue.
     */
    post: operations["sub-issues/parent-issue-removed"];
  };
  "sub-issues-sub-issue-added": {
    /**
     * This event occurs when there is activity relating to sub-issues.
     *
     * For activity relating to issues more generally, use the `issues` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permissions.
     * @description A sub-issue was added to an issue.
     */
    post: operations["sub-issues/sub-issue-added"];
  };
  "sub-issues-sub-issue-removed": {
    /**
     * This event occurs when there is activity relating to sub-issues.
     *
     * For activity relating to issues more generally, use the `issues` event instead.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Issues" repository permissions.
     * @description A sub-issue was removed from an issue.
     */
    post: operations["sub-issues/sub-issue-removed"];
  };
  "team-add": {
    /**
     * This event occurs when a team is added to a repository.
     * For more information, see "[Managing teams and people with access to your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/managing-repository-settings/managing-teams-and-people-with-access-to-your-repository)."
     *
     * For activity relating to teams, see the `teams` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     */
    post: operations["team-add"];
  };
  "team-added-to-repository": {
    /**
     * This event occurs when there is activity relating to teams in an organization.
     * For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A team was granted access to a repository.
     */
    post: operations["team/added-to-repository"];
  };
  "team-created": {
    /**
     * This event occurs when there is activity relating to teams in an organization.
     * For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A team was created.
     */
    post: operations["team/created"];
  };
  "team-deleted": {
    /**
     * This event occurs when there is activity relating to teams in an organization.
     * For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A team was deleted.
     */
    post: operations["team/deleted"];
  };
  "team-edited": {
    /**
     * This event occurs when there is activity relating to teams in an organization.
     * For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description The name, description, or visibility of a team was changed.
     */
    post: operations["team/edited"];
  };
  "team-removed-from-repository": {
    /**
     * This event occurs when there is activity relating to teams in an organization.
     * For more information, see "[About teams](https://docs.github.com/organizations/organizing-members-into-teams/about-teams)."
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Members" organization permission.
     * @description A team's access to a repository was removed.
     */
    post: operations["team/removed-from-repository"];
  };
  "watch-started": {
    /**
     * This event occurs when there is activity relating to watching, or subscribing to, a repository. For more information about watching, see "[Managing your subscriptions](https://docs.github.com/account-and-profile/managing-subscriptions-and-notifications-on-github/managing-subscriptions-for-activity-on-github/managing-your-subscriptions)." For information about the APIs to manage watching, see "[Watching](https://docs.github.com/rest/activity/watching)" in the REST API documentation.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Metadata" repository permission.
     * @description Someone started watching the repository.
     */
    post: operations["watch/started"];
  };
  "workflow-dispatch": {
    /**
     * This event occurs when a GitHub Actions workflow is manually triggered. For more information, see "[Manually running a workflow](https://docs.github.com/actions/managing-workflow-runs/manually-running-a-workflow)."
     *
     * For activity relating to workflow runs, use the `workflow_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Contents" repository permission.
     */
    post: operations["workflow-dispatch"];
  };
  "workflow-job-completed": {
    /**
     * This event occurs when there is activity relating to a job in a GitHub Actions workflow. For more information, see "[Using jobs in a workflow](https://docs.github.com/actions/using-jobs/using-jobs-in-a-workflow)." For information about the API to manage workflow jobs, see "[Workflow jobs](https://docs.github.com/rest/actions/workflow-jobs)" in the REST API documentation.
     *
     * For activity relating to a workflow run instead of a job in a workflow run, use the `workflow_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A job in a workflow run finished. This event occurs when a job in a workflow is completed, regardless of whether the job was successful or unsuccessful.
     */
    post: operations["workflow-job/completed"];
  };
  "workflow-job-in-progress": {
    /**
     * This event occurs when there is activity relating to a job in a GitHub Actions workflow. For more information, see "[Using jobs in a workflow](https://docs.github.com/actions/using-jobs/using-jobs-in-a-workflow)." For information about the API to manage workflow jobs, see "[Workflow jobs](https://docs.github.com/rest/actions/workflow-jobs)" in the REST API documentation.
     *
     * For activity relating to a workflow run instead of a job in a workflow run, use the `workflow_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A job in a workflow run started processing on a runner.
     */
    post: operations["workflow-job/in-progress"];
  };
  "workflow-job-queued": {
    /**
     * This event occurs when there is activity relating to a job in a GitHub Actions workflow. For more information, see "[Using jobs in a workflow](https://docs.github.com/actions/using-jobs/using-jobs-in-a-workflow)." For information about the API to manage workflow jobs, see "[Workflow jobs](https://docs.github.com/rest/actions/workflow-jobs)" in the REST API documentation.
     *
     * For activity relating to a workflow run instead of a job in a workflow run, use the `workflow_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A job in a workflow run was created.
     */
    post: operations["workflow-job/queued"];
  };
  "workflow-job-waiting": {
    /**
     * This event occurs when there is activity relating to a job in a GitHub Actions workflow. For more information, see "[Using jobs in a workflow](https://docs.github.com/actions/using-jobs/using-jobs-in-a-workflow)." For information about the API to manage workflow jobs, see "[Workflow jobs](https://docs.github.com/rest/actions/workflow-jobs)" in the REST API documentation.
     *
     * For activity relating to a workflow run instead of a job in a workflow run, use the `workflow_run` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A job in a workflow run was created and is waiting for approvals.
     */
    post: operations["workflow-job/waiting"];
  };
  "workflow-run-completed": {
    /**
     * This event occurs when there is activity relating to a run of a GitHub Actions workflow. For more information, see "[About workflows](https://docs.github.com/actions/using-workflows/about-workflows)." For information about the APIs to manage workflow runs, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#workflowrun) or "[Workflow runs](https://docs.github.com/rest/actions/workflow-runs)" in the REST API documentation.
     *
     * For activity relating to a job in a workflow run, use the `workflow_job` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A workflow run finished. This event occurs when a workflow run is completed, regardless of whether the workflow was successful or unsuccessful.
     */
    post: operations["workflow-run/completed"];
  };
  "workflow-run-in-progress": {
    /**
     * This event occurs when there is activity relating to a run of a GitHub Actions workflow. For more information, see "[About workflows](https://docs.github.com/actions/using-workflows/about-workflows)." For information about the APIs to manage workflow runs, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#workflowrun) or "[Workflow runs](https://docs.github.com/rest/actions/workflow-runs)" in the REST API documentation.
     *
     * For activity relating to a job in a workflow run, use the `workflow_job` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A workflow run started processing on a runner.
     */
    post: operations["workflow-run/in-progress"];
  };
  "workflow-run-requested": {
    /**
     * This event occurs when there is activity relating to a run of a GitHub Actions workflow. For more information, see "[About workflows](https://docs.github.com/actions/using-workflows/about-workflows)." For information about the APIs to manage workflow runs, see [the GraphQL documentation](https://docs.github.com/graphql/reference/objects#workflowrun) or "[Workflow runs](https://docs.github.com/rest/actions/workflow-runs)" in the REST API documentation.
     *
     * For activity relating to a job in a workflow run, use the `workflow_job` event.
     *
     * To subscribe to this event, a GitHub App must have at least read-level access for the "Actions" repository permission.
     * @description A workflow run was triggered.
     */
    post: operations["workflow-run/requested"];
  };
}

export interface components {
  schemas: {
    /** branch protection configuration disabled event */
    "webhook-branch-protection-configuration-disabled": {
      /** @enum {string} */
      action: "disabled";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Enterprise
     * @description An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured
     * on an enterprise account or an organization that's part of an enterprise account. For more information,
     * see "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."
     */
    "enterprise-webhooks": {
      /** @description A short description of the enterprise. */
      description?: string | null;
      /** Format: uri */
      html_url: string;
      /**
       * Format: uri
       * @description The enterprise's website URL.
       */
      website_url?: string | null;
      /** @description Unique identifier of the enterprise */
      id: number;
      node_id: string;
      /** @description The name of the enterprise. */
      name: string;
      /** @description The slug url identifier for the enterprise. */
      slug: string;
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      /** Format: uri */
      avatar_url: string;
    };
    /**
     * Simple Installation
     * @description The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured
     * for and sent to a GitHub App. For more information,
     * see "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."
     */
    "simple-installation": {
      /** @description The ID of the installation. */
      id: number;
      /** @description The global node ID of the installation. */
      node_id: string;
    };
    /**
     * Organization Simple
     * @description A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an
     * organization, or when the event occurs from activity in a repository owned by an organization.
     */
    "organization-simple-webhooks": {
      login: string;
      id: number;
      node_id: string;
      /** Format: uri */
      url: string;
      /** Format: uri */
      repos_url: string;
      /** Format: uri */
      events_url: string;
      hooks_url: string;
      issues_url: string;
      members_url: string;
      public_members_url: string;
      avatar_url: string;
      description: string | null;
    };
    /**
     * Repository
     * @description The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property
     * when the event occurs from activity in a repository.
     */
    "repository-webhooks": {
      /**
       * Format: int64
       * @description Unique identifier of the repository
       */
      id: number;
      node_id: string;
      /** @description The name of the repository. */
      name: string;
      full_name: string;
      license: null | components["schemas"]["license-simple"];
      organization?: null | components["schemas"]["simple-user"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /** Format: uri */
      html_url: string;
      description: string | null;
      fork: boolean;
      /** Format: uri */
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      /** Format: uri */
      contributors_url: string;
      /** Format: uri */
      deployments_url: string;
      /** Format: uri */
      downloads_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      /** Format: uri */
      languages_url: string;
      /** Format: uri */
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      /** Format: uri */
      stargazers_url: string;
      statuses_url: string;
      /** Format: uri */
      subscribers_url: string;
      /** Format: uri */
      subscription_url: string;
      /** Format: uri */
      tags_url: string;
      /** Format: uri */
      teams_url: string;
      trees_url: string;
      clone_url: string;
      /** Format: uri */
      mirror_url: string | null;
      /** Format: uri */
      hooks_url: string;
      /** Format: uri */
      svn_url: string;
      /** Format: uri */
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      /** @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0. */
      size: number;
      /** @description The default branch of the repository. */
      default_branch: string;
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       */
      is_template?: boolean;
      topics?: string[];
      /** @description The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values. */
      custom_properties?: {
        [key: string]: unknown;
      };
      /**
       * @description Whether issues are enabled.
       * @default true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @description Whether downloads are enabled.
       * @default true
       */
      has_downloads: boolean;
      /**
       * @description Whether discussions are enabled.
       * @default false
       */
      has_discussions?: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /** Format: date-time */
      pushed_at: string | null;
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       */
      allow_rebase_merge?: boolean;
      template_repository?: {
        id?: number;
        node_id?: string;
        name?: string;
        full_name?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        private?: boolean;
        html_url?: string;
        description?: string;
        fork?: boolean;
        url?: string;
        archive_url?: string;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        deployments_url?: string;
        downloads_url?: string;
        events_url?: string;
        forks_url?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        languages_url?: string;
        merges_url?: string;
        milestones_url?: string;
        notifications_url?: string;
        pulls_url?: string;
        releases_url?: string;
        ssh_url?: string;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        tags_url?: string;
        teams_url?: string;
        trees_url?: string;
        clone_url?: string;
        mirror_url?: string;
        hooks_url?: string;
        svn_url?: string;
        homepage?: string;
        language?: string;
        forks_count?: number;
        stargazers_count?: number;
        watchers_count?: number;
        size?: number;
        default_branch?: string;
        open_issues_count?: number;
        is_template?: boolean;
        topics?: string[];
        has_issues?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        has_pages?: boolean;
        has_downloads?: boolean;
        archived?: boolean;
        disabled?: boolean;
        visibility?: string;
        pushed_at?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          admin?: boolean;
          maintain?: boolean;
          push?: boolean;
          triage?: boolean;
          pull?: boolean;
        };
        allow_rebase_merge?: boolean;
        temp_clone_token?: string;
        allow_squash_merge?: boolean;
        allow_auto_merge?: boolean;
        delete_branch_on_merge?: boolean;
        allow_update_branch?: boolean;
        use_squash_pr_title_as_default?: boolean;
        /**
         * @description The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         * @enum {string}
         */
        squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
        /**
         * @description The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         * @enum {string}
         */
        squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
        /**
         * @description The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         * @enum {string}
         */
        merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
        /**
         * @description The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         * @enum {string}
         */
        merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
        allow_merge_commit?: boolean;
        subscribers_count?: number;
        network_count?: number;
      } | null;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
       * @default false
       */
      allow_update_branch?: boolean;
      /**
       * @deprecated
       * @description Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
       * @default false
       */
      use_squash_pr_title_as_default?: boolean;
      /**
       * @description The default value for a squash merge commit title:
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
       * @enum {string}
       */
      squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
      /**
       * @description The default value for a squash merge commit message:
       *
       * - `PR_BODY` - default to the pull request's body.
       * - `COMMIT_MESSAGES` - default to the branch's commit messages.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
      /**
       * @description The default value for a merge commit title.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
       * @enum {string}
       */
      merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
      /**
       * @description The default value for a merge commit message.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `PR_BODY` - default to the pull request's body.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       */
      allow_merge_commit?: boolean;
      /** @description Whether to allow forking this repo */
      allow_forking?: boolean;
      /**
       * @description Whether to require contributors to sign off on web-based commits
       * @default false
       */
      web_commit_signoff_required?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      starred_at?: string;
      /** @description Whether anonymous git access is enabled for this repository */
      anonymous_access_enabled?: boolean;
    };
    /**
     * License Simple
     * @description License Simple
     */
    "license-simple": {
      key: string;
      name: string;
      /** Format: uri */
      url: string | null;
      spdx_id: string | null;
      node_id: string;
      /** Format: uri */
      html_url?: string;
    };
    /**
     * Simple User
     * @description A GitHub user.
     */
    "simple-user": {
      name?: string | null;
      email?: string | null;
      login: string;
      /** Format: int64 */
      id: number;
      node_id: string;
      /** Format: uri */
      avatar_url: string;
      gravatar_id: string | null;
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      /** Format: uri */
      subscriptions_url: string;
      /** Format: uri */
      organizations_url: string;
      /** Format: uri */
      repos_url: string;
      events_url: string;
      /** Format: uri */
      received_events_url: string;
      type: string;
      site_admin: boolean;
      starred_at?: string;
      user_view_type?: string;
    };
    /** branch protection configuration enabled event */
    "webhook-branch-protection-configuration-enabled": {
      /** @enum {string} */
      action: "enabled";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** branch protection rule created event */
    "webhook-branch-protection-rule-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      rule: components["schemas"]["webhooks_rule"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * branch protection rule
     * @description The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
     */
    webhooks_rule: {
      admin_enforced: boolean;
      /** @enum {string} */
      allow_deletions_enforcement_level: "off" | "non_admins" | "everyone";
      /** @enum {string} */
      allow_force_pushes_enforcement_level: "off" | "non_admins" | "everyone";
      authorized_actor_names: string[];
      authorized_actors_only: boolean;
      authorized_dismissal_actors_only: boolean;
      create_protected?: boolean;
      /** Format: date-time */
      created_at: string;
      dismiss_stale_reviews_on_push: boolean;
      id: number;
      ignore_approvals_from_contributors: boolean;
      /** @enum {string} */
      linear_history_requirement_enforcement_level:
        | "off"
        | "non_admins"
        | "everyone";
      /**
       * @description The enforcement level of the branch lock setting. `off` means the branch is not locked, `non_admins` means the branch is read-only for non_admins, and `everyone` means the branch is read-only for everyone.
       * @enum {string}
       */
      lock_branch_enforcement_level: "off" | "non_admins" | "everyone";
      /** @description Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow users to pull changes from upstream when the branch is locked. This setting is only applicable for forks. */
      lock_allows_fork_sync?: boolean;
      /** @enum {string} */
      merge_queue_enforcement_level: "off" | "non_admins" | "everyone";
      name: string;
      /** @enum {string} */
      pull_request_reviews_enforcement_level: "off" | "non_admins" | "everyone";
      repository_id: number;
      require_code_owner_review: boolean;
      /** @description Whether the most recent push must be approved by someone other than the person who pushed it */
      require_last_push_approval?: boolean;
      required_approving_review_count: number;
      /** @enum {string} */
      required_conversation_resolution_level: "off" | "non_admins" | "everyone";
      /** @enum {string} */
      required_deployments_enforcement_level: "off" | "non_admins" | "everyone";
      required_status_checks: string[];
      /** @enum {string} */
      required_status_checks_enforcement_level:
        | "off"
        | "non_admins"
        | "everyone";
      /** @enum {string} */
      signature_requirement_enforcement_level:
        | "off"
        | "non_admins"
        | "everyone";
      strict_required_status_checks_policy: boolean;
      /** Format: date-time */
      updated_at: string;
    };
    /** branch protection rule deleted event */
    "webhook-branch-protection-rule-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      rule: components["schemas"]["webhooks_rule"];
      sender: components["schemas"]["simple-user"];
    };
    /** branch protection rule edited event */
    "webhook-branch-protection-rule-edited": {
      /** @enum {string} */
      action: "edited";
      /** @description If the action was `edited`, the changes to the rule. */
      changes?: {
        admin_enforced?: {
          from: boolean | null;
        };
        authorized_actor_names?: {
          from: string[];
        };
        authorized_actors_only?: {
          from: boolean | null;
        };
        authorized_dismissal_actors_only?: {
          from: boolean | null;
        };
        linear_history_requirement_enforcement_level?: {
          /** @enum {string} */
          from: "off" | "non_admins" | "everyone";
        };
        lock_branch_enforcement_level?: {
          /** @enum {string} */
          from: "off" | "non_admins" | "everyone";
        };
        lock_allows_fork_sync?: {
          from: boolean | null;
        };
        pull_request_reviews_enforcement_level?: {
          /** @enum {string} */
          from: "off" | "non_admins" | "everyone";
        };
        require_last_push_approval?: {
          from: boolean | null;
        };
        required_status_checks?: {
          from: string[];
        };
        required_status_checks_enforcement_level?: {
          /** @enum {string} */
          from: "off" | "non_admins" | "everyone";
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      rule: components["schemas"]["webhooks_rule"];
      sender: components["schemas"]["simple-user"];
    };
    /** Check Run Completed Event */
    "webhook-check-run-completed": {
      /** @enum {string} */
      action: "completed";
      check_run: components["schemas"]["check-run-with-simple-check-suite"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * CheckRun
     * @description A check performed on the code of a given code change
     */
    "check-run-with-simple-check-suite": {
      app: null | components["schemas"]["integration"];
      check_suite: components["schemas"]["simple-check-suite"];
      /** Format: date-time */
      completed_at: string | null;
      /** @enum {string|null} */
      conclusion:
        | "waiting"
        | "pending"
        | "startup_failure"
        | "stale"
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "skipped"
        | "timed_out"
        | "action_required"
        | null;
      deployment?: components["schemas"]["deployment-simple"];
      details_url: string;
      external_id: string;
      /** @description The SHA of the commit that is being checked. */
      head_sha: string;
      html_url: string;
      /** @description The id of the check. */
      id: number;
      /** @description The name of the check. */
      name: string;
      node_id: string;
      output: {
        annotations_count: number;
        /** Format: uri */
        annotations_url: string;
        summary: string | null;
        text: string | null;
        title: string | null;
      };
      pull_requests: components["schemas"]["pull-request-minimal"][];
      /** Format: date-time */
      started_at: string;
      /**
       * @description The phase of the lifecycle that the check is currently in.
       * @enum {string}
       */
      status: "queued" | "in_progress" | "completed" | "pending";
      url: string;
    };
    /**
     * GitHub app
     * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    integration: {
      /** @description Unique identifier of the GitHub app */
      id: number;
      /** @description The slug name of the GitHub app */
      slug?: string;
      node_id: string;
      client_id?: string;
      owner:
        | components["schemas"]["simple-user"]
        | components["schemas"]["enterprise"];
      /** @description The name of the GitHub app */
      name: string;
      description: string | null;
      /** Format: uri */
      external_url: string;
      /** Format: uri */
      html_url: string;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /**
       * @description The set of permissions for the GitHub app
       * @example {
       *   "issues": "read",
       *   "deployments": "write"
       * }
       */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
        [key: string]: string | undefined;
      };
      /** @description The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation. */
      events: string[];
      /** @description The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself. */
      installations_count?: number;
    } | null;
    /**
     * Enterprise
     * @description An enterprise on GitHub.
     */
    enterprise: {
      /** @description A short description of the enterprise. */
      description?: string | null;
      /** Format: uri */
      html_url: string;
      /**
       * Format: uri
       * @description The enterprise's website URL.
       */
      website_url?: string | null;
      /** @description Unique identifier of the enterprise */
      id: number;
      node_id: string;
      /** @description The name of the enterprise. */
      name: string;
      /** @description The slug url identifier for the enterprise. */
      slug: string;
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      /** Format: uri */
      avatar_url: string;
    };
    /** @description A suite of checks performed on the code of a given code change */
    "simple-check-suite": {
      after?: string | null;
      app?: components["schemas"]["integration"];
      before?: string | null;
      /** @enum {string|null} */
      conclusion?:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "skipped"
        | "timed_out"
        | "action_required"
        | "stale"
        | "startup_failure"
        | null;
      /** Format: date-time */
      created_at?: string;
      head_branch?: string | null;
      /** @description The SHA of the head commit that is being checked. */
      head_sha?: string;
      id?: number;
      node_id?: string;
      pull_requests?: components["schemas"]["pull-request-minimal"][];
      repository?: components["schemas"]["minimal-repository"];
      /** @enum {string} */
      status?: "queued" | "in_progress" | "completed" | "pending" | "waiting";
      /** Format: date-time */
      updated_at?: string;
      url?: string;
    };
    /** Pull Request Minimal */
    "pull-request-minimal": {
      /** Format: int64 */
      id: number;
      number: number;
      url: string;
      head: {
        ref: string;
        sha: string;
        repo: {
          /** Format: int64 */
          id: number;
          url: string;
          name: string;
        };
      };
      base: {
        ref: string;
        sha: string;
        repo: {
          /** Format: int64 */
          id: number;
          url: string;
          name: string;
        };
      };
    };
    /**
     * Minimal Repository
     * @description Minimal Repository
     */
    "minimal-repository": {
      /** Format: int64 */
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      /** Format: uri */
      html_url: string;
      description: string | null;
      fork: boolean;
      /** Format: uri */
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      /** Format: uri */
      contributors_url: string;
      /** Format: uri */
      deployments_url: string;
      /** Format: uri */
      downloads_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url?: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      /** Format: uri */
      languages_url: string;
      /** Format: uri */
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url?: string;
      /** Format: uri */
      stargazers_url: string;
      statuses_url: string;
      /** Format: uri */
      subscribers_url: string;
      /** Format: uri */
      subscription_url: string;
      /** Format: uri */
      tags_url: string;
      /** Format: uri */
      teams_url: string;
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      /** Format: uri */
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      /** @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0. */
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      has_discussions?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      /** Format: date-time */
      pushed_at?: string | null;
      /** Format: date-time */
      created_at?: string | null;
      /** Format: date-time */
      updated_at?: string | null;
      permissions?: {
        admin?: boolean;
        maintain?: boolean;
        push?: boolean;
        triage?: boolean;
        pull?: boolean;
      };
      role_name?: string;
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      code_of_conduct?: components["schemas"]["code-of-conduct"];
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      forks?: number;
      open_issues?: number;
      watchers?: number;
      allow_forking?: boolean;
      web_commit_signoff_required?: boolean;
      security_and_analysis?: components["schemas"]["security-and-analysis"];
    };
    /**
     * Code Of Conduct
     * @description Code Of Conduct
     */
    "code-of-conduct": {
      key: string;
      name: string;
      /** Format: uri */
      url: string;
      body?: string;
      /** Format: uri */
      html_url: string | null;
    };
    "security-and-analysis": {
      advanced_security?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      code_security?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      /** @description Enable or disable Dependabot security updates for the repository. */
      dependabot_security_updates?: {
        /**
         * @description The enablement status of Dependabot security updates for the repository.
         * @enum {string}
         */
        status?: "enabled" | "disabled";
      };
      secret_scanning?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      secret_scanning_push_protection?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      secret_scanning_non_provider_patterns?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
      secret_scanning_ai_detection?: {
        /** @enum {string} */
        status?: "enabled" | "disabled";
      };
    } | null;
    /**
     * Deployment
     * @description A deployment created as the result of an Actions check run from a workflow that references an environment
     */
    "deployment-simple": {
      /** Format: uri */
      url: string;
      /** @description Unique identifier of the deployment */
      id: number;
      node_id: string;
      /** @description Parameter to specify a task to execute */
      task: string;
      original_environment?: string;
      /** @description Name for the target deployment environment. */
      environment: string;
      description: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      statuses_url: string;
      /** Format: uri */
      repository_url: string;
      /** @description Specifies if the given environment is will no longer exist at some point in the future. Default: false. */
      transient_environment?: boolean;
      /** @description Specifies if the given environment is one that end-users directly interact with. Default: false. */
      production_environment?: boolean;
      performed_via_github_app?: null | components["schemas"]["integration"];
    };
    /** Check Run Created Event */
    "webhook-check-run-created": {
      /** @enum {string} */
      action: "created";
      check_run: components["schemas"]["check-run-with-simple-check-suite"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Check Run Requested Action Event */
    "webhook-check-run-requested-action": {
      /** @enum {string} */
      action: "requested_action";
      check_run: components["schemas"]["check-run-with-simple-check-suite"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      /** @description The action requested by the user. */
      requested_action?: {
        /** @description The integrator reference of the action requested by the user. */
        identifier?: string;
      };
      sender: components["schemas"]["simple-user"];
    };
    /** Check Run Re-Requested Event */
    "webhook-check-run-rerequested": {
      /** @enum {string} */
      action: "rerequested";
      check_run: components["schemas"]["check-run-with-simple-check-suite"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** check_suite completed event */
    "webhook-check-suite-completed": {
      /** @enum {string} */
      action: "completed";
      /** @description The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite). */
      check_suite: {
        after: string | null;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        app: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "merge_group"
            | "pull_request_review_thread"
            | "workflow_job"
            | "merge_queue_entry"
            | "security_and_analysis"
            | "projects_v2_item"
            | "secret_scanning_alert_location"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The client ID of the GitHub app */
          client_id?: string | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        };
        before: string | null;
        /** Format: uri */
        check_runs_url: string;
        /**
         * @description The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has `completed`.
         * @enum {string|null}
         */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null
          | "skipped"
          | "startup_failure";
        /** Format: date-time */
        created_at: string;
        /** @description The head branch name the changes are on. */
        head_branch: string | null;
        /** SimpleCommit */
        head_commit: {
          /**
           * Committer
           * @description Metaproperties for Git author/committer information.
           */
          author: {
            /** Format: date-time */
            date?: string;
            /** Format: email */
            email: string | null;
            /** @description The git author's name. */
            name: string;
            username?: string;
          };
          /**
           * Committer
           * @description Metaproperties for Git author/committer information.
           */
          committer: {
            /** Format: date-time */
            date?: string;
            /** Format: email */
            email: string | null;
            /** @description The git author's name. */
            name: string;
            username?: string;
          };
          id: string;
          message: string;
          timestamp: string;
          tree_id: string;
        };
        /** @description The SHA of the head commit that is being checked. */
        head_sha: string;
        id: number;
        latest_check_runs_count: number;
        node_id: string;
        /** @description An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty. */
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        rerequestable?: boolean;
        runs_rerequestable?: boolean;
        /**
         * @description The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
         * @enum {string|null}
         */
        status:
          | "requested"
          | "in_progress"
          | "completed"
          | "queued"
          | null
          | "pending";
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL that points to the check suite API resource.
         */
        url: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** check_suite requested event */
    "webhook-check-suite-requested": {
      /** @enum {string} */
      action: "requested";
      /** @description The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite). */
      check_suite: {
        after: string | null;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        app: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "pull_request_review_thread"
            | "workflow_job"
            | "merge_queue_entry"
            | "security_and_analysis"
            | "secret_scanning_alert_location"
            | "projects_v2_item"
            | "merge_group"
            | "repository_import"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description Client ID of the GitHub app */
          client_id?: string | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        };
        before: string | null;
        /** Format: uri */
        check_runs_url: string;
        /**
         * @description The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has completed.
         * @enum {string|null}
         */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null
          | "skipped";
        /** Format: date-time */
        created_at: string;
        /** @description The head branch name the changes are on. */
        head_branch: string | null;
        /** SimpleCommit */
        head_commit: {
          /**
           * Committer
           * @description Metaproperties for Git author/committer information.
           */
          author: {
            /** Format: date-time */
            date?: string;
            /** Format: email */
            email: string | null;
            /** @description The git author's name. */
            name: string;
            username?: string;
          };
          /**
           * Committer
           * @description Metaproperties for Git author/committer information.
           */
          committer: {
            /** Format: date-time */
            date?: string;
            /** Format: email */
            email: string | null;
            /** @description The git author's name. */
            name: string;
            username?: string;
          };
          id: string;
          message: string;
          timestamp: string;
          tree_id: string;
        };
        /** @description The SHA of the head commit that is being checked. */
        head_sha: string;
        id: number;
        latest_check_runs_count: number;
        node_id: string;
        /** @description An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty. */
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        rerequestable?: boolean;
        runs_rerequestable?: boolean;
        /**
         * @description The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
         * @enum {string|null}
         */
        status: "requested" | "in_progress" | "completed" | "queued" | null;
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL that points to the check suite API resource.
         */
        url: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** check_suite rerequested event */
    "webhook-check-suite-rerequested": {
      /** @enum {string} */
      action: "rerequested";
      /** @description The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite). */
      check_suite: {
        after: string | null;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        app: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "pull_request_review_thread"
            | "merge_queue_entry"
            | "workflow_job"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The Client ID for the GitHub app */
          client_id?: string | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        };
        before: string | null;
        /** Format: uri */
        check_runs_url: string;
        /**
         * @description The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has completed.
         * @enum {string|null}
         */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null;
        /** Format: date-time */
        created_at: string;
        /** @description The head branch name the changes are on. */
        head_branch: string | null;
        /** SimpleCommit */
        head_commit: {
          /**
           * Committer
           * @description Metaproperties for Git author/committer information.
           */
          author: {
            /** Format: date-time */
            date?: string;
            /** Format: email */
            email: string | null;
            /** @description The git author's name. */
            name: string;
            username?: string;
          };
          /**
           * Committer
           * @description Metaproperties for Git author/committer information.
           */
          committer: {
            /** Format: date-time */
            date?: string;
            /** Format: email */
            email: string | null;
            /** @description The git author's name. */
            name: string;
            username?: string;
          };
          id: string;
          message: string;
          timestamp: string;
          tree_id: string;
        };
        /** @description The SHA of the head commit that is being checked. */
        head_sha: string;
        id: number;
        latest_check_runs_count: number;
        node_id: string;
        /** @description An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty. */
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        rerequestable?: boolean;
        runs_rerequestable?: boolean;
        /**
         * @description The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
         * @enum {string|null}
         */
        status: "requested" | "in_progress" | "completed" | "queued" | null;
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL that points to the check suite API resource.
         */
        url: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** code_scanning_alert appeared_in_branch event */
    "webhook-code-scanning-alert-appeared-in-branch": {
      /** @enum {string} */
      action: "appeared_in_branch";
      /** @description The code scanning alert involved in the event. */
      alert: {
        /**
         * Format: date-time
         * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
         */
        created_at: string;
        /**
         * Format: date-time
         * @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        dismissed_at: string | null;
        /** User */
        dismissed_by: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
        /**
         * @description The reason for dismissing or closing the alert.
         * @enum {string|null}
         */
        dismissed_reason:
          | "false positive"
          | "won't fix"
          | "used in tests"
          | null;
        /** @description The time that the alert was fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        fixed_at?: null;
        /**
         * Format: uri
         * @description The GitHub URL of the alert resource.
         */
        html_url: string;
        /** Alert Instance */
        most_recent_instance?: {
          /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
          analysis_key: string;
          /** @description Identifies the configuration under which the analysis was executed. */
          category?: string;
          classifications?: string[];
          commit_sha?: string;
          /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
          environment: string;
          location?: {
            end_column?: number;
            end_line?: number;
            path?: string;
            start_column?: number;
            start_line?: number;
          };
          message?: {
            text?: string;
          };
          /** @description The full Git reference, formatted as `refs/heads/<branch name>`. */
          ref: string;
          /**
           * @description State of a code scanning alert.
           * @enum {string}
           */
          state: "open" | "dismissed" | "fixed";
        } | null;
        /** @description The code scanning alert number. */
        number: number;
        rule: {
          /** @description A short description of the rule used to detect the alert. */
          description: string;
          /** @description A unique identifier for the rule used to detect the alert. */
          id: string;
          /**
           * @description The severity of the alert.
           * @enum {string|null}
           */
          severity: "none" | "note" | "warning" | "error" | null;
        };
        /**
         * @description State of a code scanning alert. Events for alerts found outside the default branch will return a `null` value until they are dismissed or fixed.
         * @enum {string|null}
         */
        state: "open" | "dismissed" | "fixed" | null;
        tool: {
          /** @description The name of the tool used to generate the code scanning analysis alert. */
          name: string;
          /** @description The version of the tool used to detect the alert. */
          version: string | null;
        };
        /** Format: uri */
        url: string;
      };
      commit_oid: components["schemas"]["webhooks_code_scanning_commit_oid"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      ref: components["schemas"]["webhooks_code_scanning_ref"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description The dismissal comment associated with the dismissal of the alert. */
    "code-scanning-alert-dismissed-comment": string | null;
    /** @description The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty. */
    webhooks_code_scanning_commit_oid: string;
    /** @description The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty. */
    webhooks_code_scanning_ref: string;
    /** code_scanning_alert closed_by_user event */
    "webhook-code-scanning-alert-closed-by-user": {
      /** @enum {string} */
      action: "closed_by_user";
      /** @description The code scanning alert involved in the event. */
      alert: {
        /**
         * Format: date-time
         * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
         */
        created_at: string;
        /**
         * Format: date-time
         * @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        dismissed_at: string;
        /** User */
        dismissed_by: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
        /**
         * @description The reason for dismissing or closing the alert.
         * @enum {string|null}
         */
        dismissed_reason:
          | "false positive"
          | "won't fix"
          | "used in tests"
          | null;
        /** @description The time that the alert was fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        fixed_at?: null;
        /**
         * Format: uri
         * @description The GitHub URL of the alert resource.
         */
        html_url: string;
        /** Alert Instance */
        most_recent_instance?: {
          /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
          analysis_key: string;
          /** @description Identifies the configuration under which the analysis was executed. */
          category?: string;
          classifications?: string[];
          commit_sha?: string;
          /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
          environment: string;
          location?: {
            end_column?: number;
            end_line?: number;
            path?: string;
            start_column?: number;
            start_line?: number;
          };
          message?: {
            text?: string;
          };
          /** @description The full Git reference, formatted as `refs/heads/<branch name>`. */
          ref: string;
          /**
           * @description State of a code scanning alert.
           * @enum {string}
           */
          state: "open" | "dismissed" | "fixed";
        } | null;
        /** @description The code scanning alert number. */
        number: number;
        rule: {
          /** @description A short description of the rule used to detect the alert. */
          description: string;
          full_description?: string;
          help?: string | null;
          /** @description A link to the documentation for the rule used to detect the alert. */
          help_uri?: string | null;
          /** @description A unique identifier for the rule used to detect the alert. */
          id: string;
          name?: string;
          /**
           * @description The severity of the alert.
           * @enum {string|null}
           */
          severity: "none" | "note" | "warning" | "error" | null;
          tags?: string[] | null;
        };
        /**
         * @description State of a code scanning alert.
         * @enum {string}
         */
        state: "dismissed" | "fixed";
        tool: {
          guid?: string | null;
          /** @description The name of the tool used to generate the code scanning analysis alert. */
          name: string;
          /** @description The version of the tool used to detect the alert. */
          version: string | null;
        };
        /** Format: uri */
        url: string;
        /** User */
        dismissal_approved_by?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      commit_oid: components["schemas"]["webhooks_code_scanning_commit_oid"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      ref: components["schemas"]["webhooks_code_scanning_ref"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** code_scanning_alert created event */
    "webhook-code-scanning-alert-created": {
      /** @enum {string} */
      action: "created";
      /** @description The code scanning alert involved in the event. */
      alert: {
        /**
         * Format: date-time
         * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
         */
        created_at: string | null;
        /** @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        dismissed_at: null;
        dismissed_by: null;
        dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
        /** @description The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`. */
        dismissed_reason: null;
        /** @description The time that the alert was fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        fixed_at?: null;
        /**
         * Format: uri
         * @description The GitHub URL of the alert resource.
         */
        html_url: string;
        instances_url?: string;
        /** Alert Instance */
        most_recent_instance?: {
          /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
          analysis_key: string;
          /** @description Identifies the configuration under which the analysis was executed. */
          category?: string;
          classifications?: string[];
          commit_sha?: string;
          /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
          environment: string;
          location?: {
            end_column?: number;
            end_line?: number;
            path?: string;
            start_column?: number;
            start_line?: number;
          };
          message?: {
            text?: string;
          };
          /** @description The full Git reference, formatted as `refs/heads/<branch name>`. */
          ref: string;
          /**
           * @description State of a code scanning alert.
           * @enum {string}
           */
          state: "open" | "dismissed" | "fixed";
        } | null;
        /** @description The code scanning alert number. */
        number: number;
        rule: {
          /** @description A short description of the rule used to detect the alert. */
          description: string;
          full_description?: string;
          help?: string | null;
          /** @description A link to the documentation for the rule used to detect the alert. */
          help_uri?: string | null;
          /** @description A unique identifier for the rule used to detect the alert. */
          id: string;
          name?: string;
          /**
           * @description The severity of the alert.
           * @enum {string|null}
           */
          severity: "none" | "note" | "warning" | "error" | null;
          tags?: string[] | null;
        };
        /**
         * @description State of a code scanning alert. Events for alerts found outside the default branch will return a `null` value until they are dismissed or fixed.
         * @enum {string|null}
         */
        state: "open" | "dismissed" | null;
        tool: {
          guid?: string | null;
          /** @description The name of the tool used to generate the code scanning analysis alert. */
          name: string;
          /** @description The version of the tool used to detect the alert. */
          version: string | null;
        } | null;
        updated_at?: string | null;
        /** Format: uri */
        url: string;
        dismissal_approved_by?: null;
      };
      commit_oid: components["schemas"]["webhooks_code_scanning_commit_oid"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      ref: components["schemas"]["webhooks_code_scanning_ref"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** code_scanning_alert fixed event */
    "webhook-code-scanning-alert-fixed": {
      /** @enum {string} */
      action: "fixed";
      /** @description The code scanning alert involved in the event. */
      alert: {
        /**
         * Format: date-time
         * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
         */
        created_at: string;
        /**
         * Format: date-time
         * @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        dismissed_at: string | null;
        /** User */
        dismissed_by: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
        /**
         * @description The reason for dismissing or closing the alert.
         * @enum {string|null}
         */
        dismissed_reason:
          | "false positive"
          | "won't fix"
          | "used in tests"
          | null;
        /** @description The time that the alert was fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        fixed_at?: null;
        /**
         * Format: uri
         * @description The GitHub URL of the alert resource.
         */
        html_url: string;
        /** Format: uri */
        instances_url?: string;
        /** Alert Instance */
        most_recent_instance?: {
          /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
          analysis_key: string;
          /** @description Identifies the configuration under which the analysis was executed. */
          category?: string;
          classifications?: string[];
          commit_sha?: string;
          /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
          environment: string;
          location?: {
            end_column?: number;
            end_line?: number;
            path?: string;
            start_column?: number;
            start_line?: number;
          };
          message?: {
            text?: string;
          };
          /** @description The full Git reference, formatted as `refs/heads/<branch name>`. */
          ref: string;
          /**
           * @description State of a code scanning alert.
           * @enum {string}
           */
          state: "open" | "dismissed" | "fixed";
        } | null;
        /** @description The code scanning alert number. */
        number: number;
        rule: {
          /** @description A short description of the rule used to detect the alert. */
          description: string;
          full_description?: string;
          help?: string | null;
          /** @description A link to the documentation for the rule used to detect the alert. */
          help_uri?: string | null;
          /** @description A unique identifier for the rule used to detect the alert. */
          id: string;
          name?: string;
          /**
           * @description The severity of the alert.
           * @enum {string|null}
           */
          severity: "none" | "note" | "warning" | "error" | null;
          tags?: string[] | null;
        };
        /**
         * @description State of a code scanning alert. Events for alerts found outside the default branch will return a `null` value until they are dismissed or fixed.
         * @enum {string|null}
         */
        state: "fixed" | null;
        tool: {
          guid?: string | null;
          /** @description The name of the tool used to generate the code scanning analysis alert. */
          name: string;
          /** @description The version of the tool used to detect the alert. */
          version: string | null;
        };
        /** Format: uri */
        url: string;
      };
      commit_oid: components["schemas"]["webhooks_code_scanning_commit_oid"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      ref: components["schemas"]["webhooks_code_scanning_ref"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** code_scanning_alert reopened event */
    "webhook-code-scanning-alert-reopened": {
      /** @enum {string} */
      action: "reopened";
      /** @description The code scanning alert involved in the event. */
      alert: {
        /**
         * Format: date-time
         * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
         */
        created_at: string;
        /** @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        dismissed_at: string | null;
        dismissed_by: Record<string, never> | null;
        dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
        /** @description The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`. */
        dismissed_reason: string | null;
        /** @description The time that the alert was fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        fixed_at?: null;
        /**
         * Format: uri
         * @description The GitHub URL of the alert resource.
         */
        html_url: string;
        /** Alert Instance */
        most_recent_instance?: {
          /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
          analysis_key: string;
          /** @description Identifies the configuration under which the analysis was executed. */
          category?: string;
          classifications?: string[];
          commit_sha?: string;
          /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
          environment: string;
          location?: {
            end_column?: number;
            end_line?: number;
            path?: string;
            start_column?: number;
            start_line?: number;
          };
          message?: {
            text?: string;
          };
          /** @description The full Git reference, formatted as `refs/heads/<branch name>`. */
          ref: string;
          /**
           * @description State of a code scanning alert.
           * @enum {string}
           */
          state: "open" | "dismissed" | "fixed";
        } | null;
        /** @description The code scanning alert number. */
        number: number;
        rule: {
          /** @description A short description of the rule used to detect the alert. */
          description: string;
          full_description?: string;
          help?: string | null;
          /** @description A link to the documentation for the rule used to detect the alert. */
          help_uri?: string | null;
          /** @description A unique identifier for the rule used to detect the alert. */
          id: string;
          name?: string;
          /**
           * @description The severity of the alert.
           * @enum {string|null}
           */
          severity: "none" | "note" | "warning" | "error" | null;
          tags?: string[] | null;
        };
        /**
         * @description State of a code scanning alert. Events for alerts found outside the default branch will return a `null` value until they are dismissed or fixed.
         * @enum {string|null}
         */
        state: "open" | "dismissed" | "fixed" | null;
        tool: {
          guid?: string | null;
          /** @description The name of the tool used to generate the code scanning analysis alert. */
          name: string;
          /** @description The version of the tool used to detect the alert. */
          version: string | null;
        };
        /** Format: uri */
        url: string;
      } | null;
      /** @description The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty. */
      commit_oid: string | null;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** @description The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty. */
      ref: string | null;
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** code_scanning_alert reopened_by_user event */
    "webhook-code-scanning-alert-reopened-by-user": {
      /** @enum {string} */
      action: "reopened_by_user";
      /** @description The code scanning alert involved in the event. */
      alert: {
        /**
         * Format: date-time
         * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
         */
        created_at: string;
        /** @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        dismissed_at: null;
        dismissed_by: null;
        dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
        /** @description The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`. */
        dismissed_reason: null;
        /** @description The time that the alert was fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
        fixed_at?: null;
        /**
         * Format: uri
         * @description The GitHub URL of the alert resource.
         */
        html_url: string;
        /** Alert Instance */
        most_recent_instance?: {
          /** @description Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
          analysis_key: string;
          /** @description Identifies the configuration under which the analysis was executed. */
          category?: string;
          classifications?: string[];
          commit_sha?: string;
          /** @description Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
          environment: string;
          location?: {
            end_column?: number;
            end_line?: number;
            path?: string;
            start_column?: number;
            start_line?: number;
          };
          message?: {
            text?: string;
          };
          /** @description The full Git reference, formatted as `refs/heads/<branch name>`. */
          ref: string;
          /**
           * @description State of a code scanning alert.
           * @enum {string}
           */
          state: "open" | "dismissed" | "fixed";
        } | null;
        /** @description The code scanning alert number. */
        number: number;
        rule: {
          /** @description A short description of the rule used to detect the alert. */
          description: string;
          /** @description A unique identifier for the rule used to detect the alert. */
          id: string;
          /**
           * @description The severity of the alert.
           * @enum {string|null}
           */
          severity: "none" | "note" | "warning" | "error" | null;
        };
        /**
         * @description State of a code scanning alert. Events for alerts found outside the default branch will return a `null` value until they are dismissed or fixed.
         * @enum {string|null}
         */
        state: "open" | "fixed" | null;
        tool: {
          /** @description The name of the tool used to generate the code scanning analysis alert. */
          name: string;
          /** @description The version of the tool used to detect the alert. */
          version: string | null;
        };
        /** Format: uri */
        url: string;
      };
      commit_oid: components["schemas"]["webhooks_code_scanning_commit_oid"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      ref: components["schemas"]["webhooks_code_scanning_ref"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** commit_comment created event */
    "webhook-commit-comment-created": {
      /**
       * @description The action performed. Can be `created`.
       * @enum {string}
       */
      action: "created";
      /** @description The [commit comment](${externalDocsUpapp/api/description/components/schemas/webhooks/issue-comment-created.yamlrl}/rest/commits/comments#get-a-commit-comment) resource. */
      comment: {
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description The text of the comment. */
        body: string;
        /** @description The SHA of the commit to which the comment applies. */
        commit_id: string;
        created_at: string;
        /** Format: uri */
        html_url: string;
        /** @description The ID of the commit comment. */
        id: number;
        /** @description The line of the blob to which the comment applies. The last line of the range for a multi-line comment */
        line: number | null;
        /** @description The node ID of the commit comment. */
        node_id: string;
        /** @description The relative path of the file to which the comment applies. */
        path: string | null;
        /** @description The line index in the diff to which the comment applies. */
        position: number | null;
        /** Reactions */
        reactions?: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        updated_at: string;
        /** Format: uri */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** create event */
    "webhook-create": {
      /** @description The repository's current description. */
      description: string | null;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** @description The name of the repository's default branch (usually `main`). */
      master_branch: string;
      organization?: components["schemas"]["organization-simple-webhooks"];
      pusher_type: components["schemas"]["webhooks_deploy_pusher_type"];
      ref: components["schemas"]["webhooks_ref_0"];
      /**
       * @description The type of Git ref object created in the repository.
       * @enum {string}
       */
      ref_type: "tag" | "branch";
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description The pusher type for the event. Can be either `user` or a deploy key. */
    webhooks_deploy_pusher_type: string;
    /** @description The [`git ref`](https://docs.github.com/rest/git/refs#get-a-reference) resource. */
    webhooks_ref_0: string;
    /** custom property created event */
    "webhook-custom-property-created": {
      /** @enum {string} */
      action: "created";
      definition: components["schemas"]["custom-property"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /**
     * Organization Custom Property
     * @description Custom property defined on an organization
     */
    "custom-property": {
      /** @description The name of the property */
      property_name: string;
      /**
       * Format: uri
       * @description The URL that can be used to fetch, update, or delete info about this property via the API.
       */
      url?: string;
      /**
       * @description The source type of the property
       * @enum {string}
       */
      source_type?: "organization" | "enterprise";
      /**
       * @description The type of the value for the property
       * @enum {string}
       */
      value_type: "string" | "single_select" | "multi_select" | "true_false";
      /** @description Whether the property is required. */
      required?: boolean;
      /** @description Default value of the property */
      default_value?: string | string[] | null | unknown[];
      /** @description Short description of the property */
      description?: string | null;
      /**
       * @description An ordered list of the allowed values of the property.
       * The property can have up to 200 allowed values.
       */
      allowed_values?: string[] | null;
      /**
       * @description Who can edit the values of the property
       * @enum {string|null}
       */
      values_editable_by?: "org_actors" | "org_and_repo_actors" | null;
    };
    /** custom property deleted event */
    "webhook-custom-property-deleted": {
      /** @enum {string} */
      action: "deleted";
      definition: {
        /** @description The name of the property that was deleted. */
        property_name: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** custom property promoted to business event */
    "webhook-custom-property-promoted-to-enterprise": {
      /** @enum {string} */
      action: "promote_to_enterprise";
      definition: components["schemas"]["custom-property"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** custom property updated event */
    "webhook-custom-property-updated": {
      /** @enum {string} */
      action: "updated";
      definition: components["schemas"]["custom-property"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** Custom property values updated event */
    "webhook-custom-property-values-updated": {
      /** @enum {string} */
      action: "updated";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      repository: components["schemas"]["repository-webhooks"];
      organization: components["schemas"]["organization-simple-webhooks"];
      sender?: components["schemas"]["simple-user"];
      /** @description The new custom property values for the repository. */
      new_property_values: components["schemas"]["custom-property-value"][];
      /** @description The old custom property values for the repository. */
      old_property_values: components["schemas"]["custom-property-value"][];
    };
    /**
     * Custom Property Value
     * @description Custom property name and associated value
     */
    "custom-property-value": {
      /** @description The name of the property */
      property_name: string;
      /** @description The value assigned to the property */
      value: string | string[] | null | unknown[];
    };
    /** delete event */
    "webhook-delete": {
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      pusher_type: components["schemas"]["webhooks_deploy_pusher_type"];
      ref: components["schemas"]["webhooks_ref_0"];
      /**
       * @description The type of Git ref object deleted in the repository.
       * @enum {string}
       */
      ref_type: "tag" | "branch";
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Dependabot alert auto-dismissed event */
    "webhook-dependabot-alert-auto-dismissed": {
      /** @enum {string} */
      action: "auto_dismissed";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description A Dependabot alert. */
    "dependabot-alert": {
      number: components["schemas"]["alert-number"];
      /**
       * @description The state of the Dependabot alert.
       * @enum {string}
       */
      state: "auto_dismissed" | "dismissed" | "fixed" | "open";
      /** @description Details for the vulnerable dependency. */
      dependency: {
        readonly package?: components["schemas"]["dependabot-alert-package"];
        /** @description The full path to the dependency manifest file, relative to the root of the repository. */
        readonly manifest_path?: string;
        /**
         * @description The execution scope of the vulnerable dependency.
         * @enum {string|null}
         */
        readonly scope?: "development" | "runtime" | null;
        /**
         * @description The vulnerable dependency's relationship to your project.
         *
         * > [!NOTE]
         * > We are rolling out support for dependency relationship across ecosystems. This value will be "unknown" for all dependencies in unsupported ecosystems.
         *
         * @enum {string|null}
         */
        readonly relationship?: "unknown" | "direct" | "transitive" | null;
      };
      security_advisory: components["schemas"]["dependabot-alert-security-advisory"];
      security_vulnerability: components["schemas"]["dependabot-alert-security-vulnerability"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at: components["schemas"]["alert-updated-at"];
      dismissed_at: components["schemas"]["alert-dismissed-at"];
      dismissed_by: null | components["schemas"]["simple-user"];
      /**
       * @description The reason that the alert was dismissed.
       * @enum {string|null}
       */
      dismissed_reason:
        | "fix_started"
        | "inaccurate"
        | "no_bandwidth"
        | "not_used"
        | "tolerable_risk"
        | null;
      /** @description An optional comment associated with the alert's dismissal. */
      dismissed_comment: string | null;
      fixed_at: components["schemas"]["alert-fixed-at"];
      auto_dismissed_at?: components["schemas"]["alert-auto-dismissed-at"];
    };
    /** @description The security alert number. */
    readonly "alert-number": number;
    /** @description Details for the vulnerable package. */
    readonly "dependabot-alert-package": {
      /** @description The package's language or package management ecosystem. */
      readonly ecosystem: string;
      /** @description The unique package name within its ecosystem. */
      readonly name: string;
    };
    /** @description Details for the GitHub Security Advisory. */
    readonly "dependabot-alert-security-advisory": {
      /** @description The unique GitHub Security Advisory ID assigned to the advisory. */
      readonly ghsa_id: string;
      /** @description The unique CVE ID assigned to the advisory. */
      readonly cve_id: string | null;
      /** @description A short, plain text summary of the advisory. */
      readonly summary: string;
      /** @description A long-form Markdown-supported description of the advisory. */
      readonly description: string;
      /** @description Vulnerable version range information for the advisory. */
      readonly vulnerabilities: readonly components["schemas"]["dependabot-alert-security-vulnerability"][];
      /**
       * @description The severity of the advisory.
       * @enum {string}
       */
      readonly severity: "low" | "medium" | "high" | "critical";
      /** @description Details for the advisory pertaining to the Common Vulnerability Scoring System. */
      readonly cvss: {
        /** @description The overall CVSS score of the advisory. */
        readonly score: number;
        /** @description The full CVSS vector string for the advisory. */
        readonly vector_string: string | null;
      };
      readonly cvss_severities?: components["schemas"]["cvss-severities"];
      readonly epss?: components["schemas"]["security-advisory-epss"];
      /** @description Details for the advisory pertaining to Common Weakness Enumeration. */
      readonly cwes: readonly {
        /** @description The unique CWE ID. */
        readonly cwe_id: string;
        /** @description The short, plain text name of the CWE. */
        readonly name: string;
      }[];
      /** @description Values that identify this advisory among security information sources. */
      readonly identifiers: readonly {
        /**
         * @description The type of advisory identifier.
         * @enum {string}
         */
        readonly type: "CVE" | "GHSA";
        /** @description The value of the advisory identifer. */
        readonly value: string;
      }[];
      /** @description Links to additional advisory information. */
      readonly references: readonly {
        /**
         * Format: uri
         * @description The URL of the reference.
         */
        readonly url: string;
      }[];
      /**
       * Format: date-time
       * @description The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      readonly published_at: string;
      /**
       * Format: date-time
       * @description The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      readonly updated_at: string;
      /**
       * Format: date-time
       * @description The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      readonly withdrawn_at: string | null;
    };
    /** @description Details pertaining to one vulnerable version range for the advisory. */
    readonly "dependabot-alert-security-vulnerability": {
      readonly package: components["schemas"]["dependabot-alert-package"];
      /**
       * @description The severity of the vulnerability.
       * @enum {string}
       */
      readonly severity: "low" | "medium" | "high" | "critical";
      /** @description Conditions that identify vulnerable versions of this vulnerability's package. */
      readonly vulnerable_version_range: string;
      /** @description Details pertaining to the package version that patches this vulnerability. */
      readonly first_patched_version: {
        /** @description The package version that patches this vulnerability. */
        readonly identifier: string;
      } | null;
    };
    "cvss-severities": {
      cvss_v3?: {
        /** @description The CVSS 3 vector string. */
        vector_string: string | null;
        /** @description The CVSS 3 score. */
        score: number | null;
      } | null;
      cvss_v4?: {
        /** @description The CVSS 4 vector string. */
        vector_string: string | null;
        /** @description The CVSS 4 score. */
        score: number | null;
      } | null;
    } | null;
    /** @description The EPSS scores as calculated by the [Exploit Prediction Scoring System](https://www.first.org/epss). */
    readonly "security-advisory-epss": {
      readonly percentage?: number;
      readonly percentile?: number;
    } | null;
    /**
     * Format: uri
     * @description The REST API URL of the alert resource.
     */
    readonly "alert-url": string;
    /**
     * Format: uri
     * @description The GitHub URL of the alert resource.
     */
    readonly "alert-html-url": string;
    /**
     * Format: date-time
     * @description The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-created-at": string;
    /**
     * Format: date-time
     * @description The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-updated-at": string;
    /**
     * Format: date-time
     * @description The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-dismissed-at": string | null;
    /**
     * Format: date-time
     * @description The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-fixed-at": string | null;
    /**
     * Format: date-time
     * @description The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    readonly "alert-auto-dismissed-at": string | null;
    /** Dependabot alert auto-reopened event */
    "webhook-dependabot-alert-auto-reopened": {
      /** @enum {string} */
      action: "auto_reopened";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Dependabot alert created event */
    "webhook-dependabot-alert-created": {
      /** @enum {string} */
      action: "created";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Dependabot alert dismissed event */
    "webhook-dependabot-alert-dismissed": {
      /** @enum {string} */
      action: "dismissed";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Dependabot alert fixed event */
    "webhook-dependabot-alert-fixed": {
      /** @enum {string} */
      action: "fixed";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Dependabot alert reintroduced event */
    "webhook-dependabot-alert-reintroduced": {
      /** @enum {string} */
      action: "reintroduced";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Dependabot alert reopened event */
    "webhook-dependabot-alert-reopened": {
      /** @enum {string} */
      action: "reopened";
      alert: components["schemas"]["dependabot-alert"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** deploy_key created event */
    "webhook-deploy-key-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      key: components["schemas"]["webhooks_deploy_key"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-deploy-key) resource. */
    webhooks_deploy_key: {
      added_by?: string | null;
      created_at: string;
      id: number;
      key: string;
      last_used?: string | null;
      read_only: boolean;
      title: string;
      /** Format: uri */
      url: string;
      verified: boolean;
      enabled?: boolean;
    };
    /** deploy_key deleted event */
    "webhook-deploy-key-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      key: components["schemas"]["webhooks_deploy_key"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** deployment created event */
    "webhook-deployment-created": {
      /** @enum {string} */
      action: "created";
      /**
       * Deployment
       * @description The [deployment](https://docs.github.com/rest/deployments/deployments#list-deployments).
       */
      deployment: {
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        description: string | null;
        environment: string;
        id: number;
        node_id: string;
        original_environment: string;
        payload: Record<string, never> | string;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "workflow_job"
            | "pull_request_review_thread"
            | "merge_queue_entry"
            | "secret_scanning_alert_location"
            | "merge_group"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        production_environment?: boolean;
        ref: string;
        /** Format: uri */
        repository_url: string;
        sha: string;
        /** Format: uri */
        statuses_url: string;
        task: string;
        transient_environment?: boolean;
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
      workflow: components["schemas"]["webhooks_workflow"];
      /** Deployment Workflow Run */
      workflow_run: {
        /** User */
        actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        artifacts_url?: string;
        cancel_url?: string;
        check_suite_id: number;
        check_suite_node_id: string;
        check_suite_url?: string;
        /** @enum {string|null} */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null;
        /** Format: date-time */
        created_at: string;
        display_title: string;
        event: string;
        head_branch: string;
        head_commit?: null;
        head_repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        head_sha: string;
        /** Format: uri */
        html_url: string;
        id: number;
        jobs_url?: string;
        logs_url?: string;
        name: string;
        node_id: string;
        path: string;
        previous_attempt_url?: null;
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        referenced_workflows?:
          | {
              path: string;
              ref?: string;
              sha: string;
            }[]
          | null;
        repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        rerun_url?: string;
        run_attempt: number;
        run_number: number;
        /** Format: date-time */
        run_started_at: string;
        /** @enum {string} */
        status:
          | "requested"
          | "in_progress"
          | "completed"
          | "queued"
          | "waiting"
          | "pending";
        /** User */
        triggering_actor?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        workflow_id: number;
        workflow_url?: string;
      } | null;
    };
    /** Workflow */
    webhooks_workflow: {
      /** Format: uri */
      badge_url: string;
      /** Format: date-time */
      created_at: string;
      /** Format: uri */
      html_url: string;
      id: number;
      name: string;
      node_id: string;
      path: string;
      state: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      url: string;
    } | null;
    /** deployment protection rule requested event */
    "webhook-deployment-protection-rule-requested": {
      /** @enum {string} */
      action: "requested";
      /** @description The name of the environment that has the deployment protection rule. */
      environment?: string;
      /** @description The event that triggered the deployment protection rule. */
      event?: string;
      /**
       * Format: uri
       * @description The URL to review the deployment protection rule.
       */
      deployment_callback_url?: string;
      deployment?: components["schemas"]["deployment"];
      pull_requests?: components["schemas"]["pull-request"][];
      repository: components["schemas"]["repository-webhooks"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Deployment
     * @description A request for a specific ref(branch,sha,tag) to be deployed
     */
    deployment: {
      /** Format: uri */
      url: string;
      /**
       * Format: int64
       * @description Unique identifier of the deployment
       */
      id: number;
      node_id: string;
      sha: string;
      /** @description The ref to deploy. This can be a branch, tag, or sha. */
      ref: string;
      /** @description Parameter to specify a task to execute */
      task: string;
      payload: OneOf<
        [
          {
            [key: string]: unknown;
          },
          string,
        ]
      >;
      original_environment?: string;
      /** @description Name for the target deployment environment. */
      environment: string;
      description: string | null;
      creator: null | components["schemas"]["simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      statuses_url: string;
      /** Format: uri */
      repository_url: string;
      /** @description Specifies if the given environment is will no longer exist at some point in the future. Default: false. */
      transient_environment?: boolean;
      /** @description Specifies if the given environment is one that end-users directly interact with. Default: false. */
      production_environment?: boolean;
      performed_via_github_app?: null | components["schemas"]["integration"];
    };
    /**
     * Pull Request
     * @description Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
     */
    "pull-request": {
      /** Format: uri */
      url: string;
      /** Format: int64 */
      id: number;
      node_id: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      diff_url: string;
      /** Format: uri */
      patch_url: string;
      /** Format: uri */
      issue_url: string;
      /** Format: uri */
      commits_url: string;
      /** Format: uri */
      review_comments_url: string;
      review_comment_url: string;
      /** Format: uri */
      comments_url: string;
      /** Format: uri */
      statuses_url: string;
      /** @description Number uniquely identifying the pull request within its repository. */
      number: number;
      /**
       * @description State of this Pull Request. Either `open` or `closed`.
       * @enum {string}
       */
      state: "open" | "closed";
      locked: boolean;
      /** @description The title of the pull request. */
      title: string;
      user: components["schemas"]["simple-user"];
      body: string | null;
      labels: {
        /** Format: int64 */
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string | null;
        color: string;
        default: boolean;
      }[];
      milestone: null | components["schemas"]["milestone"];
      active_lock_reason?: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      merged_at: string | null;
      merge_commit_sha: string | null;
      assignee: null | components["schemas"]["simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team-simple"][] | null;
      head: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["simple-user"];
      };
      base: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["simple-user"];
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author-association"];
      auto_merge: components["schemas"]["auto-merge"];
      /** @description Indicates whether or not the pull request is a draft. */
      draft?: boolean;
      merged: boolean;
      mergeable: boolean | null;
      rebaseable?: boolean | null;
      mergeable_state: string;
      merged_by: null | components["schemas"]["simple-user"];
      comments: number;
      review_comments: number;
      /** @description Indicates whether maintainers can modify the pull request. */
      maintainer_can_modify: boolean;
      commits: number;
      additions: number;
      deletions: number;
      changed_files: number;
    };
    /**
     * Milestone
     * @description A collection of related issues and pull requests.
     */
    milestone: {
      /** Format: uri */
      url: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      labels_url: string;
      id: number;
      node_id: string;
      /** @description The number of the milestone. */
      number: number;
      /**
       * @description The state of the milestone.
       * @default open
       * @enum {string}
       */
      state: "open" | "closed";
      /** @description The title of the milestone. */
      title: string;
      description: string | null;
      creator: null | components["schemas"]["simple-user"];
      open_issues: number;
      closed_issues: number;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      due_on: string | null;
    };
    /**
     * Team Simple
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    "team-simple": {
      /** @description Unique identifier of the team */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the team
       */
      url: string;
      members_url: string;
      /** @description Name of the team */
      name: string;
      /** @description Description of the team */
      description: string | null;
      /** @description Permission that the team will have for its repositories */
      permission: string;
      /** @description The level of privacy this team should have */
      privacy?: string;
      /** @description The notification setting the team has set */
      notification_setting?: string;
      /** Format: uri */
      html_url: string;
      /** Format: uri */
      repositories_url: string;
      slug: string;
      /** @description Distinguished Name (DN) that team maps to within LDAP environment */
      ldap_dn?: string;
    };
    /**
     * Repository
     * @description A repository on GitHub.
     */
    repository: {
      /**
       * Format: int64
       * @description Unique identifier of the repository
       */
      id: number;
      node_id: string;
      /** @description The name of the repository. */
      name: string;
      full_name: string;
      license: null | components["schemas"]["license-simple"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /**
       * @description Whether the repository is private or public.
       * @default false
       */
      private: boolean;
      /** Format: uri */
      html_url: string;
      description: string | null;
      fork: boolean;
      /** Format: uri */
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      /** Format: uri */
      contributors_url: string;
      /** Format: uri */
      deployments_url: string;
      /** Format: uri */
      downloads_url: string;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      /** Format: uri */
      languages_url: string;
      /** Format: uri */
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      /** Format: uri */
      stargazers_url: string;
      statuses_url: string;
      /** Format: uri */
      subscribers_url: string;
      /** Format: uri */
      subscription_url: string;
      /** Format: uri */
      tags_url: string;
      /** Format: uri */
      teams_url: string;
      trees_url: string;
      clone_url: string;
      /** Format: uri */
      mirror_url: string | null;
      /** Format: uri */
      hooks_url: string;
      /** Format: uri */
      svn_url: string;
      /** Format: uri */
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      /** @description The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0. */
      size: number;
      /** @description The default branch of the repository. */
      default_branch: string;
      open_issues_count: number;
      /**
       * @description Whether this repository acts as a template that can be used to generate new repositories.
       * @default false
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * @description Whether issues are enabled.
       * @default true
       */
      has_issues: boolean;
      /**
       * @description Whether projects are enabled.
       * @default true
       */
      has_projects: boolean;
      /**
       * @description Whether the wiki is enabled.
       * @default true
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * @deprecated
       * @description Whether downloads are enabled.
       * @default true
       */
      has_downloads: boolean;
      /**
       * @description Whether discussions are enabled.
       * @default false
       */
      has_discussions?: boolean;
      /**
       * @description Whether the repository is archived.
       * @default false
       */
      archived: boolean;
      /** @description Returns whether or not this repository disabled. */
      disabled: boolean;
      /**
       * @description The repository visibility: public, private, or internal.
       * @default public
       */
      visibility?: string;
      /** Format: date-time */
      pushed_at: string | null;
      /** Format: date-time */
      created_at: string | null;
      /** Format: date-time */
      updated_at: string | null;
      /**
       * @description Whether to allow rebase merges for pull requests.
       * @default true
       */
      allow_rebase_merge?: boolean;
      temp_clone_token?: string;
      /**
       * @description Whether to allow squash merges for pull requests.
       * @default true
       */
      allow_squash_merge?: boolean;
      /**
       * @description Whether to allow Auto-merge to be used on pull requests.
       * @default false
       */
      allow_auto_merge?: boolean;
      /**
       * @description Whether to delete head branches when pull requests are merged
       * @default false
       */
      delete_branch_on_merge?: boolean;
      /**
       * @description Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
       * @default false
       */
      allow_update_branch?: boolean;
      /**
       * @deprecated
       * @description Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
       * @default false
       */
      use_squash_pr_title_as_default?: boolean;
      /**
       * @description The default value for a squash merge commit title:
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
       * @enum {string}
       */
      squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
      /**
       * @description The default value for a squash merge commit message:
       *
       * - `PR_BODY` - default to the pull request's body.
       * - `COMMIT_MESSAGES` - default to the branch's commit messages.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      squash_merge_commit_message?: "PR_BODY" | "COMMIT_MESSAGES" | "BLANK";
      /**
       * @description The default value for a merge commit title.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
       * @enum {string}
       */
      merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
      /**
       * @description The default value for a merge commit message.
       *
       * - `PR_TITLE` - default to the pull request's title.
       * - `PR_BODY` - default to the pull request's body.
       * - `BLANK` - default to a blank commit message.
       * @enum {string}
       */
      merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
      /**
       * @description Whether to allow merge commits for pull requests.
       * @default true
       */
      allow_merge_commit?: boolean;
      /** @description Whether to allow forking this repo */
      allow_forking?: boolean;
      /**
       * @description Whether to require contributors to sign off on web-based commits
       * @default false
       */
      web_commit_signoff_required?: boolean;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      starred_at?: string;
      /** @description Whether anonymous git access is enabled for this repository */
      anonymous_access_enabled?: boolean;
      /** @description The status of the code search index for this repository */
      code_search_index_status?: {
        lexical_search_ok?: boolean;
        lexical_commit_sha?: string;
      };
    };
    /**
     * Link
     * @description Hypermedia Link
     */
    link: {
      href: string;
    };
    /**
     * author_association
     * @description How the author is associated with the repository.
     * @enum {string}
     */
    "author-association":
      | "COLLABORATOR"
      | "CONTRIBUTOR"
      | "FIRST_TIMER"
      | "FIRST_TIME_CONTRIBUTOR"
      | "MANNEQUIN"
      | "MEMBER"
      | "NONE"
      | "OWNER";
    /**
     * Auto merge
     * @description The status of auto merging a pull request.
     */
    "auto-merge": {
      enabled_by: components["schemas"]["simple-user"];
      /**
       * @description The merge method to use.
       * @enum {string}
       */
      merge_method: "merge" | "squash" | "rebase";
      /** @description Title for the merge commit message. */
      commit_title: string;
      /** @description Commit message for the merge commit. */
      commit_message: string;
    } | null;
    "webhook-deployment-review-approved": {
      /** @enum {string} */
      action: "approved";
      approver?: components["schemas"]["webhooks_approver"];
      comment?: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      reviewers?: components["schemas"]["webhooks_reviewers"];
      sender: components["schemas"]["simple-user"];
      since: string;
      workflow_job_run?: components["schemas"]["webhooks_workflow_job_run"];
      workflow_job_runs?: {
        conclusion?: null;
        created_at?: string;
        environment?: string;
        html_url?: string;
        id?: number;
        name?: string | null;
        status?: string;
        updated_at?: string;
      }[];
      /** Deployment Workflow Run */
      workflow_run: {
        /** User */
        actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        artifacts_url?: string;
        cancel_url?: string;
        check_suite_id: number;
        check_suite_node_id: string;
        check_suite_url?: string;
        /** @enum {string|null} */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null;
        /** Format: date-time */
        created_at: string;
        display_title: string;
        event: string;
        head_branch: string;
        head_commit?: Record<string, never> | null;
        head_repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: string | null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
            user_view_type?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        head_sha: string;
        /** Format: uri */
        html_url: string;
        id: number;
        jobs_url?: string;
        logs_url?: string;
        name: string;
        node_id: string;
        path: string;
        previous_attempt_url?: string | null;
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        referenced_workflows?:
          | {
              path: string;
              ref?: string;
              sha: string;
            }[]
          | null;
        repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: string | null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
            user_view_type?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        rerun_url?: string;
        run_attempt: number;
        run_number: number;
        /** Format: date-time */
        run_started_at: string;
        /** @enum {string} */
        status:
          | "requested"
          | "in_progress"
          | "completed"
          | "queued"
          | "waiting"
          | "pending";
        /** User */
        triggering_actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        workflow_id: number;
        workflow_url?: string;
      } | null;
    };
    webhooks_approver: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
      user_view_type?: string;
    };
    webhooks_reviewers: {
      /** User */
      reviewer?: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
      } | null;
      /** @enum {string} */
      type?: "User";
    }[];
    webhooks_workflow_job_run: {
      conclusion: null;
      created_at: string;
      environment: string;
      html_url: string;
      id: number;
      name: null;
      status: string;
      updated_at: string;
    };
    "webhook-deployment-review-rejected": {
      /** @enum {string} */
      action: "rejected";
      approver?: components["schemas"]["webhooks_approver"];
      comment?: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      reviewers?: components["schemas"]["webhooks_reviewers"];
      sender: components["schemas"]["simple-user"];
      since: string;
      workflow_job_run?: components["schemas"]["webhooks_workflow_job_run"];
      workflow_job_runs?: {
        conclusion?: string | null;
        created_at?: string;
        environment?: string;
        html_url?: string;
        id?: number;
        name?: string | null;
        status?: string;
        updated_at?: string;
      }[];
      /** Deployment Workflow Run */
      workflow_run: {
        /** User */
        actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        artifacts_url?: string;
        cancel_url?: string;
        check_suite_id: number;
        check_suite_node_id: string;
        check_suite_url?: string;
        /** @enum {string|null} */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null;
        /** Format: date-time */
        created_at: string;
        event: string;
        head_branch: string;
        head_commit?: Record<string, never> | null;
        head_repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: string | null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
            user_view_type?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        head_sha: string;
        /** Format: uri */
        html_url: string;
        id: number;
        jobs_url?: string;
        logs_url?: string;
        name: string;
        node_id: string;
        path: string;
        previous_attempt_url?: string | null;
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        referenced_workflows?:
          | {
              path: string;
              ref?: string;
              sha: string;
            }[]
          | null;
        repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: string | null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
            user_view_type?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        rerun_url?: string;
        run_attempt: number;
        run_number: number;
        /** Format: date-time */
        run_started_at: string;
        /** @enum {string} */
        status:
          | "requested"
          | "in_progress"
          | "completed"
          | "queued"
          | "waiting";
        /** User */
        triggering_actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        workflow_id: number;
        workflow_url?: string;
        display_title: string;
      } | null;
    };
    "webhook-deployment-review-requested": {
      /** @enum {string} */
      action: "requested";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      environment: string;
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      requestor: components["schemas"]["webhooks_user"];
      reviewers: {
        /** User */
        reviewer?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login?: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** @enum {string} */
        type?: "User" | "Team";
      }[];
      sender: components["schemas"]["simple-user"];
      since: string;
      workflow_job_run: {
        conclusion: null;
        created_at: string;
        environment: string;
        html_url: string;
        id: number;
        name: string | null;
        status: string;
        updated_at: string;
      };
      /** Deployment Workflow Run */
      workflow_run: {
        /** User */
        actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        artifacts_url?: string;
        cancel_url?: string;
        check_suite_id: number;
        check_suite_node_id: string;
        check_suite_url?: string;
        /** @enum {string|null} */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null;
        /** Format: date-time */
        created_at: string;
        event: string;
        head_branch: string;
        head_commit?: Record<string, never> | null;
        head_repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: string | null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
            user_view_type?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        head_sha: string;
        /** Format: uri */
        html_url: string;
        id: number;
        jobs_url?: string;
        logs_url?: string;
        name: string;
        node_id: string;
        path: string;
        previous_attempt_url?: string | null;
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        referenced_workflows?:
          | {
              path: string;
              ref?: string;
              sha: string;
            }[]
          | null;
        repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: string | null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
            user_view_type?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        rerun_url?: string;
        run_attempt: number;
        run_number: number;
        /** Format: date-time */
        run_started_at: string;
        /** @enum {string} */
        status:
          | "requested"
          | "in_progress"
          | "completed"
          | "queued"
          | "waiting"
          | "pending";
        /** User */
        triggering_actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        workflow_id: number;
        workflow_url?: string;
        display_title: string;
      } | null;
    };
    /** User */
    webhooks_user: {
      /** Format: uri */
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      /** Format: uri-template */
      events_url?: string;
      /** Format: uri */
      followers_url?: string;
      /** Format: uri-template */
      following_url?: string;
      /** Format: uri-template */
      gists_url?: string;
      gravatar_id?: string;
      /** Format: uri */
      html_url?: string;
      /** Format: int64 */
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      /** Format: uri */
      organizations_url?: string;
      /** Format: uri */
      received_events_url?: string;
      /** Format: uri */
      repos_url?: string;
      site_admin?: boolean;
      /** Format: uri-template */
      starred_url?: string;
      /** Format: uri */
      subscriptions_url?: string;
      /** @enum {string} */
      type?: "Bot" | "User" | "Organization";
      /** Format: uri */
      url?: string;
      user_view_type?: string;
    } | null;
    /** deployment_status created event */
    "webhook-deployment-status-created": {
      /** @enum {string} */
      action: "created";
      check_run?: {
        /** Format: date-time */
        completed_at: string | null;
        /**
         * @description The result of the completed check run. This value will be `null` until the check run has completed.
         * @enum {string|null}
         */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | "skipped"
          | null;
        /** Format: uri */
        details_url: string;
        external_id: string;
        /** @description The SHA of the commit that is being checked. */
        head_sha: string;
        /** Format: uri */
        html_url: string;
        /** @description The id of the check. */
        id: number;
        /** @description The name of the check run. */
        name: string;
        node_id: string;
        /** Format: date-time */
        started_at: string;
        /**
         * @description The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
         * @enum {string}
         */
        status: "queued" | "in_progress" | "completed" | "waiting" | "pending";
        /** Format: uri */
        url: string;
      } | null;
      /**
       * Deployment
       * @description The [deployment](https://docs.github.com/rest/deployments/deployments#list-deployments).
       */
      deployment: {
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        description: string | null;
        environment: string;
        id: number;
        node_id: string;
        original_environment: string;
        payload: string | Record<string, never> | null;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "merge_queue_entry"
            | "workflow_job"
            | "pull_request_review_thread"
            | "secret_scanning_alert_location"
            | "merge_group"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        production_environment?: boolean;
        ref: string;
        /** Format: uri */
        repository_url: string;
        sha: string;
        /** Format: uri */
        statuses_url: string;
        task: string;
        transient_environment?: boolean;
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      /** @description The [deployment status](https://docs.github.com/rest/deployments/statuses#list-deployment-statuses). */
      deployment_status: {
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** Format: uri */
        deployment_url: string;
        /** @description The optional human-readable description added to the status. */
        description: string;
        environment: string;
        /** Format: uri */
        environment_url?: string;
        id: number;
        /** Format: uri */
        log_url?: string;
        node_id: string;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "pull_request_review_thread"
            | "merge_queue_entry"
            | "workflow_job"
            | "merge_group"
            | "secret_scanning_alert_location"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        /** Format: uri */
        repository_url: string;
        /** @description The new state. Can be `pending`, `success`, `failure`, or `error`. */
        state: string;
        /** @description The optional link added to the status. */
        target_url: string;
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
      workflow?: components["schemas"]["webhooks_workflow"];
      /** Deployment Workflow Run */
      workflow_run?: {
        /** User */
        actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        artifacts_url?: string;
        cancel_url?: string;
        check_suite_id: number;
        check_suite_node_id: string;
        check_suite_url?: string;
        /** @enum {string|null} */
        conclusion:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "timed_out"
          | "action_required"
          | "stale"
          | null
          | "startup_failure";
        /** Format: date-time */
        created_at: string;
        display_title: string;
        event: string;
        head_branch: string;
        head_commit?: null;
        head_repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        head_sha: string;
        /** Format: uri */
        html_url: string;
        id: number;
        jobs_url?: string;
        logs_url?: string;
        name: string;
        node_id: string;
        path: string;
        previous_attempt_url?: null;
        pull_requests: {
          base: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          head: {
            ref: string;
            /** Repo Ref */
            repo: {
              id: number;
              name: string;
              /** Format: uri */
              url: string;
            };
            sha: string;
          };
          id: number;
          number: number;
          /** Format: uri */
          url: string;
        }[];
        referenced_workflows?:
          | {
              path: string;
              ref?: string;
              sha: string;
            }[]
          | null;
        repository?: {
          archive_url?: string;
          assignees_url?: string;
          blobs_url?: string;
          branches_url?: string;
          collaborators_url?: string;
          comments_url?: string;
          commits_url?: string;
          compare_url?: string;
          contents_url?: string;
          contributors_url?: string;
          deployments_url?: string;
          description?: null;
          downloads_url?: string;
          events_url?: string;
          fork?: boolean;
          forks_url?: string;
          full_name?: string;
          git_commits_url?: string;
          git_refs_url?: string;
          git_tags_url?: string;
          hooks_url?: string;
          html_url?: string;
          id?: number;
          issue_comment_url?: string;
          issue_events_url?: string;
          issues_url?: string;
          keys_url?: string;
          labels_url?: string;
          languages_url?: string;
          merges_url?: string;
          milestones_url?: string;
          name?: string;
          node_id?: string;
          notifications_url?: string;
          owner?: {
            avatar_url?: string;
            events_url?: string;
            followers_url?: string;
            following_url?: string;
            gists_url?: string;
            gravatar_id?: string;
            html_url?: string;
            id?: number;
            login?: string;
            node_id?: string;
            organizations_url?: string;
            received_events_url?: string;
            repos_url?: string;
            site_admin?: boolean;
            starred_url?: string;
            subscriptions_url?: string;
            type?: string;
            url?: string;
          };
          private?: boolean;
          pulls_url?: string;
          releases_url?: string;
          stargazers_url?: string;
          statuses_url?: string;
          subscribers_url?: string;
          subscription_url?: string;
          tags_url?: string;
          teams_url?: string;
          trees_url?: string;
          url?: string;
        };
        rerun_url?: string;
        run_attempt: number;
        run_number: number;
        /** Format: date-time */
        run_started_at: string;
        /** @enum {string} */
        status:
          | "requested"
          | "in_progress"
          | "completed"
          | "queued"
          | "waiting"
          | "pending";
        /** User */
        triggering_actor: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        workflow_id: number;
        workflow_url?: string;
      } | null;
    };
    /** discussion answered event */
    "webhook-discussion-answered": {
      /** @enum {string} */
      action: "answered";
      answer: components["schemas"]["webhooks_answer"];
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    webhooks_answer: {
      /**
       * AuthorAssociation
       * @description How the author is associated with the repository.
       * @enum {string}
       */
      author_association:
        | "COLLABORATOR"
        | "CONTRIBUTOR"
        | "FIRST_TIMER"
        | "FIRST_TIME_CONTRIBUTOR"
        | "MANNEQUIN"
        | "MEMBER"
        | "NONE"
        | "OWNER";
      body: string;
      child_comment_count: number;
      /** Format: date-time */
      created_at: string;
      discussion_id: number;
      html_url: string;
      id: number;
      node_id: string;
      parent_id: null;
      /** Reactions */
      reactions?: {
        "+1": number;
        "-1": number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        /** Format: uri */
        url: string;
      };
      repository_url: string;
      /** Format: date-time */
      updated_at: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
    };
    /**
     * Discussion
     * @description A Discussion in a repository.
     */
    discussion: {
      active_lock_reason: string | null;
      answer_chosen_at: string | null;
      /** User */
      answer_chosen_by: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      answer_html_url: string | null;
      /**
       * AuthorAssociation
       * @description How the author is associated with the repository.
       * @enum {string}
       */
      author_association:
        | "COLLABORATOR"
        | "CONTRIBUTOR"
        | "FIRST_TIMER"
        | "FIRST_TIME_CONTRIBUTOR"
        | "MANNEQUIN"
        | "MEMBER"
        | "NONE"
        | "OWNER";
      body: string;
      category: {
        /** Format: date-time */
        created_at: string;
        description: string;
        emoji: string;
        id: number;
        is_answerable: boolean;
        name: string;
        node_id?: string;
        repository_id: number;
        slug: string;
        updated_at: string;
      };
      comments: number;
      /** Format: date-time */
      created_at: string;
      html_url: string;
      id: number;
      locked: boolean;
      node_id: string;
      number: number;
      /** Reactions */
      reactions?: {
        "+1": number;
        "-1": number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        /** Format: uri */
        url: string;
      };
      repository_url: string;
      /**
       * @description The current state of the discussion.
       * `converting` means that the discussion is being converted from an issue.
       * `transferring` means that the discussion is being transferred from another repository.
       * @enum {string}
       */
      state: "open" | "closed" | "locked" | "converting" | "transferring";
      /**
       * @description The reason for the current state
       * @enum {string|null}
       */
      state_reason: "resolved" | "outdated" | "duplicate" | "reopened" | null;
      timeline_url?: string;
      title: string;
      /** Format: date-time */
      updated_at: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      labels?: components["schemas"]["label"][];
    };
    /**
     * Label
     * @description Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
     */
    label: {
      /**
       * Format: int64
       * @description Unique identifier for the label.
       */
      id: number;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the label
       */
      url: string;
      /** @description The name of the label. */
      name: string;
      /** @description Optional description of the label, such as its purpose. */
      description: string | null;
      /** @description 6-character hex code, without the leading #, identifying the color */
      color: string;
      /** @description Whether this label comes by default in a new repository. */
      default: boolean;
    };
    /** discussion category changed event */
    "webhook-discussion-category-changed": {
      /** @enum {string} */
      action: "category_changed";
      changes: {
        category: {
          from: {
            /** Format: date-time */
            created_at: string;
            description: string;
            emoji: string;
            id: number;
            is_answerable: boolean;
            name: string;
            node_id?: string;
            repository_id: number;
            slug: string;
            updated_at: string;
          };
        };
      };
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion closed event */
    "webhook-discussion-closed": {
      /** @enum {string} */
      action: "closed";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion_comment created event */
    "webhook-discussion-comment-created": {
      /** @enum {string} */
      action: "created";
      comment: components["schemas"]["webhooks_comment"];
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    webhooks_comment: {
      /**
       * AuthorAssociation
       * @description How the author is associated with the repository.
       * @enum {string}
       */
      author_association:
        | "COLLABORATOR"
        | "CONTRIBUTOR"
        | "FIRST_TIMER"
        | "FIRST_TIME_CONTRIBUTOR"
        | "MANNEQUIN"
        | "MEMBER"
        | "NONE"
        | "OWNER";
      body: string;
      child_comment_count: number;
      created_at: string;
      discussion_id: number;
      html_url: string;
      id: number;
      node_id: string;
      parent_id: number | null;
      /** Reactions */
      reactions: {
        "+1": number;
        "-1": number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        /** Format: uri */
        url: string;
      };
      repository_url: string;
      updated_at: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
    };
    /** discussion_comment deleted event */
    "webhook-discussion-comment-deleted": {
      /** @enum {string} */
      action: "deleted";
      comment: components["schemas"]["webhooks_comment"];
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion_comment edited event */
    "webhook-discussion-comment-edited": {
      /** @enum {string} */
      action: "edited";
      changes: {
        body: {
          from: string;
        };
      };
      comment: components["schemas"]["webhooks_comment"];
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion created event */
    "webhook-discussion-created": {
      /** @enum {string} */
      action: "created";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion deleted event */
    "webhook-discussion-deleted": {
      /** @enum {string} */
      action: "deleted";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion edited event */
    "webhook-discussion-edited": {
      /** @enum {string} */
      action: "edited";
      changes?: {
        body?: {
          from: string;
        };
        title?: {
          from: string;
        };
      };
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion labeled event */
    "webhook-discussion-labeled": {
      /** @enum {string} */
      action: "labeled";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      label: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Label */
    webhooks_label: {
      /** @description 6-character hex code, without the leading #, identifying the color */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /** @description The name of the label. */
      name: string;
      node_id: string;
      /**
       * Format: uri
       * @description URL for the label
       */
      url: string;
    };
    /** discussion locked event */
    "webhook-discussion-locked": {
      /** @enum {string} */
      action: "locked";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion pinned event */
    "webhook-discussion-pinned": {
      /** @enum {string} */
      action: "pinned";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion reopened event */
    "webhook-discussion-reopened": {
      /** @enum {string} */
      action: "reopened";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion transferred event */
    "webhook-discussion-transferred": {
      /** @enum {string} */
      action: "transferred";
      changes: {
        new_discussion: components["schemas"]["discussion"];
        new_repository: components["schemas"]["repository-webhooks"];
      };
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion unanswered event */
    "webhook-discussion-unanswered": {
      /** @enum {string} */
      action: "unanswered";
      discussion: components["schemas"]["discussion"];
      old_answer: components["schemas"]["webhooks_answer"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** discussion unlabeled event */
    "webhook-discussion-unlabeled": {
      /** @enum {string} */
      action: "unlabeled";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      label: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion unlocked event */
    "webhook-discussion-unlocked": {
      /** @enum {string} */
      action: "unlocked";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** discussion unpinned event */
    "webhook-discussion-unpinned": {
      /** @enum {string} */
      action: "unpinned";
      discussion: components["schemas"]["discussion"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * fork event
     * @description A user forks a repository.
     */
    "webhook-fork": {
      enterprise?: components["schemas"]["enterprise-webhooks"];
      /** @description The created [`repository`](https://docs.github.com/rest/repos/repos#get-a-repository) resource. */
      forkee: {
        /**
         * @description Whether to allow auto-merge for pull requests.
         * @default false
         */
        allow_auto_merge?: boolean;
        /** @description Whether to allow private forks */
        allow_forking?: boolean;
        /**
         * @description Whether to allow merge commits for pull requests.
         * @default true
         */
        allow_merge_commit?: boolean;
        /**
         * @description Whether to allow rebase merges for pull requests.
         * @default true
         */
        allow_rebase_merge?: boolean;
        /**
         * @description Whether to allow squash merges for pull requests.
         * @default true
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        /** Format: uri-template */
        archive_url: string;
        /**
         * @description Whether the repository is archived.
         * @default false
         */
        archived: boolean;
        /** Format: uri-template */
        assignees_url: string;
        /** Format: uri-template */
        blobs_url: string;
        /** Format: uri-template */
        branches_url: string;
        /** Format: uri */
        clone_url: string;
        /** Format: uri-template */
        collaborators_url: string;
        /** Format: uri-template */
        comments_url: string;
        /** Format: uri-template */
        commits_url: string;
        /** Format: uri-template */
        compare_url: string;
        /** Format: uri-template */
        contents_url: string;
        /** Format: uri */
        contributors_url: string;
        created_at: number | string;
        /** @description The default branch of the repository. */
        default_branch: string;
        /**
         * @description Whether to delete head branches when pull requests are merged
         * @default false
         */
        delete_branch_on_merge?: boolean;
        /** Format: uri */
        deployments_url: string;
        description: string | null;
        /** @description Returns whether or not this repository is disabled. */
        disabled?: boolean;
        /** Format: uri */
        downloads_url: string;
        /** Format: uri */
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        /** Format: uri */
        forks_url: string;
        full_name: string;
        /** Format: uri-template */
        git_commits_url: string;
        /** Format: uri-template */
        git_refs_url: string;
        /** Format: uri-template */
        git_tags_url: string;
        /** Format: uri */
        git_url: string;
        /**
         * @description Whether downloads are enabled.
         * @default true
         */
        has_downloads: boolean;
        /**
         * @description Whether issues are enabled.
         * @default true
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * @description Whether projects are enabled.
         * @default true
         */
        has_projects: boolean;
        /**
         * @description Whether the wiki is enabled.
         * @default true
         */
        has_wiki: boolean;
        homepage: string | null;
        /** Format: uri */
        hooks_url: string;
        /** Format: uri */
        html_url: string;
        /**
         * Format: int64
         * @description Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        /** Format: uri-template */
        issue_comment_url: string;
        /** Format: uri-template */
        issue_events_url: string;
        /** Format: uri-template */
        issues_url: string;
        /** Format: uri-template */
        keys_url: string;
        /** Format: uri-template */
        labels_url: string;
        language: string | null;
        /** Format: uri */
        languages_url: string;
        /** License */
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          /** Format: uri */
          url: string | null;
        } | null;
        master_branch?: string;
        /** Format: uri */
        merges_url: string;
        /** Format: uri-template */
        milestones_url: string;
        /** Format: uri */
        mirror_url: string | null;
        /** @description The name of the repository. */
        name: string;
        node_id: string;
        /** Format: uri-template */
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        /** User */
        owner: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /** @description Whether the repository is private or public. */
        private: boolean;
        public?: boolean;
        /** Format: uri-template */
        pulls_url: string;
        pushed_at: number | string | null;
        /** Format: uri-template */
        releases_url: string;
        role_name?: string | null;
        size: number;
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        /** Format: uri */
        stargazers_url: string;
        /** Format: uri-template */
        statuses_url: string;
        /** Format: uri */
        subscribers_url: string;
        /** Format: uri */
        subscription_url: string;
        /** Format: uri */
        svn_url: string;
        /** Format: uri */
        tags_url: string;
        /** Format: uri */
        teams_url: string;
        topics: string[];
        /** Format: uri-template */
        trees_url: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        /** @enum {string} */
        visibility: "public" | "private" | "internal";
        watchers: number;
        watchers_count: number;
        /** @description Whether to require contributors to sign off on web-based commits */
        web_commit_signoff_required?: boolean;
      } & {
        allow_forking?: boolean;
        archive_url?: string;
        archived?: boolean;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        clone_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        created_at?: string;
        default_branch?: string;
        deployments_url?: string;
        description?: string | null;
        disabled?: boolean;
        downloads_url?: string;
        events_url?: string;
        /** @enum {boolean} */
        fork?: true;
        forks?: number;
        forks_count?: number;
        forks_url?: string;
        full_name?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        has_downloads?: boolean;
        has_issues?: boolean;
        has_pages?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        homepage?: string | null;
        hooks_url?: string;
        html_url?: string;
        id?: number;
        is_template?: boolean;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        language?: null;
        languages_url?: string;
        license?: Record<string, never> | null;
        merges_url?: string;
        milestones_url?: string;
        mirror_url?: null;
        name?: string;
        node_id?: string;
        notifications_url?: string;
        open_issues?: number;
        open_issues_count?: number;
        owner?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        };
        private?: boolean;
        public?: boolean;
        pulls_url?: string;
        pushed_at?: string;
        releases_url?: string;
        size?: number;
        ssh_url?: string;
        stargazers_count?: number;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        svn_url?: string;
        tags_url?: string;
        teams_url?: string;
        topics?: null[];
        trees_url?: string;
        updated_at?: string;
        url?: string;
        visibility?: string;
        watchers?: number;
        watchers_count?: number;
      };
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** github_app_authorization revoked event */
    "webhook-github-app-authorization-revoked": {
      /** @enum {string} */
      action: "revoked";
      sender: components["schemas"]["simple-user"];
    };
    /** gollum event */
    "webhook-gollum": {
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** @description The pages that were updated. */
      pages: {
        /**
         * @description The action that was performed on the page. Can be `created` or `edited`.
         * @enum {string}
         */
        action: "created" | "edited";
        /**
         * Format: uri
         * @description Points to the HTML wiki page.
         */
        html_url: string;
        /** @description The name of the page. */
        page_name: string;
        /** @description The latest commit SHA of the page. */
        sha: string;
        summary: string | null;
        /** @description The current page title. */
        title: string;
      }[];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** installation created event */
    "webhook-installation-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories?: components["schemas"]["webhooks_repositories"];
      repository?: components["schemas"]["repository-webhooks"];
      requester?: components["schemas"]["webhooks_user"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Installation
     * @description Installation
     */
    installation: {
      /** @description The ID of the installation. */
      id: number;
      account:
        | null
        | (
            | components["schemas"]["simple-user"]
            | components["schemas"]["enterprise"]
          );
      /**
       * @description Describe whether all repositories have been selected or there's a selection involved
       * @enum {string}
       */
      repository_selection: "all" | "selected";
      /** Format: uri */
      access_tokens_url: string;
      /** Format: uri */
      repositories_url: string;
      /** Format: uri */
      html_url: string;
      app_id: number;
      /** @description The ID of the user or organization this token is being scoped to. */
      target_id: number;
      target_type: string;
      permissions: components["schemas"]["app-permissions"];
      events: string[];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      single_file_name: string | null;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
      app_slug: string;
      suspended_by: null | components["schemas"]["simple-user"];
      /** Format: date-time */
      suspended_at: string | null;
      contact_email?: string | null;
    };
    /**
     * App Permissions
     * @description The permissions granted to the user access token.
     * @example {
     *   "contents": "read",
     *   "issues": "read",
     *   "deployments": "write",
     *   "single_file": "read"
     * }
     */
    "app-permissions": {
      /**
       * @description The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
       * @enum {string}
       */
      actions?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
       * @enum {string}
       */
      administration?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for checks on code.
       * @enum {string}
       */
      checks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to create, edit, delete, and list Codespaces.
       * @enum {string}
       */
      codespaces?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
       * @enum {string}
       */
      contents?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage Dependabot secrets.
       * @enum {string}
       */
      dependabot_secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for deployments and deployment statuses.
       * @enum {string}
       */
      deployments?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for managing repository environments.
       * @enum {string}
       */
      environments?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
       * @enum {string}
       */
      issues?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
       * @enum {string}
       */
      metadata?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for packages published to GitHub Packages.
       * @enum {string}
       */
      packages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
       * @enum {string}
       */
      pages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
       * @enum {string}
       */
      pull_requests?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.
       * @enum {string}
       */
      repository_custom_properties?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the post-receive hooks for a repository.
       * @enum {string}
       */
      repository_hooks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage repository projects, columns, and cards.
       * @enum {string}
       */
      repository_projects?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token to view and manage secret scanning alerts.
       * @enum {string}
       */
      secret_scanning_alerts?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage repository secrets.
       * @enum {string}
       */
      secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage security events like code scanning alerts.
       * @enum {string}
       */
      security_events?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage just a single file.
       * @enum {string}
       */
      single_file?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for commit statuses.
       * @enum {string}
       */
      statuses?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage Dependabot alerts.
       * @enum {string}
       */
      vulnerability_alerts?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to update GitHub Actions workflow files.
       * @enum {string}
       */
      workflows?: "write";
      /**
       * @description The level of permission to grant the access token for organization teams and members.
       * @enum {string}
       */
      members?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage access to an organization.
       * @enum {string}
       */
      organization_administration?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for custom repository roles management.
       * @enum {string}
       */
      organization_custom_roles?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for custom organization roles management.
       * @enum {string}
       */
      organization_custom_org_roles?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for custom property management.
       * @enum {string}
       */
      organization_custom_properties?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in public preview and is subject to change.
       * @enum {string}
       */
      organization_copilot_seat_management?: "write";
      /**
       * @description The level of permission to grant the access token to view and manage announcement banners for an organization.
       * @enum {string}
       */
      organization_announcement_banners?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view events triggered by an activity in an organization.
       * @enum {string}
       */
      organization_events?: "read";
      /**
       * @description The level of permission to grant the access token to manage the post-receive hooks for an organization.
       * @enum {string}
       */
      organization_hooks?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.
       * @enum {string}
       */
      organization_personal_access_tokens?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.
       * @enum {string}
       */
      organization_personal_access_token_requests?: "read" | "write";
      /**
       * @description The level of permission to grant the access token for viewing an organization's plan.
       * @enum {string}
       */
      organization_plan?: "read";
      /**
       * @description The level of permission to grant the access token to manage organization projects and projects public preview (where available).
       * @enum {string}
       */
      organization_projects?: "read" | "write" | "admin";
      /**
       * @description The level of permission to grant the access token for organization packages published to GitHub Packages.
       * @enum {string}
       */
      organization_packages?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage organization secrets.
       * @enum {string}
       */
      organization_secrets?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
       * @enum {string}
       */
      organization_self_hosted_runners?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage users blocked by the organization.
       * @enum {string}
       */
      organization_user_blocking?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage team discussions and related comments.
       * @enum {string}
       */
      team_discussions?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the email addresses belonging to a user.
       * @enum {string}
       */
      email_addresses?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the followers belonging to a user.
       * @enum {string}
       */
      followers?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage git SSH keys.
       * @enum {string}
       */
      git_ssh_keys?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage GPG keys belonging to a user.
       * @enum {string}
       */
      gpg_keys?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to view and manage interaction limits on a repository.
       * @enum {string}
       */
      interaction_limits?: "read" | "write";
      /**
       * @description The level of permission to grant the access token to manage the profile settings belonging to a user.
       * @enum {string}
       */
      profile?: "write";
      /**
       * @description The level of permission to grant the access token to list and manage repositories a user is starring.
       * @enum {string}
       */
      starring?: "read" | "write";
    };
    /** @description An array of repository objects that the installation can access. */
    webhooks_repositories: {
      full_name: string;
      /** @description Unique identifier of the repository */
      id: number;
      /** @description The name of the repository. */
      name: string;
      node_id: string;
      /** @description Whether the repository is private or public. */
      private: boolean;
    }[];
    /** installation deleted event */
    "webhook-installation-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories?: components["schemas"]["webhooks_repositories"];
      repository?: components["schemas"]["repository-webhooks"];
      requester?: null;
      sender: components["schemas"]["simple-user"];
    };
    /** installation new_permissions_accepted event */
    "webhook-installation-new-permissions-accepted": {
      /** @enum {string} */
      action: "new_permissions_accepted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories?: components["schemas"]["webhooks_repositories"];
      repository?: components["schemas"]["repository-webhooks"];
      requester?: null;
      sender: components["schemas"]["simple-user"];
    };
    /** installation_repositories added event */
    "webhook-installation-repositories-added": {
      /** @enum {string} */
      action: "added";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories_added: components["schemas"]["webhooks_repositories_added"];
      /** @description An array of repository objects, which were removed from the installation. */
      repositories_removed: {
        full_name?: string;
        /** @description Unique identifier of the repository */
        id?: number;
        /** @description The name of the repository. */
        name?: string;
        node_id?: string;
        /** @description Whether the repository is private or public. */
        private?: boolean;
      }[];
      repository?: components["schemas"]["repository-webhooks"];
      repository_selection: components["schemas"]["webhooks_repository_selection"];
      requester: components["schemas"]["webhooks_user"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description An array of repository objects, which were added to the installation. */
    webhooks_repositories_added: {
      full_name: string;
      /** @description Unique identifier of the repository */
      id: number;
      /** @description The name of the repository. */
      name: string;
      node_id: string;
      /** @description Whether the repository is private or public. */
      private: boolean;
    }[];
    /**
     * @description Describe whether all repositories have been selected or there's a selection involved
     * @enum {string}
     */
    webhooks_repository_selection: "all" | "selected";
    /** installation_repositories removed event */
    "webhook-installation-repositories-removed": {
      /** @enum {string} */
      action: "removed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories_added: components["schemas"]["webhooks_repositories_added"];
      /** @description An array of repository objects, which were removed from the installation. */
      repositories_removed: {
        full_name: string;
        /** @description Unique identifier of the repository */
        id: number;
        /** @description The name of the repository. */
        name: string;
        node_id: string;
        /** @description Whether the repository is private or public. */
        private: boolean;
      }[];
      repository?: components["schemas"]["repository-webhooks"];
      repository_selection: components["schemas"]["webhooks_repository_selection"];
      requester: components["schemas"]["webhooks_user"];
      sender: components["schemas"]["simple-user"];
    };
    /** installation suspend event */
    "webhook-installation-suspend": {
      /** @enum {string} */
      action: "suspend";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories?: components["schemas"]["webhooks_repositories"];
      repository?: components["schemas"]["repository-webhooks"];
      requester?: null;
      sender: components["schemas"]["simple-user"];
    };
    "webhook-installation-target-renamed": {
      account: {
        archived_at?: string | null;
        avatar_url: string;
        created_at?: string;
        description?: null;
        events_url?: string;
        followers?: number;
        followers_url?: string;
        following?: number;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        has_organization_projects?: boolean;
        has_repository_projects?: boolean;
        hooks_url?: string;
        html_url: string;
        id: number;
        is_verified?: boolean;
        issues_url?: string;
        login?: string;
        members_url?: string;
        name?: string;
        node_id: string;
        organizations_url?: string;
        public_gists?: number;
        public_members_url?: string;
        public_repos?: number;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        slug?: string;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        updated_at?: string;
        url?: string;
        website_url?: null;
        user_view_type?: string;
      };
      /** @enum {string} */
      action: "renamed";
      changes: {
        login?: {
          from: string;
        };
        slug?: {
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
      target_type: string;
    };
    /** installation unsuspend event */
    "webhook-installation-unsuspend": {
      /** @enum {string} */
      action: "unsuspend";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation: components["schemas"]["installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repositories?: components["schemas"]["webhooks_repositories"];
      repository?: components["schemas"]["repository-webhooks"];
      requester?: null;
      sender: components["schemas"]["simple-user"];
    };
    /** issue_comment created event */
    "webhook-issue-comment-created": {
      /** @enum {string} */
      action: "created";
      /**
       * issue comment
       * @description The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment) itself.
       */
      comment: {
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue comment */
        body: string;
        /** Format: date-time */
        created_at: string;
        /** Format: uri */
        html_url: string;
        /**
         * Format: int64
         * @description Unique identifier of the issue comment
         */
        id: number;
        /** Format: uri */
        issue_url: string;
        node_id: string;
        performed_via_github_app: null | components["schemas"]["integration"];
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue comment
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment belongs to. */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "reminder"
            | "pull_request_review_thread"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      } & {
        active_lock_reason?: string | null;
        /** User */
        assignee: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees?: (Record<string, never> | null)[];
        author_association?: string;
        body?: string | null;
        closed_at?: string | null;
        comments?: number;
        comments_url?: string;
        created_at?: string;
        events_url?: string;
        html_url?: string;
        id?: number;
        labels: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        labels_url?: string;
        locked: boolean;
        milestone?: Record<string, never> | null;
        node_id?: string;
        number?: number;
        performed_via_github_app?: Record<string, never> | null;
        reactions?: {
          "+1"?: number;
          "-1"?: number;
          confused?: number;
          eyes?: number;
          heart?: number;
          hooray?: number;
          laugh?: number;
          rocket?: number;
          total_count?: number;
          url?: string;
        };
        repository_url?: string;
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state: "open" | "closed";
        timeline_url?: string;
        title?: string;
        updated_at?: string;
        url?: string;
        user?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          /** Format: int64 */
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        };
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Issue Type
     * @description The type of issue.
     */
    "issue-type": {
      /** @description The unique identifier of the issue type. */
      id: number;
      /** @description The node identifier of the issue type. */
      node_id: string;
      /** @description The name of the issue type. */
      name: string;
      /** @description The description of the issue type. */
      description: string | null;
      /**
       * @description The color of the issue type.
       * @enum {string|null}
       */
      color?:
        | "gray"
        | "blue"
        | "green"
        | "yellow"
        | "orange"
        | "red"
        | "pink"
        | "purple"
        | null;
      /**
       * Format: date-time
       * @description The time the issue type created.
       */
      created_at?: string;
      /**
       * Format: date-time
       * @description The time the issue type last updated.
       */
      updated_at?: string;
      /** @description The enabled state of the issue type. */
      is_enabled?: boolean;
    } | null;
    /** issue_comment deleted event */
    "webhook-issue-comment-deleted": {
      /** @enum {string} */
      action: "deleted";
      comment: components["schemas"]["webhooks_issue_comment"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment belongs to. */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      } & {
        active_lock_reason?: string | null;
        /** User */
        assignee: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees?: (Record<string, never> | null)[];
        author_association?: string;
        body?: string | null;
        closed_at?: string | null;
        comments?: number;
        comments_url?: string;
        created_at?: string;
        events_url?: string;
        html_url?: string;
        id?: number;
        labels: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        labels_url?: string;
        locked: boolean;
        milestone?: Record<string, never> | null;
        node_id?: string;
        number?: number;
        performed_via_github_app?: Record<string, never> | null;
        reactions?: {
          "+1"?: number;
          "-1"?: number;
          confused?: number;
          eyes?: number;
          heart?: number;
          hooray?: number;
          laugh?: number;
          rocket?: number;
          total_count?: number;
          url?: string;
        };
        repository_url?: string;
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state: "open" | "closed";
        timeline_url?: string;
        title?: string;
        updated_at?: string;
        url?: string;
        user?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          /** Format: int64 */
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
          user_view_type?: string;
        };
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * issue comment
     * @description The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment) itself.
     */
    webhooks_issue_comment: {
      /**
       * AuthorAssociation
       * @description How the author is associated with the repository.
       * @enum {string}
       */
      author_association:
        | "COLLABORATOR"
        | "CONTRIBUTOR"
        | "FIRST_TIMER"
        | "FIRST_TIME_CONTRIBUTOR"
        | "MANNEQUIN"
        | "MEMBER"
        | "NONE"
        | "OWNER";
      /** @description Contents of the issue comment */
      body: string;
      /** Format: date-time */
      created_at: string;
      /** Format: uri */
      html_url: string;
      /**
       * Format: int64
       * @description Unique identifier of the issue comment
       */
      id: number;
      /** Format: uri */
      issue_url: string;
      node_id: string;
      performed_via_github_app: components["schemas"]["integration"];
      /** Reactions */
      reactions: {
        "+1": number;
        "-1": number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        /** Format: uri */
        url: string;
      };
      /** Format: date-time */
      updated_at: string;
      /**
       * Format: uri
       * @description URL for the issue comment
       */
      url: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization" | "Mannequin";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
    };
    /** issue_comment edited event */
    "webhook-issue-comment-edited": {
      /** @enum {string} */
      action: "edited";
      changes: components["schemas"]["webhooks_changes"];
      comment: components["schemas"]["webhooks_issue_comment"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment belongs to. */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "reminder"
            | "pull_request_review_thread"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      } & {
        active_lock_reason?: string | null;
        /** User */
        assignee: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees?: (Record<string, never> | null)[];
        author_association?: string;
        body?: string | null;
        closed_at?: string | null;
        comments?: number;
        comments_url?: string;
        created_at?: string;
        events_url?: string;
        html_url?: string;
        id?: number;
        labels: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        labels_url?: string;
        locked: boolean;
        milestone?: Record<string, never> | null;
        node_id?: string;
        number?: number;
        performed_via_github_app?: Record<string, never> | null;
        reactions?: {
          "+1"?: number;
          "-1"?: number;
          confused?: number;
          eyes?: number;
          heart?: number;
          hooray?: number;
          laugh?: number;
          rocket?: number;
          total_count?: number;
          url?: string;
        };
        repository_url?: string;
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state: "open" | "closed";
        timeline_url?: string;
        title?: string;
        updated_at?: string;
        url?: string;
        user?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          /** Format: int64 */
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        };
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description The changes to the comment. */
    webhooks_changes: {
      body?: {
        /** @description The previous version of the body. */
        from: string;
      };
    };
    /** issues assigned event */
    "webhook-issues-assigned": {
      /**
       * @description The action that was performed.
       * @enum {string}
       */
      action: "assigned";
      assignee?: components["schemas"]["webhooks_user"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Issue
     * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
     */
    webhooks_issue: {
      /** @enum {string|null} */
      active_lock_reason:
        | "resolved"
        | "off-topic"
        | "too heated"
        | "spam"
        | null;
      /** User */
      assignee?: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization" | "Mannequin";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      assignees: ({
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization" | "Mannequin";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null)[];
      /**
       * AuthorAssociation
       * @description How the author is associated with the repository.
       * @enum {string}
       */
      author_association:
        | "COLLABORATOR"
        | "CONTRIBUTOR"
        | "FIRST_TIMER"
        | "FIRST_TIME_CONTRIBUTOR"
        | "MANNEQUIN"
        | "MEMBER"
        | "NONE"
        | "OWNER";
      /** @description Contents of the issue */
      body: string | null;
      /** Format: date-time */
      closed_at: string | null;
      comments: number;
      /** Format: uri */
      comments_url: string;
      /** Format: date-time */
      created_at: string;
      draft?: boolean;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      /** Format: int64 */
      id: number;
      labels?: {
        /** @description 6-character hex code, without the leading #, identifying the color */
        color: string;
        default: boolean;
        description: string | null;
        id: number;
        /** @description The name of the label. */
        name: string;
        node_id: string;
        /**
         * Format: uri
         * @description URL for the label
         */
        url: string;
      }[];
      /** Format: uri-template */
      labels_url: string;
      locked?: boolean;
      /**
       * Milestone
       * @description A collection of related issues and pull requests.
       */
      milestone: {
        /** Format: date-time */
        closed_at: string | null;
        closed_issues: number;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        description: string | null;
        /** Format: date-time */
        due_on: string | null;
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        labels_url: string;
        node_id: string;
        /** @description The number of the milestone. */
        number: number;
        open_issues: number;
        /**
         * @description The state of the milestone.
         * @enum {string}
         */
        state: "open" | "closed";
        /** @description The title of the milestone. */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      } | null;
      node_id: string;
      number: number;
      /**
       * App
       * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
       */
      performed_via_github_app?: {
        /** Format: date-time */
        created_at: string | null;
        description: string | null;
        /** @description The list of events for the GitHub app */
        events?: (
          | "branch_protection_rule"
          | "check_run"
          | "check_suite"
          | "code_scanning_alert"
          | "commit_comment"
          | "content_reference"
          | "create"
          | "delete"
          | "deployment"
          | "deployment_review"
          | "deployment_status"
          | "deploy_key"
          | "discussion"
          | "discussion_comment"
          | "fork"
          | "gollum"
          | "issues"
          | "issue_comment"
          | "label"
          | "member"
          | "membership"
          | "milestone"
          | "organization"
          | "org_block"
          | "page_build"
          | "project"
          | "project_card"
          | "project_column"
          | "public"
          | "pull_request"
          | "pull_request_review"
          | "pull_request_review_comment"
          | "push"
          | "registry_package"
          | "release"
          | "repository"
          | "repository_dispatch"
          | "secret_scanning_alert"
          | "star"
          | "status"
          | "team"
          | "team_add"
          | "watch"
          | "workflow_dispatch"
          | "workflow_run"
          | "reminder"
          | "pull_request_review_thread"
        )[];
        /** Format: uri */
        external_url: string | null;
        /** Format: uri */
        html_url: string;
        /** @description Unique identifier of the GitHub app */
        id: number | null;
        /** @description The name of the GitHub app */
        name: string;
        node_id: string;
        /** User */
        owner: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** @description The set of permissions for the GitHub app */
        permissions?: {
          /** @enum {string} */
          actions?: "read" | "write";
          /** @enum {string} */
          administration?: "read" | "write";
          /** @enum {string} */
          checks?: "read" | "write";
          /** @enum {string} */
          content_references?: "read" | "write";
          /** @enum {string} */
          contents?: "read" | "write";
          /** @enum {string} */
          deployments?: "read" | "write";
          /** @enum {string} */
          discussions?: "read" | "write";
          /** @enum {string} */
          emails?: "read" | "write";
          /** @enum {string} */
          environments?: "read" | "write";
          /** @enum {string} */
          issues?: "read" | "write";
          /** @enum {string} */
          keys?: "read" | "write";
          /** @enum {string} */
          members?: "read" | "write";
          /** @enum {string} */
          metadata?: "read" | "write";
          /** @enum {string} */
          organization_administration?: "read" | "write";
          /** @enum {string} */
          organization_hooks?: "read" | "write";
          /** @enum {string} */
          organization_packages?: "read" | "write";
          /** @enum {string} */
          organization_plan?: "read" | "write";
          /** @enum {string} */
          organization_projects?: "read" | "write" | "admin";
          /** @enum {string} */
          organization_secrets?: "read" | "write";
          /** @enum {string} */
          organization_self_hosted_runners?: "read" | "write";
          /** @enum {string} */
          organization_user_blocking?: "read" | "write";
          /** @enum {string} */
          packages?: "read" | "write";
          /** @enum {string} */
          pages?: "read" | "write";
          /** @enum {string} */
          pull_requests?: "read" | "write";
          /** @enum {string} */
          repository_hooks?: "read" | "write";
          /** @enum {string} */
          repository_projects?: "read" | "write";
          /** @enum {string} */
          secret_scanning_alerts?: "read" | "write";
          /** @enum {string} */
          secrets?: "read" | "write";
          /** @enum {string} */
          security_events?: "read" | "write";
          /** @enum {string} */
          security_scanning_alert?: "read" | "write";
          /** @enum {string} */
          single_file?: "read" | "write";
          /** @enum {string} */
          statuses?: "read" | "write";
          /** @enum {string} */
          team_discussions?: "read" | "write";
          /** @enum {string} */
          vulnerability_alerts?: "read" | "write";
          /** @enum {string} */
          workflows?: "read" | "write";
        };
        /** @description The slug name of the GitHub app */
        slug?: string;
        /** Format: date-time */
        updated_at: string | null;
      } | null;
      pull_request?: {
        /** Format: uri */
        diff_url?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        patch_url?: string;
        /** Format: uri */
        url?: string;
      };
      /** Reactions */
      reactions: {
        "+1": number;
        "-1": number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        /** Format: uri */
        url: string;
      };
      /** Format: uri */
      repository_url: string;
      /** Sub-issues Summary */
      sub_issues_summary?: {
        total: number;
        completed: number;
        percent_completed: number;
      };
      /**
       * @description State of the issue; either 'open' or 'closed'
       * @enum {string}
       */
      state?: "open" | "closed";
      state_reason?: string | null;
      /** Format: uri */
      timeline_url?: string;
      /** @description Title of the issue */
      title: string;
      type?: components["schemas"]["issue-type"];
      /** Format: date-time */
      updated_at: string;
      /**
       * Format: uri
       * @description URL for the issue
       */
      url: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization" | "Mannequin";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
    };
    /** issues closed event */
    "webhook-issues-closed": {
      /**
       * @description The action that was performed.
       * @enum {string}
       */
      action: "closed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself. */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "security_and_analysis"
            | "reminder"
            | "pull_request_review_thread"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      } & {
        active_lock_reason?: string | null;
        assignee?: Record<string, never> | null;
        assignees?: (Record<string, never> | null)[];
        author_association?: string;
        body?: string | null;
        closed_at: string | null;
        comments?: number;
        comments_url?: string;
        created_at?: string;
        events_url?: string;
        html_url?: string;
        id?: number;
        labels?: (Record<string, never> | null)[];
        labels_url?: string;
        locked?: boolean;
        milestone?: Record<string, never> | null;
        node_id?: string;
        number?: number;
        performed_via_github_app?: Record<string, never> | null;
        reactions?: {
          "+1"?: number;
          "-1"?: number;
          confused?: number;
          eyes?: number;
          heart?: number;
          hooray?: number;
          laugh?: number;
          rocket?: number;
          total_count?: number;
          url?: string;
        };
        repository_url?: string;
        /** @enum {string} */
        state: "closed" | "open";
        timeline_url?: string;
        title?: string;
        updated_at?: string;
        url?: string;
        user?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          /** Format: int64 */
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
          user_view_type?: string;
        };
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues deleted event */
    "webhook-issues-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "reminder"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues demilestoned event */
    "webhook-issues-demilestoned": {
      /** @enum {string} */
      action: "demilestoned";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: ({
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        } | null)[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      milestone?: components["schemas"]["webhooks_milestone"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Milestone
     * @description A collection of related issues and pull requests.
     */
    webhooks_milestone: {
      /** Format: date-time */
      closed_at: string | null;
      closed_issues: number;
      /** Format: date-time */
      created_at: string;
      /** User */
      creator: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization" | "Mannequin";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      description: string | null;
      /** Format: date-time */
      due_on: string | null;
      /** Format: uri */
      html_url: string;
      id: number;
      /** Format: uri */
      labels_url: string;
      node_id: string;
      /** @description The number of the milestone. */
      number: number;
      open_issues: number;
      /**
       * @description The state of the milestone.
       * @enum {string}
       */
      state: "open" | "closed";
      /** @description The title of the milestone. */
      title: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      url: string;
    };
    /** issues edited event */
    "webhook-issues-edited": {
      /** @enum {string} */
      action: "edited";
      /** @description The changes to the issue. */
      changes: {
        body?: {
          /** @description The previous version of the body. */
          from: string;
        };
        title?: {
          /** @description The previous version of the title. */
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "security_and_analysis"
            | "pull_request_review_thread"
            | "reminder"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        type?: components["schemas"]["issue-type"];
        /** @description Title of the issue */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      label?: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues labeled event */
    "webhook-issues-labeled": {
      /** @enum {string} */
      action: "labeled";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "pull_request_review_thread"
            | "reminder"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        type?: components["schemas"]["issue-type"];
        /** @description Title of the issue */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      label?: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues locked event */
    "webhook-issues-locked": {
      /** @enum {string} */
      action: "locked";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: ({
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        } | null)[];
        /** Format: uri-template */
        labels_url: string;
        /** @enum {boolean} */
        locked: true;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "reminder"
            | "security_and_analysis"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        type?: components["schemas"]["issue-type"];
        /** @description Title of the issue */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues milestoned event */
    "webhook-issues-milestoned": {
      /** @enum {string} */
      action: "milestoned";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: ({
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        } | null)[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "reminder"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      milestone: components["schemas"]["webhooks_milestone"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues opened event */
    "webhook-issues-opened": {
      /** @enum {string} */
      action: "opened";
      changes?: {
        /**
         * Issue
         * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
         */
        old_issue: {
          /** @enum {string|null} */
          active_lock_reason?:
            | "resolved"
            | "off-topic"
            | "too heated"
            | "spam"
            | null;
          /** User */
          assignee?: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          assignees?: ({
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null)[];
          /**
           * AuthorAssociation
           * @description How the author is associated with the repository.
           * @enum {string}
           */
          author_association?:
            | "COLLABORATOR"
            | "CONTRIBUTOR"
            | "FIRST_TIMER"
            | "FIRST_TIME_CONTRIBUTOR"
            | "MANNEQUIN"
            | "MEMBER"
            | "NONE"
            | "OWNER";
          /** @description Contents of the issue */
          body?: string | null;
          /** Format: date-time */
          closed_at?: string | null;
          comments?: number;
          /** Format: uri */
          comments_url?: string;
          /** Format: date-time */
          created_at?: string;
          draft?: boolean;
          /** Format: uri */
          events_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          labels?: {
            /** @description 6-character hex code, without the leading #, identifying the color */
            color: string;
            default: boolean;
            description: string | null;
            id: number;
            /** @description The name of the label. */
            name: string;
            node_id: string;
            /**
             * Format: uri
             * @description URL for the label
             */
            url: string;
          }[];
          /** Format: uri-template */
          labels_url?: string;
          locked?: boolean;
          /**
           * Milestone
           * @description A collection of related issues and pull requests.
           */
          milestone?: {
            /** Format: date-time */
            closed_at: string | null;
            closed_issues: number;
            /** Format: date-time */
            created_at: string;
            /** User */
            creator: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            description: string | null;
            /** Format: date-time */
            due_on: string | null;
            /** Format: uri */
            html_url: string;
            id: number;
            /** Format: uri */
            labels_url: string;
            node_id: string;
            /** @description The number of the milestone. */
            number: number;
            open_issues: number;
            /**
             * @description The state of the milestone.
             * @enum {string}
             */
            state: "open" | "closed";
            /** @description The title of the milestone. */
            title: string;
            /** Format: date-time */
            updated_at: string;
            /** Format: uri */
            url: string;
          } | null;
          node_id?: string;
          number: number;
          /**
           * App
           * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
           */
          performed_via_github_app?: {
            /** Format: date-time */
            created_at: string | null;
            description: string | null;
            /** @description The list of events for the GitHub app */
            events?: (
              | "branch_protection_rule"
              | "check_run"
              | "check_suite"
              | "code_scanning_alert"
              | "commit_comment"
              | "content_reference"
              | "create"
              | "delete"
              | "deployment"
              | "deployment_review"
              | "deployment_status"
              | "deploy_key"
              | "discussion"
              | "discussion_comment"
              | "fork"
              | "gollum"
              | "issues"
              | "issue_comment"
              | "label"
              | "member"
              | "membership"
              | "milestone"
              | "organization"
              | "org_block"
              | "page_build"
              | "project"
              | "project_card"
              | "project_column"
              | "public"
              | "pull_request"
              | "pull_request_review"
              | "pull_request_review_comment"
              | "push"
              | "registry_package"
              | "release"
              | "repository"
              | "repository_dispatch"
              | "secret_scanning_alert"
              | "star"
              | "status"
              | "team"
              | "team_add"
              | "watch"
              | "workflow_dispatch"
              | "workflow_run"
            )[];
            /** Format: uri */
            external_url: string | null;
            /** Format: uri */
            html_url: string;
            /** @description Unique identifier of the GitHub app */
            id: number | null;
            /** @description The name of the GitHub app */
            name: string;
            node_id: string;
            /** User */
            owner: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            /** @description The set of permissions for the GitHub app */
            permissions?: {
              /** @enum {string} */
              actions?: "read" | "write";
              /** @enum {string} */
              administration?: "read" | "write";
              /** @enum {string} */
              checks?: "read" | "write";
              /** @enum {string} */
              content_references?: "read" | "write";
              /** @enum {string} */
              contents?: "read" | "write";
              /** @enum {string} */
              deployments?: "read" | "write";
              /** @enum {string} */
              discussions?: "read" | "write";
              /** @enum {string} */
              emails?: "read" | "write";
              /** @enum {string} */
              environments?: "read" | "write";
              /** @enum {string} */
              issues?: "read" | "write";
              /** @enum {string} */
              keys?: "read" | "write";
              /** @enum {string} */
              members?: "read" | "write";
              /** @enum {string} */
              metadata?: "read" | "write";
              /** @enum {string} */
              organization_administration?: "read" | "write";
              /** @enum {string} */
              organization_hooks?: "read" | "write";
              /** @enum {string} */
              organization_packages?: "read" | "write";
              /** @enum {string} */
              organization_plan?: "read" | "write";
              /** @enum {string} */
              organization_projects?: "read" | "write";
              /** @enum {string} */
              organization_secrets?: "read" | "write";
              /** @enum {string} */
              organization_self_hosted_runners?: "read" | "write";
              /** @enum {string} */
              organization_user_blocking?: "read" | "write";
              /** @enum {string} */
              packages?: "read" | "write";
              /** @enum {string} */
              pages?: "read" | "write";
              /** @enum {string} */
              pull_requests?: "read" | "write";
              /** @enum {string} */
              repository_hooks?: "read" | "write";
              /** @enum {string} */
              repository_projects?: "read" | "write";
              /** @enum {string} */
              secret_scanning_alerts?: "read" | "write";
              /** @enum {string} */
              secrets?: "read" | "write";
              /** @enum {string} */
              security_events?: "read" | "write";
              /** @enum {string} */
              security_scanning_alert?: "read" | "write";
              /** @enum {string} */
              single_file?: "read" | "write";
              /** @enum {string} */
              statuses?: "read" | "write";
              /** @enum {string} */
              team_discussions?: "read" | "write";
              /** @enum {string} */
              vulnerability_alerts?: "read" | "write";
              /** @enum {string} */
              workflows?: "read" | "write";
            };
            /** @description The slug name of the GitHub app */
            slug?: string;
            /** Format: date-time */
            updated_at: string | null;
          } | null;
          pull_request?: {
            /** Format: uri */
            diff_url?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: date-time */
            merged_at?: string | null;
            /** Format: uri */
            patch_url?: string;
            /** Format: uri */
            url?: string;
          };
          /** Reactions */
          reactions?: {
            "+1": number;
            "-1": number;
            confused: number;
            eyes: number;
            heart: number;
            hooray: number;
            laugh: number;
            rocket: number;
            total_count: number;
            /** Format: uri */
            url: string;
          };
          /** Format: uri */
          repository_url?: string;
          /** Sub-issues Summary */
          sub_issues_summary?: {
            total: number;
            completed: number;
            percent_completed: number;
          };
          /**
           * @description State of the issue; either 'open' or 'closed'
           * @enum {string}
           */
          state?: "open" | "closed";
          state_reason?: string | null;
          /** Format: uri */
          timeline_url?: string;
          /** @description Title of the issue */
          title?: string;
          /** Format: date-time */
          updated_at?: string;
          /**
           * Format: uri
           * @description URL for the issue
           */
          url?: string;
          /** User */
          user?: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: int64 */
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          type?: components["schemas"]["issue-type"];
        } | null;
        /**
         * Repository
         * @description A git repository
         */
        old_repository: {
          /**
           * @description Whether to allow auto-merge for pull requests.
           * @default false
           */
          allow_auto_merge?: boolean;
          /** @description Whether to allow private forks */
          allow_forking?: boolean;
          /**
           * @description Whether to allow merge commits for pull requests.
           * @default true
           */
          allow_merge_commit?: boolean;
          /**
           * @description Whether to allow rebase merges for pull requests.
           * @default true
           */
          allow_rebase_merge?: boolean;
          /**
           * @description Whether to allow squash merges for pull requests.
           * @default true
           */
          allow_squash_merge?: boolean;
          allow_update_branch?: boolean;
          /** Format: uri-template */
          archive_url: string;
          /**
           * @description Whether the repository is archived.
           * @default false
           */
          archived: boolean;
          /** Format: uri-template */
          assignees_url: string;
          /** Format: uri-template */
          blobs_url: string;
          /** Format: uri-template */
          branches_url: string;
          /** Format: uri */
          clone_url: string;
          /** Format: uri-template */
          collaborators_url: string;
          /** Format: uri-template */
          comments_url: string;
          /** Format: uri-template */
          commits_url: string;
          /** Format: uri-template */
          compare_url: string;
          /** Format: uri-template */
          contents_url: string;
          /** Format: uri */
          contributors_url: string;
          created_at: number | string;
          /** @description The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values. */
          custom_properties?: {
            [key: string]: unknown;
          };
          /** @description The default branch of the repository. */
          default_branch: string;
          /**
           * @description Whether to delete head branches when pull requests are merged
           * @default false
           */
          delete_branch_on_merge?: boolean;
          /** Format: uri */
          deployments_url: string;
          description: string | null;
          /** @description Returns whether or not this repository is disabled. */
          disabled?: boolean;
          /** Format: uri */
          downloads_url: string;
          /** Format: uri */
          events_url: string;
          fork: boolean;
          forks: number;
          forks_count: number;
          /** Format: uri */
          forks_url: string;
          full_name: string;
          /** Format: uri-template */
          git_commits_url: string;
          /** Format: uri-template */
          git_refs_url: string;
          /** Format: uri-template */
          git_tags_url: string;
          /** Format: uri */
          git_url: string;
          /** @description Whether the repository has discussions enabled. */
          has_discussions?: boolean;
          /**
           * @description Whether downloads are enabled.
           * @default true
           */
          has_downloads: boolean;
          /**
           * @description Whether issues are enabled.
           * @default true
           */
          has_issues: boolean;
          has_pages: boolean;
          /**
           * @description Whether projects are enabled.
           * @default true
           */
          has_projects: boolean;
          /**
           * @description Whether the wiki is enabled.
           * @default true
           */
          has_wiki: boolean;
          homepage: string | null;
          /** Format: uri */
          hooks_url: string;
          /** Format: uri */
          html_url: string;
          /**
           * Format: int64
           * @description Unique identifier of the repository
           */
          id: number;
          is_template?: boolean;
          /** Format: uri-template */
          issue_comment_url: string;
          /** Format: uri-template */
          issue_events_url: string;
          /** Format: uri-template */
          issues_url: string;
          /** Format: uri-template */
          keys_url: string;
          /** Format: uri-template */
          labels_url: string;
          language: string | null;
          /** Format: uri */
          languages_url: string;
          /** License */
          license: {
            key: string;
            name: string;
            node_id: string;
            spdx_id: string;
            /** Format: uri */
            url: string | null;
          } | null;
          master_branch?: string;
          /** Format: uri */
          merges_url: string;
          /** Format: uri-template */
          milestones_url: string;
          /** Format: uri */
          mirror_url: string | null;
          /** @description The name of the repository. */
          name: string;
          node_id: string;
          /** Format: uri-template */
          notifications_url: string;
          open_issues: number;
          open_issues_count: number;
          organization?: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            pull: boolean;
            push: boolean;
            triage?: boolean;
          };
          /** @description Whether the repository is private or public. */
          private: boolean;
          public?: boolean;
          /** Format: uri-template */
          pulls_url: string;
          pushed_at: number | string | null;
          /** Format: uri-template */
          releases_url: string;
          role_name?: string | null;
          size: number;
          ssh_url: string;
          stargazers?: number;
          stargazers_count: number;
          /** Format: uri */
          stargazers_url: string;
          /** Format: uri-template */
          statuses_url: string;
          /** Format: uri */
          subscribers_url: string;
          /** Format: uri */
          subscription_url: string;
          /** Format: uri */
          svn_url: string;
          /** Format: uri */
          tags_url: string;
          /** Format: uri */
          teams_url: string;
          topics: string[];
          /** Format: uri-template */
          trees_url: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
          /** @enum {string} */
          visibility: "public" | "private" | "internal";
          watchers: number;
          watchers_count: number;
          /** @description Whether to require commit signoff. */
          web_commit_signoff_required?: boolean;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "security_and_analysis"
            | "pull_request_review_thread"
            | "reminder"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues pinned event */
    "webhook-issues-pinned": {
      /** @enum {string} */
      action: "pinned";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue_2"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Issue
     * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
     */
    webhooks_issue_2: {
      /** @enum {string|null} */
      active_lock_reason:
        | "resolved"
        | "off-topic"
        | "too heated"
        | "spam"
        | null;
      /** User */
      assignee?: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      assignees: ({
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null)[];
      /**
       * AuthorAssociation
       * @description How the author is associated with the repository.
       * @enum {string}
       */
      author_association:
        | "COLLABORATOR"
        | "CONTRIBUTOR"
        | "FIRST_TIMER"
        | "FIRST_TIME_CONTRIBUTOR"
        | "MANNEQUIN"
        | "MEMBER"
        | "NONE"
        | "OWNER";
      /** @description Contents of the issue */
      body: string | null;
      /** Format: date-time */
      closed_at: string | null;
      comments: number;
      /** Format: uri */
      comments_url: string;
      /** Format: date-time */
      created_at: string;
      draft?: boolean;
      /** Format: uri */
      events_url: string;
      /** Format: uri */
      html_url: string;
      /** Format: int64 */
      id: number;
      labels?: {
        /** @description 6-character hex code, without the leading #, identifying the color */
        color: string;
        default: boolean;
        description: string | null;
        id: number;
        /** @description The name of the label. */
        name: string;
        node_id: string;
        /**
         * Format: uri
         * @description URL for the label
         */
        url: string;
      }[];
      /** Format: uri-template */
      labels_url: string;
      locked?: boolean;
      /**
       * Milestone
       * @description A collection of related issues and pull requests.
       */
      milestone: {
        /** Format: date-time */
        closed_at: string | null;
        closed_issues: number;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        description: string | null;
        /** Format: date-time */
        due_on: string | null;
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        labels_url: string;
        node_id: string;
        /** @description The number of the milestone. */
        number: number;
        open_issues: number;
        /**
         * @description The state of the milestone.
         * @enum {string}
         */
        state: "open" | "closed";
        /** @description The title of the milestone. */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      } | null;
      node_id: string;
      number: number;
      /**
       * App
       * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
       */
      performed_via_github_app?: {
        /** Format: date-time */
        created_at: string | null;
        description: string | null;
        /** @description The list of events for the GitHub app */
        events?: (
          | "branch_protection_rule"
          | "check_run"
          | "check_suite"
          | "code_scanning_alert"
          | "commit_comment"
          | "content_reference"
          | "create"
          | "delete"
          | "deployment"
          | "deployment_review"
          | "deployment_status"
          | "deploy_key"
          | "discussion"
          | "discussion_comment"
          | "fork"
          | "gollum"
          | "issues"
          | "issue_comment"
          | "label"
          | "member"
          | "membership"
          | "milestone"
          | "organization"
          | "org_block"
          | "page_build"
          | "project"
          | "project_card"
          | "project_column"
          | "public"
          | "pull_request"
          | "pull_request_review"
          | "pull_request_review_comment"
          | "push"
          | "registry_package"
          | "release"
          | "repository"
          | "repository_dispatch"
          | "secret_scanning_alert"
          | "star"
          | "status"
          | "team"
          | "team_add"
          | "watch"
          | "workflow_dispatch"
          | "workflow_run"
        )[];
        /** Format: uri */
        external_url: string | null;
        /** Format: uri */
        html_url: string;
        /** @description Unique identifier of the GitHub app */
        id: number | null;
        /** @description The name of the GitHub app */
        name: string;
        node_id: string;
        /** User */
        owner: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** @description The set of permissions for the GitHub app */
        permissions?: {
          /** @enum {string} */
          actions?: "read" | "write";
          /** @enum {string} */
          administration?: "read" | "write";
          /** @enum {string} */
          checks?: "read" | "write";
          /** @enum {string} */
          content_references?: "read" | "write";
          /** @enum {string} */
          contents?: "read" | "write";
          /** @enum {string} */
          deployments?: "read" | "write";
          /** @enum {string} */
          discussions?: "read" | "write";
          /** @enum {string} */
          emails?: "read" | "write";
          /** @enum {string} */
          environments?: "read" | "write";
          /** @enum {string} */
          issues?: "read" | "write";
          /** @enum {string} */
          keys?: "read" | "write";
          /** @enum {string} */
          members?: "read" | "write";
          /** @enum {string} */
          metadata?: "read" | "write";
          /** @enum {string} */
          organization_administration?: "read" | "write";
          /** @enum {string} */
          organization_hooks?: "read" | "write";
          /** @enum {string} */
          organization_packages?: "read" | "write";
          /** @enum {string} */
          organization_plan?: "read" | "write";
          /** @enum {string} */
          organization_projects?: "read" | "write";
          /** @enum {string} */
          organization_secrets?: "read" | "write";
          /** @enum {string} */
          organization_self_hosted_runners?: "read" | "write";
          /** @enum {string} */
          organization_user_blocking?: "read" | "write";
          /** @enum {string} */
          packages?: "read" | "write";
          /** @enum {string} */
          pages?: "read" | "write";
          /** @enum {string} */
          pull_requests?: "read" | "write";
          /** @enum {string} */
          repository_hooks?: "read" | "write";
          /** @enum {string} */
          repository_projects?: "read" | "write";
          /** @enum {string} */
          secret_scanning_alerts?: "read" | "write";
          /** @enum {string} */
          secrets?: "read" | "write";
          /** @enum {string} */
          security_events?: "read" | "write";
          /** @enum {string} */
          security_scanning_alert?: "read" | "write";
          /** @enum {string} */
          single_file?: "read" | "write";
          /** @enum {string} */
          statuses?: "read" | "write";
          /** @enum {string} */
          team_discussions?: "read" | "write";
          /** @enum {string} */
          vulnerability_alerts?: "read" | "write";
          /** @enum {string} */
          workflows?: "read" | "write";
        };
        /** @description The slug name of the GitHub app */
        slug?: string;
        /** Format: date-time */
        updated_at: string | null;
      } | null;
      pull_request?: {
        /** Format: uri */
        diff_url?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: date-time */
        merged_at?: string | null;
        /** Format: uri */
        patch_url?: string;
        /** Format: uri */
        url?: string;
      };
      /** Reactions */
      reactions: {
        "+1": number;
        "-1": number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        /** Format: uri */
        url: string;
      };
      /** Format: uri */
      repository_url: string;
      /** Sub-issues Summary */
      sub_issues_summary?: {
        total: number;
        completed: number;
        percent_completed: number;
      };
      /**
       * @description State of the issue; either 'open' or 'closed'
       * @enum {string}
       */
      state?: "open" | "closed";
      state_reason?: string | null;
      /** Format: uri */
      timeline_url?: string;
      /** @description Title of the issue */
      title: string;
      type?: components["schemas"]["issue-type"];
      /** Format: date-time */
      updated_at: string;
      /**
       * Format: uri
       * @description URL for the issue
       */
      url: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
    };
    /** issues reopened event */
    "webhook-issues-reopened": {
      /** @enum {string} */
      action: "reopened";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: ({
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        } | null)[];
        /** Format: uri-template */
        labels_url: string;
        locked?: boolean;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
            | "pull_request_review_thread"
            | "reminder"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write" | "admin";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        type?: components["schemas"]["issue-type"];
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues transferred event */
    "webhook-issues-transferred": {
      /** @enum {string} */
      action: "transferred";
      changes: {
        /**
         * Issue
         * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
         */
        new_issue: {
          /** @enum {string|null} */
          active_lock_reason:
            | "resolved"
            | "off-topic"
            | "too heated"
            | "spam"
            | null;
          /** User */
          assignee?: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          assignees: ({
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null)[];
          /**
           * AuthorAssociation
           * @description How the author is associated with the repository.
           * @enum {string}
           */
          author_association:
            | "COLLABORATOR"
            | "CONTRIBUTOR"
            | "FIRST_TIMER"
            | "FIRST_TIME_CONTRIBUTOR"
            | "MANNEQUIN"
            | "MEMBER"
            | "NONE"
            | "OWNER";
          /** @description Contents of the issue */
          body: string | null;
          /** Format: date-time */
          closed_at: string | null;
          comments: number;
          /** Format: uri */
          comments_url: string;
          /** Format: date-time */
          created_at: string;
          draft?: boolean;
          /** Format: uri */
          events_url: string;
          /** Format: uri */
          html_url: string;
          /** Format: int64 */
          id: number;
          labels?: {
            /** @description 6-character hex code, without the leading #, identifying the color */
            color: string;
            default: boolean;
            description: string | null;
            id: number;
            /** @description The name of the label. */
            name: string;
            node_id: string;
            /**
             * Format: uri
             * @description URL for the label
             */
            url: string;
          }[];
          /** Format: uri-template */
          labels_url: string;
          locked?: boolean;
          /**
           * Milestone
           * @description A collection of related issues and pull requests.
           */
          milestone: {
            /** Format: date-time */
            closed_at: string | null;
            closed_issues: number;
            /** Format: date-time */
            created_at: string;
            /** User */
            creator: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            description: string | null;
            /** Format: date-time */
            due_on: string | null;
            /** Format: uri */
            html_url: string;
            id: number;
            /** Format: uri */
            labels_url: string;
            node_id: string;
            /** @description The number of the milestone. */
            number: number;
            open_issues: number;
            /**
             * @description The state of the milestone.
             * @enum {string}
             */
            state: "open" | "closed";
            /** @description The title of the milestone. */
            title: string;
            /** Format: date-time */
            updated_at: string;
            /** Format: uri */
            url: string;
          } | null;
          node_id: string;
          number: number;
          /**
           * App
           * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
           */
          performed_via_github_app?: {
            /** Format: date-time */
            created_at: string | null;
            description: string | null;
            /** @description The list of events for the GitHub app */
            events?: (
              | "branch_protection_rule"
              | "check_run"
              | "check_suite"
              | "code_scanning_alert"
              | "commit_comment"
              | "content_reference"
              | "create"
              | "delete"
              | "deployment"
              | "deployment_review"
              | "deployment_status"
              | "deploy_key"
              | "discussion"
              | "discussion_comment"
              | "fork"
              | "gollum"
              | "issues"
              | "issue_comment"
              | "label"
              | "member"
              | "membership"
              | "milestone"
              | "organization"
              | "org_block"
              | "page_build"
              | "project"
              | "project_card"
              | "project_column"
              | "public"
              | "pull_request"
              | "pull_request_review"
              | "pull_request_review_comment"
              | "push"
              | "registry_package"
              | "release"
              | "repository"
              | "repository_dispatch"
              | "secret_scanning_alert"
              | "star"
              | "status"
              | "team"
              | "team_add"
              | "watch"
              | "workflow_dispatch"
              | "workflow_run"
            )[];
            /** Format: uri */
            external_url: string | null;
            /** Format: uri */
            html_url: string;
            /** @description Unique identifier of the GitHub app */
            id: number | null;
            /** @description The name of the GitHub app */
            name: string;
            node_id: string;
            /** User */
            owner: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            /** @description The set of permissions for the GitHub app */
            permissions?: {
              /** @enum {string} */
              actions?: "read" | "write";
              /** @enum {string} */
              administration?: "read" | "write";
              /** @enum {string} */
              checks?: "read" | "write";
              /** @enum {string} */
              content_references?: "read" | "write";
              /** @enum {string} */
              contents?: "read" | "write";
              /** @enum {string} */
              deployments?: "read" | "write";
              /** @enum {string} */
              discussions?: "read" | "write";
              /** @enum {string} */
              emails?: "read" | "write";
              /** @enum {string} */
              environments?: "read" | "write";
              /** @enum {string} */
              issues?: "read" | "write";
              /** @enum {string} */
              keys?: "read" | "write";
              /** @enum {string} */
              members?: "read" | "write";
              /** @enum {string} */
              metadata?: "read" | "write";
              /** @enum {string} */
              organization_administration?: "read" | "write";
              /** @enum {string} */
              organization_hooks?: "read" | "write";
              /** @enum {string} */
              organization_packages?: "read" | "write";
              /** @enum {string} */
              organization_plan?: "read" | "write";
              /** @enum {string} */
              organization_projects?: "read" | "write";
              /** @enum {string} */
              organization_secrets?: "read" | "write";
              /** @enum {string} */
              organization_self_hosted_runners?: "read" | "write";
              /** @enum {string} */
              organization_user_blocking?: "read" | "write";
              /** @enum {string} */
              packages?: "read" | "write";
              /** @enum {string} */
              pages?: "read" | "write";
              /** @enum {string} */
              pull_requests?: "read" | "write";
              /** @enum {string} */
              repository_hooks?: "read" | "write";
              /** @enum {string} */
              repository_projects?: "read" | "write";
              /** @enum {string} */
              secret_scanning_alerts?: "read" | "write";
              /** @enum {string} */
              secrets?: "read" | "write";
              /** @enum {string} */
              security_events?: "read" | "write";
              /** @enum {string} */
              security_scanning_alert?: "read" | "write";
              /** @enum {string} */
              single_file?: "read" | "write";
              /** @enum {string} */
              statuses?: "read" | "write";
              /** @enum {string} */
              team_discussions?: "read" | "write";
              /** @enum {string} */
              vulnerability_alerts?: "read" | "write";
              /** @enum {string} */
              workflows?: "read" | "write";
            };
            /** @description The slug name of the GitHub app */
            slug?: string;
            /** Format: date-time */
            updated_at: string | null;
          } | null;
          pull_request?: {
            /** Format: uri */
            diff_url?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: date-time */
            merged_at?: string | null;
            /** Format: uri */
            patch_url?: string;
            /** Format: uri */
            url?: string;
          };
          /** Reactions */
          reactions: {
            "+1": number;
            "-1": number;
            confused: number;
            eyes: number;
            heart: number;
            hooray: number;
            laugh: number;
            rocket: number;
            total_count: number;
            /** Format: uri */
            url: string;
          };
          /** Format: uri */
          repository_url: string;
          /** Sub-issues Summary */
          sub_issues_summary?: {
            total: number;
            completed: number;
            percent_completed: number;
          };
          /**
           * @description State of the issue; either 'open' or 'closed'
           * @enum {string}
           */
          state?: "open" | "closed";
          state_reason?: string | null;
          /** Format: uri */
          timeline_url?: string;
          /** @description Title of the issue */
          title: string;
          type?: components["schemas"]["issue-type"];
          /** Format: date-time */
          updated_at: string;
          /**
           * Format: uri
           * @description URL for the issue
           */
          url: string;
          /** User */
          user: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: int64 */
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
        };
        /**
         * Repository
         * @description A git repository
         */
        new_repository: {
          /**
           * @description Whether to allow auto-merge for pull requests.
           * @default false
           */
          allow_auto_merge?: boolean;
          /** @description Whether to allow private forks */
          allow_forking?: boolean;
          /**
           * @description Whether to allow merge commits for pull requests.
           * @default true
           */
          allow_merge_commit?: boolean;
          /**
           * @description Whether to allow rebase merges for pull requests.
           * @default true
           */
          allow_rebase_merge?: boolean;
          /**
           * @description Whether to allow squash merges for pull requests.
           * @default true
           */
          allow_squash_merge?: boolean;
          allow_update_branch?: boolean;
          /** Format: uri-template */
          archive_url: string;
          /**
           * @description Whether the repository is archived.
           * @default false
           */
          archived: boolean;
          /** Format: uri-template */
          assignees_url: string;
          /** Format: uri-template */
          blobs_url: string;
          /** Format: uri-template */
          branches_url: string;
          /** Format: uri */
          clone_url: string;
          /** Format: uri-template */
          collaborators_url: string;
          /** Format: uri-template */
          comments_url: string;
          /** Format: uri-template */
          commits_url: string;
          /** Format: uri-template */
          compare_url: string;
          /** Format: uri-template */
          contents_url: string;
          /** Format: uri */
          contributors_url: string;
          created_at: number | string;
          /** @description The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values. */
          custom_properties?: {
            [key: string]: unknown;
          };
          /** @description The default branch of the repository. */
          default_branch: string;
          /**
           * @description Whether to delete head branches when pull requests are merged
           * @default false
           */
          delete_branch_on_merge?: boolean;
          /** Format: uri */
          deployments_url: string;
          description: string | null;
          /** @description Returns whether or not this repository is disabled. */
          disabled?: boolean;
          /** Format: uri */
          downloads_url: string;
          /** Format: uri */
          events_url: string;
          fork: boolean;
          forks: number;
          forks_count: number;
          /** Format: uri */
          forks_url: string;
          full_name: string;
          /** Format: uri-template */
          git_commits_url: string;
          /** Format: uri-template */
          git_refs_url: string;
          /** Format: uri-template */
          git_tags_url: string;
          /** Format: uri */
          git_url: string;
          /**
           * @description Whether downloads are enabled.
           * @default true
           */
          has_downloads: boolean;
          /**
           * @description Whether issues are enabled.
           * @default true
           */
          has_issues: boolean;
          has_pages: boolean;
          /**
           * @description Whether projects are enabled.
           * @default true
           */
          has_projects: boolean;
          /**
           * @description Whether the wiki is enabled.
           * @default true
           */
          has_wiki: boolean;
          /**
           * @description Whether discussions are enabled.
           * @default false
           */
          has_discussions: boolean;
          homepage: string | null;
          /** Format: uri */
          hooks_url: string;
          /** Format: uri */
          html_url: string;
          /**
           * Format: int64
           * @description Unique identifier of the repository
           */
          id: number;
          is_template?: boolean;
          /** Format: uri-template */
          issue_comment_url: string;
          /** Format: uri-template */
          issue_events_url: string;
          /** Format: uri-template */
          issues_url: string;
          /** Format: uri-template */
          keys_url: string;
          /** Format: uri-template */
          labels_url: string;
          language: string | null;
          /** Format: uri */
          languages_url: string;
          /** License */
          license: {
            key: string;
            name: string;
            node_id: string;
            spdx_id: string;
            /** Format: uri */
            url: string | null;
          } | null;
          master_branch?: string;
          /** Format: uri */
          merges_url: string;
          /** Format: uri-template */
          milestones_url: string;
          /** Format: uri */
          mirror_url: string | null;
          /** @description The name of the repository. */
          name: string;
          node_id: string;
          /** Format: uri-template */
          notifications_url: string;
          open_issues: number;
          open_issues_count: number;
          organization?: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            pull: boolean;
            push: boolean;
            triage?: boolean;
          };
          /** @description Whether the repository is private or public. */
          private: boolean;
          public?: boolean;
          /** Format: uri-template */
          pulls_url: string;
          pushed_at: number | string | null;
          /** Format: uri-template */
          releases_url: string;
          role_name?: string | null;
          size: number;
          ssh_url: string;
          stargazers?: number;
          stargazers_count: number;
          /** Format: uri */
          stargazers_url: string;
          /** Format: uri-template */
          statuses_url: string;
          /** Format: uri */
          subscribers_url: string;
          /** Format: uri */
          subscription_url: string;
          /** Format: uri */
          svn_url: string;
          /** Format: uri */
          tags_url: string;
          /** Format: uri */
          teams_url: string;
          topics: string[];
          /** Format: uri-template */
          trees_url: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
          /** @enum {string} */
          visibility: "public" | "private" | "internal";
          watchers: number;
          watchers_count: number;
          /** @description Whether to require contributors to sign off on web-based commits */
          web_commit_signoff_required?: boolean;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue_2"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues typed event */
    "webhook-issues-typed": {
      /** @enum {string} */
      action: "typed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue"];
      type: components["schemas"]["issue-type"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues unassigned event */
    "webhook-issues-unassigned": {
      /**
       * @description The action that was performed.
       * @enum {string}
       */
      action: "unassigned";
      assignee?: components["schemas"]["webhooks_user_mannequin"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** User */
    webhooks_user_mannequin: {
      /** Format: uri */
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      /** Format: uri-template */
      events_url?: string;
      /** Format: uri */
      followers_url?: string;
      /** Format: uri-template */
      following_url?: string;
      /** Format: uri-template */
      gists_url?: string;
      gravatar_id?: string;
      /** Format: uri */
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      /** Format: uri */
      organizations_url?: string;
      /** Format: uri */
      received_events_url?: string;
      /** Format: uri */
      repos_url?: string;
      site_admin?: boolean;
      /** Format: uri-template */
      starred_url?: string;
      /** Format: uri */
      subscriptions_url?: string;
      /** @enum {string} */
      type?: "Bot" | "User" | "Organization" | "Mannequin";
      /** Format: uri */
      url?: string;
      user_view_type?: string;
    } | null;
    /** issues unlabeled event */
    "webhook-issues-unlabeled": {
      /** @enum {string} */
      action: "unlabeled";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue"];
      label?: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues unlocked event */
    "webhook-issues-unlocked": {
      /** @enum {string} */
      action: "unlocked";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Issue
       * @description The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
       */
      issue: {
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        /** User */
        assignee?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /** @description Contents of the issue */
        body: string | null;
        /** Format: date-time */
        closed_at: string | null;
        comments: number;
        /** Format: uri */
        comments_url: string;
        /** Format: date-time */
        created_at: string;
        draft?: boolean;
        /** Format: uri */
        events_url: string;
        /** Format: uri */
        html_url: string;
        /** Format: int64 */
        id: number;
        labels?: ({
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        } | null)[];
        /** Format: uri-template */
        labels_url: string;
        /** @enum {boolean} */
        locked: false;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        number: number;
        /**
         * App
         * @description GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
         */
        performed_via_github_app?: {
          /** Format: date-time */
          created_at: string | null;
          description: string | null;
          /** @description The list of events for the GitHub app */
          events?: (
            | "branch_protection_rule"
            | "check_run"
            | "check_suite"
            | "code_scanning_alert"
            | "commit_comment"
            | "content_reference"
            | "create"
            | "delete"
            | "deployment"
            | "deployment_review"
            | "deployment_status"
            | "deploy_key"
            | "discussion"
            | "discussion_comment"
            | "fork"
            | "gollum"
            | "issues"
            | "issue_comment"
            | "label"
            | "member"
            | "membership"
            | "milestone"
            | "organization"
            | "org_block"
            | "page_build"
            | "project"
            | "project_card"
            | "project_column"
            | "public"
            | "pull_request"
            | "pull_request_review"
            | "pull_request_review_comment"
            | "push"
            | "registry_package"
            | "release"
            | "repository"
            | "repository_dispatch"
            | "secret_scanning_alert"
            | "star"
            | "status"
            | "team"
            | "team_add"
            | "watch"
            | "workflow_dispatch"
            | "workflow_run"
          )[];
          /** Format: uri */
          external_url: string | null;
          /** Format: uri */
          html_url: string;
          /** @description Unique identifier of the GitHub app */
          id: number | null;
          /** @description The name of the GitHub app */
          name: string;
          node_id: string;
          /** User */
          owner: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /** @description The set of permissions for the GitHub app */
          permissions?: {
            /** @enum {string} */
            actions?: "read" | "write";
            /** @enum {string} */
            administration?: "read" | "write";
            /** @enum {string} */
            checks?: "read" | "write";
            /** @enum {string} */
            content_references?: "read" | "write";
            /** @enum {string} */
            contents?: "read" | "write";
            /** @enum {string} */
            deployments?: "read" | "write";
            /** @enum {string} */
            discussions?: "read" | "write";
            /** @enum {string} */
            emails?: "read" | "write";
            /** @enum {string} */
            environments?: "read" | "write";
            /** @enum {string} */
            issues?: "read" | "write";
            /** @enum {string} */
            keys?: "read" | "write";
            /** @enum {string} */
            members?: "read" | "write";
            /** @enum {string} */
            metadata?: "read" | "write";
            /** @enum {string} */
            organization_administration?: "read" | "write";
            /** @enum {string} */
            organization_hooks?: "read" | "write";
            /** @enum {string} */
            organization_packages?: "read" | "write";
            /** @enum {string} */
            organization_plan?: "read" | "write";
            /** @enum {string} */
            organization_projects?: "read" | "write";
            /** @enum {string} */
            organization_secrets?: "read" | "write";
            /** @enum {string} */
            organization_self_hosted_runners?: "read" | "write";
            /** @enum {string} */
            organization_user_blocking?: "read" | "write";
            /** @enum {string} */
            packages?: "read" | "write";
            /** @enum {string} */
            pages?: "read" | "write";
            /** @enum {string} */
            pull_requests?: "read" | "write";
            /** @enum {string} */
            repository_hooks?: "read" | "write";
            /** @enum {string} */
            repository_projects?: "read" | "write";
            /** @enum {string} */
            secret_scanning_alerts?: "read" | "write";
            /** @enum {string} */
            secrets?: "read" | "write";
            /** @enum {string} */
            security_events?: "read" | "write";
            /** @enum {string} */
            security_scanning_alert?: "read" | "write";
            /** @enum {string} */
            single_file?: "read" | "write";
            /** @enum {string} */
            statuses?: "read" | "write";
            /** @enum {string} */
            team_discussions?: "read" | "write";
            /** @enum {string} */
            vulnerability_alerts?: "read" | "write";
            /** @enum {string} */
            workflows?: "read" | "write";
          };
          /** @description The slug name of the GitHub app */
          slug?: string;
          /** Format: date-time */
          updated_at: string | null;
        } | null;
        pull_request?: {
          /** Format: uri */
          diff_url?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: date-time */
          merged_at?: string | null;
          /** Format: uri */
          patch_url?: string;
          /** Format: uri */
          url?: string;
        };
        /** Reactions */
        reactions: {
          "+1": number;
          "-1": number;
          confused: number;
          eyes: number;
          heart: number;
          hooray: number;
          laugh: number;
          rocket: number;
          total_count: number;
          /** Format: uri */
          url: string;
        };
        /** Format: uri */
        repository_url: string;
        /** Sub-issues Summary */
        sub_issues_summary?: {
          total: number;
          completed: number;
          percent_completed: number;
        };
        /**
         * @description State of the issue; either 'open' or 'closed'
         * @enum {string}
         */
        state?: "open" | "closed";
        state_reason?: string | null;
        /** Format: uri */
        timeline_url?: string;
        /** @description Title of the issue */
        title: string;
        type?: components["schemas"]["issue-type"];
        /** Format: date-time */
        updated_at: string;
        /**
         * Format: uri
         * @description URL for the issue
         */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues unpinned event */
    "webhook-issues-unpinned": {
      /** @enum {string} */
      action: "unpinned";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue_2"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** issues untyped event */
    "webhook-issues-untyped": {
      /** @enum {string} */
      action: "untyped";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      issue: components["schemas"]["webhooks_issue"];
      type: components["schemas"]["issue-type"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** label created event */
    "webhook-label-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      label: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** label deleted event */
    "webhook-label-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      label: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** label edited event */
    "webhook-label-edited": {
      /** @enum {string} */
      action: "edited";
      /** @description The changes to the label if the action was `edited`. */
      changes?: {
        color?: {
          /** @description The previous version of the color if the action was `edited`. */
          from: string;
        };
        description?: {
          /** @description The previous version of the description if the action was `edited`. */
          from: string;
        };
        name?: {
          /** @description The previous version of the name if the action was `edited`. */
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      label: components["schemas"]["webhooks_label"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** marketplace_purchase cancelled event */
    "webhook-marketplace-purchase-cancelled": {
      /** @enum {string} */
      action: "cancelled";
      effective_date: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      marketplace_purchase: components["schemas"]["webhooks_marketplace_purchase"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      previous_marketplace_purchase?: components["schemas"]["webhooks_previous_marketplace_purchase"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Marketplace Purchase */
    webhooks_marketplace_purchase: {
      account: {
        id: number;
        login: string;
        node_id: string;
        organization_billing_email: string | null;
        type: string;
      };
      billing_cycle: string;
      free_trial_ends_on: string | null;
      next_billing_date: string | null;
      on_free_trial: boolean;
      plan: {
        bullets: (string | null)[];
        description: string;
        has_free_trial: boolean;
        id: number;
        monthly_price_in_cents: number;
        name: string;
        /** @enum {string} */
        price_model: "FREE" | "FLAT_RATE" | "PER_UNIT";
        unit_name: string | null;
        yearly_price_in_cents: number;
      };
      unit_count: number;
    };
    /** Marketplace Purchase */
    webhooks_previous_marketplace_purchase: {
      account: {
        id: number;
        login: string;
        node_id: string;
        organization_billing_email: string | null;
        type: string;
      };
      billing_cycle: string;
      free_trial_ends_on: null;
      next_billing_date?: string | null;
      on_free_trial: boolean;
      plan: {
        bullets: string[];
        description: string;
        has_free_trial: boolean;
        id: number;
        monthly_price_in_cents: number;
        name: string;
        /** @enum {string} */
        price_model: "FREE" | "FLAT_RATE" | "PER_UNIT";
        unit_name: string | null;
        yearly_price_in_cents: number;
      };
      unit_count: number;
    };
    /** marketplace_purchase changed event */
    "webhook-marketplace-purchase-changed": {
      /** @enum {string} */
      action: "changed";
      effective_date: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      marketplace_purchase: components["schemas"]["webhooks_marketplace_purchase"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** Marketplace Purchase */
      previous_marketplace_purchase?: {
        account: {
          id: number;
          login: string;
          node_id: string;
          organization_billing_email: string | null;
          type: string;
        };
        billing_cycle: string;
        free_trial_ends_on: string | null;
        next_billing_date?: string | null;
        on_free_trial: boolean | null;
        plan: {
          bullets: string[];
          description: string;
          has_free_trial: boolean;
          id: number;
          monthly_price_in_cents: number;
          name: string;
          /** @enum {string} */
          price_model: "FREE" | "FLAT_RATE" | "PER_UNIT";
          unit_name: string | null;
          yearly_price_in_cents: number;
        };
        unit_count: number;
      };
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** marketplace_purchase pending_change event */
    "webhook-marketplace-purchase-pending-change": {
      /** @enum {string} */
      action: "pending_change";
      effective_date: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      marketplace_purchase: components["schemas"]["webhooks_marketplace_purchase"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** Marketplace Purchase */
      previous_marketplace_purchase?: {
        account: {
          id: number;
          login: string;
          node_id: string;
          organization_billing_email: string | null;
          type: string;
        };
        billing_cycle: string;
        free_trial_ends_on: string | null;
        next_billing_date?: string | null;
        on_free_trial: boolean;
        plan: {
          bullets: string[];
          description: string;
          has_free_trial: boolean;
          id: number;
          monthly_price_in_cents: number;
          name: string;
          /** @enum {string} */
          price_model: "FREE" | "FLAT_RATE" | "PER_UNIT";
          unit_name: string | null;
          yearly_price_in_cents: number;
        };
        unit_count: number;
      };
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** marketplace_purchase pending_change_cancelled event */
    "webhook-marketplace-purchase-pending-change-cancelled": {
      /** @enum {string} */
      action: "pending_change_cancelled";
      effective_date: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** Marketplace Purchase */
      marketplace_purchase: {
        account: {
          id: number;
          login: string;
          node_id: string;
          organization_billing_email: string | null;
          type: string;
        };
        billing_cycle: string;
        free_trial_ends_on: null;
        next_billing_date: string | null;
        on_free_trial: boolean;
        plan: {
          bullets: string[];
          description: string;
          has_free_trial: boolean;
          id: number;
          monthly_price_in_cents: number;
          name: string;
          /** @enum {string} */
          price_model: "FREE" | "FLAT_RATE" | "PER_UNIT";
          unit_name: string | null;
          yearly_price_in_cents: number;
        };
        unit_count: number;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      previous_marketplace_purchase?: components["schemas"]["webhooks_previous_marketplace_purchase"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** marketplace_purchase purchased event */
    "webhook-marketplace-purchase-purchased": {
      /** @enum {string} */
      action: "purchased";
      effective_date: string;
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      marketplace_purchase: components["schemas"]["webhooks_marketplace_purchase"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      previous_marketplace_purchase?: components["schemas"]["webhooks_previous_marketplace_purchase"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** member added event */
    "webhook-member-added": {
      /** @enum {string} */
      action: "added";
      changes?: {
        /**
         * @description This field is included for legacy purposes; use the `role_name` field instead. The `maintain`
         * role is mapped to `write` and the `triage` role is mapped to `read`. To determine the role
         * assigned to the collaborator, use the `role_name` field instead, which will provide the full
         * role name, including custom roles.
         */
        permission?: {
          /** @enum {string} */
          to: "write" | "admin" | "read";
        };
        /** @description The role assigned to the collaborator. */
        role_name?: {
          to: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      member: components["schemas"]["webhooks_user"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** member edited event */
    "webhook-member-edited": {
      /** @enum {string} */
      action: "edited";
      /** @description The changes to the collaborator permissions */
      changes: {
        old_permission?: {
          /** @description The previous permissions of the collaborator if the action was edited. */
          from: string;
        };
        permission?: {
          from?: string | null;
          to?: string | null;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      member: components["schemas"]["webhooks_user"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** member removed event */
    "webhook-member-removed": {
      /** @enum {string} */
      action: "removed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      member: components["schemas"]["webhooks_user"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** membership added event */
    "webhook-membership-added": {
      /** @enum {string} */
      action: "added";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      member: components["schemas"]["webhooks_user"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      /**
       * @description The scope of the membership. Currently, can only be `team`.
       * @enum {string}
       */
      scope: "team";
      /** User */
      sender: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      team: components["schemas"]["webhooks_team"];
    };
    /**
     * Team
     * @description Groups of organization members that gives permissions on specified repositories.
     */
    webhooks_team: {
      deleted?: boolean;
      /** @description Description of the team */
      description?: string | null;
      /** Format: uri */
      html_url?: string;
      /** @description Unique identifier of the team */
      id: number;
      /** Format: uri-template */
      members_url?: string;
      /** @description Name of the team */
      name: string;
      node_id?: string;
      parent?: {
        /** @description Description of the team */
        description: string | null;
        /** Format: uri */
        html_url: string;
        /** @description Unique identifier of the team */
        id: number;
        /** Format: uri-template */
        members_url: string;
        /** @description Name of the team */
        name: string;
        node_id: string;
        /** @description Permission that the team will have for its repositories */
        permission: string;
        /** @enum {string} */
        privacy: "open" | "closed" | "secret";
        /**
         * @description Whether team members will receive notifications when their team is @mentioned
         * @enum {string}
         */
        notification_setting:
          | "notifications_enabled"
          | "notifications_disabled";
        /** Format: uri */
        repositories_url: string;
        slug: string;
        /**
         * Format: uri
         * @description URL for the team
         */
        url: string;
      } | null;
      /** @description Permission that the team will have for its repositories */
      permission?: string;
      /** @enum {string} */
      privacy?: "open" | "closed" | "secret";
      /** @enum {string} */
      notification_setting?: "notifications_enabled" | "notifications_disabled";
      /** Format: uri */
      repositories_url?: string;
      slug?: string;
      /**
       * Format: uri
       * @description URL for the team
       */
      url?: string;
    };
    /** membership removed event */
    "webhook-membership-removed": {
      /** @enum {string} */
      action: "removed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      member: components["schemas"]["webhooks_user"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      /**
       * @description The scope of the membership. Currently, can only be `team`.
       * @enum {string}
       */
      scope: "team" | "organization";
      /** User */
      sender: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      team: components["schemas"]["webhooks_team"];
    };
    "webhook-merge-group-checks-requested": {
      /** @enum {string} */
      action: "checks_requested";
      installation?: components["schemas"]["simple-installation"];
      merge_group: components["schemas"]["merge-group"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /**
     * Merge Group
     * @description A group of pull requests that the merge queue has grouped together to be merged.
     */
    "merge-group": {
      /** @description The SHA of the merge group. */
      head_sha: string;
      /** @description The full ref of the merge group. */
      head_ref: string;
      /** @description The SHA of the merge group's parent commit. */
      base_sha: string;
      /** @description The full ref of the branch the merge group will be merged into. */
      base_ref: string;
      head_commit: components["schemas"]["simple-commit"];
    };
    /**
     * Simple Commit
     * @description A commit.
     */
    "simple-commit": {
      /** @description SHA for the commit */
      id: string;
      /** @description SHA for the commit's tree */
      tree_id: string;
      /** @description Message describing the purpose of the commit */
      message: string;
      /**
       * Format: date-time
       * @description Timestamp of the commit
       */
      timestamp: string;
      /** @description Information about the Git author */
      author: {
        /** @description Name of the commit's author */
        name: string;
        /**
         * Format: email
         * @description Git email address of the commit's author
         */
        email: string;
      } | null;
      /** @description Information about the Git committer */
      committer: {
        /** @description Name of the commit's committer */
        name: string;
        /**
         * Format: email
         * @description Git email address of the commit's committer
         */
        email: string;
      } | null;
    };
    "webhook-merge-group-destroyed": {
      /** @enum {string} */
      action: "destroyed";
      /**
       * @description Explains why the merge group is being destroyed. The group could have been merged, removed from the queue (dequeued), or invalidated by an earlier queue entry being dequeued (invalidated).
       * @enum {string}
       */
      reason?: "merged" | "invalidated" | "dequeued";
      installation?: components["schemas"]["simple-installation"];
      merge_group: components["schemas"]["merge-group"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** meta deleted event */
    "webhook-meta-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      /** @description The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace. */
      hook: {
        active: boolean;
        config: {
          /** @enum {string} */
          content_type: "json" | "form";
          insecure_ssl: string;
          secret?: string;
          /** Format: uri */
          url: string;
        };
        created_at: string;
        events: (
          | "*"
          | "branch_protection_rule"
          | "check_run"
          | "check_suite"
          | "code_scanning_alert"
          | "commit_comment"
          | "create"
          | "delete"
          | "deployment"
          | "deployment_status"
          | "deploy_key"
          | "discussion"
          | "discussion_comment"
          | "fork"
          | "gollum"
          | "issues"
          | "issue_comment"
          | "label"
          | "member"
          | "membership"
          | "meta"
          | "milestone"
          | "organization"
          | "org_block"
          | "package"
          | "page_build"
          | "project"
          | "project_card"
          | "project_column"
          | "public"
          | "pull_request"
          | "pull_request_review"
          | "pull_request_review_comment"
          | "pull_request_review_thread"
          | "push"
          | "registry_package"
          | "release"
          | "repository"
          | "repository_import"
          | "repository_vulnerability_alert"
          | "secret_scanning_alert"
          | "secret_scanning_alert_location"
          | "security_and_analysis"
          | "star"
          | "status"
          | "team"
          | "team_add"
          | "watch"
          | "workflow_job"
          | "workflow_run"
          | "repository_dispatch"
          | "projects_v2_item"
        )[];
        id: number;
        name: string;
        type: string;
        updated_at: string;
      };
      /** @description The id of the modified webhook. */
      hook_id: number;
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository?: null | components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** milestone closed event */
    "webhook-milestone-closed": {
      /** @enum {string} */
      action: "closed";
      installation?: components["schemas"]["simple-installation"];
      /**
       * Milestone
       * @description A collection of related issues and pull requests.
       */
      milestone: {
        /** Format: date-time */
        closed_at: string;
        closed_issues: number;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
        } | null;
        description: string | null;
        /** Format: date-time */
        due_on: string | null;
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        labels_url: string;
        node_id: string;
        /** @description The number of the milestone. */
        number: number;
        open_issues: number;
        /**
         * @description The state of the milestone.
         * @enum {string}
         */
        state: "closed";
        /** @description The title of the milestone. */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** milestone created event */
    "webhook-milestone-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /**
       * Milestone
       * @description A collection of related issues and pull requests.
       */
      milestone: {
        closed_at: null;
        closed_issues: number;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
        } | null;
        description: string | null;
        /** Format: date-time */
        due_on: string | null;
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        labels_url: string;
        node_id: string;
        /** @description The number of the milestone. */
        number: number;
        open_issues: number;
        /**
         * @description The state of the milestone.
         * @enum {string}
         */
        state: "open";
        /** @description The title of the milestone. */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** milestone deleted event */
    "webhook-milestone-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      milestone: components["schemas"]["webhooks_milestone"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** milestone edited event */
    "webhook-milestone-edited": {
      /** @enum {string} */
      action: "edited";
      /** @description The changes to the milestone if the action was `edited`. */
      changes: {
        description?: {
          /** @description The previous version of the description if the action was `edited`. */
          from: string;
        };
        due_on?: {
          /** @description The previous version of the due date if the action was `edited`. */
          from: string;
        };
        title?: {
          /** @description The previous version of the title if the action was `edited`. */
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      milestone: components["schemas"]["webhooks_milestone"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** milestone opened event */
    "webhook-milestone-opened": {
      /** @enum {string} */
      action: "opened";
      installation?: components["schemas"]["simple-installation"];
      /**
       * Milestone
       * @description A collection of related issues and pull requests.
       */
      milestone: {
        closed_at: null;
        closed_issues: number;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
        } | null;
        description: string | null;
        /** Format: date-time */
        due_on: string | null;
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        labels_url: string;
        node_id: string;
        /** @description The number of the milestone. */
        number: number;
        open_issues: number;
        /**
         * @description The state of the milestone.
         * @enum {string}
         */
        state: "open";
        /** @description The title of the milestone. */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** org_block blocked event */
    "webhook-org-block-blocked": {
      /** @enum {string} */
      action: "blocked";
      blocked_user: components["schemas"]["webhooks_user"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** org_block unblocked event */
    "webhook-org-block-unblocked": {
      /** @enum {string} */
      action: "unblocked";
      blocked_user: components["schemas"]["webhooks_user"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** organization deleted event */
    "webhook-organization-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      membership?: components["schemas"]["webhooks_membership"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Membership
     * @description The membership between the user and the organization. Not present when the action is `member_invited`.
     */
    webhooks_membership: {
      /** Format: uri */
      organization_url: string;
      role: string;
      state: string;
      /** Format: uri */
      url: string;
      /** User */
      user: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        /** Format: int64 */
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
    };
    /** organization member_added event */
    "webhook-organization-member-added": {
      /** @enum {string} */
      action: "member_added";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      membership: components["schemas"]["webhooks_membership"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** organization member_invited event */
    "webhook-organization-member-invited": {
      /** @enum {string} */
      action: "member_invited";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      /** @description The invitation for the user or email if the action is `member_invited`. */
      invitation: {
        /** Format: date-time */
        created_at: string;
        email: string | null;
        /** Format: date-time */
        failed_at: string | null;
        failed_reason: string | null;
        id: number;
        /** Format: uri */
        invitation_teams_url: string;
        /** User */
        inviter: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        login: string | null;
        node_id: string;
        role: string;
        team_count: number;
        invitation_source?: string;
      };
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
      user?: components["schemas"]["webhooks_user"];
    };
    /** organization member_removed event */
    "webhook-organization-member-removed": {
      /** @enum {string} */
      action: "member_removed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      membership: components["schemas"]["webhooks_membership"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** organization renamed event */
    "webhook-organization-renamed": {
      /** @enum {string} */
      action: "renamed";
      changes?: {
        login?: {
          from?: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      membership?: components["schemas"]["webhooks_membership"];
      organization: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** package published event */
    "webhook-package-published": {
      /** @enum {string} */
      action: "published";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** @description Information about the package. */
      package: {
        created_at: string | null;
        description: string | null;
        ecosystem: string;
        /** Format: uri */
        html_url: string;
        id: number;
        name: string;
        namespace: string;
        /** User */
        owner: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        package_type: string;
        package_version: {
          /** User */
          author?: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          body?: string | Record<string, never>;
          body_html?: string;
          container_metadata?: {
            labels?: Record<string, never> | null;
            manifest?: Record<string, never> | null;
            tag?: {
              digest?: string;
              name?: string;
            };
          } | null;
          created_at?: string;
          description: string;
          docker_metadata?: {
            tags?: string[];
          }[];
          draft?: boolean;
          /** Format: uri */
          html_url: string;
          id: number;
          installation_command: string;
          manifest?: string;
          metadata: {
            [key: string]: unknown;
          }[];
          name: string;
          npm_metadata?: {
            name?: string;
            version?: string;
            npm_user?: string;
            author?: Record<string, never> | null;
            bugs?: Record<string, never> | null;
            dependencies?: Record<string, never>;
            dev_dependencies?: Record<string, never>;
            peer_dependencies?: Record<string, never>;
            optional_dependencies?: Record<string, never>;
            description?: string;
            dist?: Record<string, never> | null;
            git_head?: string;
            homepage?: string;
            license?: string;
            main?: string;
            repository?: Record<string, never> | null;
            scripts?: Record<string, never>;
            id?: string;
            node_version?: string;
            npm_version?: string;
            has_shrinkwrap?: boolean;
            maintainers?: Record<string, never>[];
            contributors?: Record<string, never>[];
            engines?: Record<string, never>;
            keywords?: string[];
            files?: string[];
            bin?: Record<string, never>;
            man?: Record<string, never>;
            directories?: Record<string, never> | null;
            os?: string[];
            cpu?: string[];
            readme?: string;
            installation_command?: string;
            release_id?: number;
            commit_oid?: string;
            published_via_actions?: boolean;
            deleted_by_id?: number;
          } | null;
          nuget_metadata?:
            | {
                id?: number | string;
                name?: string;
                value?: OneOf<
                  [
                    boolean,
                    string,
                    number,
                    {
                      url?: string;
                      branch?: string;
                      commit?: string;
                      type?: string;
                    },
                  ]
                >;
              }[]
            | null;
          package_files: {
            content_type: string;
            created_at: string;
            /** Format: uri */
            download_url: string;
            id: number;
            md5: string | null;
            name: string;
            sha1: string | null;
            sha256: string | null;
            size: number;
            state: string | null;
            updated_at: string;
          }[];
          package_url?: string;
          prerelease?: boolean;
          release?: {
            /** User */
            author: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            created_at: string;
            draft: boolean;
            /** Format: uri */
            html_url: string;
            id: number;
            name: string | null;
            prerelease: boolean;
            published_at: string;
            tag_name: string;
            target_commitish: string;
            /** Format: uri */
            url: string;
          };
          rubygems_metadata?: components["schemas"]["webhook-rubygems-metadata"][];
          source_url?: string;
          summary: string;
          tag_name?: string;
          target_commitish?: string;
          target_oid?: string;
          updated_at?: string;
          version: string;
        } | null;
        registry: {
          /** Format: uri */
          about_url: string;
          name: string;
          type: string;
          /** Format: uri */
          url: string;
          vendor: string;
        } | null;
        updated_at: string | null;
      };
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Ruby Gems metadata */
    "webhook-rubygems-metadata": {
      name?: string;
      description?: string;
      readme?: string;
      homepage?: string;
      version_info?: {
        version?: string;
      };
      platform?: string;
      metadata?: {
        [key: string]: string;
      };
      repo?: string;
      dependencies?: {
        [key: string]: string;
      }[];
      commit_oid?: string;
    };
    /** package updated event */
    "webhook-package-updated": {
      /** @enum {string} */
      action: "updated";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** @description Information about the package. */
      package: {
        created_at: string;
        description: string | null;
        ecosystem: string;
        /** Format: uri */
        html_url: string;
        id: number;
        name: string;
        namespace: string;
        /** User */
        owner: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        package_type: string;
        package_version: {
          /** User */
          author: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          body: string;
          body_html: string;
          created_at: string;
          description: string;
          docker_metadata?: {
            tags?: string[];
          }[];
          draft?: boolean;
          /** Format: uri */
          html_url: string;
          id: number;
          installation_command: string;
          manifest?: string;
          metadata: {
            [key: string]: unknown;
          }[];
          name: string;
          package_files: {
            content_type: string;
            created_at: string;
            /** Format: uri */
            download_url: string;
            id: number;
            md5: string | null;
            name: string;
            sha1: string | null;
            sha256: string;
            size: number;
            state: string;
            updated_at: string;
          }[];
          package_url?: string;
          prerelease?: boolean;
          release?: {
            /** User */
            author: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            created_at: string;
            draft: boolean;
            /** Format: uri */
            html_url: string;
            id: number;
            name: string;
            prerelease: boolean;
            published_at: string;
            tag_name: string;
            target_commitish: string;
            /** Format: uri */
            url: string;
          };
          rubygems_metadata?: components["schemas"]["webhook-rubygems-metadata"][];
          /** Format: uri */
          source_url?: string;
          summary: string;
          tag_name?: string;
          target_commitish: string;
          target_oid: string;
          updated_at: string;
          version: string;
        };
        registry: {
          /** Format: uri */
          about_url: string;
          name: string;
          type: string;
          /** Format: uri */
          url: string;
          vendor: string;
        } | null;
        updated_at: string;
      };
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** page_build event */
    "webhook-page-build": {
      /** @description The [List GitHub Pages builds](https://docs.github.com/rest/pages/pages#list-github-pages-builds) itself. */
      build: {
        commit: string | null;
        created_at: string;
        duration: number;
        error: {
          message: string | null;
        };
        /** User */
        pusher: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        status: string;
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      id: number;
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** personal_access_token_request approved event */
    "webhook-personal-access-token-request-approved": {
      /** @enum {string} */
      action: "approved";
      personal_access_token_request: components["schemas"]["personal-access-token-request"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      organization: components["schemas"]["organization-simple-webhooks"];
      sender: components["schemas"]["simple-user"];
      installation: components["schemas"]["simple-installation"];
    };
    /**
     * Personal Access Token Request
     * @description Details of a Personal Access Token Request.
     */
    "personal-access-token-request": {
      /** @description Unique identifier of the request for access via fine-grained personal access token. Used as the `pat_request_id` parameter in the list and review API calls. */
      id: number;
      owner: components["schemas"]["simple-user"];
      /** @description New requested permissions, categorized by type of permission. */
      permissions_added: {
        organization?: {
          [key: string]: string;
        };
        repository?: {
          [key: string]: string;
        };
        other?: {
          [key: string]: string;
        };
      };
      /** @description Requested permissions that elevate access for a previously approved request for access, categorized by type of permission. */
      permissions_upgraded: {
        organization?: {
          [key: string]: string;
        };
        repository?: {
          [key: string]: string;
        };
        other?: {
          [key: string]: string;
        };
      };
      /** @description Permissions requested, categorized by type of permission. This field incorporates `permissions_added` and `permissions_upgraded`. */
      permissions_result: {
        organization?: {
          [key: string]: string;
        };
        repository?: {
          [key: string]: string;
        };
        other?: {
          [key: string]: string;
        };
      };
      /**
       * @description Type of repository selection requested.
       * @enum {string}
       */
      repository_selection: "none" | "all" | "subset";
      /** @description The number of repositories the token is requesting access to. This field is only populated when `repository_selection` is `subset`. */
      repository_count: number | null;
      /** @description An array of repository objects the token is requesting access to. This field is only populated when `repository_selection` is `subset`. */
      repositories:
        | {
            full_name: string;
            /** @description Unique identifier of the repository */
            id: number;
            /** @description The name of the repository. */
            name: string;
            node_id: string;
            /** @description Whether the repository is private or public. */
            private: boolean;
          }[]
        | null;
      /** @description Date and time when the request for access was created. */
      created_at: string;
      /** @description Unique identifier of the user's token. This field can also be found in audit log events and the organization's settings for their PAT grants. */
      token_id: number;
      /** @description The name given to the user's token. This field can also be found in an organization's settings page for Active Tokens. */
      token_name: string;
      /** @description Whether the associated fine-grained personal access token has expired. */
      token_expired: boolean;
      /** @description Date and time when the associated fine-grained personal access token expires. */
      token_expires_at: string | null;
      /** @description Date and time when the associated fine-grained personal access token was last used for authentication. */
      token_last_used_at: string | null;
    };
    /** personal_access_token_request cancelled event */
    "webhook-personal-access-token-request-cancelled": {
      /** @enum {string} */
      action: "cancelled";
      personal_access_token_request: components["schemas"]["personal-access-token-request"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      organization: components["schemas"]["organization-simple-webhooks"];
      sender: components["schemas"]["simple-user"];
      installation: components["schemas"]["simple-installation"];
    };
    /** personal_access_token_request created event */
    "webhook-personal-access-token-request-created": {
      /** @enum {string} */
      action: "created";
      personal_access_token_request: components["schemas"]["personal-access-token-request"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      organization: components["schemas"]["organization-simple-webhooks"];
      sender: components["schemas"]["simple-user"];
      installation?: components["schemas"]["simple-installation"];
    };
    /** personal_access_token_request denied event */
    "webhook-personal-access-token-request-denied": {
      /** @enum {string} */
      action: "denied";
      personal_access_token_request: components["schemas"]["personal-access-token-request"];
      organization: components["schemas"]["organization-simple-webhooks"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      sender: components["schemas"]["simple-user"];
      installation: components["schemas"]["simple-installation"];
    };
    "webhook-ping": {
      /**
       * Webhook
       * @description The webhook that is being pinged
       */
      hook?: {
        /** @description Determines whether the hook is actually triggered for the events it subscribes to. */
        active: boolean;
        /** @description Only included for GitHub Apps. When you register a new GitHub App, GitHub sends a ping event to the webhook URL you specified during registration. The GitHub App ID sent in this field is required for authenticating an app. */
        app_id?: number;
        config: {
          content_type?: components["schemas"]["webhook-config-content-type"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
          secret?: components["schemas"]["webhook-config-secret"];
          url?: components["schemas"]["webhook-config-url"];
        };
        /** Format: date-time */
        created_at: string;
        /** Format: uri */
        deliveries_url?: string;
        /** @description Determines what events the hook is triggered for. Default: ['push']. */
        events: string[];
        /** @description Unique identifier of the webhook. */
        id: number;
        last_response?: components["schemas"]["hook-response"];
        /**
         * @description The type of webhook. The only valid value is 'web'.
         * @enum {string}
         */
        name: "web";
        /** Format: uri */
        ping_url?: string;
        /** Format: uri */
        test_url?: string;
        type: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url?: string;
      };
      /** @description The ID of the webhook that triggered the ping. */
      hook_id?: number;
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
      /** @description Random string of GitHub zen. */
      zen?: string;
    };
    /** @description The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`. */
    "webhook-config-content-type": string;
    "webhook-config-insecure-ssl": string | number;
    /** @description If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers). */
    "webhook-config-secret": string;
    /**
     * Format: uri
     * @description The URL to which the payloads will be delivered.
     */
    "webhook-config-url": string;
    /** Hook Response */
    "hook-response": {
      code: number | null;
      status: string | null;
      message: string | null;
    };
    /** project_card converted event */
    "webhook-project-card-converted": {
      /** @enum {string} */
      action: "converted";
      changes: {
        note: {
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_card: components["schemas"]["webhooks_project_card"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Project Card */
    webhooks_project_card: {
      after_id?: number | null;
      /** @description Whether or not the card is archived */
      archived: boolean;
      column_id: number;
      /** Format: uri */
      column_url: string;
      /** Format: uri */
      content_url?: string;
      /** Format: date-time */
      created_at: string;
      /** User */
      creator: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      /** @description The project card's ID */
      id: number;
      node_id: string;
      note: string | null;
      /** Format: uri */
      project_url: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      url: string;
    };
    /** project_card created event */
    "webhook-project-card-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_card: components["schemas"]["webhooks_project_card"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** project_card deleted event */
    "webhook-project-card-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** Project Card */
      project_card: {
        after_id?: number | null;
        /** @description Whether or not the card is archived */
        archived: boolean;
        column_id: number | null;
        /** Format: uri */
        column_url: string;
        /** Format: uri */
        content_url?: string;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** @description The project card's ID */
        id: number;
        node_id: string;
        note: string | null;
        /** Format: uri */
        project_url: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      };
      repository?: null | components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** project_card edited event */
    "webhook-project-card-edited": {
      /** @enum {string} */
      action: "edited";
      changes: {
        note: {
          from: string | null;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_card: components["schemas"]["webhooks_project_card"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** project_card moved event */
    "webhook-project-card-moved": {
      /** @enum {string} */
      action: "moved";
      changes?: {
        column_id: {
          from: number;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_card: {
        after_id?: number | null;
        /** @description Whether or not the card is archived */
        archived: boolean;
        column_id: number;
        /** Format: uri */
        column_url: string;
        /** Format: uri */
        content_url?: string;
        /** Format: date-time */
        created_at: string;
        /** User */
        creator: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /** @description The project card's ID */
        id: number;
        node_id: string;
        note: string | null;
        /** Format: uri */
        project_url: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
      } & {
        after_id: number | null;
        archived?: boolean;
        column_id?: number;
        column_url?: string;
        created_at?: string;
        creator?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        } | null;
        id?: number;
        node_id?: string;
        note?: string | null;
        project_url?: string;
        updated_at?: string;
        url?: string;
      };
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** project closed event */
    "webhook-project-closed": {
      /** @enum {string} */
      action: "closed";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project: components["schemas"]["webhooks_project"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Project */
    webhooks_project: {
      /** @description Body of the project */
      body: string | null;
      /** Format: uri */
      columns_url: string;
      /** Format: date-time */
      created_at: string;
      /** User */
      creator: {
        /** Format: uri */
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        /** Format: uri-template */
        events_url?: string;
        /** Format: uri */
        followers_url?: string;
        /** Format: uri-template */
        following_url?: string;
        /** Format: uri-template */
        gists_url?: string;
        gravatar_id?: string;
        /** Format: uri */
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        /** Format: uri */
        organizations_url?: string;
        /** Format: uri */
        received_events_url?: string;
        /** Format: uri */
        repos_url?: string;
        site_admin?: boolean;
        /** Format: uri-template */
        starred_url?: string;
        /** Format: uri */
        subscriptions_url?: string;
        /** @enum {string} */
        type?: "Bot" | "User" | "Organization";
        /** Format: uri */
        url?: string;
        user_view_type?: string;
      } | null;
      /** Format: uri */
      html_url: string;
      id: number;
      /** @description Name of the project */
      name: string;
      node_id: string;
      number: number;
      /** Format: uri */
      owner_url: string;
      /**
       * @description State of the project; either 'open' or 'closed'
       * @enum {string}
       */
      state: "open" | "closed";
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      url: string;
    };
    /** project_column created event */
    "webhook-project-column-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_column: components["schemas"]["webhooks_project_column"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** Project Column */
    webhooks_project_column: {
      after_id?: number | null;
      /** Format: uri */
      cards_url: string;
      /** Format: date-time */
      created_at: string;
      /** @description The unique identifier of the project column */
      id: number;
      /** @description Name of the project column */
      name: string;
      node_id: string;
      /** Format: uri */
      project_url: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: uri */
      url: string;
    };
    /** project_column deleted event */
    "webhook-project-column-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_column: components["schemas"]["webhooks_project_column"];
      repository?: null | components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** project_column edited event */
    "webhook-project-column-edited": {
      /** @enum {string} */
      action: "edited";
      changes: {
        name?: {
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_column: components["schemas"]["webhooks_project_column"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** project_column moved event */
    "webhook-project-column-moved": {
      /** @enum {string} */
      action: "moved";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project_column: components["schemas"]["webhooks_project_column"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** project created event */
    "webhook-project-created": {
      /** @enum {string} */
      action: "created";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project: components["schemas"]["webhooks_project"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** project deleted event */
    "webhook-project-deleted": {
      /** @enum {string} */
      action: "deleted";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project: components["schemas"]["webhooks_project"];
      repository?: null | components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** project edited event */
    "webhook-project-edited": {
      /** @enum {string} */
      action: "edited";
      /** @description The changes to the project if the action was `edited`. */
      changes?: {
        body?: {
          /** @description The previous version of the body if the action was `edited`. */
          from: string;
        };
        name?: {
          /** @description The changes to the project if the action was `edited`. */
          from: string;
        };
      };
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project: components["schemas"]["webhooks_project"];
      repository?: components["schemas"]["repository-webhooks"];
      sender?: components["schemas"]["simple-user"];
    };
    /** project reopened event */
    "webhook-project-reopened": {
      /** @enum {string} */
      action: "reopened";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      project: components["schemas"]["webhooks_project"];
      repository?: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Project Closed Event */
    "webhook-projects-v2-project-closed": {
      /** @enum {string} */
      action: "closed";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2: components["schemas"]["projects-v2"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Projects v2 Project
     * @description A projects v2 project
     */
    "projects-v2": {
      id: number;
      node_id: string;
      owner: components["schemas"]["simple-user"];
      creator: components["schemas"]["simple-user"];
      title: string;
      description: string | null;
      public: boolean;
      /** Format: date-time */
      closed_at: string | null;
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      number: number;
      short_description: string | null;
      /** Format: date-time */
      deleted_at: string | null;
      deleted_by: null | components["schemas"]["simple-user"];
    };
    /** @description A project was created */
    "webhook-projects-v2-project-created": {
      /** @enum {string} */
      action: "created";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2: components["schemas"]["projects-v2"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Project Deleted Event */
    "webhook-projects-v2-project-deleted": {
      /** @enum {string} */
      action: "deleted";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2: components["schemas"]["projects-v2"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Project Edited Event */
    "webhook-projects-v2-project-edited": {
      /** @enum {string} */
      action: "edited";
      changes: {
        description?: {
          from?: string | null;
          to?: string | null;
        };
        public?: {
          from?: boolean;
          to?: boolean;
        };
        short_description?: {
          from?: string | null;
          to?: string | null;
        };
        title?: {
          from?: string;
          to?: string;
        };
      };
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2: components["schemas"]["projects-v2"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Item Archived Event */
    "webhook-projects-v2-item-archived": {
      /** @enum {string} */
      action: "archived";
      changes: components["schemas"]["webhooks_project_changes"];
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    webhooks_project_changes: {
      archived_at?: {
        /** Format: date-time */
        from?: string | null;
        /** Format: date-time */
        to?: string | null;
      };
    };
    /**
     * Projects v2 Item
     * @description An item belonging to a project
     */
    "projects-v2-item": {
      id: number;
      node_id?: string;
      project_node_id?: string;
      content_node_id: string;
      content_type: components["schemas"]["projects-v2-item-content-type"];
      creator?: components["schemas"]["simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** Format: date-time */
      archived_at: string | null;
    };
    /**
     * Projects v2 Item Content Type
     * @description The type of content tracked in a project item
     * @enum {string}
     */
    "projects-v2-item-content-type": "Issue" | "PullRequest" | "DraftIssue";
    /** Projects v2 Item Converted Event */
    "webhook-projects-v2-item-converted": {
      /** @enum {string} */
      action: "converted";
      changes: {
        content_type?: {
          from?: string | null;
          to?: string;
        };
      };
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Item Created Event */
    "webhook-projects-v2-item-created": {
      /** @enum {string} */
      action: "created";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Item Deleted Event */
    "webhook-projects-v2-item-deleted": {
      /** @enum {string} */
      action: "deleted";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Item Edited Event */
    "webhook-projects-v2-item-edited": {
      /** @enum {string} */
      action: "edited";
      /**
       * @description The changes made to the item may involve modifications in the item's fields and draft issue body.
       * It includes altered values for text, number, date, single select, and iteration fields, along with the GraphQL node ID of the changed field.
       */
      changes?: OneOf<
        [
          {
            field_value: {
              field_node_id?: string;
              field_type?: string;
              field_name?: string;
              project_number?: number;
              from?:
                | string
                | number
                | components["schemas"]["projects-v2-single-select-option"]
                | components["schemas"]["projects-v2-iteration-setting"]
                | null
                | Record<string, never>;
              to?:
                | string
                | number
                | components["schemas"]["projects-v2-single-select-option"]
                | components["schemas"]["projects-v2-iteration-setting"]
                | null
                | Record<string, never>;
            };
          },
          {
            body: {
              from?: string | null;
              to?: string | null;
            };
          },
        ]
      >;
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Projects v2 Single Select Option
     * @description An option for a single select field
     */
    "projects-v2-single-select-option": {
      id: string;
      name: string;
      color?: string | null;
      description?: string | null;
    };
    /**
     * Projects v2 Iteration Setting
     * @description An iteration setting for an iteration field
     */
    "projects-v2-iteration-setting": {
      id: string;
      title: string;
      duration?: number | null;
      start_date?: string | null;
    };
    /** Projects v2 Item Reordered Event */
    "webhook-projects-v2-item-reordered": {
      /** @enum {string} */
      action: "reordered";
      changes: {
        previous_projects_v2_item_node_id?: {
          from?: string | null;
          to?: string | null;
        };
      };
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Item Restored Event */
    "webhook-projects-v2-item-restored": {
      /** @enum {string} */
      action: "restored";
      changes: components["schemas"]["webhooks_project_changes"];
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_item: components["schemas"]["projects-v2-item"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Project Reopened Event */
    "webhook-projects-v2-project-reopened": {
      /** @enum {string} */
      action: "reopened";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2: components["schemas"]["projects-v2"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Status Update Created Event */
    "webhook-projects-v2-status-update-created": {
      /** @enum {string} */
      action: "created";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_status_update: components["schemas"]["projects-v2-status-update"];
      sender: components["schemas"]["simple-user"];
    };
    /**
     * Projects v2 Status Update
     * @description An status update belonging to a project
     */
    "projects-v2-status-update": {
      id: number;
      node_id: string;
      project_node_id?: string;
      creator?: components["schemas"]["simple-user"];
      /** Format: date-time */
      created_at: string;
      /** Format: date-time */
      updated_at: string;
      /** @enum {string|null} */
      status?:
        | "INACTIVE"
        | "ON_TRACK"
        | "AT_RISK"
        | "OFF_TRACK"
        | "COMPLETE"
        | null;
      /** Format: date */
      start_date?: string;
      /** Format: date */
      target_date?: string;
      /** @description Body of the status update */
      body?: string | null;
    };
    /** Projects v2 Status Update Deleted Event */
    "webhook-projects-v2-status-update-deleted": {
      /** @enum {string} */
      action: "deleted";
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_status_update: components["schemas"]["projects-v2-status-update"];
      sender: components["schemas"]["simple-user"];
    };
    /** Projects v2 Status Update Edited Event */
    "webhook-projects-v2-status-update-edited": {
      /** @enum {string} */
      action: "edited";
      changes?: {
        body?: {
          from?: string | null;
          to?: string | null;
        };
        status?: {
          /** @enum {string|null} */
          from?:
            | "INACTIVE"
            | "ON_TRACK"
            | "AT_RISK"
            | "OFF_TRACK"
            | "COMPLETE"
            | null;
          /** @enum {string|null} */
          to?:
            | "INACTIVE"
            | "ON_TRACK"
            | "AT_RISK"
            | "OFF_TRACK"
            | "COMPLETE"
            | null;
        };
        start_date?: {
          /** Format: date */
          from?: string | null;
          /** Format: date */
          to?: string | null;
        };
        target_date?: {
          /** Format: date */
          from?: string | null;
          /** Format: date */
          to?: string | null;
        };
      };
      installation?: components["schemas"]["simple-installation"];
      organization: components["schemas"]["organization-simple-webhooks"];
      projects_v2_status_update: components["schemas"]["projects-v2-status-update"];
      sender: components["schemas"]["simple-user"];
    };
    /** public event */
    "webhook-public": {
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** pull_request assigned event */
    "webhook-pull-request-assigned": {
      /** @enum {string} */
      action: "assigned";
      assignee: components["schemas"]["webhooks_user"];
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      number: components["schemas"]["webhooks_number"];
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** Pull Request */
      pull_request: {
        _links: {
          /** Link */
          comments: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          commits: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          html: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          issue: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          review_comment: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          review_comments: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          self: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          statuses: {
            /** Format: uri-template */
            href: string;
          };
        };
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        additions?: number;
        /** User */
        assignee: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /**
         * PullRequestAutoMerge
         * @description The status of auto merging a pull request.
         */
        auto_merge: {
          /** @description Commit message for the merge commit. */
          commit_message: string | null;
          /** @description Title for the merge commit message. */
          commit_title: string | null;
          /** User */
          enabled_by: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /**
           * @description The merge method to use.
           * @enum {string}
           */
          merge_method: "merge" | "squash" | "rebase";
        } | null;
        base: {
          label: string;
          ref: string;
          /**
           * Repository
           * @description A git repository
           */
          repo: {
            /**
             * @description Whether to allow auto-merge for pull requests.
             * @default false
             */
            allow_auto_merge?: boolean;
            /** @description Whether to allow private forks */
            allow_forking?: boolean;
            /**
             * @description Whether to allow merge commits for pull requests.
             * @default true
             */
            allow_merge_commit?: boolean;
            /**
             * @description Whether to allow rebase merges for pull requests.
             * @default true
             */
            allow_rebase_merge?: boolean;
            /**
             * @description Whether to allow squash merges for pull requests.
             * @default true
             */
            allow_squash_merge?: boolean;
            allow_update_branch?: boolean;
            /** Format: uri-template */
            archive_url: string;
            /**
             * @description Whether the repository is archived.
             * @default false
             */
            archived: boolean;
            /** Format: uri-template */
            assignees_url: string;
            /** Format: uri-template */
            blobs_url: string;
            /** Format: uri-template */
            branches_url: string;
            /** Format: uri */
            clone_url: string;
            /** Format: uri-template */
            collaborators_url: string;
            /** Format: uri-template */
            comments_url: string;
            /** Format: uri-template */
            commits_url: string;
            /** Format: uri-template */
            compare_url: string;
            /** Format: uri-template */
            contents_url: string;
            /** Format: uri */
            contributors_url: string;
            created_at: number | string;
            /** @description The default branch of the repository. */
            default_branch: string;
            /**
             * @description Whether to delete head branches when pull requests are merged
             * @default false
             */
            delete_branch_on_merge?: boolean;
            /** Format: uri */
            deployments_url: string;
            description: string | null;
            /** @description Returns whether or not this repository is disabled. */
            disabled?: boolean;
            /** Format: uri */
            downloads_url: string;
            /** Format: uri */
            events_url: string;
            fork: boolean;
            forks: number;
            forks_count: number;
            /** Format: uri */
            forks_url: string;
            full_name: string;
            /** Format: uri-template */
            git_commits_url: string;
            /** Format: uri-template */
            git_refs_url: string;
            /** Format: uri-template */
            git_tags_url: string;
            /** Format: uri */
            git_url: string;
            /**
             * @description Whether downloads are enabled.
             * @default true
             */
            has_downloads: boolean;
            /**
             * @description Whether issues are enabled.
             * @default true
             */
            has_issues: boolean;
            has_pages: boolean;
            /**
             * @description Whether projects are enabled.
             * @default true
             */
            has_projects: boolean;
            /**
             * @description Whether the wiki is enabled.
             * @default true
             */
            has_wiki: boolean;
            /**
             * @description Whether discussions are enabled.
             * @default false
             */
            has_discussions: boolean;
            homepage: string | null;
            /** Format: uri */
            hooks_url: string;
            /** Format: uri */
            html_url: string;
            /**
             * Format: int64
             * @description Unique identifier of the repository
             */
            id: number;
            is_template?: boolean;
            /** Format: uri-template */
            issue_comment_url: string;
            /** Format: uri-template */
            issue_events_url: string;
            /** Format: uri-template */
            issues_url: string;
            /** Format: uri-template */
            keys_url: string;
            /** Format: uri-template */
            labels_url: string;
            language: string | null;
            /** Format: uri */
            languages_url: string;
            /** License */
            license: {
              key: string;
              name: string;
              node_id: string;
              spdx_id: string;
              /** Format: uri */
              url: string | null;
            } | null;
            master_branch?: string;
            /**
             * @description The default value for a merge commit message.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `PR_BODY` - default to the pull request's body.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
            /**
             * @description The default value for a merge commit title.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
             * @enum {string}
             */
            merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
            /** Format: uri */
            merges_url: string;
            /** Format: uri-template */
            milestones_url: string;
            /** Format: uri */
            mirror_url: string | null;
            /** @description The name of the repository. */
            name: string;
            node_id: string;
            /** Format: uri-template */
            notifications_url: string;
            open_issues: number;
            open_issues_count: number;
            organization?: string;
            /** User */
            owner: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            permissions?: {
              admin: boolean;
              maintain?: boolean;
              pull: boolean;
              push: boolean;
              triage?: boolean;
            };
            /** @description Whether the repository is private or public. */
            private: boolean;
            public?: boolean;
            /** Format: uri-template */
            pulls_url: string;
            pushed_at: number | string | null;
            /** Format: uri-template */
            releases_url: string;
            role_name?: string | null;
            size: number;
            /**
             * @description The default value for a squash merge commit message:
             *
             * - `PR_BODY` - default to the pull request's body.
             * - `COMMIT_MESSAGES` - default to the branch's commit messages.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            squash_merge_commit_message?:
              | "PR_BODY"
              | "COMMIT_MESSAGES"
              | "BLANK";
            /**
             * @description The default value for a squash merge commit title:
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
             * @enum {string}
             */
            squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
            ssh_url: string;
            stargazers?: number;
            stargazers_count: number;
            /** Format: uri */
            stargazers_url: string;
            /** Format: uri-template */
            statuses_url: string;
            /** Format: uri */
            subscribers_url: string;
            /** Format: uri */
            subscription_url: string;
            /** Format: uri */
            svn_url: string;
            /** Format: uri */
            tags_url: string;
            /** Format: uri */
            teams_url: string;
            topics: string[];
            /** Format: uri-template */
            trees_url: string;
            /** Format: date-time */
            updated_at: string;
            /** Format: uri */
            url: string;
            /**
             * @description Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
             * @default false
             */
            use_squash_pr_title_as_default?: boolean;
            /** @enum {string} */
            visibility: "public" | "private" | "internal";
            watchers: number;
            watchers_count: number;
            /** @description Whether to require contributors to sign off on web-based commits */
            web_commit_signoff_required?: boolean;
          };
          sha: string;
          /** User */
          user: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: int64 */
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
        };
        body: string | null;
        changed_files?: number;
        /** Format: date-time */
        closed_at: string | null;
        comments?: number;
        /** Format: uri */
        comments_url: string;
        commits?: number;
        /** Format: uri */
        commits_url: string;
        /** Format: date-time */
        created_at: string;
        deletions?: number;
        /** Format: uri */
        diff_url: string;
        /** @description Indicates whether or not the pull request is a draft. */
        draft: boolean;
        head: {
          label: string | null;
          ref: string;
          /**
           * Repository
           * @description A git repository
           */
          repo: {
            /**
             * @description Whether to allow auto-merge for pull requests.
             * @default false
             */
            allow_auto_merge?: boolean;
            /** @description Whether to allow private forks */
            allow_forking?: boolean;
            /**
             * @description Whether to allow merge commits for pull requests.
             * @default true
             */
            allow_merge_commit?: boolean;
            /**
             * @description Whether to allow rebase merges for pull requests.
             * @default true
             */
            allow_rebase_merge?: boolean;
            /**
             * @description Whether to allow squash merges for pull requests.
             * @default true
             */
            allow_squash_merge?: boolean;
            allow_update_branch?: boolean;
            /** Format: uri-template */
            archive_url: string;
            /**
             * @description Whether the repository is archived.
             * @default false
             */
            archived: boolean;
            /** Format: uri-template */
            assignees_url: string;
            /** Format: uri-template */
            blobs_url: string;
            /** Format: uri-template */
            branches_url: string;
            /** Format: uri */
            clone_url: string;
            /** Format: uri-template */
            collaborators_url: string;
            /** Format: uri-template */
            comments_url: string;
            /** Format: uri-template */
            commits_url: string;
            /** Format: uri-template */
            compare_url: string;
            /** Format: uri-template */
            contents_url: string;
            /** Format: uri */
            contributors_url: string;
            created_at: number | string;
            /** @description The default branch of the repository. */
            default_branch: string;
            /**
             * @description Whether to delete head branches when pull requests are merged
             * @default false
             */
            delete_branch_on_merge?: boolean;
            /** Format: uri */
            deployments_url: string;
            description: string | null;
            /** @description Returns whether or not this repository is disabled. */
            disabled?: boolean;
            /** Format: uri */
            downloads_url: string;
            /** Format: uri */
            events_url: string;
            fork: boolean;
            forks: number;
            forks_count: number;
            /** Format: uri */
            forks_url: string;
            full_name: string;
            /** Format: uri-template */
            git_commits_url: string;
            /** Format: uri-template */
            git_refs_url: string;
            /** Format: uri-template */
            git_tags_url: string;
            /** Format: uri */
            git_url: string;
            /**
             * @description Whether downloads are enabled.
             * @default true
             */
            has_downloads: boolean;
            /**
             * @description Whether issues are enabled.
             * @default true
             */
            has_issues: boolean;
            has_pages: boolean;
            /**
             * @description Whether projects are enabled.
             * @default true
             */
            has_projects: boolean;
            /**
             * @description Whether the wiki is enabled.
             * @default true
             */
            has_wiki: boolean;
            /**
             * @description Whether discussions are enabled.
             * @default false
             */
            has_discussions: boolean;
            homepage: string | null;
            /** Format: uri */
            hooks_url: string;
            /** Format: uri */
            html_url: string;
            /**
             * Format: int64
             * @description Unique identifier of the repository
             */
            id: number;
            is_template?: boolean;
            /** Format: uri-template */
            issue_comment_url: string;
            /** Format: uri-template */
            issue_events_url: string;
            /** Format: uri-template */
            issues_url: string;
            /** Format: uri-template */
            keys_url: string;
            /** Format: uri-template */
            labels_url: string;
            language: string | null;
            /** Format: uri */
            languages_url: string;
            /** License */
            license: {
              key: string;
              name: string;
              node_id: string;
              spdx_id: string;
              /** Format: uri */
              url: string | null;
            } | null;
            master_branch?: string;
            /**
             * @description The default value for a merge commit message.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `PR_BODY` - default to the pull request's body.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
            /**
             * @description The default value for a merge commit title.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
             * @enum {string}
             */
            merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
            /** Format: uri */
            merges_url: string;
            /** Format: uri-template */
            milestones_url: string;
            /** Format: uri */
            mirror_url: string | null;
            /** @description The name of the repository. */
            name: string;
            node_id: string;
            /** Format: uri-template */
            notifications_url: string;
            open_issues: number;
            open_issues_count: number;
            organization?: string;
            /** User */
            owner: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            permissions?: {
              admin: boolean;
              maintain?: boolean;
              pull: boolean;
              push: boolean;
              triage?: boolean;
            };
            /** @description Whether the repository is private or public. */
            private: boolean;
            public?: boolean;
            /** Format: uri-template */
            pulls_url: string;
            pushed_at: number | string | null;
            /** Format: uri-template */
            releases_url: string;
            role_name?: string | null;
            size: number;
            /**
             * @description The default value for a squash merge commit message:
             *
             * - `PR_BODY` - default to the pull request's body.
             * - `COMMIT_MESSAGES` - default to the branch's commit messages.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            squash_merge_commit_message?:
              | "PR_BODY"
              | "COMMIT_MESSAGES"
              | "BLANK";
            /**
             * @description The default value for a squash merge commit title:
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
             * @enum {string}
             */
            squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
            ssh_url: string;
            stargazers?: number;
            stargazers_count: number;
            /** Format: uri */
            stargazers_url: string;
            /** Format: uri-template */
            statuses_url: string;
            /** Format: uri */
            subscribers_url: string;
            /** Format: uri */
            subscription_url: string;
            /** Format: uri */
            svn_url: string;
            /** Format: uri */
            tags_url: string;
            /** Format: uri */
            teams_url: string;
            topics: string[];
            /** Format: uri-template */
            trees_url: string;
            /** Format: date-time */
            updated_at: string;
            /** Format: uri */
            url: string;
            /**
             * @description Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
             * @default false
             */
            use_squash_pr_title_as_default?: boolean;
            /** @enum {string} */
            visibility: "public" | "private" | "internal";
            watchers: number;
            watchers_count: number;
            /** @description Whether to require contributors to sign off on web-based commits */
            web_commit_signoff_required?: boolean;
          } | null;
          sha: string;
          /** User */
          user: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: int64 */
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
        };
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        issue_url: string;
        labels: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        locked: boolean;
        /** @description Indicates whether maintainers can modify the pull request. */
        maintainer_can_modify?: boolean;
        merge_commit_sha: string | null;
        mergeable?: boolean | null;
        mergeable_state?: string;
        merged?: boolean | null;
        /** Format: date-time */
        merged_at: string | null;
        /** User */
        merged_by?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization" | "Mannequin";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        /** @description Number uniquely identifying the pull request within its repository. */
        number: number;
        /** Format: uri */
        patch_url: string;
        rebaseable?: boolean | null;
        requested_reviewers: OneOf<
          [
            {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization" | "Mannequin";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null,
            {
              deleted?: boolean;
              /** @description Description of the team */
              description: string | null;
              /** Format: uri */
              html_url: string;
              /** @description Unique identifier of the team */
              id: number;
              /** Format: uri-template */
              members_url: string;
              /** @description Name of the team */
              name: string;
              node_id: string;
              parent?: {
                /** @description Description of the team */
                description: string | null;
                /** Format: uri */
                html_url: string;
                /** @description Unique identifier of the team */
                id: number;
                /** Format: uri-template */
                members_url: string;
                /** @description Name of the team */
                name: string;
                node_id: string;
                /** @description Permission that the team will have for its repositories */
                permission: string;
                /** @enum {string} */
                privacy: "open" | "closed" | "secret";
                /** Format: uri */
                repositories_url: string;
                slug: string;
                /**
                 * Format: uri
                 * @description URL for the team
                 */
                url: string;
              } | null;
              /** @description Permission that the team will have for its repositories */
              permission: string;
              /** @enum {string} */
              privacy: "open" | "closed" | "secret";
              /** Format: uri */
              repositories_url: string;
              slug: string;
              /**
               * Format: uri
               * @description URL for the team
               */
              url: string;
            },
          ]
        >[];
        requested_teams: {
          deleted?: boolean;
          /** @description Description of the team */
          description?: string | null;
          /** Format: uri */
          html_url?: string;
          /** @description Unique identifier of the team */
          id: number;
          /** Format: uri-template */
          members_url?: string;
          /** @description Name of the team */
          name: string;
          node_id?: string;
          parent?: {
            /** @description Description of the team */
            description: string | null;
            /** Format: uri */
            html_url: string;
            /** @description Unique identifier of the team */
            id: number;
            /** Format: uri-template */
            members_url: string;
            /** @description Name of the team */
            name: string;
            node_id: string;
            /** @description Permission that the team will have for its repositories */
            permission: string;
            /** @enum {string} */
            privacy: "open" | "closed" | "secret";
            /** Format: uri */
            repositories_url: string;
            slug: string;
            /**
             * Format: uri
             * @description URL for the team
             */
            url: string;
          } | null;
          /** @description Permission that the team will have for its repositories */
          permission?: string;
          /** @enum {string} */
          privacy?: "open" | "closed" | "secret";
          /** Format: uri */
          repositories_url?: string;
          slug?: string;
          /**
           * Format: uri
           * @description URL for the team
           */
          url?: string;
        }[];
        /** Format: uri-template */
        review_comment_url: string;
        review_comments?: number;
        /** Format: uri */
        review_comments_url: string;
        /**
         * @description State of this Pull Request. Either `open` or `closed`.
         * @enum {string}
         */
        state: "open" | "closed";
        /** Format: uri */
        statuses_url: string;
        /** @description The title of the pull request. */
        title: string;
        /** Format: date-time */
        updated_at: string;
        /** Format: uri */
        url: string;
        /** User */
        user: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          /** Format: int64 */
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization" | "Mannequin";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
      };
      repository: components["schemas"]["repository-webhooks"];
      sender: components["schemas"]["simple-user"];
    };
    /** @description The pull request number. */
    webhooks_number: number;
    /** pull_request auto_merge_disabled event */
    "webhook-pull-request-auto-merge-disabled": {
      /** @enum {string} */
      action: "auto_merge_disabled";
      enterprise?: components["schemas"]["enterprise-webhooks"];
      installation?: components["schemas"]["simple-installation"];
      number: number;
      organization?: components["schemas"]["organization-simple-webhooks"];
      /** Pull Request */
      pull_request: {
        _links: {
          /** Link */
          comments: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          commits: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          html: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          issue: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          review_comment: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          review_comments: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          self: {
            /** Format: uri-template */
            href: string;
          };
          /** Link */
          statuses: {
            /** Format: uri-template */
            href: string;
          };
        };
        /** @enum {string|null} */
        active_lock_reason:
          | "resolved"
          | "off-topic"
          | "too heated"
          | "spam"
          | null;
        additions?: number;
        /** User */
        assignee: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        assignees: ({
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
        } | null)[];
        /**
         * AuthorAssociation
         * @description How the author is associated with the repository.
         * @enum {string}
         */
        author_association:
          | "COLLABORATOR"
          | "CONTRIBUTOR"
          | "FIRST_TIMER"
          | "FIRST_TIME_CONTRIBUTOR"
          | "MANNEQUIN"
          | "MEMBER"
          | "NONE"
          | "OWNER";
        /**
         * PullRequestAutoMerge
         * @description The status of auto merging a pull request.
         */
        auto_merge: {
          /** @description Commit message for the merge commit. */
          commit_message: string | null;
          /** @description Title for the merge commit message. */
          commit_title: string | null;
          /** User */
          enabled_by: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          /**
           * @description The merge method to use.
           * @enum {string}
           */
          merge_method: "merge" | "squash" | "rebase";
        } | null;
        base: {
          label: string;
          ref: string;
          /**
           * Repository
           * @description A git repository
           */
          repo: {
            /**
             * @description Whether to allow auto-merge for pull requests.
             * @default false
             */
            allow_auto_merge?: boolean;
            /** @description Whether to allow private forks */
            allow_forking?: boolean;
            /**
             * @description Whether to allow merge commits for pull requests.
             * @default true
             */
            allow_merge_commit?: boolean;
            /**
             * @description Whether to allow rebase merges for pull requests.
             * @default true
             */
            allow_rebase_merge?: boolean;
            /**
             * @description Whether to allow squash merges for pull requests.
             * @default true
             */
            allow_squash_merge?: boolean;
            allow_update_branch?: boolean;
            /** Format: uri-template */
            archive_url: string;
            /**
             * @description Whether the repository is archived.
             * @default false
             */
            archived: boolean;
            /** Format: uri-template */
            assignees_url: string;
            /** Format: uri-template */
            blobs_url: string;
            /** Format: uri-template */
            branches_url: string;
            /** Format: uri */
            clone_url: string;
            /** Format: uri-template */
            collaborators_url: string;
            /** Format: uri-template */
            comments_url: string;
            /** Format: uri-template */
            commits_url: string;
            /** Format: uri-template */
            compare_url: string;
            /** Format: uri-template */
            contents_url: string;
            /** Format: uri */
            contributors_url: string;
            created_at: number | string;
            /** @description The default branch of the repository. */
            default_branch: string;
            /**
             * @description Whether to delete head branches when pull requests are merged
             * @default false
             */
            delete_branch_on_merge?: boolean;
            /** Format: uri */
            deployments_url: string;
            description: string | null;
            /** @description Returns whether or not this repository is disabled. */
            disabled?: boolean;
            /** Format: uri */
            downloads_url: string;
            /** Format: uri */
            events_url: string;
            fork: boolean;
            forks: number;
            forks_count: number;
            /** Format: uri */
            forks_url: string;
            full_name: string;
            /** Format: uri-template */
            git_commits_url: string;
            /** Format: uri-template */
            git_refs_url: string;
            /** Format: uri-template */
            git_tags_url: string;
            /** Format: uri */
            git_url: string;
            /**
             * @description Whether downloads are enabled.
             * @default true
             */
            has_downloads: boolean;
            /**
             * @description Whether issues are enabled.
             * @default true
             */
            has_issues: boolean;
            /**
             * @description Whether discussions are enabled.
             * @default false
             */
            has_discussions: boolean;
            has_pages: boolean;
            /**
             * @description Whether projects are enabled.
             * @default true
             */
            has_projects: boolean;
            /**
             * @description Whether the wiki is enabled.
             * @default true
             */
            has_wiki: boolean;
            homepage: string | null;
            /** Format: uri */
            hooks_url: string;
            /** Format: uri */
            html_url: string;
            /**
             * Format: int64
             * @description Unique identifier of the repository
             */
            id: number;
            is_template?: boolean;
            /** Format: uri-template */
            issue_comment_url: string;
            /** Format: uri-template */
            issue_events_url: string;
            /** Format: uri-template */
            issues_url: string;
            /** Format: uri-template */
            keys_url: string;
            /** Format: uri-template */
            labels_url: string;
            language: string | null;
            /** Format: uri */
            languages_url: string;
            /** License */
            license: {
              key: string;
              name: string;
              node_id: string;
              spdx_id: string;
              /** Format: uri */
              url: string | null;
            } | null;
            master_branch?: string;
            /**
             * @description The default value for a merge commit message.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `PR_BODY` - default to the pull request's body.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
            /**
             * @description The default value for a merge commit title.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
             * @enum {string}
             */
            merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
            /** Format: uri */
            merges_url: string;
            /** Format: uri-template */
            milestones_url: string;
            /** Format: uri */
            mirror_url: string | null;
            /** @description The name of the repository. */
            name: string;
            node_id: string;
            /** Format: uri-template */
            notifications_url: string;
            open_issues: number;
            open_issues_count: number;
            organization?: string;
            /** User */
            owner: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            permissions?: {
              admin: boolean;
              maintain?: boolean;
              pull: boolean;
              push: boolean;
              triage?: boolean;
            };
            /** @description Whether the repository is private or public. */
            private: boolean;
            public?: boolean;
            /** Format: uri-template */
            pulls_url: string;
            pushed_at: number | string | null;
            /** Format: uri-template */
            releases_url: string;
            role_name?: string | null;
            size: number;
            /**
             * @description The default value for a squash merge commit message:
             *
             * - `PR_BODY` - default to the pull request's body.
             * - `COMMIT_MESSAGES` - default to the branch's commit messages.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            squash_merge_commit_message?:
              | "PR_BODY"
              | "COMMIT_MESSAGES"
              | "BLANK";
            /**
             * @description The default value for a squash merge commit title:
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
             * @enum {string}
             */
            squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
            ssh_url: string;
            stargazers?: number;
            stargazers_count: number;
            /** Format: uri */
            stargazers_url: string;
            /** Format: uri-template */
            statuses_url: string;
            /** Format: uri */
            subscribers_url: string;
            /** Format: uri */
            subscription_url: string;
            /** Format: uri */
            svn_url: string;
            /** Format: uri */
            tags_url: string;
            /** Format: uri */
            teams_url: string;
            topics: string[];
            /** Format: uri-template */
            trees_url: string;
            /** Format: date-time */
            updated_at: string;
            /** Format: uri */
            url: string;
            /**
             * @description Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
             * @default false
             */
            use_squash_pr_title_as_default?: boolean;
            /** @enum {string} */
            visibility: "public" | "private" | "internal";
            watchers: number;
            watchers_count: number;
            /** @description Whether to require contributors to sign off on web-based commits */
            web_commit_signoff_required?: boolean;
          };
          sha: string;
          /** User */
          user: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: int64 */
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
        };
        body: string | null;
        changed_files?: number;
        /** Format: date-time */
        closed_at: string | null;
        comments?: number;
        /** Format: uri */
        comments_url: string;
        commits?: number;
        /** Format: uri */
        commits_url: string;
        /** Format: date-time */
        created_at: string;
        deletions?: number;
        /** Format: uri */
        diff_url: string;
        /** @description Indicates whether or not the pull request is a draft. */
        draft: boolean;
        head: {
          label: string;
          ref: string;
          /**
           * Repository
           * @description A git repository
           */
          repo: {
            /**
             * @description Whether to allow auto-merge for pull requests.
             * @default false
             */
            allow_auto_merge?: boolean;
            /** @description Whether to allow private forks */
            allow_forking?: boolean;
            /**
             * @description Whether to allow merge commits for pull requests.
             * @default true
             */
            allow_merge_commit?: boolean;
            /**
             * @description Whether to allow rebase merges for pull requests.
             * @default true
             */
            allow_rebase_merge?: boolean;
            /**
             * @description Whether to allow squash merges for pull requests.
             * @default true
             */
            allow_squash_merge?: boolean;
            allow_update_branch?: boolean;
            /** Format: uri-template */
            archive_url: string;
            /**
             * @description Whether the repository is archived.
             * @default false
             */
            archived: boolean;
            /** Format: uri-template */
            assignees_url: string;
            /** Format: uri-template */
            blobs_url: string;
            /** Format: uri-template */
            branches_url: string;
            /** Format: uri */
            clone_url: string;
            /** Format: uri-template */
            collaborators_url: string;
            /** Format: uri-template */
            comments_url: string;
            /** Format: uri-template */
            commits_url: string;
            /** Format: uri-template */
            compare_url: string;
            /** Format: uri-template */
            contents_url: string;
            /** Format: uri */
            contributors_url: string;
            created_at: number | string;
            /** @description The default branch of the repository. */
            default_branch: string;
            /**
             * @description Whether to delete head branches when pull requests are merged
             * @default false
             */
            delete_branch_on_merge?: boolean;
            /** Format: uri */
            deployments_url: string;
            description: string | null;
            /** @description Returns whether or not this repository is disabled. */
            disabled?: boolean;
            /** Format: uri */
            downloads_url: string;
            /** Format: uri */
            events_url: string;
            fork: boolean;
            forks: number;
            forks_count: number;
            /** Format: uri */
            forks_url: string;
            full_name: string;
            /** Format: uri-template */
            git_commits_url: string;
            /** Format: uri-template */
            git_refs_url: string;
            /** Format: uri-template */
            git_tags_url: string;
            /** Format: uri */
            git_url: string;
            /**
             * @description Whether downloads are enabled.
             * @default true
             */
            has_downloads: boolean;
            /**
             * @description Whether issues are enabled.
             * @default true
             */
            has_issues: boolean;
            has_pages: boolean;
            /**
             * @description Whether projects are enabled.
             * @default true
             */
            has_projects: boolean;
            /**
             * @description Whether the wiki is enabled.
             * @default true
             */
            has_wiki: boolean;
            /**
             * @description Whether discussions are enabled.
             * @default false
             */
            has_discussions: boolean;
            homepage: string | null;
            /** Format: uri */
            hooks_url: string;
            /** Format: uri */
            html_url: string;
            /**
             * Format: int64
             * @description Unique identifier of the repository
             */
            id: number;
            is_template?: boolean;
            /** Format: uri-template */
            issue_comment_url: string;
            /** Format: uri-template */
            issue_events_url: string;
            /** Format: uri-template */
            issues_url: string;
            /** Format: uri-template */
            keys_url: string;
            /** Format: uri-template */
            labels_url: string;
            language: string | null;
            /** Format: uri */
            languages_url: string;
            /** License */
            license: {
              key: string;
              name: string;
              node_id: string;
              spdx_id: string;
              /** Format: uri */
              url: string | null;
            } | null;
            master_branch?: string;
            /**
             * @description The default value for a merge commit message.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `PR_BODY` - default to the pull request's body.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            merge_commit_message?: "PR_BODY" | "PR_TITLE" | "BLANK";
            /**
             * @description The default value for a merge commit title.
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
             * @enum {string}
             */
            merge_commit_title?: "PR_TITLE" | "MERGE_MESSAGE";
            /** Format: uri */
            merges_url: string;
            /** Format: uri-template */
            milestones_url: string;
            /** Format: uri */
            mirror_url: string | null;
            /** @description The name of the repository. */
            name: string;
            node_id: string;
            /** Format: uri-template */
            notifications_url: string;
            open_issues: number;
            open_issues_count: number;
            organization?: string;
            /** User */
            owner: {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null;
            permissions?: {
              admin: boolean;
              maintain?: boolean;
              pull: boolean;
              push: boolean;
              triage?: boolean;
            };
            /** @description Whether the repository is private or public. */
            private: boolean;
            public?: boolean;
            /** Format: uri-template */
            pulls_url: string;
            pushed_at: number | string | null;
            /** Format: uri-template */
            releases_url: string;
            role_name?: string | null;
            size: number;
            /**
             * @description The default value for a squash merge commit message:
             *
             * - `PR_BODY` - default to the pull request's body.
             * - `COMMIT_MESSAGES` - default to the branch's commit messages.
             * - `BLANK` - default to a blank commit message.
             * @enum {string}
             */
            squash_merge_commit_message?:
              | "PR_BODY"
              | "COMMIT_MESSAGES"
              | "BLANK";
            /**
             * @description The default value for a squash merge commit title:
             *
             * - `PR_TITLE` - default to the pull request's title.
             * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
             * @enum {string}
             */
            squash_merge_commit_title?: "PR_TITLE" | "COMMIT_OR_PR_TITLE";
            ssh_url: string;
            stargazers?: number;
            stargazers_count: number;
            /** Format: uri */
            stargazers_url: string;
            /** Format: uri-template */
            statuses_url: string;
            /** Format: uri */
            subscribers_url: string;
            /** Format: uri */
            subscription_url: string;
            /** Format: uri */
            svn_url: string;
            /** Format: uri */
            tags_url: string;
            /** Format: uri */
            teams_url: string;
            topics: string[];
            /** Format: uri-template */
            trees_url: string;
            /** Format: date-time */
            updated_at: string;
            /** Format: uri */
            url: string;
            /**
             * @description Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
             * @default false
             */
            use_squash_pr_title_as_default?: boolean;
            /** @enum {string} */
            visibility: "public" | "private" | "internal";
            watchers: number;
            watchers_count: number;
            /** @description Whether to require contributors to sign off on web-based commits */
            web_commit_signoff_required?: boolean;
          };
          sha: string;
          /** User */
          user: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            /** Format: int64 */
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
        };
        /** Format: uri */
        html_url: string;
        id: number;
        /** Format: uri */
        issue_url: string;
        labels: {
          /** @description 6-character hex code, without the leading #, identifying the color */
          color: string;
          default: boolean;
          description: string | null;
          id: number;
          /** @description The name of the label. */
          name: string;
          node_id: string;
          /**
           * Format: uri
           * @description URL for the label
           */
          url: string;
        }[];
        locked: boolean;
        /** @description Indicates whether maintainers can modify the pull request. */
        maintainer_can_modify?: boolean;
        merge_commit_sha: string | null;
        mergeable?: boolean | null;
        mergeable_state?: string;
        merged?: boolean | null;
        /** Format: date-time */
        merged_at: string | null;
        /** User */
        merged_by?: {
          /** Format: uri */
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          /** Format: uri-template */
          events_url?: string;
          /** Format: uri */
          followers_url?: string;
          /** Format: uri-template */
          following_url?: string;
          /** Format: uri-template */
          gists_url?: string;
          gravatar_id?: string;
          /** Format: uri */
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          /** Format: uri */
          organizations_url?: string;
          /** Format: uri */
          received_events_url?: string;
          /** Format: uri */
          repos_url?: string;
          site_admin?: boolean;
          /** Format: uri-template */
          starred_url?: string;
          /** Format: uri */
          subscriptions_url?: string;
          /** @enum {string} */
          type?: "Bot" | "User" | "Organization";
          /** Format: uri */
          url?: string;
          user_view_type?: string;
        } | null;
        /**
         * Milestone
         * @description A collection of related issues and pull requests.
         */
        milestone: {
          /** Format: date-time */
          closed_at: string | null;
          closed_issues: number;
          /** Format: date-time */
          created_at: string;
          /** User */
          creator: {
            /** Format: uri */
            avatar_url?: string;
            deleted?: boolean;
            email?: string | null;
            /** Format: uri-template */
            events_url?: string;
            /** Format: uri */
            followers_url?: string;
            /** Format: uri-template */
            following_url?: string;
            /** Format: uri-template */
            gists_url?: string;
            gravatar_id?: string;
            /** Format: uri */
            html_url?: string;
            id: number;
            login: string;
            name?: string;
            node_id?: string;
            /** Format: uri */
            organizations_url?: string;
            /** Format: uri */
            received_events_url?: string;
            /** Format: uri */
            repos_url?: string;
            site_admin?: boolean;
            /** Format: uri-template */
            starred_url?: string;
            /** Format: uri */
            subscriptions_url?: string;
            /** @enum {string} */
            type?: "Bot" | "User" | "Organization";
            /** Format: uri */
            url?: string;
            user_view_type?: string;
          } | null;
          description: string | null;
          /** Format: date-time */
          due_on: string | null;
          /** Format: uri */
          html_url: string;
          id: number;
          /** Format: uri */
          labels_url: string;
          node_id: string;
          /** @description The number of the milestone. */
          number: number;
          open_issues: number;
          /**
           * @description The state of the milestone.
           * @enum {string}
           */
          state: "open" | "closed";
          /** @description The title of the milestone. */
          title: string;
          /** Format: date-time */
          updated_at: string;
          /** Format: uri */
          url: string;
        } | null;
        node_id: string;
        /** @description Number uniquely identifying the pull request within its repository. */
        number: number;
        /** Format: uri */
        patch_url: string;
        rebaseable?: boolean | null;
        requested_reviewers: OneOf<
          [
            {
              /** Format: uri */
              avatar_url?: string;
              deleted?: boolean;
              email?: string | null;
              /** Format: uri-template */
              events_url?: string;
              /** Format: uri */
              followers_url?: string;
              /** Format: uri-template */
              following_url?: string;
              /** Format: uri-template */
              gists_url?: string;
              gravatar_id?: string;
              /** Format: uri */
              html_url?: string;
              id: number;
              login: string;
              name?: string;
              node_id?: string;
              /** Format: uri */
              organizations_url?: string;
              /** Format: uri */
              received_events_url?: string;
              /** Format: uri */
              repos_url?: string;
              site_admin?: boolean;
              /** Format: uri-template */
              starred_url?: string;
              /** Format: uri */
              subscriptions_url?: string;
              /** @enum {string} */
              type?: "Bot" | "User" | "Organization" | "Mannequin";
              /** Format: uri */
              url?: string;
              user_view_type?: string;
            } | null,
            {
              deleted?: boolean;
              /** @description Description of the team */
              description: string | null;
              /** Format: uri */
              html_url: string;
              /** @description Unique identifier of the team */
              id: number;
              /** Format: uri-template */
              members_url: string;
              /** @description Name of the team */
              name: string;
              node_id: string;
              parent?: {
                /** @description Description of the team */
                description: string | null;
                /** Format: uri */
                html_url: string;
                /**