import { type GetUserOctokitWithStateInterface } from "./methods/get-user-octokit.js";
import { type GetWebFlowAuthorizationUrlInterface } from "./methods/get-web-flow-authorization-url.js";
import { type CreateTokenInterface } from "./methods/create-token.js";
import { type CheckTokenInterface } from "./methods/check-token.js";
import { type ResetTokenInterface } from "./methods/reset-token.js";
import { type RefreshTokenInterface } from "./methods/refresh-token.js";
import { type ScopeTokenInterface } from "./methods/scope-token.js";
import { type DeleteTokenInterface } from "./methods/delete-token.js";
import { type DeleteAuthorizationInterface } from "./methods/delete-authorization.js";
import type { AddEventHandler, ClientType, ClientTypeFromOptions, ConstructorOptions, OctokitTypeFromOptions, Options } from "./types.js";
export type { HandlerOptions, OctokitRequest, OctokitResponse, } from "./middleware/types.js";
export { handleRequest } from "./middleware/handle-request.js";
export { unknownRouteResponse } from "./middleware/unknown-route-response.js";
export { createNodeMiddleware } from "./middleware/node/index.js";
export { sendResponse as sendNodeResponse } from "./middleware/node/send-response.js";
export { createWebWorkerHandler } from "./middleware/web-worker/index.js";
export { createAWSLambdaAPIGatewayV2Handler } from "./middleware/aws-lambda/api-gateway-v2.js";
export type { GetUserOctokitWithStateInterface } from "./methods/get-user-octokit.js";
export type { GetWebFlowAuthorizationUrlInterface } from "./methods/get-web-flow-authorization-url.js";
export type { CreateTokenInterface } from "./methods/create-token.js";
export type { CheckTokenInterface } from "./methods/check-token.js";
export type { ResetTokenInterface } from "./methods/reset-token.js";
export type { RefreshTokenInterface } from "./methods/refresh-token.js";
export type { ScopeTokenInterface } from "./methods/scope-token.js";
export type { DeleteTokenInterface } from "./methods/delete-token.js";
export type { DeleteAuthorizationInterface } from "./methods/delete-authorization.js";
export type { AddEventHandler, ClientType, ClientTypeFromOptions, ConstructorOptions, OctokitTypeFromOptions, Options, } from "./types.js";
type Constructor<T> = new (...args: any[]) => T;
export declare class OAuthApp<TOptions extends Options<ClientType> = Options<"oauth-app">> {
    static VERSION: string;
    static defaults<TDefaults extends Options<ClientType>, S extends Constructor<OAuthApp<TDefaults>>>(this: S, defaults: TDefaults): ({
        new (...args: any[]): {
            type: ClientTypeFromOptions<TDefaults>;
            on: AddEventHandler<TDefaults>;
            octokit: OctokitTypeFromOptions<TDefaults>;
            getUserOctokit: GetUserOctokitWithStateInterface<ClientTypeFromOptions<TDefaults>>;
            getWebFlowAuthorizationUrl: GetWebFlowAuthorizationUrlInterface<ClientTypeFromOptions<TDefaults>>;
            createToken: CreateTokenInterface<ClientTypeFromOptions<TDefaults>>;
            checkToken: CheckTokenInterface<ClientTypeFromOptions<TDefaults>>;
            resetToken: ResetTokenInterface<ClientTypeFromOptions<TDefaults>>;
            refreshToken: RefreshTokenInterface;
            scopeToken: ScopeTokenInterface;
            deleteToken: DeleteTokenInterface;
            deleteAuthorization: DeleteAuthorizationInterface;
        };
    } & S) & typeof this;
    constructor(options: ConstructorOptions<TOptions>);
    type: ClientTypeFromOptions<TOptions>;
    on: AddEventHandler<TOptions>;
    octokit: OctokitTypeFromOptions<TOptions>;
    getUserOctokit: GetUserOctokitWithStateInterface<ClientTypeFromOptions<TOptions>>;
    getWebFlowAuthorizationUrl: GetWebFlowAuthorizationUrlInterface<ClientTypeFromOptions<TOptions>>;
    createToken: CreateTokenInterface<ClientTypeFromOptions<TOptions>>;
    checkToken: CheckTokenInterface<ClientTypeFromOptions<TOptions>>;
    resetToken: ResetTokenInterface<ClientTypeFromOptions<TOptions>>;
    refreshToken: RefreshTokenInterface;
    scopeToken: ScopeTokenInterface;
    deleteToken: DeleteTokenInterface;
    deleteAuthorization: DeleteAuthorizationInterface;
}
