import type { Octokit } from "@octokit/core";
import type { App } from "./index.js";
import type { EachInstallationFunction, EachInstallationInterface } from "./types.js";
export declare function eachInstallationFactory(app: App): EachInstallationInterface<Octokit>;
export declare function eachInstallation(app: App, callback: EachInstallationFunction<Octokit>): Promise<void>;
export declare function eachInstallationIterator(app: App): {
    [Symbol.asyncIterator](): AsyncGenerator<{
        octokit: Octokit;
        installation: {
            id: number;
            account: ({
                name?: string | null;
                email?: string | null;
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string | null;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
                starred_at?: string;
            } & {
                description?: string | null;
                html_url: string;
                website_url?: string | null;
                id: number;
                node_id: string;
                name: string;
                slug: string;
                created_at: string | null;
                updated_at: string | null;
                avatar_url: string;
            }) | null;
            repository_selection: "all" | "selected";
            access_tokens_url: string;
            repositories_url: string;
            html_url: string;
            app_id: number;
            target_id: number;
            target_type: string;
            permissions: {
                actions?: "read" | "write";
                administration?: "read" | "write";
                checks?: "read" | "write";
                contents?: "read" | "write";
                deployments?: "read" | "write";
                environments?: "read" | "write";
                issues?: "read" | "write";
                metadata?: "read" | "write";
                packages?: "read" | "write";
                pages?: "read" | "write";
                pull_requests?: "read" | "write";
                repository_hooks?: "read" | "write";
                repository_projects?: "read" | "write" | "admin";
                secret_scanning_alerts?: "read" | "write";
                secrets?: "read" | "write";
                security_events?: "read" | "write";
                single_file?: "read" | "write";
                statuses?: "read" | "write";
                vulnerability_alerts?: "read" | "write";
                workflows?: "write";
                members?: "read" | "write";
                organization_administration?: "read" | "write";
                organization_custom_roles?: "read" | "write";
                organization_announcement_banners?: "read" | "write";
                organization_hooks?: "read" | "write";
                organization_personal_access_tokens?: "read" | "write";
                organization_personal_access_token_requests?: "read" | "write";
                organization_plan?: "read";
                organization_projects?: "read" | "write" | "admin";
                organization_packages?: "read" | "write";
                organization_secrets?: "read" | "write";
                organization_self_hosted_runners?: "read" | "write";
                organization_user_blocking?: "read" | "write";
                team_discussions?: "read" | "write";
            };
            events: string[];
            created_at: string;
            updated_at: string;
            single_file_name: string | null;
            has_multiple_single_files?: boolean;
            single_file_paths?: string[];
            app_slug: string;
            suspended_by: {
                name?: string | null;
                email?: string | null;
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string | null;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
                starred_at?: string;
            } | null;
            suspended_at: string | null;
            contact_email?: string | null;
        };
    }, void, unknown>;
};
