/* auto-generated by NAPI-RS */
/* eslint-disable */

export class ModuleConfig {
  constructor()
  /**
   * Sets a flag to whether DWARF debug sections are generated for this
   * module.
   *
   * By default this flag is `false`. Note that any emitted DWARF is
   * currently wildly incorrect and buggy, and is also larger than the wasm
   * itself!
   */
  generateDwarf(generateDwarf: boolean): this
  /**
   * Sets a flag to whether the custom "name" section is generated for this
   * module.
   *
   * The "name" section contains symbol names for the module, functions, and
   * locals. When enabled, stack traces will use these names, instead of
   * `wasm-function[123]`.
   *
   * By default this flag is `true`.
   */
  generateNameSection(generateNameSection: boolean): this
  /**
   * Sets a flag to whether synthetic debugging names are generated for
   * anonymous locals/functions/etc when parsing and running passes for this
   * module.
   *
   * By default this flag is `false`, and it will generate quite a few names
   * if enabled!
   */
  generateSyntheticNamesForAnonymousItems(generateSyntheticNamesForAnonymousItems: boolean): this
  /**
   * Indicates whether the module, after parsing, performs strict validation
   * of the wasm module to adhere with the current version of the wasm
   * specification.
   *
   * This can be expensive for some modules and strictly isn't required to
   * create a `Module` from a wasm file. This includes checks such as "atomic
   * instructions require a shared memory".
   *
   * By default this flag is `true`
   */
  strictValidate(strictValidate: boolean): this
  /**
   * Indicates whether the module will have the "producers" custom section
   * which preserves the original producers and also includes `walrus`.
   *
   * This is generally used for telemetry in browsers, but for otherwise tiny
   * wasm binaries can add some size to the binary.
   *
   * By default this flag is `true`
   */
  generateProducersSection(generateProducersSection: boolean): this
  /**
   * Indicates whether this module is allowed to use only stable WebAssembly
   * features or not.
   *
   * This is currently used to disable some validity checks required by the
   * WebAssembly specification. It's not religiously adhered to throughout
   * the codebase, even if set to `true` some unstable features may still be
   * allowed.
   *
   * By default this flag is `false`
   */
  onlyStableFeatures(onlyStableFeatures: boolean): this
  /**
   * Sets a flag to whether code transform is preverved during parsing.
   *
   * By default this flag is `false`.
   */
  preserveCodeTransform(preserve: boolean): this
  parse(binary: Uint8Array): WasmModule
}

export class WasmModule {
  /**
   * Construct a new module from the given path with the default
   * configuration.
   */
  static fromPath(path: string): WasmModule
  /** Construct a new module from the given path and configuration. */
  static fromFileWithConfig(path: string, config: ModuleConfig): WasmModule
  /** Emit this module into an in-memory wasm buffer. */
  emitWasm(demangle: boolean): Uint8Array
}

