var _WebAssembly$2 = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
var ENVIRONMENT_IS_NODE = null !== null;
function getPostMessage(options) {
    return typeof (options === null || options === void 0 ? void 0 : options.postMessage) === 'function'
        ? options.postMessage
        : typeof postMessage === 'function'
            ? postMessage
            : undefined;
}
function serizeErrorToBuffer(sab, code, error) {
    var i32array = new Int32Array(sab);
    Atomics.store(i32array, 0, code);
    if (code > 1 && error) {
        var name_1 = error.name;
        var message = error.message;
        var stack = error.stack;
        var nameBuffer = new TextEncoder().encode(name_1);
        var messageBuffer = new TextEncoder().encode(message);
        var stackBuffer = new TextEncoder().encode(stack);
        Atomics.store(i32array, 1, nameBuffer.length);
        Atomics.store(i32array, 2, messageBuffer.length);
        Atomics.store(i32array, 3, stackBuffer.length);
        var buffer = new Uint8Array(sab);
        buffer.set(nameBuffer, 16);
        buffer.set(messageBuffer, 16 + nameBuffer.length);
        buffer.set(stackBuffer, 16 + nameBuffer.length + messageBuffer.length);
    }
}
function deserizeErrorFromBuffer(sab) {
    var _a, _b;
    var i32array = new Int32Array(sab);
    var status = Atomics.load(i32array, 0);
    if (status <= 1) {
        return null;
    }
    var nameLength = Atomics.load(i32array, 1);
    var messageLength = Atomics.load(i32array, 2);
    var stackLength = Atomics.load(i32array, 3);
    var buffer = new Uint8Array(sab);
    var nameBuffer = buffer.slice(16, 16 + nameLength);
    var messageBuffer = buffer.slice(16 + nameLength, 16 + nameLength + messageLength);
    var stackBuffer = buffer.slice(16 + nameLength + messageLength, 16 + nameLength + messageLength + stackLength);
    var name = new TextDecoder().decode(nameBuffer);
    var message = new TextDecoder().decode(messageBuffer);
    var stack = new TextDecoder().decode(stackBuffer);
    var ErrorConstructor = (_a = globalThis[name]) !== null && _a !== void 0 ? _a : (name === 'RuntimeError' ? ((_b = _WebAssembly$2.RuntimeError) !== null && _b !== void 0 ? _b : Error) : Error);
    var error = new ErrorConstructor(message);
    Object.defineProperty(error, 'stack', {
        value: stack,
        writable: true,
        enumerable: false,
        configurable: true
    });
    return error;
}
/** @public */
function isSharedArrayBuffer(value) {
    return ((typeof SharedArrayBuffer === 'function' && value instanceof SharedArrayBuffer) ||
        (Object.prototype.toString.call(value) === '[object SharedArrayBuffer]'));
}
/** @public */
function isTrapError(e) {
    try {
        return e instanceof _WebAssembly$2.RuntimeError;
    }
    catch (_) {
        return false;
    }
}

function createMessage(type, payload) {
    return {
        __emnapi__: {
            type: type,
            payload: payload
        }
    };
}

var WASI_THREADS_MAX_TID = 0x1FFFFFFF;
function checkSharedWasmMemory(wasmMemory) {
    if (wasmMemory) {
        if (!isSharedArrayBuffer(wasmMemory.buffer)) {
            throw new Error('Multithread features require shared wasm memory. ' +
                'Try to compile with `-matomics -mbulk-memory` and use `--import-memory --shared-memory` during linking, ' +
                'then create WebAssembly.Memory with `shared: true` option');
        }
    }
    else {
        if (typeof SharedArrayBuffer === 'undefined') {
            throw new Error('Current environment does not support SharedArrayBuffer, threads are not available!');
        }
    }
}
function getReuseWorker(value) {
    var _a;
    if (typeof value === 'boolean') {
        return value ? { size: 0, strict: false } : false;
    }
    if (typeof value === 'number') {
        if (!(value >= 0)) {
            throw new RangeError('reuseWorker: size must be a non-negative integer');
        }
        return { size: value, strict: false };
    }
    if (!value) {
        return false;
    }
    var size = (_a = Number(value.size)) !== null && _a !== void 0 ? _a : 0;
    var strict = Boolean(value.strict);
    if (!(size > 0) && strict) {
        throw new RangeError('reuseWorker: size must be set to positive integer if strict is set to true');
    }
    return { size: size, strict: strict };
}
var nextWorkerID = 0;
/** @public */
var ThreadManager = /*#__PURE__*/ (function () {
    function ThreadManager(options) {
        var _a;
        this.unusedWorkers = [];
        this.runningWorkers = [];
        this.pthreads = Object.create(null);
        this.wasmModule = null;
        this.wasmMemory = null;
        this.messageEvents = new WeakMap();
        if (!options) {
            throw new TypeError('ThreadManager(): options is not provided');
        }
        if ('childThread' in options) {
            this._childThread = Boolean(options.childThread);
        }
        else {
            this._childThread = false;
        }
        if (this._childThread) {
            this._onCreateWorker = undefined;
            this._reuseWorker = false;
            this._beforeLoad = undefined;
        }
        else {
            this._onCreateWorker = options.onCreateWorker;
            this._reuseWorker = getReuseWorker(options.reuseWorker);
            this._beforeLoad = options.beforeLoad;
        }
        this.printErr = (_a = options.printErr) !== null && _a !== void 0 ? _a : console.error.bind(console);
    }
    Object.defineProperty(ThreadManager.prototype, "nextWorkerID", {
        get: function () { return nextWorkerID; },
        enumerable: false,
        configurable: true
    });
    ThreadManager.prototype.init = function () {
        if (!this._childThread) {
            this.initMainThread();
        }
    };
    ThreadManager.prototype.initMainThread = function () {
        this.preparePool();
    };
    ThreadManager.prototype.preparePool = function () {
        if (this._reuseWorker) {
            if (this._reuseWorker.size) {
                var pthreadPoolSize = this._reuseWorker.size;
                while (pthreadPoolSize--) {
                    this.allocateUnusedWorker();
                }
            }
        }
    };
    ThreadManager.prototype.shouldPreloadWorkers = function () {
        return !this._childThread && this._reuseWorker && this._reuseWorker.size > 0;
    };
    ThreadManager.prototype.loadWasmModuleToAllWorkers = function () {
        var _this_1 = this;
        var promises = Array(this.unusedWorkers.length);
        var _loop_1 = function (i) {
            var worker = this_1.unusedWorkers[i];
            promises[i] = this_1.loadWasmModuleToWorker(worker).then(function (w) {
                return w;
            }, function (e) {
                throw e;
            });
        };
        var this_1 = this;
        for (var i = 0; i < this.unusedWorkers.length; ++i) {
            _loop_1(i);
        }
        return Promise.all(promises).catch(function (err) {
            _this_1.terminateAllThreads();
            throw err;
        });
    };
    ThreadManager.prototype.preloadWorkers = function () {
        if (this.shouldPreloadWorkers()) {
            return this.loadWasmModuleToAllWorkers();
        }
        return Promise.resolve([]);
    };
    ThreadManager.prototype.setup = function (wasmModule, wasmMemory) {
        this.wasmModule = wasmModule;
        this.wasmMemory = wasmMemory;
    };
    ThreadManager.prototype.markId = function (worker) {
        if (worker.__emnapi_tid)
            return worker.__emnapi_tid;
        var tid = nextWorkerID + 43;
        nextWorkerID = (nextWorkerID + 1) % (WASI_THREADS_MAX_TID - 42);
        this.pthreads[tid] = worker;
        worker.__emnapi_tid = tid;
        return tid;
    };
    ThreadManager.prototype.returnWorkerToPool = function (worker) {
        var tid = worker.__emnapi_tid;
        if (tid !== undefined) {
            delete this.pthreads[tid];
        }
        this.unusedWorkers.push(worker);
        this.runningWorkers.splice(this.runningWorkers.indexOf(worker), 1);
        delete worker.__emnapi_tid;
    };
    ThreadManager.prototype.loadWasmModuleToWorker = function (worker, sab) {
        var _this_1 = this;
        if (worker.whenLoaded)
            return worker.whenLoaded;
        var err = this.printErr;
        var beforeLoad = this._beforeLoad;
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        var _this = this;
        worker.whenLoaded = new Promise(function (resolve, reject) {
            var handleError = function (e) {
                var message = 'worker sent an error!';
                if (worker.__emnapi_tid !== undefined) {
                    message = 'worker (tid = ' + worker.__emnapi_tid + ') sent an error!';
                }
                err(message + ' ' + e.message);
                if (e.message.indexOf('RuntimeError') !== -1 || e.message.indexOf('unreachable') !== -1) {
                    try {
                        _this.terminateAllThreads();
                    }
                    catch (_) { }
                }
                reject(e);
                throw e;
            };
            var handleMessage = function (data) {
                if (data.__emnapi__) {
                    var type = data.__emnapi__.type;
                    var payload = data.__emnapi__.payload;
                    if (type === 'loaded') {
                        worker.loaded = true;
                        resolve(worker);
                        // if (payload.err) {
                        //   err('failed to load in child thread: ' + (payload.err.message || payload.err))
                        // }
                    }
                    else if (type === 'cleanup-thread') {
                        if (payload.tid in _this_1.pthreads) {
                            _this_1.cleanThread(worker, payload.tid);
                        }
                    }
                }
            };
            worker.onmessage = function (e) {
                handleMessage(e.data);
                _this_1.fireMessageEvent(worker, e);
            };
            worker.onerror = handleError;
            if (typeof beforeLoad === 'function') {
                beforeLoad(worker);
            }
            try {
                worker.postMessage(createMessage('load', {
                    wasmModule: _this_1.wasmModule,
                    wasmMemory: _this_1.wasmMemory,
                    sab: sab
                }));
            }
            catch (err) {
                checkSharedWasmMemory(_this_1.wasmMemory);
                throw err;
            }
        });
        return worker.whenLoaded;
    };
    ThreadManager.prototype.allocateUnusedWorker = function () {
        var _onCreateWorker = this._onCreateWorker;
        if (typeof _onCreateWorker !== 'function') {
            throw new TypeError('`options.onCreateWorker` is not provided');
        }
        var worker = _onCreateWorker({ type: 'thread', name: 'emnapi-pthread' });
        this.unusedWorkers.push(worker);
        return worker;
    };
    ThreadManager.prototype.getNewWorker = function (sab) {
        if (this._reuseWorker) {
            if (this.unusedWorkers.length === 0) {
                if (this._reuseWorker.strict) {
                    {
                        var err = this.printErr;
                        err('Tried to spawn a new thread, but the thread pool is exhausted.\n' +
                            'This might result in a deadlock unless some threads eventually exit or the code explicitly breaks out to the event loop.');
                        return;
                    }
                }
                var worker_1 = this.allocateUnusedWorker();
                // eslint-disable-next-line @typescript-eslint/no-floating-promises
                this.loadWasmModuleToWorker(worker_1, sab);
            }
            return this.unusedWorkers.pop();
        }
        var worker = this.allocateUnusedWorker();
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.loadWasmModuleToWorker(worker, sab);
        return this.unusedWorkers.pop();
    };
    ThreadManager.prototype.cleanThread = function (worker, tid, force) {
        if (!force && this._reuseWorker) {
            this.returnWorkerToPool(worker);
        }
        else {
            delete this.pthreads[tid];
            var index = this.runningWorkers.indexOf(worker);
            if (index !== -1) {
                this.runningWorkers.splice(index, 1);
            }
            this.terminateWorker(worker);
            delete worker.__emnapi_tid;
        }
    };
    ThreadManager.prototype.terminateWorker = function (worker) {
        var _this_1 = this;
        var _a;
        var tid = worker.__emnapi_tid;
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        worker.terminate();
        (_a = this.messageEvents.get(worker)) === null || _a === void 0 ? void 0 : _a.clear();
        this.messageEvents.delete(worker);
        worker.onmessage = function (e) {
            if (e.data.__emnapi__) {
                var err = _this_1.printErr;
                err('received "' + e.data.__emnapi__.type + '" command from terminated worker: ' + tid);
            }
        };
    };
    ThreadManager.prototype.terminateAllThreads = function () {
        for (var i = 0; i < this.runningWorkers.length; ++i) {
            this.terminateWorker(this.runningWorkers[i]);
        }
        for (var i = 0; i < this.unusedWorkers.length; ++i) {
            this.terminateWorker(this.unusedWorkers[i]);
        }
        this.unusedWorkers = [];
        this.runningWorkers = [];
        this.pthreads = Object.create(null);
        this.preparePool();
    };
    ThreadManager.prototype.addMessageEventListener = function (worker, onMessage) {
        var listeners = this.messageEvents.get(worker);
        if (!listeners) {
            listeners = new Set();
            this.messageEvents.set(worker, listeners);
        }
        listeners.add(onMessage);
        return function () {
            listeners === null || listeners === void 0 ? void 0 : listeners.delete(onMessage);
        };
    };
    ThreadManager.prototype.fireMessageEvent = function (worker, e) {
        var listeners = this.messageEvents.get(worker);
        if (!listeners)
            return;
        var err = this.printErr;
        listeners.forEach(function (listener) {
            try {
                listener(e);
            }
            catch (e) {
                err(e.stack);
            }
        });
    };
    return ThreadManager;
}());

var kIsProxy = Symbol('kIsProxy');
/** @public */
function createInstanceProxy(instance, memory) {
    if (instance[kIsProxy])
        return instance;
    // https://github.com/nodejs/help/issues/4102
    var originalExports = instance.exports;
    var createHandler = function (target) {
        var handlers = [
            'apply',
            'construct',
            'defineProperty',
            'deleteProperty',
            'get',
            'getOwnPropertyDescriptor',
            'getPrototypeOf',
            'has',
            'isExtensible',
            'ownKeys',
            'preventExtensions',
            'set',
            'setPrototypeOf'
        ];
        var handler = {};
        var _loop_1 = function (i) {
            var name_1 = handlers[i];
            handler[name_1] = function () {
                var args = Array.prototype.slice.call(arguments, 1);
                args.unshift(target);
                return Reflect[name_1].apply(Reflect, args);
            };
        };
        for (var i = 0; i < handlers.length; i++) {
            _loop_1(i);
        }
        return handler;
    };
    var handler = createHandler(originalExports);
    var _initialize = function () { };
    var _start = function () { return 0; };
    handler.get = function (_target, p, receiver) {
        var _a;
        if (p === 'memory') {
            return (_a = (typeof memory === 'function' ? memory() : memory)) !== null && _a !== void 0 ? _a : Reflect.get(originalExports, p, receiver);
        }
        if (p === '_initialize') {
            return p in originalExports ? _initialize : undefined;
        }
        if (p === '_start') {
            return p in originalExports ? _start : undefined;
        }
        return Reflect.get(originalExports, p, receiver);
    };
    handler.has = function (_target, p) {
        if (p === 'memory')
            return true;
        return Reflect.has(originalExports, p);
    };
    var exportsProxy = new Proxy(Object.create(null), handler);
    return new Proxy(instance, {
        get: function (target, p, receiver) {
            if (p === 'exports') {
                return exportsProxy;
            }
            if (p === kIsProxy) {
                return true;
            }
            return Reflect.get(target, p, receiver);
        }
    });
}

var patchedWasiInstances = new WeakMap();
/** @public */
var WASIThreads = /*#__PURE__*/ (function () {
    function WASIThreads(options) {
        var _this_1 = this;
        if (!options) {
            throw new TypeError('WASIThreads(): options is not provided');
        }
        if (!options.wasi) {
            throw new TypeError('WASIThreads(): options.wasi is not provided');
        }
        patchedWasiInstances.set(this, new WeakSet());
        var wasi = options.wasi;
        patchWasiInstance(this, wasi);
        this.wasi = wasi;
        if ('childThread' in options) {
            this.childThread = Boolean(options.childThread);
        }
        else {
            this.childThread = false;
        }
        this.PThread = undefined;
        if ('threadManager' in options) {
            if (typeof options.threadManager === 'function') {
                this.PThread = options.threadManager();
            }
            else {
                this.PThread = options.threadManager;
            }
        }
        else {
            if (!this.childThread) {
                this.PThread = new ThreadManager(options);
                this.PThread.init();
            }
        }
        var waitThreadStart = false;
        if ('waitThreadStart' in options) {
            waitThreadStart = typeof options.waitThreadStart === 'number' ? options.waitThreadStart : Boolean(options.waitThreadStart);
        }
        var postMessage = getPostMessage(options);
        if (this.childThread && typeof postMessage !== 'function') {
            throw new TypeError('options.postMessage is not a function');
        }
        this.postMessage = postMessage;
        var wasm64 = Boolean(options.wasm64);
        var onMessage = function (e) {
            if (e.data.__emnapi__) {
                var type = e.data.__emnapi__.type;
                var payload = e.data.__emnapi__.payload;
                if (type === 'spawn-thread') {
                    threadSpawn(payload.startArg, payload.errorOrTid);
                }
                else if (type === 'terminate-all-threads') {
                    _this_1.terminateAllThreads();
                }
            }
        };
        var threadSpawn = function (startArg, errorOrTid) {
            var _a;
            var EAGAIN = 6;
            var isNewABI = errorOrTid !== undefined;
            try {
                checkSharedWasmMemory(_this_1.wasmMemory);
            }
            catch (err) {
                (_a = _this_1.PThread) === null || _a === void 0 ? void 0 : _a.printErr(err.stack);
                if (isNewABI) {
                    var struct_1 = new Int32Array(_this_1.wasmMemory.buffer, errorOrTid, 2);
                    Atomics.store(struct_1, 0, 1);
                    Atomics.store(struct_1, 1, EAGAIN);
                    Atomics.notify(struct_1, 1);
                    return 1;
                }
                else {
                    return -6;
                }
            }
            if (!isNewABI) {
                var malloc = _this_1.wasmInstance.exports.malloc;
                errorOrTid = wasm64 ? Number(malloc(BigInt(8))) : malloc(8);
                if (!errorOrTid) {
                    return -48; /* ENOMEM */
                }
            }
            var _free = _this_1.wasmInstance.exports.free;
            var free = wasm64 ? function (ptr) { _free(BigInt(ptr)); } : _free;
            var struct = new Int32Array(_this_1.wasmMemory.buffer, errorOrTid, 2);
            Atomics.store(struct, 0, 0);
            Atomics.store(struct, 1, 0);
            if (_this_1.childThread) {
                postMessage(createMessage('spawn-thread', {
                    startArg: startArg,
                    errorOrTid: errorOrTid
                }));
                Atomics.wait(struct, 1, 0);
                var isError = Atomics.load(struct, 0);
                var result = Atomics.load(struct, 1);
                if (isNewABI) {
                    return isError;
                }
                free(errorOrTid);
                return isError ? -result : result;
            }
            var shouldWait = waitThreadStart || (waitThreadStart === 0);
            var sab;
            if (shouldWait) {
                sab = new Int32Array(new SharedArrayBuffer(16 + 8192));
                Atomics.store(sab, 0, 0);
            }
            var worker;
            var tid;
            var PThread = _this_1.PThread;
            try {
                worker = PThread.getNewWorker(sab);
                if (!worker) {
                    throw new Error('failed to get new worker');
                }
                PThread.addMessageEventListener(worker, onMessage);
                tid = PThread.markId(worker);
                if (ENVIRONMENT_IS_NODE) ;
                worker.postMessage(createMessage('start', {
                    tid: tid,
                    arg: startArg,
                    sab: sab
                }));
                if (shouldWait) {
                    if (typeof waitThreadStart === 'number') {
                        var waitResult = Atomics.wait(sab, 0, 0, waitThreadStart);
                        if (waitResult === 'timed-out') {
                            try {
                                PThread.cleanThread(worker, tid, true);
                            }
                            catch (_) { }
                            throw new Error('Spawning thread timed out. Please check if the worker is created successfully and if message is handled properly in the worker.');
                        }
                    }
                    else {
                        Atomics.wait(sab, 0, 0);
                    }
                    var r = Atomics.load(sab, 0);
                    if (r > 1) {
                        try {
                            PThread.cleanThread(worker, tid, true);
                        }
                        catch (_) { }
                        throw deserizeErrorFromBuffer(sab.buffer);
                    }
                }
            }
            catch (e) {
                Atomics.store(struct, 0, 1);
                Atomics.store(struct, 1, EAGAIN);
                Atomics.notify(struct, 1);
                PThread === null || PThread === void 0 ? void 0 : PThread.printErr(e.stack);
                if (isNewABI) {
                    return 1;
                }
                free(errorOrTid);
                return -6;
            }
            Atomics.store(struct, 0, 0);
            Atomics.store(struct, 1, tid);
            Atomics.notify(struct, 1);
            PThread.runningWorkers.push(worker);
            if (!shouldWait) {
                worker.whenLoaded.catch(function (err) {
                    delete worker.whenLoaded;
                    PThread.cleanThread(worker, tid, true);
                    throw err;
                });
            }
            if (isNewABI) {
                return 0;
            }
            free(errorOrTid);
            return tid;
        };
        this.threadSpawn = threadSpawn;
    }
    WASIThreads.prototype.getImportObject = function () {
        return {
            wasi: {
                'thread-spawn': this.threadSpawn
            }
        };
    };
    WASIThreads.prototype.setup = function (wasmInstance, wasmModule, wasmMemory) {
        wasmMemory !== null && wasmMemory !== void 0 ? wasmMemory : (wasmMemory = wasmInstance.exports.memory);
        this.wasmInstance = wasmInstance;
        this.wasmMemory = wasmMemory;
        if (this.PThread) {
            this.PThread.setup(wasmModule, wasmMemory);
        }
    };
    WASIThreads.prototype.preloadWorkers = function () {
        if (this.PThread) {
            return this.PThread.preloadWorkers();
        }
        return Promise.resolve([]);
    };
    /**
     * It's ok to call this method to a WASI command module.
     *
     * in child thread, must call this method instead of {@link WASIThreads.start} even if it's a WASI command module
     *
     * @returns A proxied WebAssembly instance if in child thread, other wise the original instance
     */
    WASIThreads.prototype.initialize = function (instance, module, memory) {
        var exports = instance.exports;
        memory !== null && memory !== void 0 ? memory : (memory = exports.memory);
        if (this.childThread) {
            instance = createInstanceProxy(instance, memory);
        }
        this.setup(instance, module, memory);
        var wasi = this.wasi;
        if (('_start' in exports) && (typeof exports._start === 'function')) {
            if (this.childThread) {
                wasi.start(instance);
                try {
                    var kStarted = getWasiSymbol(wasi, 'kStarted');
                    wasi[kStarted] = false;
                }
                catch (_) { }
            }
            else {
                setupInstance$1(wasi, instance);
            }
        }
        else {
            wasi.initialize(instance);
        }
        return instance;
    };
    /**
     * Equivalent to calling {@link WASIThreads.initialize} and then calling {@link WASIInstance.start}
     * ```js
     * this.initialize(instance, module, memory)
     * this.wasi.start(instance)
     * ```
     */
    WASIThreads.prototype.start = function (instance, module, memory) {
        var exports = instance.exports;
        memory !== null && memory !== void 0 ? memory : (memory = exports.memory);
        if (this.childThread) {
            instance = createInstanceProxy(instance, memory);
        }
        this.setup(instance, module, memory);
        var exitCode = this.wasi.start(instance);
        return { exitCode: exitCode, instance: instance };
    };
    WASIThreads.prototype.terminateAllThreads = function () {
        var _a;
        if (!this.childThread) {
            (_a = this.PThread) === null || _a === void 0 ? void 0 : _a.terminateAllThreads();
        }
        else {
            this.postMessage(createMessage('terminate-all-threads', {}));
        }
    };
    return WASIThreads;
}());
function patchWasiInstance(wasiThreads, wasi) {
    var patched = patchedWasiInstances.get(wasiThreads);
    if (patched.has(wasi)) {
        return;
    }
    var _this = wasiThreads;
    var wasiImport = wasi.wasiImport;
    if (wasiImport) {
        var proc_exit_1 = wasiImport.proc_exit;
        wasiImport.proc_exit = function (code) {
            _this.terminateAllThreads();
            return proc_exit_1.call(this, code);
        };
    }
    var start = wasi.start;
    if (typeof start === 'function') {
        wasi.start = function (instance) {
            try {
                return start.call(this, instance);
            }
            catch (err) {
                if (isTrapError(err)) {
                    _this.terminateAllThreads();
                }
                throw err;
            }
        };
    }
    patched.add(wasi);
}
function getWasiSymbol(wasi, description) {
    var symbols = Object.getOwnPropertySymbols(wasi);
    var selectDescription = function (description) { return function (s) {
        if (s.description) {
            return s.description === description;
        }
        return s.toString() === "Symbol(".concat(description, ")");
    }; };
    if (Array.isArray(description)) {
        return description.map(function (d) { return symbols.filter(selectDescription(d))[0]; });
    }
    return symbols.filter(selectDescription(description))[0];
}
function setupInstance$1(wasi, instance) {
    var _a = getWasiSymbol(wasi, ['kInstance', 'kSetMemory']), kInstance = _a[0], kSetMemory = _a[1];
    wasi[kInstance] = instance;
    wasi[kSetMemory](instance.exports.memory);
}

/** @public */
var ThreadMessageHandler = /*#__PURE__*/ (function () {
    function ThreadMessageHandler(options) {
        var postMsg = getPostMessage(options);
        if (typeof postMsg !== 'function') {
            throw new TypeError('options.postMessage is not a function');
        }
        this.postMessage = postMsg;
        this.onLoad = options === null || options === void 0 ? void 0 : options.onLoad;
        this.instance = undefined;
        // this.module = undefined
        this.messagesBeforeLoad = [];
    }
    /** @virtual */
    ThreadMessageHandler.prototype.instantiate = function (data) {
        if (typeof this.onLoad === 'function') {
            return this.onLoad(data);
        }
        throw new Error('ThreadMessageHandler.prototype.instantiate is not implemented');
    };
    /** @virtual */
    ThreadMessageHandler.prototype.handle = function (e) {
        var _this = this;
        var _a;
        if ((_a = e === null || e === void 0 ? void 0 : e.data) === null || _a === void 0 ? void 0 : _a.__emnapi__) {
            var type = e.data.__emnapi__.type;
            var payload_1 = e.data.__emnapi__.payload;
            if (type === 'load') {
                this._load(payload_1);
            }
            else if (type === 'start') {
                this.handleAfterLoad(e, function () {
                    _this._start(payload_1);
                });
            }
        }
    };
    ThreadMessageHandler.prototype._load = function (payload) {
        var _this = this;
        if (this.instance !== undefined)
            return;
        var source;
        try {
            source = this.instantiate(payload);
        }
        catch (err) {
            this._loaded(err, null, payload);
            return;
        }
        var then = source && 'then' in source ? source.then : undefined;
        if (typeof then === 'function') {
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            then.call(source, function (source) { _this._loaded(null, source, payload); }, function (err) { _this._loaded(err, null, payload); });
        }
        else {
            this._loaded(null, source, payload);
        }
    };
    ThreadMessageHandler.prototype._start = function (payload) {
        if (typeof this.instance.exports.wasi_thread_start !== 'function') {
            var err = new TypeError('wasi_thread_start is not exported');
            notifyPthreadCreateResult(payload.sab, 2, err);
            throw err;
        }
        var postMessage = this.postMessage;
        var tid = payload.tid;
        var startArg = payload.arg;
        notifyPthreadCreateResult(payload.sab, 1);
        try {
            this.instance.exports.wasi_thread_start(tid, startArg);
        }
        catch (err) {
            if (isTrapError(err)) {
                postMessage(createMessage('terminate-all-threads', {}));
            }
            throw err;
        }
        postMessage(createMessage('cleanup-thread', { tid: tid }));
    };
    ThreadMessageHandler.prototype._loaded = function (err, source, payload) {
        if (err) {
            notifyPthreadCreateResult(payload.sab, 2, err);
            throw err;
        }
        if (source == null) {
            var err_1 = new TypeError('onLoad should return an object');
            notifyPthreadCreateResult(payload.sab, 2, err_1);
            throw err_1;
        }
        var instance = source.instance;
        if (!instance) {
            var err_2 = new TypeError('onLoad should return an object which includes "instance"');
            notifyPthreadCreateResult(payload.sab, 2, err_2);
            throw err_2;
        }
        this.instance = instance;
        var postMessage = this.postMessage;
        postMessage(createMessage('loaded', {}));
        var messages = this.messagesBeforeLoad;
        this.messagesBeforeLoad = [];
        for (var i = 0; i < messages.length; i++) {
            var data = messages[i];
            this.handle({ data: data });
        }
    };
    ThreadMessageHandler.prototype.handleAfterLoad = function (e, f) {
        if (this.instance !== undefined) {
            f.call(this, e);
        }
        else {
            this.messagesBeforeLoad.push(e.data);
        }
    };
    return ThreadMessageHandler;
}());
function notifyPthreadCreateResult(sab, result, error) {
    if (sab) {
        serizeErrorToBuffer(sab.buffer, result, error);
        Atomics.notify(sab, 0);
    }
}

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

/* eslint-disable no-undef */
var _WebAssembly$1 = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
function validateImports(imports) {
    if (imports && typeof imports !== 'object') {
        throw new TypeError('imports must be an object or undefined');
    }
    return true;
}
function load(wasmInput, imports) {
    if (!wasmInput)
        throw new TypeError('Invalid wasm source');
    validateImports(imports);
    imports = imports !== null && imports !== void 0 ? imports : {};
    // Promise<string | URL | Response | BufferSource | WebAssembly.Module>
    try {
        var then = typeof wasmInput === 'object' && wasmInput !== null && 'then' in wasmInput ? wasmInput.then : undefined;
        if (typeof then === 'function') {
            return then.call(wasmInput, function (input) { return load(input, imports); });
        }
    }
    catch (_) { }
    // BufferSource
    if (wasmInput instanceof ArrayBuffer || ArrayBuffer.isView(wasmInput)) {
        return _WebAssembly$1.instantiate(wasmInput, imports);
    }
    // WebAssembly.Module
    if (wasmInput instanceof _WebAssembly$1.Module) {
        return _WebAssembly$1.instantiate(wasmInput, imports).then(function (instance) {
            return { instance: instance, module: wasmInput };
        });
    }
    // Response
    if (typeof Response !== 'undefined' && wasmInput instanceof Response) {
        return wasmInput.arrayBuffer().then(function (buffer) {
            return _WebAssembly$1.instantiate(buffer, imports);
        });
    }
    // string | URL
    var inputIsString = typeof wasmInput === 'string';
    if (inputIsString || (typeof URL !== 'undefined' && wasmInput instanceof URL)) {
        if (inputIsString && typeof wx !== 'undefined' && typeof __wxConfig !== 'undefined') {
            return _WebAssembly$1.instantiate(wasmInput, imports);
        }
        if (typeof fetch !== 'function') {
            throw new TypeError('wasm source can not be a string or URL in this environment');
        }
        if (typeof _WebAssembly$1.instantiateStreaming === 'function') {
            try {
                return _WebAssembly$1.instantiateStreaming(fetch(wasmInput), imports).catch(function () {
                    return load(fetch(wasmInput), imports);
                });
            }
            catch (_) {
                return load(fetch(wasmInput), imports);
            }
        }
        else {
            return load(fetch(wasmInput), imports);
        }
    }
    throw new TypeError('Invalid wasm source');
}
function loadSync(wasmInput, imports) {
    if (!wasmInput)
        throw new TypeError('Invalid wasm source');
    validateImports(imports);
    imports = imports !== null && imports !== void 0 ? imports : {};
    var module;
    if ((wasmInput instanceof ArrayBuffer) || ArrayBuffer.isView(wasmInput)) {
        module = new _WebAssembly$1.Module(wasmInput);
    }
    else if (wasmInput instanceof WebAssembly.Module) {
        module = wasmInput;
    }
    else {
        throw new TypeError('Invalid wasm source');
    }
    var instance = new _WebAssembly$1.Instance(module, imports);
    var source = { instance: instance, module: module };
    return source;
}

function createNapiModule(options) {
    var napiModule = (function () {
        var ENVIRONMENT_IS_PTHREAD = Boolean(options.childThread);
        var waitThreadStart = typeof options.waitThreadStart === 'number' ? options.waitThreadStart : Boolean(options.waitThreadStart);
        var wasmInstance;
        var wasmMemory;
        var wasmTable;
        var _malloc;
        var _free;
        function abort(msg) {
            if (typeof _WebAssembly$1.RuntimeError === 'function') {
                throw new _WebAssembly$1.RuntimeError(msg);
            }
            throw Error(msg);
        }
        var napiModule = {
            imports: {
                env: {},
                napi: {},
                emnapi: {}
            },
            exports: {},
            emnapi: {},
            loaded: false,
            filename: '',
            childThread: ENVIRONMENT_IS_PTHREAD,
            initWorker: undefined,
            executeAsyncWork: undefined,
            waitThreadStart: waitThreadStart,
            PThread: undefined,
            init: function (options) {
                if (napiModule.loaded)
                    return napiModule.exports;
                if (!options)
                    throw new TypeError('Invalid napi init options');
                var instance = options.instance;
                if (!(instance === null || instance === void 0 ? void 0 : instance.exports))
                    throw new TypeError('Invalid wasm instance');
                wasmInstance = instance;
                var exports = instance.exports;
                var module = options.module;
                var memory = options.memory || exports.memory;
                var table = options.table || exports.__indirect_function_table;
                if (!(module instanceof _WebAssembly$1.Module))
                    throw new TypeError('Invalid wasm module');
                if (!(memory instanceof _WebAssembly$1.Memory))
                    throw new TypeError('Invalid wasm memory');
                if (!(table instanceof _WebAssembly$1.Table))
                    throw new TypeError('Invalid wasm table');
                wasmMemory = memory;
                wasmTable = table;
                if (typeof exports.malloc !== 'function')
                    throw new TypeError('malloc is not exported');
                if (typeof exports.free !== 'function')
                    throw new TypeError('free is not exported');
                _malloc = exports.malloc;
                _free = exports.free;
                if (!napiModule.childThread) {
                    // main thread only
                    var moduleApiVersion = 8 /* Version.NODE_API_DEFAULT_MODULE_API_VERSION */;
                    var node_api_module_get_api_version_v1 = instance.exports.node_api_module_get_api_version_v1;
                    if (typeof node_api_module_get_api_version_v1 === 'function') {
                        moduleApiVersion = node_api_module_get_api_version_v1();
                    }
                    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                    var envObject = napiModule.envObject || (napiModule.envObject = emnapiCtx.createEnv(napiModule.filename, moduleApiVersion, function (cb) { return (wasmTable.get(cb)); }, function (cb) { return (wasmTable.get(cb)); }, abort, emnapiNodeBinding));
                    var scope_1 = emnapiCtx.openScope(envObject);
                    try {
                        envObject.callIntoModule(function (_envObject) {
                            var exports = napiModule.exports;
                            var exportsHandle = scope_1.add(exports);
                            var napi_register_wasm_v1 = instance.exports.napi_register_wasm_v1;
                            var napiValue = napi_register_wasm_v1(_envObject.id, exportsHandle.id);
                            napiModule.exports = (!napiValue) ? exports : emnapiCtx.handleStore.get(napiValue).value;
                        });
                    }
                    finally {
                        emnapiCtx.closeScope(envObject, scope_1);
                    }
                    napiModule.loaded = true;
                    delete napiModule.envObject;
                    return napiModule.exports;
                }
            }
        };
        var emnapiCtx;
        var emnapiNodeBinding;
        var onCreateWorker = undefined;
        var err;
        if (!ENVIRONMENT_IS_PTHREAD) {
            var context = options.context;
            if (typeof context !== 'object' || context === null) {
                throw new TypeError("Invalid `options.context`. Use `import { getDefaultContext } from '@emnapi/runtime'`");
            }
            emnapiCtx = context;
        }
        else {
            emnapiCtx = options === null || options === void 0 ? void 0 : options.context;
            var postMsg = typeof options.postMessage === 'function'
                ? options.postMessage
                : typeof postMessage === 'function'
                    ? postMessage
                    : undefined;
            if (typeof postMsg !== 'function') {
                throw new TypeError('No postMessage found');
            }
            napiModule.postMessage = postMsg;
        }
        if (typeof options.filename === 'string') {
            napiModule.filename = options.filename;
        }
        if (typeof options.onCreateWorker === 'function') {
            onCreateWorker = options.onCreateWorker;
        }
        if (typeof options.print === 'function') {
            options.print;
        }
        else {
            console.log.bind(console);
        }
        if (typeof options.printErr === 'function') {
            err = options.printErr;
        }
        else {
            err = console.warn.bind(console);
        }
        if ('nodeBinding' in options) {
            var nodeBinding = options.nodeBinding;
            if (typeof nodeBinding !== 'object' || nodeBinding === null) {
                throw new TypeError('Invalid `options.nodeBinding`. Use @emnapi/node-binding package');
            }
            emnapiNodeBinding = nodeBinding;
        }
        var emnapiAsyncWorkPoolSize = 0;
        if ('asyncWorkPoolSize' in options) {
            if (typeof options.asyncWorkPoolSize !== 'number') {
                throw new TypeError('options.asyncWorkPoolSize must be a integer');
            }
            emnapiAsyncWorkPoolSize = options.asyncWorkPoolSize >> 0;
            if (emnapiAsyncWorkPoolSize > 1024) {
                emnapiAsyncWorkPoolSize = 1024;
            }
            else if (emnapiAsyncWorkPoolSize < -1024) {
                emnapiAsyncWorkPoolSize = -1024;
            }
        }
        var singleThreadAsyncWork = ENVIRONMENT_IS_PTHREAD ? false : (emnapiAsyncWorkPoolSize <= 0);
        function _emnapi_async_work_pool_size() {
            return Math.abs(emnapiAsyncWorkPoolSize);
        }
        napiModule.imports.env._emnapi_async_work_pool_size = _emnapi_async_work_pool_size;
        // ------------------------------ pthread -------------------------------
        function emnapiAddSendListener(worker) {
            if (!worker)
                return false;
            if (worker._emnapiSendListener)
                return true;
            var handler = function (e) {
                var data = e.data;
                var __emnapi__ = data.__emnapi__;
                if (__emnapi__ && __emnapi__.type === 'async-send') {
                    if (ENVIRONMENT_IS_PTHREAD) {
                        var postMessage_1 = napiModule.postMessage;
                        postMessage_1({ __emnapi__: __emnapi__ });
                    }
                    else {
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                        var callback = __emnapi__.payload.callback;
                        (wasmTable.get(callback))(__emnapi__.payload.data);
                    }
                }
            };
            var dispose = function () {
                {
                    worker.removeEventListener('message', handler, false);
                }
                delete worker._emnapiSendListener;
            };
            worker._emnapiSendListener = { handler: handler, dispose: dispose };
            {
                worker.addEventListener('message', handler, false);
            }
            return true;
        }
        napiModule.emnapi.addSendListener = emnapiAddSendListener;
        var PThread = new ThreadManager(ENVIRONMENT_IS_PTHREAD
            ? {
                printErr: err,
                childThread: true
            }
            : {
                printErr: err,
                beforeLoad: function (worker) {
                    emnapiAddSendListener(worker);
                },
                reuseWorker: options.reuseWorker,
                onCreateWorker: onCreateWorker
            });
        napiModule.PThread = PThread;
        /**
         * @__sig ipiip
         */
        function napi_set_last_error(env, error_code, engine_error_code, engine_reserved) {
            var envObject = emnapiCtx.envStore.get(env);
            return envObject.setLastError(error_code, engine_error_code, engine_reserved);
        }
        /**
         * @__sig ip
         */
        function napi_clear_last_error(env) {
            var envObject = emnapiCtx.envStore.get(env);
            return envObject.clearLastError();
        }
        /**
         * @__sig vppp
         */
        function _emnapi_get_node_version(major, minor, patch) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var versions = [0, 0, 0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(major, versions[0], true);
            HEAP_DATA_VIEW.setUint32(minor, versions[1], true);
            HEAP_DATA_VIEW.setUint32(patch, versions[2], true);
        }
        /**
         * @__sig v
         * @__deps $runtimeKeepalivePush
         */
        function _emnapi_runtime_keepalive_push() {
        }
        /**
         * @__sig v
         * @__deps $runtimeKeepalivePop
         */
        function _emnapi_runtime_keepalive_pop() {
        }
        /**
         * @__sig vpp
         */
        function _emnapi_set_immediate(callback, data) {
            emnapiCtx.feature.setImmediate(function () {
                (wasmTable.get(callback))(data);
            });
        }
        /**
         * @__sig vpp
         */
        function _emnapi_next_tick(callback, data) {
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.resolve().then(function () {
                (wasmTable.get(callback))(data);
            });
        }
        /**
         * @__sig vipppi
         */
        function _emnapi_callback_into_module(forceUncaught, env, callback, data, close_scope_if_throw) {
            var envObject = emnapiCtx.envStore.get(env);
            var scope = emnapiCtx.openScope(envObject);
            try {
                envObject.callbackIntoModule(Boolean(forceUncaught), function () {
                    (wasmTable.get(callback))(env, data);
                });
            }
            catch (err) {
                emnapiCtx.closeScope(envObject, scope);
                if (close_scope_if_throw) {
                    emnapiCtx.closeScope(envObject);
                }
                throw err;
            }
            emnapiCtx.closeScope(envObject, scope);
        }
        /**
         * @__sig vipppp
         */
        function _emnapi_call_finalizer(forceUncaught, env, callback, data, hint) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.callFinalizerInternal(forceUncaught, callback, data, hint);
        }
        /**
         * @__sig v
         */
        function _emnapi_ctx_increase_waiting_request_counter() {
            emnapiCtx.increaseWaitingRequestCounter();
        }
        /**
         * @__sig v
         */
        function _emnapi_ctx_decrease_waiting_request_counter() {
            emnapiCtx.decreaseWaitingRequestCounter();
        }
        function $emnapiSetValueI64(result, numberValue) {
            var tempDouble;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var tempI64 = [
                numberValue >>> 0,
                (tempDouble = numberValue, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)
            ];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, tempI64[0], true);
            HEAP_DATA_VIEW.setInt32(result + 4, tempI64[1], true);
        }
        var utilMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            $emnapiSetValueI64: $emnapiSetValueI64,
            _emnapi_call_finalizer: _emnapi_call_finalizer,
            _emnapi_callback_into_module: _emnapi_callback_into_module,
            _emnapi_ctx_decrease_waiting_request_counter: _emnapi_ctx_decrease_waiting_request_counter,
            _emnapi_ctx_increase_waiting_request_counter: _emnapi_ctx_increase_waiting_request_counter,
            _emnapi_get_node_version: _emnapi_get_node_version,
            _emnapi_next_tick: _emnapi_next_tick,
            _emnapi_runtime_keepalive_pop: _emnapi_runtime_keepalive_pop,
            _emnapi_runtime_keepalive_push: _emnapi_runtime_keepalive_push,
            _emnapi_set_immediate: _emnapi_set_immediate,
            napi_clear_last_error: napi_clear_last_error,
            napi_set_last_error: napi_set_last_error
        });
        function emnapiGetWorkerByPthreadPtr(pthreadPtr) {
            var view = new DataView(wasmMemory.buffer);
            /**
             * wasi-sdk-20.0+threads
             *
             * struct pthread {
             *   struct pthread *self;        // 0
             *   struct pthread *prev, *next; // 4, 8
             *   uintptr_t sysinfo;           // 12
             *   uintptr_t canary;            // 16
             *   int tid;                     // 20
             *   // ...
             * }
             */
            var tidOffset = 20;
            var tid = view.getInt32(pthreadPtr + tidOffset, true);
            var worker = PThread.pthreads[tid];
            return worker;
        }
        /** @__sig vp */
        function _emnapi_worker_unref(pthreadPtr) {
            if (ENVIRONMENT_IS_PTHREAD)
                return;
            var worker = emnapiGetWorkerByPthreadPtr(pthreadPtr);
            if (worker && typeof worker.unref === 'function') {
                worker.unref();
            }
        }
        /** @__sig vipp */
        function _emnapi_async_send_js(type, callback, data) {
            if (ENVIRONMENT_IS_PTHREAD) {
                var postMessage_1 = napiModule.postMessage;
                postMessage_1({
                    __emnapi__: {
                        type: 'async-send',
                        payload: {
                            callback: callback,
                            data: data
                        }
                    }
                });
            }
            else {
                switch (type) {
                    case 0:
                        _emnapi_set_immediate(callback, data);
                        break;
                    case 1:
                        _emnapi_next_tick(callback, data);
                        break;
                }
            }
        }
        // function ptrToString (ptr: number): string {
        //   return '0x' + ('00000000' + ptr.toString(16)).slice(-8)
        // }
        var uvThreadpoolReadyResolve;
        var uvThreadpoolReady = new Promise(function (resolve) {
            uvThreadpoolReadyResolve = function () {
                uvThreadpoolReady.ready = true;
                resolve();
            };
        });
        uvThreadpoolReady.ready = false;
        /** @__sig i */
        function _emnapi_is_main_browser_thread() {
            return (typeof window !== 'undefined' && typeof document !== 'undefined' && true) ? 1 : 0;
        }
        /** @__sig vppi */
        function _emnapi_after_uvthreadpool_ready(callback, q, type) {
            if (uvThreadpoolReady.ready) {
                (wasmTable.get(callback))(q, type);
            }
            else {
                uvThreadpoolReady.then(function () {
                    (wasmTable.get(callback))(q, type);
                });
            }
        }
        /** @__sig vpi */
        function _emnapi_tell_js_uvthreadpool(threads, size) {
            var p = [];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var _loop_1 = function (i) {
                var pthreadPtr = HEAP_DATA_VIEW.getInt32(threads + i * 4, true);
                var worker = emnapiGetWorkerByPthreadPtr(pthreadPtr);
                p.push(new Promise(function (resolve) {
                    var handler = function (e) {
                        var data = e.data;
                        var __emnapi__ = data.__emnapi__;
                        if (__emnapi__ && __emnapi__.type === 'async-thread-ready') {
                            resolve();
                            if (worker && typeof worker.unref === 'function') {
                                worker.unref();
                            }
                            {
                                worker.removeEventListener('message', handler);
                            }
                        }
                    };
                    {
                        worker.addEventListener('message', handler);
                    }
                }));
            };
            for (var i = 0; i < size; i++) {
                _loop_1(i);
            }
            Promise.all(p).then(uvThreadpoolReadyResolve);
        }
        /** @__sig v */
        function _emnapi_emit_async_thread_ready() {
            if (!ENVIRONMENT_IS_PTHREAD)
                return;
            var postMessage = napiModule.postMessage;
            postMessage({
                __emnapi__: {
                    type: 'async-thread-ready',
                    payload: {}
                }
            });
        }
        var asyncMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_after_uvthreadpool_ready: _emnapi_after_uvthreadpool_ready,
            _emnapi_async_send_js: _emnapi_async_send_js,
            _emnapi_emit_async_thread_ready: _emnapi_emit_async_thread_ready,
            _emnapi_is_main_browser_thread: _emnapi_is_main_browser_thread,
            _emnapi_tell_js_uvthreadpool: _emnapi_tell_js_uvthreadpool,
            _emnapi_worker_unref: _emnapi_worker_unref
        });
        /* eslint-disable @typescript-eslint/indent */
        /** @__sig ipjp */
        function napi_adjust_external_memory(env, change_in_bytes, adjusted_value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!adjusted_value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var change_in_bytes_number = Number(change_in_bytes);
            if (change_in_bytes_number < 0) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var old_size = wasmMemory.buffer.byteLength;
            var new_size = old_size + change_in_bytes_number;
            new_size = new_size + ((65536 - new_size % 65536) % 65536);
            if (wasmMemory.grow((new_size - old_size + 65535) >> 16) === -1) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (emnapiCtx.feature.supportBigInt) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setBigInt64(adjusted_value, BigInt(wasmMemory.buffer.byteLength), true);
            }
            else {
                $emnapiSetValueI64(adjusted_value, wasmMemory.buffer.byteLength);
            }
            return envObject.clearLastError();
        }
        var memoryMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_adjust_external_memory: napi_adjust_external_memory
        });
        /**
         * @__postset
         * ```
         * emnapiAWST.init();
         * ```
         */
        var emnapiAWST = {
            idGen: {},
            values: [undefined],
            queued: new Set(),
            pending: [],
            init: function () {
                var idGen = {
                    nextId: 1,
                    list: [],
                    generate: function () {
                        var id;
                        if (idGen.list.length) {
                            id = idGen.list.shift();
                        }
                        else {
                            id = idGen.nextId;
                            idGen.nextId++;
                        }
                        return id;
                    },
                    reuse: function (id) {
                        idGen.list.push(id);
                    }
                };
                emnapiAWST.idGen = idGen;
                emnapiAWST.values = [undefined];
                emnapiAWST.queued = new Set();
                emnapiAWST.pending = [];
            },
            create: function (env, resource, resourceName, execute, complete, data) {
                var asyncId = 0;
                var triggerAsyncId = 0;
                if (emnapiNodeBinding) {
                    var asyncContext = emnapiNodeBinding.node.emitAsyncInit(resource, resourceName, -1);
                    asyncId = asyncContext.asyncId;
                    triggerAsyncId = asyncContext.triggerAsyncId;
                }
                var id = emnapiAWST.idGen.generate();
                emnapiAWST.values[id] = {
                    env: env,
                    id: id,
                    resource: resource,
                    asyncId: asyncId,
                    triggerAsyncId: triggerAsyncId,
                    status: 0,
                    execute: execute,
                    complete: complete,
                    data: data
                };
                return id;
            },
            callComplete: function (work, status) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var complete = work.complete;
                var env = work.env;
                var data = work.data;
                var callback = function () {
                    if (!complete)
                        return;
                    var envObject = emnapiCtx.envStore.get(env);
                    var scope = emnapiCtx.openScope(envObject);
                    try {
                        envObject.callbackIntoModule(true, function () {
                            (wasmTable.get(complete))(env, status, data);
                        });
                    }
                    finally {
                        emnapiCtx.closeScope(envObject, scope);
                    }
                };
                if (emnapiNodeBinding) {
                    emnapiNodeBinding.node.makeCallback(work.resource, callback, [], {
                        asyncId: work.asyncId,
                        triggerAsyncId: work.triggerAsyncId
                    });
                }
                else {
                    callback();
                }
            },
            queue: function (id) {
                var work = emnapiAWST.values[id];
                if (!work)
                    return;
                if (work.status === 0) {
                    work.status = 1;
                    if (emnapiAWST.queued.size >= (Math.abs(emnapiAsyncWorkPoolSize) || 4)) {
                        emnapiAWST.pending.push(id);
                        return;
                    }
                    emnapiAWST.queued.add(id);
                    var env_1 = work.env;
                    var data_1 = work.data;
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var execute = work.execute;
                    work.status = 2;
                    emnapiCtx.feature.setImmediate(function () {
                        (wasmTable.get(execute))(env_1, data_1);
                        emnapiAWST.queued.delete(id);
                        work.status = 3;
                        emnapiCtx.feature.setImmediate(function () {
                            emnapiAWST.callComplete(work, 0 /* napi_status.napi_ok */);
                        });
                        if (emnapiAWST.pending.length > 0) {
                            var nextWorkId = emnapiAWST.pending.shift();
                            emnapiAWST.values[nextWorkId].status = 0;
                            emnapiAWST.queue(nextWorkId);
                        }
                    });
                }
            },
            cancel: function (id) {
                var index = emnapiAWST.pending.indexOf(id);
                if (index !== -1) {
                    var work_1 = emnapiAWST.values[id];
                    if (work_1 && (work_1.status === 1)) {
                        work_1.status = 4;
                        emnapiAWST.pending.splice(index, 1);
                        emnapiCtx.feature.setImmediate(function () {
                            emnapiAWST.callComplete(work_1, 11 /* napi_status.napi_cancelled */);
                        });
                        return 0 /* napi_status.napi_ok */;
                    }
                    else {
                        return 9 /* napi_status.napi_generic_failure */;
                    }
                }
                return 9 /* napi_status.napi_generic_failure */;
            },
            remove: function (id) {
                var work = emnapiAWST.values[id];
                if (!work)
                    return;
                if (emnapiNodeBinding) {
                    emnapiNodeBinding.node.emitAsyncDestroy({
                        asyncId: work.asyncId,
                        triggerAsyncId: work.triggerAsyncId
                    });
                }
                emnapiAWST.values[id] = undefined;
                emnapiAWST.idGen.reuse(id);
            }
        };
        /** @__sig vppdp */
        function _emnapi_node_emit_async_init(async_resource, async_resource_name, trigger_async_id, result) {
            if (!emnapiNodeBinding)
                return;
            var resource = emnapiCtx.handleStore.get(async_resource).value;
            var resource_name = emnapiCtx.handleStore.get(async_resource_name).value;
            var asyncContext = emnapiNodeBinding.node.emitAsyncInit(resource, resource_name, trigger_async_id);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var asyncId = asyncContext.asyncId;
            var triggerAsyncId = asyncContext.triggerAsyncId;
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setFloat64(result, asyncId, true);
                HEAP_DATA_VIEW.setFloat64(result + 8, triggerAsyncId, true);
            }
        }
        /** @__sig vdd */
        function _emnapi_node_emit_async_destroy(async_id, trigger_async_id) {
            if (!emnapiNodeBinding)
                return;
            emnapiNodeBinding.node.emitAsyncDestroy({
                asyncId: async_id,
                triggerAsyncId: trigger_async_id
            });
        }
        /* vpddp export function _emnapi_node_open_callback_scope (async_resource: napi_value, async_id: double, trigger_async_id: double, result: Pointer<int64_t>): void {
          if (!emnapiNodeBinding || !result) return
          const resource = emnapiCtx.handleStore.get(async_resource)!.value
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          const nativeCallbackScopePointer = emnapiNodeBinding.node.openCallbackScope(resource, {
            asyncId: async_id,
            triggerAsyncId: trigger_async_id
          })
    
          from64('result')
          $_TODO_makeSetValue('result', 0, 'nativeCallbackScopePointer', 'i64')
        }
    
        vp
        export function _emnapi_node_close_callback_scope (scope: Pointer<int64_t>): void {
          if (!emnapiNodeBinding || !scope) return
          from64('scope')
          const nativeCallbackScopePointer = $_TODO_makeGetValue('scope', 0, 'i64')
          emnapiNodeBinding.node.closeCallbackScope(BigInt(nativeCallbackScopePointer))
        } */
        /** @__sig ipppppddp */
        function _emnapi_node_make_callback(env, async_resource, cb, argv, size, async_id, trigger_async_id, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!emnapiNodeBinding)
                return;
            var resource = emnapiCtx.handleStore.get(async_resource).value;
            var callback = emnapiCtx.handleStore.get(cb).value;
            size = size >>> 0;
            var arr = Array(size);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            for (; i < size; i++) {
                var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                arr[i] = emnapiCtx.handleStore.get(argVal).value;
            }
            var ret = emnapiNodeBinding.node.makeCallback(resource, callback, arr, {
                asyncId: async_id,
                triggerAsyncId: trigger_async_id
            });
            if (result) {
                var envObject = emnapiCtx.envStore.get(env);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = envObject.ensureHandleId(ret);
                HEAP_DATA_VIEW.setInt32(result, v, true);
            }
        }
        /** @__sig ippp */
        function _emnapi_async_init_js(async_resource, async_resource_name, result) {
            if (!emnapiNodeBinding) {
                return 9 /* napi_status.napi_generic_failure */;
            }
            var resource;
            if (async_resource) {
                resource = Object(emnapiCtx.handleStore.get(async_resource).value);
            }
            var name = emnapiCtx.handleStore.get(async_resource_name).value;
            var ret = emnapiNodeBinding.napi.asyncInit(resource, name);
            if (ret.status !== 0)
                return ret.status;
            var numberValue = ret.value;
            if (!((numberValue >= (BigInt(-1) * (BigInt(1) << BigInt(63)))) && (numberValue < (BigInt(1) << BigInt(63))))) {
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                if (numberValue >= (BigInt(1) << BigInt(63))) {
                    numberValue = numberValue - (BigInt(1) << BigInt(64));
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, low, true);
            HEAP_DATA_VIEW.setInt32(result + 4, high, true);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ip */
        function _emnapi_async_destroy_js(async_context) {
            if (!emnapiNodeBinding) {
                return 9 /* napi_status.napi_generic_failure */;
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var low = HEAP_DATA_VIEW.getInt32(async_context, true);
            var high = HEAP_DATA_VIEW.getInt32(async_context + 4, true);
            var pointer = BigInt(low >>> 0) | (BigInt(high) << BigInt(32));
            var ret = emnapiNodeBinding.napi.asyncDestroy(pointer);
            if (ret.status !== 0)
                return ret.status;
            return 0 /* napi_status.napi_ok */;
        }
        // https://github.com/nodejs/node-addon-api/pull/1283
        /** @__sig ipppp */
        function napi_open_callback_scope(env, ignored, async_context_handle, result) {
            throw new Error('napi_open_callback_scope has not been implemented yet');
        }
        /** @__sig ipp */
        function napi_close_callback_scope(env, scope) {
            throw new Error('napi_close_callback_scope has not been implemented yet');
        }
        /** @__sig ippppppp */
        function napi_make_callback(env, async_context, recv, func, argc, argv, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiNodeBinding) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                if (!recv)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var v8recv = Object(emnapiCtx.handleStore.get(recv).value);
                var v8func = emnapiCtx.handleStore.get(func).value;
                if (typeof v8func !== 'function') {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var low = HEAP_DATA_VIEW.getInt32(async_context, true);
                var high = HEAP_DATA_VIEW.getInt32(async_context + 4, true);
                var ctx = BigInt(low >>> 0) | (BigInt(high) << BigInt(32));
                argc = argc >>> 0;
                var arr = Array(argc);
                for (; i < argc; i++) {
                    var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                    arr[i] = emnapiCtx.handleStore.get(argVal).value;
                }
                var ret = emnapiNodeBinding.napi.makeCallback(ctx, v8recv, v8func, arr);
                if (ret.error) {
                    throw ret.error;
                }
                if (ret.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(ret.status);
                if (result) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    v = envObject.ensureHandleId(ret.value);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig vp */
        function _emnapi_env_check_gc_access(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
        }
        var nodeMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_async_destroy_js: _emnapi_async_destroy_js,
            _emnapi_async_init_js: _emnapi_async_init_js,
            _emnapi_env_check_gc_access: _emnapi_env_check_gc_access,
            _emnapi_node_emit_async_destroy: _emnapi_node_emit_async_destroy,
            _emnapi_node_emit_async_init: _emnapi_node_emit_async_init,
            _emnapi_node_make_callback: _emnapi_node_make_callback,
            napi_close_callback_scope: napi_close_callback_scope,
            napi_make_callback: napi_make_callback,
            napi_open_callback_scope: napi_open_callback_scope
        });
        /**
         * @__deps malloc
         * @__deps free
         * @__postset
         * ```
         * emnapiTSFN.init();
         * ```
         */
        var emnapiTSFN = {
            offset: {
                /* napi_ref */ resource: 0,
                /* double */ async_id: 8,
                /* double */ trigger_async_id: 16,
                /* size_t */ queue_size: 24,
                /* void* */ queue: 1 * 4 + 24,
                /* size_t */ thread_count: 2 * 4 + 24,
                /* bool */ is_closing: 3 * 4 + 24,
                /* atomic_uchar */ dispatch_state: 3 * 4 + 28,
                /* void* */ context: 3 * 4 + 32,
                /* size_t */ max_queue_size: 4 * 4 + 32,
                /* napi_ref */ ref: 5 * 4 + 32,
                /* napi_env */ env: 6 * 4 + 32,
                /* void* */ finalize_data: 7 * 4 + 32,
                /* napi_finalize */ finalize_cb: 8 * 4 + 32,
                /* napi_threadsafe_function_call_js */ call_js_cb: 9 * 4 + 32,
                /* bool */ handles_closing: 10 * 4 + 32,
                /* bool */ async_ref: 10 * 4 + 36,
                /* int32_t */ mutex: 10 * 4 + 40,
                /* int32_t */ cond: 10 * 4 + 44,
                end: 10 * 4 + 48
            },
            init: function () {
                if (typeof PThread !== 'undefined') {
                    PThread.unusedWorkers.forEach(emnapiTSFN.addListener);
                    PThread.runningWorkers.forEach(emnapiTSFN.addListener);
                    var __original_getNewWorker_1 = PThread.getNewWorker;
                    PThread.getNewWorker = function () {
                        var r = __original_getNewWorker_1.apply(this, arguments);
                        emnapiTSFN.addListener(r);
                        return r;
                    };
                }
            },
            addListener: function (worker) {
                if (!worker)
                    return false;
                if (worker._emnapiTSFNListener)
                    return true;
                var handler = function (e) {
                    var data = e.data;
                    var __emnapi__ = data.__emnapi__;
                    if (__emnapi__) {
                        var type = __emnapi__.type;
                        var payload = __emnapi__.payload;
                        if (type === 'tsfn-send') {
                            emnapiTSFN.dispatch(payload.tsfn);
                        }
                    }
                };
                var dispose = function () {
                    {
                        worker.removeEventListener('message', handler, false);
                    }
                    delete worker._emnapiTSFNListener;
                };
                worker._emnapiTSFNListener = { handler: handler, dispose: dispose };
                {
                    worker.addEventListener('message', handler, false);
                }
                return true;
            },
            initQueue: function (func) {
                var size = 2 * 4;
                var queue = _malloc(size);
                if (!queue)
                    return false;
                new Uint8Array(wasmMemory.buffer, queue, size).fill(0);
                emnapiTSFN.storeSizeTypeValue(func + emnapiTSFN.offset.queue, queue, false);
                return true;
            },
            destroyQueue: function (func) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                if (queue) {
                    _free(queue);
                }
            },
            pushQueue: function (func, data) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                var head = emnapiTSFN.loadSizeTypeValue(queue, false);
                var tail = emnapiTSFN.loadSizeTypeValue(queue + 4, false);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var size = 2 * 4;
                var node = _malloc(size);
                if (!node)
                    throw new Error('OOM');
                emnapiTSFN.storeSizeTypeValue(node, data, false);
                emnapiTSFN.storeSizeTypeValue(node + 4, 0, false);
                if (head === 0 && tail === 0) {
                    emnapiTSFN.storeSizeTypeValue(queue, node, false);
                    emnapiTSFN.storeSizeTypeValue(queue + 4, node, false);
                }
                else {
                    emnapiTSFN.storeSizeTypeValue(tail + 4, node, false);
                    emnapiTSFN.storeSizeTypeValue(queue + 4, node, false);
                }
                emnapiTSFN.addQueueSize(func);
            },
            shiftQueue: function (func) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                var head = emnapiTSFN.loadSizeTypeValue(queue, false);
                if (head === 0)
                    return 0;
                var node = head;
                var next = emnapiTSFN.loadSizeTypeValue(head + 4, false);
                emnapiTSFN.storeSizeTypeValue(queue, next, false);
                if (next === 0) {
                    emnapiTSFN.storeSizeTypeValue(queue + 4, 0, false);
                }
                emnapiTSFN.storeSizeTypeValue(node + 4, 0, false);
                var value = emnapiTSFN.loadSizeTypeValue(node, false);
                _free(node);
                emnapiTSFN.subQueueSize(func);
                return value;
            },
            push: function (func, data, mode) {
                var mutex = emnapiTSFN.getMutex(func);
                var cond = emnapiTSFN.getCond(func);
                var waitCondition = function () {
                    var queueSize = emnapiTSFN.getQueueSize(func);
                    var maxSize = emnapiTSFN.getMaxQueueSize(func);
                    var isClosing = emnapiTSFN.getIsClosing(func);
                    return queueSize >= maxSize && maxSize > 0 && !isClosing;
                };
                var isBrowserMain = typeof window !== 'undefined' && typeof document !== 'undefined' && true;
                return mutex.execute(function () {
                    while (waitCondition()) {
                        if (mode === 0 /* napi_threadsafe_function_call_mode.napi_tsfn_nonblocking */) {
                            return 15 /* napi_status.napi_queue_full */;
                        }
                        /**
                         * Browser JS main thread can not use `Atomics.wait`
                         *
                         * Related:
                         * https://github.com/nodejs/node/pull/32689
                         * https://github.com/nodejs/node/pull/33453
                         */
                        if (isBrowserMain) {
                            return 21 /* napi_status.napi_would_deadlock */;
                        }
                        cond.wait();
                    }
                    if (emnapiTSFN.getIsClosing(func)) {
                        if (emnapiTSFN.getThreadCount(func) === 0) {
                            return 1 /* napi_status.napi_invalid_arg */;
                        }
                        else {
                            emnapiTSFN.subThreadCount(func);
                            return 16 /* napi_status.napi_closing */;
                        }
                    }
                    else {
                        emnapiTSFN.pushQueue(func, data);
                        emnapiTSFN.send(func);
                        return 0 /* napi_status.napi_ok */;
                    }
                });
            },
            getMutex: function (func) {
                var index = func + emnapiTSFN.offset.mutex;
                var mutex = {
                    lock: function () {
                        var isBrowserMain = typeof window !== 'undefined' && typeof document !== 'undefined' && true;
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        if (isBrowserMain) {
                            while (true) {
                                var oldValue = Atomics.compareExchange(i32a, 0, 0, 1);
                                if (oldValue === 0) {
                                    return;
                                }
                            }
                        }
                        else {
                            while (true) {
                                var oldValue = Atomics.compareExchange(i32a, 0, 0, 1);
                                if (oldValue === 0) {
                                    return;
                                }
                                Atomics.wait(i32a, 0, 1);
                            }
                        }
                    },
                    /* lockAsync () {
                      return new Promise<void>(resolve => {
                        const again = (): void => { fn() }
                        const fn = (): void => {
                          const i32a = new Int32Array(wasmMemory.buffer, index, 1)
                          const oldValue = Atomics.compareExchange(i32a, 0, 0, 1)
                          if (oldValue === 0) {
                            resolve()
                            return
                          }
                          (Atomics as any).waitAsync(i32a, 0, 1).value.then(again)
                        }
                        fn()
                      })
                    }, */
                    unlock: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        var oldValue = Atomics.compareExchange(i32a, 0, 1, 0);
                        if (oldValue !== 1) {
                            throw new Error('Tried to unlock while not holding the mutex');
                        }
                        Atomics.notify(i32a, 0, 1);
                    },
                    execute: function (fn) {
                        mutex.lock();
                        try {
                            return fn();
                        }
                        finally {
                            mutex.unlock();
                        }
                    } /* ,
                    executeAsync<T> (fn: () => Promise<T>): Promise<T> {
                      return mutex.lockAsync().then(() => {
                        const r = fn()
                        mutex.unlock()
                        return r
                      }, (err) => {
                        mutex.unlock()
                        throw err
                      })
                    } */
                };
                return mutex;
            },
            getCond: function (func) {
                var index = func + emnapiTSFN.offset.cond;
                var mutex = emnapiTSFN.getMutex(func);
                var cond = {
                    wait: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        var value = Atomics.load(i32a, 0);
                        mutex.unlock();
                        Atomics.wait(i32a, 0, value);
                        mutex.lock();
                    },
                    /* waitAsync () {
                      const i32a = new Int32Array(wasmMemory.buffer, index, 1)
                      const value = Atomics.load(i32a, 0)
                      mutex.unlock()
                      const lock = (): Promise<void> => mutex.lockAsync()
                      try {
                        return (Atomics as any).waitAsync(i32a, 0, value).value.then(lock, lock)
                      } catch (err) {
                        return lock()
                      }
                    }, */
                    signal: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        Atomics.add(i32a, 0, 1);
                        Atomics.notify(i32a, 0, 1);
                    }
                };
                return cond;
            },
            getQueueSize: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue_size, true);
            },
            addQueueSize: function (func) {
                var offset = emnapiTSFN.offset.queue_size;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.add(arr, index, 1);
            },
            subQueueSize: function (func) {
                var offset = emnapiTSFN.offset.queue_size;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.sub(arr, index, 1);
            },
            getThreadCount: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.thread_count, true);
            },
            addThreadCount: function (func) {
                var offset = emnapiTSFN.offset.thread_count;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.add(arr, index, 1);
            },
            subThreadCount: function (func) {
                var offset = emnapiTSFN.offset.thread_count;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.sub(arr, index, 1);
            },
            getIsClosing: function (func) {
                return Atomics.load(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.is_closing) >> 2);
            },
            setIsClosing: function (func, value) {
                Atomics.store(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.is_closing) >> 2, value);
            },
            getHandlesClosing: function (func) {
                return Atomics.load(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.handles_closing) >> 2);
            },
            setHandlesClosing: function (func, value) {
                Atomics.store(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.handles_closing) >> 2, value);
            },
            getDispatchState: function (func) {
                return Atomics.load(new Uint32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.dispatch_state) >> 2);
            },
            getContext: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.context, false);
            },
            getMaxQueueSize: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.max_queue_size, true);
            },
            getEnv: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.env, false);
            },
            getCallJSCb: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.call_js_cb, false);
            },
            getRef: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.ref, false);
            },
            getResource: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.resource, false);
            },
            getFinalizeCb: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.finalize_cb, false);
            },
            getFinalizeData: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.finalize_data, false);
            },
            loadSizeTypeValue: function (offset, unsigned) {
                var ret;
                var arr;
                if (unsigned) {
                    arr = new Uint32Array(wasmMemory.buffer);
                    ret = Atomics.load(arr, offset >> 2);
                    return ret;
                }
                else {
                    arr = new Int32Array(wasmMemory.buffer);
                    ret = Atomics.load(arr, offset >> 2);
                    return ret;
                }
            },
            storeSizeTypeValue: function (offset, value, unsigned) {
                var arr;
                if (unsigned) {
                    arr = new Uint32Array(wasmMemory.buffer);
                    Atomics.store(arr, offset >> 2, value);
                    return undefined;
                }
                else {
                    arr = new Int32Array(wasmMemory.buffer);
                    Atomics.store(arr, offset >> 2, value >>> 0);
                    return undefined;
                }
            },
            destroy: function (func) {
                emnapiTSFN.destroyQueue(func);
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                var ref = emnapiTSFN.getRef(func);
                if (ref) {
                    emnapiCtx.refStore.get(ref).dispose();
                }
                emnapiCtx.removeCleanupHook(envObject, emnapiTSFN.cleanup, func);
                envObject.unref();
                var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
                var arr = new Int32Array(wasmMemory.buffer);
                if (Atomics.load(arr, asyncRefOffset)) {
                    Atomics.store(arr, asyncRefOffset, 0);
                    emnapiCtx.decreaseWaitingRequestCounter();
                }
                var resource = emnapiTSFN.getResource(func);
                emnapiCtx.refStore.get(resource).dispose();
                if (emnapiNodeBinding) {
                    var view = new DataView(wasmMemory.buffer);
                    var asyncId = view.getFloat64(func + emnapiTSFN.offset.async_id, true);
                    var triggerAsyncId = view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true);
                    _emnapi_node_emit_async_destroy(asyncId, triggerAsyncId);
                }
                _free(func);
            },
            emptyQueueAndDelete: function (func) {
                var callJsCb = emnapiTSFN.getCallJSCb(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var context = emnapiTSFN.getContext(func);
                var data;
                while (emnapiTSFN.getQueueSize(func) > 0) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    data = emnapiTSFN.shiftQueue(func);
                    if (callJsCb) {
                        (wasmTable.get(callJsCb))(0, 0, context, data);
                    }
                }
                emnapiTSFN.destroy(func);
            },
            finalize: function (func) {
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                emnapiCtx.openScope(envObject);
                var finalize = emnapiTSFN.getFinalizeCb(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var data = emnapiTSFN.getFinalizeData(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var context = emnapiTSFN.getContext(func);
                var f = function () {
                    envObject.callFinalizerInternal(0, finalize, data, context);
                };
                try {
                    if (finalize) {
                        if (emnapiNodeBinding) {
                            var resource = emnapiTSFN.getResource(func);
                            var resource_value = emnapiCtx.refStore.get(resource).get();
                            var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                            var view = new DataView(wasmMemory.buffer);
                            var asyncId = view.getFloat64(func + emnapiTSFN.offset.async_id, true);
                            var triggerAsyncId = view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true);
                            emnapiNodeBinding.node.makeCallback(resourceObject, f, [], {
                                asyncId: asyncId,
                                triggerAsyncId: triggerAsyncId
                            });
                        }
                        else {
                            f();
                        }
                    }
                    emnapiTSFN.emptyQueueAndDelete(func);
                }
                finally {
                    emnapiCtx.closeScope(envObject);
                }
            },
            cleanup: function (func) {
                emnapiTSFN.closeHandlesAndMaybeDelete(func, 1);
            },
            closeHandlesAndMaybeDelete: function (func, set_closing) {
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                emnapiCtx.openScope(envObject);
                try {
                    if (set_closing) {
                        emnapiTSFN.getMutex(func).execute(function () {
                            emnapiTSFN.setIsClosing(func, 1);
                            if (emnapiTSFN.getMaxQueueSize(func) > 0) {
                                emnapiTSFN.getCond(func).signal();
                            }
                        });
                    }
                    if (emnapiTSFN.getHandlesClosing(func)) {
                        return;
                    }
                    emnapiTSFN.setHandlesClosing(func, 1);
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiTSFN.finalize(func);
                    });
                }
                finally {
                    emnapiCtx.closeScope(envObject);
                }
            },
            dispatchOne: function (func) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var data = 0;
                var popped_value = false;
                var has_more = false;
                var mutex = emnapiTSFN.getMutex(func);
                var cond = emnapiTSFN.getCond(func);
                mutex.execute(function () {
                    if (emnapiTSFN.getIsClosing(func)) {
                        emnapiTSFN.closeHandlesAndMaybeDelete(func, 0);
                    }
                    else {
                        var size = emnapiTSFN.getQueueSize(func);
                        if (size > 0) {
                            data = emnapiTSFN.shiftQueue(func);
                            popped_value = true;
                            var maxQueueSize = emnapiTSFN.getMaxQueueSize(func);
                            if (size === maxQueueSize && maxQueueSize > 0) {
                                cond.signal();
                            }
                            size--;
                        }
                        if (size === 0) {
                            if (emnapiTSFN.getThreadCount(func) === 0) {
                                emnapiTSFN.setIsClosing(func, 1);
                                if (emnapiTSFN.getMaxQueueSize(func) > 0) {
                                    cond.signal();
                                }
                                emnapiTSFN.closeHandlesAndMaybeDelete(func, 0);
                            }
                        }
                        else {
                            has_more = true;
                        }
                    }
                });
                if (popped_value) {
                    var env = emnapiTSFN.getEnv(func);
                    var envObject_1 = emnapiCtx.envStore.get(env);
                    emnapiCtx.openScope(envObject_1);
                    var f = function () {
                        envObject_1.callbackIntoModule(false, function () {
                            var callJsCb = emnapiTSFN.getCallJSCb(func);
                            var ref = emnapiTSFN.getRef(func);
                            var js_callback = ref ? emnapiCtx.refStore.get(ref).get() : 0;
                            if (callJsCb) {
                                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                                var context = emnapiTSFN.getContext(func);
                                (wasmTable.get(callJsCb))(env, js_callback, context, data);
                            }
                            else {
                                var jsCallback = js_callback ? emnapiCtx.handleStore.get(js_callback).value : null;
                                if (typeof jsCallback === 'function') {
                                    jsCallback();
                                }
                            }
                        });
                    };
                    try {
                        if (emnapiNodeBinding) {
                            var resource = emnapiTSFN.getResource(func);
                            var resource_value = emnapiCtx.refStore.get(resource).get();
                            var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                            var view = new DataView(wasmMemory.buffer);
                            emnapiNodeBinding.node.makeCallback(resourceObject, f, [], {
                                asyncId: view.getFloat64(func + emnapiTSFN.offset.async_id, true),
                                triggerAsyncId: view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true)
                            });
                        }
                        else {
                            f();
                        }
                    }
                    finally {
                        emnapiCtx.closeScope(envObject_1);
                    }
                }
                return has_more;
            },
            dispatch: function (func) {
                var has_more = true;
                var iterations_left = 1000;
                var ui32a = new Uint32Array(wasmMemory.buffer);
                var index = (func + emnapiTSFN.offset.dispatch_state) >> 2;
                while (has_more && --iterations_left !== 0) {
                    Atomics.store(ui32a, index, 1);
                    has_more = emnapiTSFN.dispatchOne(func);
                    if (Atomics.exchange(ui32a, index, 0) !== 1) {
                        has_more = true;
                    }
                }
                if (has_more) {
                    emnapiTSFN.send(func);
                }
            },
            send: function (func) {
                var current_state = Atomics.or(new Uint32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.dispatch_state) >> 2, 1 << 1);
                if ((current_state & 1) === 1) {
                    return;
                }
                if ((typeof ENVIRONMENT_IS_PTHREAD !== 'undefined') && ENVIRONMENT_IS_PTHREAD) {
                    postMessage({
                        __emnapi__: {
                            type: 'tsfn-send',
                            payload: {
                                tsfn: func
                            }
                        }
                    });
                }
                else {
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiTSFN.dispatch(func);
                    });
                }
            }
        };
        /** @__sig ippppppppppp */
        function napi_create_threadsafe_function(env, func, async_resource, async_resource_name, max_queue_size, initial_thread_count, thread_finalize_data, thread_finalize_cb, context, call_js_cb, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!async_resource_name)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            max_queue_size = max_queue_size >>> 0;
            initial_thread_count = initial_thread_count >>> 0;
            if (initial_thread_count === 0) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var ref = 0;
            if (!func) {
                if (!call_js_cb)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            else {
                var funcValue = emnapiCtx.handleStore.get(func).value;
                if (typeof funcValue !== 'function') {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                ref = emnapiCtx.createReference(envObject, func, 1, 1 /* ReferenceOwnership.kUserland */).id;
            }
            var asyncResourceObject;
            if (async_resource) {
                asyncResourceObject = emnapiCtx.handleStore.get(async_resource).value;
                if (asyncResourceObject == null) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                asyncResourceObject = Object(asyncResourceObject);
            }
            else {
                asyncResourceObject = {};
            }
            var resource = envObject.ensureHandleId(asyncResourceObject);
            var asyncResourceName = emnapiCtx.handleStore.get(async_resource_name).value;
            if (typeof asyncResourceName === 'symbol') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            asyncResourceName = String(asyncResourceName);
            var resource_name = envObject.ensureHandleId(asyncResourceName);
            // tsfn create
            var sizeofTSFN = emnapiTSFN.offset.end;
            var tsfn = _malloc(sizeofTSFN);
            if (!tsfn)
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            new Uint8Array(wasmMemory.buffer).subarray(tsfn, tsfn + sizeofTSFN).fill(0);
            var resourceRef = emnapiCtx.createReference(envObject, resource, 1, 1 /* ReferenceOwnership.kUserland */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var resource_ = resourceRef.id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(tsfn, resource_, true);
            if (!emnapiTSFN.initQueue(tsfn)) {
                _free(tsfn);
                resourceRef.dispose();
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            _emnapi_node_emit_async_init(resource, resource_name, -1, tsfn + emnapiTSFN.offset.async_id);
            HEAP_DATA_VIEW.setUint32(tsfn + emnapiTSFN.offset.thread_count, initial_thread_count, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.context, context, true);
            HEAP_DATA_VIEW.setUint32(tsfn + emnapiTSFN.offset.max_queue_size, max_queue_size, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.ref, ref, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.env, env, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.finalize_data, thread_finalize_data, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.finalize_cb, thread_finalize_cb, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.call_js_cb, call_js_cb, true);
            emnapiCtx.addCleanupHook(envObject, emnapiTSFN.cleanup, tsfn);
            envObject.ref();
            emnapiCtx.increaseWaitingRequestCounter();
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.async_ref, 1, true);
            HEAP_DATA_VIEW.setInt32(result, tsfn, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_threadsafe_function_context(func, result) {
            if (!func || !result) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var context = emnapiTSFN.getContext(func);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, context, true);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ippi */
        function napi_call_threadsafe_function(func, data, mode) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            return emnapiTSFN.push(func, data, mode);
        }
        /** @__sig ip */
        function napi_acquire_threadsafe_function(func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var mutex = emnapiTSFN.getMutex(func);
            return mutex.execute(function () {
                if (emnapiTSFN.getIsClosing(func)) {
                    return 16 /* napi_status.napi_closing */;
                }
                emnapiTSFN.addThreadCount(func);
                return 0 /* napi_status.napi_ok */;
            });
        }
        /** @__sig ipi */
        function napi_release_threadsafe_function(func, mode) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var mutex = emnapiTSFN.getMutex(func);
            var cond = emnapiTSFN.getCond(func);
            return mutex.execute(function () {
                if (emnapiTSFN.getThreadCount(func) === 0) {
                    return 1 /* napi_status.napi_invalid_arg */;
                }
                emnapiTSFN.subThreadCount(func);
                if (emnapiTSFN.getThreadCount(func) === 0 || mode === 1 /* napi_threadsafe_function_release_mode.napi_tsfn_abort */) {
                    var isClosing = emnapiTSFN.getIsClosing(func);
                    if (!isClosing) {
                        var isClosingValue = (mode === 1 /* napi_threadsafe_function_release_mode.napi_tsfn_abort */) ? 1 : 0;
                        emnapiTSFN.setIsClosing(func, isClosingValue);
                        if (isClosingValue && emnapiTSFN.getMaxQueueSize(func) > 0) {
                            cond.signal();
                        }
                        emnapiTSFN.send(func);
                    }
                }
                return 0 /* napi_status.napi_ok */;
            });
        }
        /** @__sig ipp */
        function napi_unref_threadsafe_function(env, func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
            var arr = new Int32Array(wasmMemory.buffer);
            if (Atomics.load(arr, asyncRefOffset)) {
                Atomics.store(arr, asyncRefOffset, 0);
                emnapiCtx.decreaseWaitingRequestCounter();
            }
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ipp */
        function napi_ref_threadsafe_function(env, func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
            var arr = new Int32Array(wasmMemory.buffer);
            if (!Atomics.load(arr, asyncRefOffset)) {
                Atomics.store(arr, asyncRefOffset, 1);
                emnapiCtx.increaseWaitingRequestCounter();
            }
            return 0 /* napi_status.napi_ok */;
        }
        var emnapiAWMT = {
            unusedWorkers: [],
            runningWorkers: [],
            workQueue: [],
            workerReady: null,
            offset: {
                /* napi_ref */ resource: 0,
                /* double */ async_id: 8,
                /* double */ trigger_async_id: 16,
                /* napi_env */ env: 24,
                /* void* */ data: 1 * 4 + 24,
                /* napi_async_execute_callback */ execute: 2 * 4 + 24,
                /* napi_async_complete_callback */ complete: 3 * 4 + 24,
                end: 4 * 4 + 24
            },
            init: function () {
                emnapiAWMT.unusedWorkers = [];
                emnapiAWMT.runningWorkers = [];
                emnapiAWMT.workQueue = [];
                emnapiAWMT.workerReady = null;
            },
            addListener: function (worker) {
                if (!worker)
                    return false;
                if (worker._emnapiAWMTListener)
                    return true;
                var handler = function (e) {
                    var data = e.data;
                    var __emnapi__ = data.__emnapi__;
                    if (__emnapi__) {
                        var type = __emnapi__.type;
                        var payload = __emnapi__.payload;
                        if (type === 'async-work-complete') {
                            emnapiCtx.decreaseWaitingRequestCounter();
                            emnapiAWMT.runningWorkers.splice(emnapiAWMT.runningWorkers.indexOf(worker), 1);
                            emnapiAWMT.unusedWorkers.push(worker);
                            emnapiAWMT.checkIdleWorker();
                            emnapiAWMT.callComplete(payload.work, 0 /* napi_status.napi_ok */);
                        }
                        else if (type === 'async-work-queue') {
                            emnapiAWMT.scheduleWork(payload.work);
                        }
                        else if (type === 'async-work-cancel') {
                            emnapiAWMT.cancelWork(payload.work);
                        }
                    }
                };
                var dispose = function () {
                    {
                        worker.removeEventListener('message', handler, false);
                    }
                    delete worker._emnapiAWMTListener;
                };
                worker._emnapiAWMTListener = { handler: handler, dispose: dispose };
                {
                    worker.addEventListener('message', handler, false);
                }
                return true;
            },
            initWorkers: function (n) {
                if (ENVIRONMENT_IS_PTHREAD) {
                    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                    return emnapiAWMT.workerReady || (emnapiAWMT.workerReady = Promise.resolve());
                }
                if (emnapiAWMT.workerReady)
                    return emnapiAWMT.workerReady;
                if (typeof onCreateWorker !== 'function') {
                    throw new TypeError('`options.onCreateWorker` is not a function');
                }
                var promises = [];
                var args = [];
                if (!('emnapi_async_worker_create' in wasmInstance.exports)) {
                    throw new TypeError('`emnapi_async_worker_create` is not exported, please try to add `--export=emnapi_async_worker_create` to linker flags');
                }
                for (var i = 0; i < n; ++i) {
                    args.push(wasmInstance.exports.emnapi_async_worker_create());
                }
                try {
                    var _loop_1 = function (i) {
                        var worker = onCreateWorker({ type: 'async-work', name: 'emnapi-async-worker' });
                        var p = PThread.loadWasmModuleToWorker(worker);
                        emnapiAWMT.addListener(worker);
                        promises.push(p.then(function () {
                            if (typeof worker.unref === 'function') {
                                worker.unref();
                            }
                        }));
                        emnapiAWMT.unusedWorkers.push(worker);
                        var arg = args[i];
                        worker.threadBlockBase = arg;
                        worker.postMessage({
                            __emnapi__: {
                                type: 'async-worker-init',
                                payload: { arg: arg }
                            }
                        });
                    };
                    for (var i = 0; i < n; ++i) {
                        _loop_1(i);
                    }
                }
                catch (err) {
                    for (var i = 0; i < n; ++i) {
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                        var arg = args[i];
                        _free(arg);
                    }
                    throw err;
                }
                emnapiAWMT.workerReady = Promise.all(promises);
                return emnapiAWMT.workerReady;
            },
            checkIdleWorker: function () {
                if (emnapiAWMT.unusedWorkers.length > 0 && emnapiAWMT.workQueue.length > 0) {
                    var worker = emnapiAWMT.unusedWorkers.shift();
                    var work = emnapiAWMT.workQueue.shift();
                    emnapiAWMT.runningWorkers.push(worker);
                    worker.postMessage({
                        __emnapi__: {
                            type: 'async-work-execute',
                            payload: { work: work }
                        }
                    });
                }
            },
            getResource: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.resource, false);
            },
            getExecute: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.execute, false);
            },
            getComplete: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.complete, false);
            },
            getEnv: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.env, false);
            },
            getData: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.data, false);
            },
            scheduleWork: function (work) {
                var _a;
                if (ENVIRONMENT_IS_PTHREAD) {
                    var postMessage_1 = napiModule.postMessage;
                    postMessage_1({
                        __emnapi__: {
                            type: 'async-work-queue',
                            payload: { work: work }
                        }
                    });
                    return;
                }
                emnapiCtx.increaseWaitingRequestCounter();
                emnapiAWMT.workQueue.push(work);
                if ((_a = emnapiAWMT.workerReady) === null || _a === void 0 ? void 0 : _a.ready) {
                    emnapiAWMT.checkIdleWorker();
                }
                else {
                    var fail = function (err) {
                        emnapiCtx.decreaseWaitingRequestCounter();
                        throw err;
                    };
                    try {
                        emnapiAWMT.initWorkers(_emnapi_async_work_pool_size()).then(function () {
                            emnapiAWMT.workerReady.ready = true;
                            emnapiAWMT.checkIdleWorker();
                        }, fail);
                    }
                    catch (err) {
                        fail(err);
                    }
                }
            },
            cancelWork: function (work) {
                if (ENVIRONMENT_IS_PTHREAD) {
                    var postMessage_2 = napiModule.postMessage;
                    postMessage_2({
                        __emnapi__: {
                            type: 'async-work-cancel',
                            payload: { work: work }
                        }
                    });
                    return 0 /* napi_status.napi_ok */;
                }
                var index = emnapiAWMT.workQueue.indexOf(work);
                if (index !== -1) {
                    emnapiAWMT.workQueue.splice(index, 1);
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiCtx.decreaseWaitingRequestCounter();
                        emnapiAWMT.checkIdleWorker();
                        emnapiAWMT.callComplete(work, 11 /* napi_status.napi_cancelled */);
                    });
                    return 0 /* napi_status.napi_ok */;
                }
                return 9 /* napi_status.napi_generic_failure */;
            },
            callComplete: function (work, status) {
                var complete = emnapiAWMT.getComplete(work);
                var env = emnapiAWMT.getEnv(work);
                var data = emnapiAWMT.getData(work);
                var envObject = emnapiCtx.envStore.get(env);
                var scope = emnapiCtx.openScope(envObject);
                var callback = function () {
                    if (!complete)
                        return;
                    envObject.callbackIntoModule(true, function () {
                        (wasmTable.get(complete))(env, status, data);
                    });
                };
                try {
                    if (emnapiNodeBinding) {
                        var resource = emnapiAWMT.getResource(work);
                        var resource_value = emnapiCtx.refStore.get(resource).get();
                        var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                        var view = new DataView(wasmMemory.buffer);
                        var asyncId = view.getFloat64(work + emnapiAWMT.offset.async_id, true);
                        var triggerAsyncId = view.getFloat64(work + emnapiAWMT.offset.trigger_async_id, true);
                        emnapiNodeBinding.node.makeCallback(resourceObject, callback, [], {
                            asyncId: asyncId,
                            triggerAsyncId: triggerAsyncId
                        });
                    }
                    else {
                        callback();
                    }
                }
                finally {
                    emnapiCtx.closeScope(envObject, scope);
                }
            }
        };
        /** @__sig ippppppp */
        var napi_create_async_work = singleThreadAsyncWork
            ? function (env, resource, resource_name, execute, complete, data, result) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!execute)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceObject;
                if (resource) {
                    resourceObject = Object(emnapiCtx.handleStore.get(resource).value);
                }
                else {
                    resourceObject = {};
                }
                if (!resource_name)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceName = String(emnapiCtx.handleStore.get(resource_name).value);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var id = emnapiAWST.create(env, resourceObject, resourceName, execute, complete, data);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, id, true);
                return envObject.clearLastError();
            }
            : function (env, resource, resource_name, execute, complete, data, result) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!execute)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceObject;
                if (resource) {
                    resourceObject = Object(emnapiCtx.handleStore.get(resource).value);
                }
                else {
                    resourceObject = {};
                }
                if (!resource_name)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var sizeofAW = emnapiAWMT.offset.end;
                var aw = _malloc(sizeofAW);
                if (!aw)
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                new Uint8Array(wasmMemory.buffer).subarray(aw, aw + sizeofAW).fill(0);
                var s = envObject.ensureHandleId(resourceObject);
                var resourceRef = emnapiCtx.createReference(envObject, s, 1, 1 /* ReferenceOwnership.kUserland */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var resource_ = resourceRef.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(aw, resource_, true);
                _emnapi_node_emit_async_init(s, resource_name, -1, aw + emnapiAWMT.offset.async_id);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.env, env, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.execute, execute, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.complete, complete, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.data, data, true);
                HEAP_DATA_VIEW.setInt32(result, aw, true);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_delete_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWST.remove(work);
                return envObject.clearLastError();
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resource = emnapiAWMT.getResource(work);
                emnapiCtx.refStore.get(resource).dispose();
                if (emnapiNodeBinding) {
                    var view = new DataView(wasmMemory.buffer);
                    var asyncId = view.getFloat64(work + emnapiAWMT.offset.async_id, true);
                    var triggerAsyncId = view.getFloat64(work + emnapiAWMT.offset.trigger_async_id, true);
                    _emnapi_node_emit_async_destroy(asyncId, triggerAsyncId);
                }
                _free(work);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_queue_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWST.queue(work);
                return envObject.clearLastError();
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWMT.scheduleWork(work);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_cancel_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = emnapiAWST.cancel(work);
                if (status === 0 /* napi_status.napi_ok */)
                    return envObject.clearLastError();
                return envObject.setLastError(status);
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = emnapiAWMT.cancelWork(work);
                if (status === 0 /* napi_status.napi_ok */)
                    return envObject.clearLastError();
                return envObject.setLastError(status);
            };
        function initWorker(startArg) {
            if (napiModule.childThread) {
                if (typeof wasmInstance.exports.emnapi_async_worker_init !== 'function') {
                    throw new TypeError('`emnapi_async_worker_init` is not exported, please try to add `--export=emnapi_async_worker_init` to linker flags');
                }
                wasmInstance.exports.emnapi_async_worker_init(startArg);
            }
            else {
                throw new Error('startThread is only available in child threads');
            }
        }
        function executeAsyncWork(work) {
            if (!ENVIRONMENT_IS_PTHREAD)
                return;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var execute = emnapiAWMT.getExecute(work);
            var env = emnapiAWMT.getEnv(work);
            var data = emnapiAWMT.getData(work);
            (wasmTable.get(execute))(env, data);
            var postMessage = napiModule.postMessage;
            postMessage({
                __emnapi__: {
                    type: 'async-work-complete',
                    payload: { work: work }
                }
            });
        }
        napiModule.initWorker = initWorker;
        napiModule.executeAsyncWork = executeAsyncWork;
        var asyncWorkMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_cancel_async_work: napi_cancel_async_work,
            napi_create_async_work: napi_create_async_work,
            napi_delete_async_work: napi_delete_async_work,
            napi_queue_async_work: napi_queue_async_work
        });
        /**
         * @__deps malloc
         * @__deps free
         * @__postset
         * ```
         * emnapiExternalMemory.init();
         * ```
         */
        var emnapiExternalMemory = {
            registry: typeof FinalizationRegistry === 'function' ? new FinalizationRegistry(function (_pointer) { _free(_pointer); }) : undefined,
            table: new WeakMap(),
            wasmMemoryViewTable: new WeakMap(),
            init: function () {
                emnapiExternalMemory.registry = typeof FinalizationRegistry === 'function' ? new FinalizationRegistry(function (_pointer) { _free(_pointer); }) : undefined;
                emnapiExternalMemory.table = new WeakMap();
                emnapiExternalMemory.wasmMemoryViewTable = new WeakMap();
            },
            isDetachedArrayBuffer: function (arrayBuffer) {
                if (arrayBuffer.byteLength === 0) {
                    try {
                        // eslint-disable-next-line no-new
                        new Uint8Array(arrayBuffer);
                    }
                    catch (_) {
                        return true;
                    }
                }
                return false;
            },
            getArrayBufferPointer: function (arrayBuffer, shouldCopy) {
                var _a;
                var info = {
                    address: 0,
                    ownership: 0 /* ReferenceOwnership.kRuntime */,
                    runtimeAllocated: 0
                };
                if (arrayBuffer === wasmMemory.buffer) {
                    return info;
                }
                var isDetached = emnapiExternalMemory.isDetachedArrayBuffer(arrayBuffer);
                if (emnapiExternalMemory.table.has(arrayBuffer)) {
                    var cachedInfo = emnapiExternalMemory.table.get(arrayBuffer);
                    if (isDetached) {
                        cachedInfo.address = 0;
                        return cachedInfo;
                    }
                    if (shouldCopy && cachedInfo.ownership === 0 /* ReferenceOwnership.kRuntime */ && cachedInfo.runtimeAllocated === 1) {
                        new Uint8Array(wasmMemory.buffer).set(new Uint8Array(arrayBuffer), cachedInfo.address);
                    }
                    return cachedInfo;
                }
                if (isDetached || (arrayBuffer.byteLength === 0)) {
                    return info;
                }
                if (!shouldCopy) {
                    return info;
                }
                var pointer = _malloc(arrayBuffer.byteLength);
                if (!pointer)
                    throw new Error('Out of memory');
                new Uint8Array(wasmMemory.buffer).set(new Uint8Array(arrayBuffer), pointer);
                info.address = pointer;
                info.ownership = emnapiExternalMemory.registry ? 0 /* ReferenceOwnership.kRuntime */ : 1 /* ReferenceOwnership.kUserland */;
                info.runtimeAllocated = 1;
                emnapiExternalMemory.table.set(arrayBuffer, info);
                (_a = emnapiExternalMemory.registry) === null || _a === void 0 ? void 0 : _a.register(arrayBuffer, pointer);
                return info;
            },
            getOrUpdateMemoryView: function (view) {
                if (view.buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(view, {
                            Ctor: view.constructor,
                            address: view.byteOffset,
                            length: view instanceof DataView ? view.byteLength : view.length,
                            ownership: 1 /* ReferenceOwnership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                    return view;
                }
                var maybeOldWasmMemory = emnapiExternalMemory.isDetachedArrayBuffer(view.buffer) ||
                    ((typeof SharedArrayBuffer === 'function') && (view.buffer instanceof SharedArrayBuffer));
                if (maybeOldWasmMemory && emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                    var info = emnapiExternalMemory.wasmMemoryViewTable.get(view);
                    var Ctor = info.Ctor;
                    var newView = void 0;
                    var Buffer_1 = emnapiCtx.feature.Buffer;
                    if (typeof Buffer_1 === 'function' && Ctor === Buffer_1) {
                        newView = Buffer_1.from(wasmMemory.buffer, info.address, info.length);
                    }
                    else {
                        newView = new Ctor(wasmMemory.buffer, info.address, info.length);
                    }
                    emnapiExternalMemory.wasmMemoryViewTable.set(newView, info);
                    return newView;
                }
                return view;
            },
            getViewPointer: function (view, shouldCopy) {
                view = emnapiExternalMemory.getOrUpdateMemoryView(view);
                if (view.buffer === wasmMemory.buffer) {
                    if (emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                        var _a = emnapiExternalMemory.wasmMemoryViewTable.get(view), address_1 = _a.address, ownership_1 = _a.ownership, runtimeAllocated_1 = _a.runtimeAllocated;
                        return { address: address_1, ownership: ownership_1, runtimeAllocated: runtimeAllocated_1, view: view };
                    }
                    return { address: view.byteOffset, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0, view: view };
                }
                var _b = emnapiExternalMemory.getArrayBufferPointer(view.buffer, shouldCopy), address = _b.address, ownership = _b.ownership, runtimeAllocated = _b.runtimeAllocated;
                return { address: address === 0 ? 0 : (address + view.byteOffset), ownership: ownership, runtimeAllocated: runtimeAllocated, view: view };
            }
        };
        /* eslint-disable @typescript-eslint/indent */
        /**
         * @__postset
         * ```
         * emnapiString.init();
         * ```
         */
        var emnapiString = {
            utf8Decoder: undefined,
            utf16Decoder: undefined,
            init: function () {
                var fallbackDecoder = {
                    decode: function (bytes) {
                        var inputIndex = 0;
                        var pendingSize = Math.min(0x1000, bytes.length + 1);
                        var pending = new Uint16Array(pendingSize);
                        var chunks = [];
                        var pendingIndex = 0;
                        for (;;) {
                            var more = inputIndex < bytes.length;
                            if (!more || (pendingIndex >= pendingSize - 1)) {
                                var subarray = pending.subarray(0, pendingIndex);
                                var arraylike = subarray;
                                chunks.push(String.fromCharCode.apply(null, arraylike));
                                if (!more) {
                                    return chunks.join('');
                                }
                                bytes = bytes.subarray(inputIndex);
                                inputIndex = 0;
                                pendingIndex = 0;
                            }
                            var byte1 = bytes[inputIndex++];
                            if ((byte1 & 0x80) === 0) {
                                pending[pendingIndex++] = byte1;
                            }
                            else if ((byte1 & 0xe0) === 0xc0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                pending[pendingIndex++] = ((byte1 & 0x1f) << 6) | byte2;
                            }
                            else if ((byte1 & 0xf0) === 0xe0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                var byte3 = bytes[inputIndex++] & 0x3f;
                                pending[pendingIndex++] = ((byte1 & 0x1f) << 12) | (byte2 << 6) | byte3;
                            }
                            else if ((byte1 & 0xf8) === 0xf0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                var byte3 = bytes[inputIndex++] & 0x3f;
                                var byte4 = bytes[inputIndex++] & 0x3f;
                                var codepoint = ((byte1 & 0x07) << 0x12) | (byte2 << 0x0c) | (byte3 << 0x06) | byte4;
                                if (codepoint > 0xffff) {
                                    codepoint -= 0x10000;
                                    pending[pendingIndex++] = (codepoint >>> 10) & 0x3ff | 0xd800;
                                    codepoint = 0xdc00 | codepoint & 0x3ff;
                                }
                                pending[pendingIndex++] = codepoint;
                            }
                            else ;
                        }
                    }
                };
                var utf8Decoder;
                utf8Decoder = typeof TextDecoder === 'function' ? new TextDecoder() : fallbackDecoder;
                emnapiString.utf8Decoder = utf8Decoder;
                var fallbackDecoder2 = {
                    decode: function (input) {
                        var bytes = new Uint16Array(input.buffer, input.byteOffset, input.byteLength / 2);
                        if (bytes.length <= 0x1000) {
                            return String.fromCharCode.apply(null, bytes);
                        }
                        var chunks = [];
                        var i = 0;
                        var len = 0;
                        for (; i < bytes.length; i += len) {
                            len = Math.min(0x1000, bytes.length - i);
                            chunks.push(String.fromCharCode.apply(null, bytes.subarray(i, i + len)));
                        }
                        return chunks.join('');
                    }
                };
                var utf16Decoder;
                utf16Decoder = typeof TextDecoder === 'function' ? new TextDecoder('utf-16le') : fallbackDecoder2;
                emnapiString.utf16Decoder = utf16Decoder;
            },
            lengthBytesUTF8: function (str) {
                var c;
                var len = 0;
                for (var i = 0; i < str.length; ++i) {
                    c = str.charCodeAt(i);
                    if (c <= 0x7F) {
                        len++;
                    }
                    else if (c <= 0x7FF) {
                        len += 2;
                    }
                    else if (c >= 0xD800 && c <= 0xDFFF) {
                        len += 4;
                        ++i;
                    }
                    else {
                        len += 3;
                    }
                }
                return len;
            },
            UTF8ToString: function (ptr, length) {
                if (!ptr || !length)
                    return '';
                ptr >>>= 0;
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                var end = ptr;
                if (length === -1) {
                    for (; HEAPU8[end];)
                        ++end;
                }
                else {
                    end = ptr + (length >>> 0);
                }
                length = end - ptr;
                if (length <= 16) {
                    var idx = ptr;
                    var str = '';
                    while (idx < end) {
                        var u0 = HEAPU8[idx++];
                        if (!(u0 & 0x80)) {
                            str += String.fromCharCode(u0);
                            continue;
                        }
                        var u1 = HEAPU8[idx++] & 63;
                        if ((u0 & 0xE0) === 0xC0) {
                            str += String.fromCharCode(((u0 & 31) << 6) | u1);
                            continue;
                        }
                        var u2 = HEAPU8[idx++] & 63;
                        if ((u0 & 0xF0) === 0xE0) {
                            u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
                        }
                        else {
                            u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | (HEAPU8[idx++] & 63);
                        }
                        if (u0 < 0x10000) {
                            str += String.fromCharCode(u0);
                        }
                        else {
                            var ch = u0 - 0x10000;
                            str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
                        }
                    }
                    return str;
                }
                return emnapiString.utf8Decoder.decode(((typeof SharedArrayBuffer === "function" && HEAPU8.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(HEAPU8.buffer) === "[object SharedArrayBuffer]")) ? HEAPU8.slice(ptr, end) : HEAPU8.subarray(ptr, end));
            },
            stringToUTF8: function (str, outPtr, maxBytesToWrite) {
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                var outIdx = outPtr;
                outIdx >>>= 0;
                if (!(maxBytesToWrite > 0)) {
                    return 0;
                }
                var startIdx = outIdx;
                var endIdx = outIdx + maxBytesToWrite - 1;
                for (var i = 0; i < str.length; ++i) {
                    var u = str.charCodeAt(i);
                    if (u >= 0xD800 && u <= 0xDFFF) {
                        var u1 = str.charCodeAt(++i);
                        u = 0x10000 + ((u & 0x3FF) << 10) | (u1 & 0x3FF);
                    }
                    if (u <= 0x7F) {
                        if (outIdx >= endIdx)
                            break;
                        HEAPU8[outIdx++] = u;
                    }
                    else if (u <= 0x7FF) {
                        if (outIdx + 1 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xC0 | (u >> 6);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                    else if (u <= 0xFFFF) {
                        if (outIdx + 2 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xE0 | (u >> 12);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 6) & 63);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                    else {
                        if (outIdx + 3 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xF0 | (u >> 18);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 12) & 63);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 6) & 63);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                }
                HEAPU8[outIdx] = 0;
                return outIdx - startIdx;
            },
            UTF16ToString: function (ptr, length) {
                if (!ptr || !length)
                    return '';
                ptr >>>= 0;
                var end = ptr;
                if (length === -1) {
                    var idx = end >> 1;
                    var HEAPU16 = new Uint16Array(wasmMemory.buffer);
                    while (HEAPU16[idx])
                        ++idx;
                    end = idx << 1;
                }
                else {
                    end = ptr + (length >>> 0) * 2;
                }
                length = end - ptr;
                if (length <= 32) {
                    return String.fromCharCode.apply(null, new Uint16Array(wasmMemory.buffer, ptr, length / 2));
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                return emnapiString.utf16Decoder.decode(((typeof SharedArrayBuffer === "function" && HEAPU8.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(HEAPU8.buffer) === "[object SharedArrayBuffer]")) ? HEAPU8.slice(ptr, end) : HEAPU8.subarray(ptr, end));
            },
            stringToUTF16: function (str, outPtr, maxBytesToWrite) {
                if (maxBytesToWrite === undefined) {
                    maxBytesToWrite = 0x7FFFFFFF;
                }
                if (maxBytesToWrite < 2)
                    return 0;
                maxBytesToWrite -= 2;
                var startPtr = outPtr;
                var numCharsToWrite = (maxBytesToWrite < str.length * 2) ? (maxBytesToWrite / 2) : str.length;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < numCharsToWrite; ++i) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var codeUnit = str.charCodeAt(i);
                    HEAP_DATA_VIEW.setInt16(outPtr, codeUnit, true);
                    outPtr += 2;
                }
                HEAP_DATA_VIEW.setInt16(outPtr, 0, true);
                return outPtr - startPtr;
            },
            newString: function (env, str, length, result, stringMaker) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                var autoLength = length === -1;
                var sizelength = length >>> 0;
                if (length !== 0) {
                    if (!str)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!(autoLength || (sizelength <= 2147483647)))
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var strValue = stringMaker(str, autoLength, sizelength);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = emnapiCtx.addToCurrentScope(strValue).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            },
            newExternalString: function (env, str, length, finalize_callback, finalize_hint, result, copied, createApi, stringMaker) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                var autoLength = length === -1;
                var sizelength = length >>> 0;
                if (length !== 0) {
                    if (!str)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!(autoLength || (sizelength <= 2147483647)))
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = createApi(env, str, length, result);
                if (status === 0 /* napi_status.napi_ok */) {
                    if (copied) {
                        var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                        HEAP_DATA_VIEW.setInt8(copied, 1, true);
                    }
                    if (finalize_callback) {
                        envObject.callFinalizer(finalize_callback, str, finalize_hint);
                    }
                }
                return status;
            }
        };
        /**
         * @__sig ippp
         */
        function napi_get_array_length(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (!handle.isArray()) {
                    return envObject.setLastError(8 /* napi_status.napi_array_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = handle.value.length >>> 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function napi_get_arraybuffer_info(env, arraybuffer, data, byte_length) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!arraybuffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(arraybuffer);
            if (!handle.isArrayBuffer()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (data) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = emnapiExternalMemory.getArrayBufferPointer(handle.value, true).address;
                HEAP_DATA_VIEW.setInt32(data, p, true);
            }
            if (byte_length) {
                HEAP_DATA_VIEW.setUint32(byte_length, handle.value.byteLength, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_prototype(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = handle.isObject() || handle.isFunction() ? handle.value : Object(handle.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = envObject.ensureHandleId(Object.getPrototypeOf(v));
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, p, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppppp
         */
        function napi_get_typedarray_info(env, typedarray, type, length, data, arraybuffer, byte_offset) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!typedarray)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(typedarray);
            if (!handle.isTypedArray()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var v = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (type) {
                var t = void 0;
                if (v instanceof Int8Array) {
                    t = 0 /* napi_typedarray_type.napi_int8_array */;
                }
                else if (v instanceof Uint8Array) {
                    t = 1 /* napi_typedarray_type.napi_uint8_array */;
                }
                else if (v instanceof Uint8ClampedArray) {
                    t = 2 /* napi_typedarray_type.napi_uint8_clamped_array */;
                }
                else if (v instanceof Int16Array) {
                    t = 3 /* napi_typedarray_type.napi_int16_array */;
                }
                else if (v instanceof Uint16Array) {
                    t = 4 /* napi_typedarray_type.napi_uint16_array */;
                }
                else if (v instanceof Int32Array) {
                    t = 5 /* napi_typedarray_type.napi_int32_array */;
                }
                else if (v instanceof Uint32Array) {
                    t = 6 /* napi_typedarray_type.napi_uint32_array */;
                }
                else if (v instanceof Float32Array) {
                    t = 7 /* napi_typedarray_type.napi_float32_array */;
                }
                else if (v instanceof Float64Array) {
                    t = 8 /* napi_typedarray_type.napi_float64_array */;
                }
                else if (v instanceof BigInt64Array) {
                    t = 9 /* napi_typedarray_type.napi_bigint64_array */;
                }
                else if (v instanceof BigUint64Array) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    t = 10 /* napi_typedarray_type.napi_biguint64_array */;
                }
                else {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                HEAP_DATA_VIEW.setInt32(type, t, true);
            }
            if (length) {
                HEAP_DATA_VIEW.setUint32(length, v.length, true);
            }
            var buffer;
            if (data || arraybuffer) {
                buffer = v.buffer;
                if (data) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var p = emnapiExternalMemory.getViewPointer(v, true).address;
                    HEAP_DATA_VIEW.setInt32(data, p, true);
                }
                if (arraybuffer) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var ab = envObject.ensureHandleId(buffer);
                    HEAP_DATA_VIEW.setInt32(arraybuffer, ab, true);
                }
            }
            if (byte_offset) {
                HEAP_DATA_VIEW.setUint32(byte_offset, v.byteOffset, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_buffer_info(env, buffer, data, length) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!buffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(buffer);
            if (!handle.isBuffer(emnapiCtx.feature.Buffer))
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (handle.isDataView()) {
                return napi_get_dataview_info(env, buffer, length, data, 0, 0);
            }
            return napi_get_typedarray_info(env, buffer, 0, length, data, 0, 0);
        }
        /**
         * @__sig ipppppp
         */
        function napi_get_dataview_info(env, dataview, byte_length, data, arraybuffer, byte_offset) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!dataview)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(dataview);
            if (!handle.isDataView()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var v = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (byte_length) {
                HEAP_DATA_VIEW.setUint32(byte_length, v.byteLength, true);
            }
            var buffer;
            if (data || arraybuffer) {
                buffer = v.buffer;
                if (data) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var p = emnapiExternalMemory.getViewPointer(v, true).address;
                    HEAP_DATA_VIEW.setInt32(data, p, true);
                }
                if (arraybuffer) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var ab = envObject.ensureHandleId(buffer);
                    HEAP_DATA_VIEW.setInt32(arraybuffer, ab, true);
                }
            }
            if (byte_offset) {
                HEAP_DATA_VIEW.setUint32(byte_offset, v.byteOffset, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_date_value(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (!handle.isDate()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                v = handle.value.valueOf();
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setFloat64(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_bool(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'boolean') {
                return envObject.setLastError(7 /* napi_status.napi_boolean_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = handle.value ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_double(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setFloat64(result, r, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_value_bigint_int64(env, value, result, lossless) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!lossless)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            var numberValue = handle.value;
            if (typeof numberValue !== 'bigint') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if ((numberValue >= (BigInt(-1) * (BigInt(1) << BigInt(63)))) && (numberValue < (BigInt(1) << BigInt(63)))) {
                HEAP_DATA_VIEW.setInt8(lossless, 1, true);
            }
            else {
                HEAP_DATA_VIEW.setInt8(lossless, 0, true);
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                if (numberValue >= (BigInt(1) << BigInt(63))) {
                    numberValue = numberValue - (BigInt(1) << BigInt(64));
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            HEAP_DATA_VIEW.setInt32(result, low, true);
            HEAP_DATA_VIEW.setInt32(result + 4, high, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_value_bigint_uint64(env, value, result, lossless) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!lossless)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            var numberValue = handle.value;
            if (typeof numberValue !== 'bigint') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if ((numberValue >= BigInt(0)) && (numberValue < (BigInt(1) << BigInt(64)))) {
                HEAP_DATA_VIEW.setInt8(lossless, 1, true);
            }
            else {
                HEAP_DATA_VIEW.setInt8(lossless, 0, true);
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            HEAP_DATA_VIEW.setUint32(result, low, true);
            HEAP_DATA_VIEW.setUint32(result + 4, high, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_bigint_words(env, value, sign_bit, word_count, words) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!word_count)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (!handle.isBigInt()) {
                return envObject.setLastError(17 /* napi_status.napi_bigint_expected */);
            }
            var isMinus = handle.value < BigInt(0);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var word_count_int = HEAP_DATA_VIEW.getUint32(word_count, true);
            var wordCount = 0;
            var bigintValue = isMinus ? (handle.value * BigInt(-1)) : handle.value;
            while (bigintValue !== BigInt(0)) {
                wordCount++;
                bigintValue = bigintValue >> BigInt(64);
            }
            bigintValue = isMinus ? (handle.value * BigInt(-1)) : handle.value;
            if (!sign_bit && !words) {
                word_count_int = wordCount;
                HEAP_DATA_VIEW.setUint32(word_count, word_count_int, true);
            }
            else {
                if (!sign_bit)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!words)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var wordsArr = [];
                while (bigintValue !== BigInt(0)) {
                    var uint64 = bigintValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                    wordsArr.push(uint64);
                    bigintValue = bigintValue >> BigInt(64);
                }
                var len = Math.min(word_count_int, wordsArr.length);
                for (var i = 0; i < len; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var low = Number(wordsArr[i] & BigInt(0xffffffff));
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var high = Number(wordsArr[i] >> BigInt(32));
                    HEAP_DATA_VIEW.setUint32(words + i * 8, low, true);
                    HEAP_DATA_VIEW.setUint32(words + (i * 8 + 4), high, true);
                }
                HEAP_DATA_VIEW.setInt32(sign_bit, isMinus ? 1 : 0, true);
                HEAP_DATA_VIEW.setUint32(word_count, len, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_external(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (!handle.isExternal()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var p = handle.data();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, p, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_int32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = new Int32Array([handle.value])[0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_int64(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var numberValue = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (numberValue === Number.POSITIVE_INFINITY || numberValue === Number.NEGATIVE_INFINITY || isNaN(numberValue)) {
                HEAP_DATA_VIEW.setInt32(result, 0, true);
                HEAP_DATA_VIEW.setInt32(result + 4, 0, true);
            }
            else if (numberValue < /* INT64_RANGE_NEGATIVE */ -9223372036854776e3) {
                HEAP_DATA_VIEW.setInt32(result, 0, true);
                HEAP_DATA_VIEW.setInt32(result + 4, 2147483648, true);
            }
            else if (numberValue >= /* INT64_RANGE_POSITIVE */ 9223372036854776000) {
                HEAP_DATA_VIEW.setUint32(result, 4294967295, true);
                HEAP_DATA_VIEW.setUint32(result + 4, 2147483647, true);
            }
            else {
                $emnapiSetValueI64(result, Math.trunc(numberValue));
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_latin1(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                HEAP_DATA_VIEW.setUint32(result, handle.value.length, true);
            }
            else if (buf_size !== 0) {
                var copied = 0;
                var v = void 0;
                for (var i = 0; i < buf_size - 1; ++i) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    v = handle.value.charCodeAt(i) & 0xff;
                    HEAP_DATA_VIEW.setUint8(buf + i, v, true);
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    copied++;
                }
                HEAP_DATA_VIEW.setUint8(buf + copied, 0, true);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_utf8(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var strLength = emnapiString.lengthBytesUTF8(handle.value);
                HEAP_DATA_VIEW.setUint32(result, strLength, true);
            }
            else if (buf_size !== 0) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var copied = emnapiString.stringToUTF8(handle.value, buf, buf_size);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_utf16(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                HEAP_DATA_VIEW.setUint32(result, handle.value.length, true);
            }
            else if (buf_size !== 0) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var copied = emnapiString.stringToUTF16(handle.value, buf, buf_size * 2);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied / 2, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_uint32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = new Uint32Array([handle.value])[0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(result, v, true);
            return envObject.clearLastError();
        }
        var convert2cMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_array_length: napi_get_array_length,
            napi_get_arraybuffer_info: napi_get_arraybuffer_info,
            napi_get_buffer_info: napi_get_buffer_info,
            napi_get_dataview_info: napi_get_dataview_info,
            napi_get_date_value: napi_get_date_value,
            napi_get_prototype: napi_get_prototype,
            napi_get_typedarray_info: napi_get_typedarray_info,
            napi_get_value_bigint_int64: napi_get_value_bigint_int64,
            napi_get_value_bigint_uint64: napi_get_value_bigint_uint64,
            napi_get_value_bigint_words: napi_get_value_bigint_words,
            napi_get_value_bool: napi_get_value_bool,
            napi_get_value_double: napi_get_value_double,
            napi_get_value_external: napi_get_value_external,
            napi_get_value_int32: napi_get_value_int32,
            napi_get_value_int64: napi_get_value_int64,
            napi_get_value_string_latin1: napi_get_value_string_latin1,
            napi_get_value_string_utf16: napi_get_value_string_utf16,
            napi_get_value_string_utf8: napi_get_value_string_utf8,
            napi_get_value_uint32: napi_get_value_uint32
        });
        /**
         * @__sig ipip
         */
        function napi_create_int32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipip
         */
        function napi_create_uint32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value >>> 0).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipjp
         */
        function napi_create_int64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = Number(low);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipdp
         */
        function napi_create_double(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_latin1(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str, autoLength, sizeLength) {
                var latin1String = '';
                var len = 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (autoLength) {
                    while (true) {
                        var ch = HEAP_DATA_VIEW.getUint8(str, true);
                        if (!ch)
                            break;
                        latin1String += String.fromCharCode(ch);
                        str++;
                    }
                }
                else {
                    while (len < sizeLength) {
                        var ch = HEAP_DATA_VIEW.getUint8(str, true);
                        if (!ch)
                            break;
                        latin1String += String.fromCharCode(ch);
                        len++;
                        str++;
                    }
                }
                return latin1String;
            });
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_utf16(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str) {
                return emnapiString.UTF16ToString(str, length);
            });
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_utf8(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str) {
                return emnapiString.UTF8ToString(str, length);
            });
        }
        /**
         * @__sig ippppppp
         */
        function node_api_create_external_string_latin1(env, str, length, finalize_callback, finalize_hint, result, copied) {
            return emnapiString.newExternalString(env, str, length, finalize_callback, finalize_hint, result, copied, napi_create_string_latin1, undefined);
        }
        /**
         * @__sig ippppppp
         */
        function node_api_create_external_string_utf16(env, str, length, finalize_callback, finalize_hint, result, copied) {
            return emnapiString.newExternalString(env, str, length, finalize_callback, finalize_hint, result, copied, napi_create_string_utf16, undefined);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_latin1(env, str, length, result) {
            return napi_create_string_latin1(env, str, length, result);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_utf8(env, str, length, result) {
            return napi_create_string_utf8(env, str, length, result);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_utf16(env, str, length, result) {
            return napi_create_string_utf16(env, str, length, result);
        }
        /**
         * @__sig ipjp
         */
        function napi_create_bigint_int64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = low;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipjp
         */
        function napi_create_bigint_uint64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = low & ((BigInt(1) << BigInt(64)) - BigInt(1));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipippp
         */
        function napi_create_bigint_words(env, sign_bit, word_count, words, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v, i;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiCtx.feature.supportBigInt) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                word_count = word_count >>> 0;
                if (word_count > 2147483647) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (word_count > (1024 * 1024 / (4 * 8) / 2)) {
                    throw new RangeError('Maximum BigInt size exceeded');
                }
                var value = BigInt(0);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (i = 0; i < word_count; i++) {
                    var low = HEAP_DATA_VIEW.getUint32(words + i * 8, true);
                    var high = HEAP_DATA_VIEW.getUint32(words + (i * 8 + 4), true);
                    var wordi = BigInt(low) | (BigInt(high) << BigInt(32));
                    value += wordi << BigInt(64 * i);
                }
                value *= ((BigInt(sign_bit) % BigInt(2) === BigInt(0)) ? BigInt(1) : BigInt(-1));
                v = emnapiCtx.addToCurrentScope(value).id;
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var convert2napiMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_bigint_int64: napi_create_bigint_int64,
            napi_create_bigint_uint64: napi_create_bigint_uint64,
            napi_create_bigint_words: napi_create_bigint_words,
            napi_create_double: napi_create_double,
            napi_create_int32: napi_create_int32,
            napi_create_int64: napi_create_int64,
            napi_create_string_latin1: napi_create_string_latin1,
            napi_create_string_utf16: napi_create_string_utf16,
            napi_create_string_utf8: napi_create_string_utf8,
            napi_create_uint32: napi_create_uint32,
            node_api_create_external_string_latin1: node_api_create_external_string_latin1,
            node_api_create_external_string_utf16: node_api_create_external_string_utf16,
            node_api_create_property_key_latin1: node_api_create_property_key_latin1,
            node_api_create_property_key_utf16: node_api_create_property_key_utf16,
            node_api_create_property_key_utf8: node_api_create_property_key_utf8
        });
        function emnapiCreateFunction(envObject, utf8name, length, cb, data) {
            var functionName = (!utf8name || !length) ? '' : (emnapiString.UTF8ToString(utf8name, length));
            var f;
            var napiCallback = (wasmTable.get(cb));
            var callback = function (envObject) {
                return napiCallback(envObject.id, envObject.ctx.scopeStore.currentScope.id);
            };
            var makeFunction = function (envObject, callback) {
                return function () {
                    var scope = envObject.ctx.openScope(envObject);
                    var callbackInfo = scope.callbackInfo;
                    callbackInfo.data = data;
                    callbackInfo.args = arguments;
                    callbackInfo.thiz = this;
                    callbackInfo.fn = f;
                    try {
                        var napiValue = envObject.callIntoModule(callback);
                        return (!napiValue) ? undefined : envObject.ctx.handleStore.get(napiValue).value;
                    }
                    finally {
                        callbackInfo.data = 0;
                        callbackInfo.args = undefined;
                        callbackInfo.thiz = undefined;
                        callbackInfo.fn = undefined;
                        envObject.ctx.closeScope(envObject, scope);
                    }
                };
            };
            if (functionName === '') {
                f = makeFunction(envObject, callback);
                return { status: 0 /* napi_status.napi_ok */, f: f };
            }
            if (!(/^[_$a-zA-Z][_$a-zA-Z0-9]*$/.test(functionName))) {
                return { status: 1 /* napi_status.napi_invalid_arg */, f: undefined };
            }
            if (emnapiCtx.feature.supportNewFunction) {
                var _ = makeFunction(envObject, callback);
                try {
                    f = (new Function('_', 'return function ' + functionName + '(){' +
                        '"use strict";' +
                        'return _.apply(this,arguments);' +
                        '};'))(_);
                }
                catch (_err) {
                    f = makeFunction(envObject, callback);
                    if (emnapiCtx.feature.canSetFunctionName)
                        Object.defineProperty(f, 'name', { value: functionName });
                }
            }
            else {
                f = makeFunction(envObject, callback);
                if (emnapiCtx.feature.canSetFunctionName)
                    Object.defineProperty(f, 'name', { value: functionName });
            }
            return { status: 0 /* napi_status.napi_ok */, f: f };
        }
        function emnapiDefineProperty(envObject, obj, propertyName, method, getter, setter, value, attributes, data) {
            if (getter || setter) {
                var localGetter = void 0;
                var localSetter = void 0;
                if (getter) {
                    localGetter = emnapiCreateFunction(envObject, 0, 0, getter, data).f;
                }
                if (setter) {
                    localSetter = emnapiCreateFunction(envObject, 0, 0, setter, data).f;
                }
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    get: localGetter,
                    set: localSetter
                };
                Object.defineProperty(obj, propertyName, desc);
            }
            else if (method) {
                var localMethod = emnapiCreateFunction(envObject, 0, 0, method, data).f;
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    writable: (attributes & 1 /* napi_property_attributes.napi_writable */) !== 0,
                    value: localMethod
                };
                Object.defineProperty(obj, propertyName, desc);
            }
            else {
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    writable: (attributes & 1 /* napi_property_attributes.napi_writable */) !== 0,
                    value: emnapiCtx.handleStore.get(value).value
                };
                Object.defineProperty(obj, propertyName, desc);
            }
        }
        function emnapiGetHandle(js_object) {
            var handle = emnapiCtx.handleStore.get(js_object);
            if (!(handle.isObject() || handle.isFunction())) {
                return { status: 1 /* napi_status.napi_invalid_arg */ };
            }
            if (typeof emnapiExternalMemory !== 'undefined' && ArrayBuffer.isView(handle.value)) {
                if (emnapiExternalMemory.wasmMemoryViewTable.has(handle.value)) {
                    handle = emnapiCtx.addToCurrentScope(emnapiExternalMemory.wasmMemoryViewTable.get(handle.value));
                }
            }
            return { status: 0 /* napi_status.napi_ok */, handle: handle };
        }
        function emnapiWrap(env, js_object, native_object, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var referenceId;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiCtx.feature.supportFinalizer) {
                    if (finalize_cb) {
                        throw emnapiCtx.createNotSupportWeakRefError('napi_wrap', 'Parameter "finalize_cb" must be 0(NULL)');
                    }
                    if (result) {
                        throw emnapiCtx.createNotSupportWeakRefError('napi_wrap', 'Parameter "result" must be 0(NULL)');
                    }
                }
                if (!js_object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handleResult = emnapiGetHandle(js_object);
                if (handleResult.status !== 0 /* napi_status.napi_ok */) {
                    return envObject.setLastError(handleResult.status);
                }
                var handle = handleResult.handle;
                if (envObject.getObjectBinding(handle.value).wrapped !== 0) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var reference = void 0;
                if (result) {
                    if (!finalize_cb)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                    reference = emnapiCtx.createReferenceWithFinalizer(envObject, handle.id, 0, 1 /* ReferenceOwnership.kUserland */, finalize_cb, native_object, finalize_hint);
                    referenceId = reference.id;
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, referenceId, true);
                }
                else {
                    if (finalize_cb) {
                        reference = emnapiCtx.createReferenceWithFinalizer(envObject, handle.id, 0, 0 /* ReferenceOwnership.kRuntime */, finalize_cb, native_object, finalize_hint);
                    }
                    else {
                        reference = emnapiCtx.createReferenceWithData(envObject, handle.id, 0, 0 /* ReferenceOwnership.kRuntime */, native_object);
                    }
                }
                envObject.getObjectBinding(handle.value).wrapped = reference.id;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        function emnapiUnwrap(env, js_object, result, action) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var data;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!js_object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (action === 0 /* UnwrapAction.KeepWrap */) {
                    if (!result)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(js_object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                var referenceId = binding.wrapped;
                var ref = emnapiCtx.refStore.get(referenceId);
                if (!ref)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (result) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    data = ref.data();
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, data, true);
                }
                if (action === 1 /* UnwrapAction.RemoveWrap */) {
                    binding.wrapped = 0;
                    if (ref.ownership() === 1 /* ReferenceOwnership.kUserland */) {
                        // When the wrap is been removed, the finalizer should be reset.
                        ref.resetFinalizer();
                    }
                    else {
                        ref.dispose();
                    }
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppppp
         */
        function napi_define_class(env, utf8name, length, constructor, callback_data, property_count, properties, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var propPtr, valueHandleId, attributes;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                property_count = property_count >>> 0;
                if (property_count > 0) {
                    if (!properties)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if ((length < -1) || (length > 2147483647) || (!utf8name)) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var fresult = emnapiCreateFunction(envObject, utf8name, length, constructor, callback_data);
                if (fresult.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(fresult.status);
                var F = fresult.f;
                var propertyName = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < property_count; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    propPtr = properties + (i * (4 * 8));
                    var utf8Name = HEAP_DATA_VIEW.getInt32(propPtr, true);
                    var name_1 = HEAP_DATA_VIEW.getInt32(propPtr + 4, true);
                    var method = HEAP_DATA_VIEW.getInt32(propPtr + 8, true);
                    var getter = HEAP_DATA_VIEW.getInt32(propPtr + 12, true);
                    var setter = HEAP_DATA_VIEW.getInt32(propPtr + 16, true);
                    var value = HEAP_DATA_VIEW.getInt32(propPtr + 20, true);
                    attributes = HEAP_DATA_VIEW.getInt32(propPtr + 24, true);
                    var data = HEAP_DATA_VIEW.getInt32(propPtr + 28, true);
                    if (utf8Name) {
                        propertyName = emnapiString.UTF8ToString(utf8Name, -1);
                    }
                    else {
                        if (!name_1) {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                        propertyName = emnapiCtx.handleStore.get(name_1).value;
                        if (typeof propertyName !== 'string' && typeof propertyName !== 'symbol') {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                    }
                    if ((attributes & 1024 /* napi_property_attributes.napi_static */) !== 0) {
                        emnapiDefineProperty(envObject, F, propertyName, method, getter, setter, value, attributes, data);
                        continue;
                    }
                    emnapiDefineProperty(envObject, F.prototype, propertyName, method, getter, setter, value, attributes, data);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var valueHandle = emnapiCtx.addToCurrentScope(F);
                valueHandleId = valueHandle.id;
                HEAP_DATA_VIEW.setInt32(result, valueHandleId, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_wrap(env, js_object, native_object, finalize_cb, finalize_hint, result) {
            return emnapiWrap(env, js_object, native_object, finalize_cb, finalize_hint, result);
        }
        /**
         * @__sig ippp
         */
        function napi_unwrap(env, js_object, result) {
            return emnapiUnwrap(env, js_object, result, 0 /* UnwrapAction.KeepWrap */);
        }
        /**
         * @__sig ippp
         */
        function napi_remove_wrap(env, js_object, result) {
            return emnapiUnwrap(env, js_object, result, 1 /* UnwrapAction.RemoveWrap */);
        }
        /**
         * @__sig ippp
         */
        function napi_type_tag_object(env, object, type_tag) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 2 /* napi_status.napi_object_expected */);
                }
                if (!type_tag) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                if (binding.tag !== null) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var tag = new Uint8Array(16);
                tag.set(new Uint8Array(wasmMemory.buffer, type_tag, 16));
                binding.tag = new Uint32Array(tag.buffer);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function napi_check_object_type_tag(env, object, type_tag, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars, one-var
            var ret = true;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 2 /* napi_status.napi_object_expected */);
                }
                if (!type_tag) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                if (!result) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                if (binding.tag !== null) {
                    var tag = binding.tag;
                    var typeTag = new Uint32Array(wasmMemory.buffer, type_tag, 4);
                    ret = (tag[0] === typeTag[0] &&
                        tag[1] === typeTag[1] &&
                        tag[2] === typeTag[2] &&
                        tag[3] === typeTag[3]);
                }
                else {
                    ret = false;
                }
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, ret ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_add_finalizer(env, js_object, finalize_data, finalize_cb, finalize_hint, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportFinalizer) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!js_object)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!finalize_cb)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handleResult = emnapiGetHandle(js_object);
            if (handleResult.status !== 0 /* napi_status.napi_ok */) {
                return envObject.setLastError(handleResult.status);
            }
            var handle = handleResult.handle;
            var ownership = !result ? 0 /* ReferenceOwnership.kRuntime */ : 1 /* ReferenceOwnership.kUserland */;
            var reference = emnapiCtx.createReferenceWithFinalizer(envObject, handle.id, 0, ownership, finalize_cb, finalize_data, finalize_hint);
            if (result) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var referenceId = reference.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, referenceId, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function node_api_post_finalizer(env, finalize_cb, finalize_data, finalize_hint) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            envObject.enqueueFinalizer(emnapiCtx.createTrackedFinalizer(envObject, finalize_cb, finalize_data, finalize_hint));
            return envObject.clearLastError();
        }
        var wrapMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_add_finalizer: napi_add_finalizer,
            napi_check_object_type_tag: napi_check_object_type_tag,
            napi_define_class: napi_define_class,
            napi_remove_wrap: napi_remove_wrap,
            napi_type_tag_object: napi_type_tag_object,
            napi_unwrap: napi_unwrap,
            napi_wrap: napi_wrap,
            node_api_post_finalizer: node_api_post_finalizer
        });
        /**
         * @__sig ipippppp
         */
        function emnapi_create_memory_view(env, typedarray_type, external_data, byte_length, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                if (!external_data) {
                    byte_length = 0;
                }
                if (byte_length > 2147483647) {
                    throw new RangeError('Cannot create a memory view larger than 2147483647 bytes');
                }
                if ((external_data + byte_length) > wasmMemory.buffer.byteLength) {
                    throw new RangeError('Memory out of range');
                }
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('emnapi_create_memory_view', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var viewDescriptor = void 0;
                switch (typedarray_type) {
                    case 0 /* emnapi_memory_view_type.emnapi_int8_array */:
                        viewDescriptor = { Ctor: Int8Array, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 1 /* emnapi_memory_view_type.emnapi_uint8_array */:
                        viewDescriptor = { Ctor: Uint8Array, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 2 /* emnapi_memory_view_type.emnapi_uint8_clamped_array */:
                        viewDescriptor = { Ctor: Uint8ClampedArray, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 3 /* emnapi_memory_view_type.emnapi_int16_array */:
                        viewDescriptor = { Ctor: Int16Array, address: external_data, length: byte_length >> 1, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 4 /* emnapi_memory_view_type.emnapi_uint16_array */:
                        viewDescriptor = { Ctor: Uint16Array, address: external_data, length: byte_length >> 1, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 5 /* emnapi_memory_view_type.emnapi_int32_array */:
                        viewDescriptor = { Ctor: Int32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 6 /* emnapi_memory_view_type.emnapi_uint32_array */:
                        viewDescriptor = { Ctor: Uint32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 7 /* emnapi_memory_view_type.emnapi_float32_array */:
                        viewDescriptor = { Ctor: Float32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 8 /* emnapi_memory_view_type.emnapi_float64_array */:
                        viewDescriptor = { Ctor: Float64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 9 /* emnapi_memory_view_type.emnapi_bigint64_array */:
                        viewDescriptor = { Ctor: BigInt64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 10 /* emnapi_memory_view_type.emnapi_biguint64_array */:
                        viewDescriptor = { Ctor: BigUint64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case -1 /* emnapi_memory_view_type.emnapi_data_view */:
                        viewDescriptor = { Ctor: DataView, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case -2 /* emnapi_memory_view_type.emnapi_buffer */: {
                        if (!emnapiCtx.feature.Buffer) {
                            throw emnapiCtx.createNotSupportBufferError('emnapi_create_memory_view', '');
                        }
                        viewDescriptor = { Ctor: emnapiCtx.feature.Buffer, address: external_data, length: byte_length, ownership: 1 /* ReferenceOwnership.kUserland */, runtimeAllocated: 0 };
                        break;
                    }
                    default: return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var Ctor = viewDescriptor.Ctor;
                var typedArray = typedarray_type === -2 /* emnapi_memory_view_type.emnapi_buffer */
                    ? emnapiCtx.feature.Buffer.from(wasmMemory.buffer, viewDescriptor.address, viewDescriptor.length)
                    : new Ctor(wasmMemory.buffer, viewDescriptor.address, viewDescriptor.length);
                var handle = emnapiCtx.addToCurrentScope(typedArray);
                emnapiExternalMemory.wasmMemoryViewTable.set(typedArray, viewDescriptor);
                if (finalize_cb) {
                    var status_1 = napi_add_finalizer(env, handle.id, external_data, finalize_cb, finalize_hint, /* NULL */ 0);
                    if (status_1 === 10 /* napi_status.napi_pending_exception */) {
                        var err = envObject.tryCatch.extractException();
                        envObject.clearLastError();
                        throw err;
                    }
                    else if (status_1 !== 0 /* napi_status.napi_ok */) {
                        return envObject.setLastError(status_1);
                    }
                }
                value = handle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig i
         */
        function emnapi_is_support_weakref() {
            return emnapiCtx.feature.supportFinalizer ? 1 : 0;
        }
        /**
         * @__sig i
         */
        function emnapi_is_support_bigint() {
            return emnapiCtx.feature.supportBigInt ? 1 : 0;
        }
        /**
         * @__sig i
         */
        function emnapi_is_node_binding_available() {
            return emnapiNodeBinding ? 1 : 0;
        }
        function $emnapiSyncMemory(js_to_wasm, arrayBufferOrView, offset, len) {
            offset = offset !== null && offset !== void 0 ? offset : 0;
            offset = offset >>> 0;
            var view;
            if (arrayBufferOrView instanceof ArrayBuffer) {
                var pointer = emnapiExternalMemory.getArrayBufferPointer(arrayBufferOrView, false).address;
                if (!pointer)
                    throw new Error('Unknown ArrayBuffer address');
                if (typeof len !== 'number' || len === -1) {
                    len = arrayBufferOrView.byteLength - offset;
                }
                len = len >>> 0;
                if (len === 0)
                    return arrayBufferOrView;
                view = new Uint8Array(arrayBufferOrView, offset, len);
                var wasmMemoryU8 = new Uint8Array(wasmMemory.buffer);
                if (!js_to_wasm) {
                    view.set(wasmMemoryU8.subarray(pointer, pointer + len));
                }
                else {
                    wasmMemoryU8.set(view, pointer);
                }
                return arrayBufferOrView;
            }
            if (ArrayBuffer.isView(arrayBufferOrView)) {
                var viewPointerInfo = emnapiExternalMemory.getViewPointer(arrayBufferOrView, false);
                var latestView = viewPointerInfo.view;
                var pointer = viewPointerInfo.address;
                if (!pointer)
                    throw new Error('Unknown ArrayBuffer address');
                if (typeof len !== 'number' || len === -1) {
                    len = latestView.byteLength - offset;
                }
                len = len >>> 0;
                if (len === 0)
                    return latestView;
                view = new Uint8Array(latestView.buffer, latestView.byteOffset + offset, len);
                var wasmMemoryU8 = new Uint8Array(wasmMemory.buffer);
                if (!js_to_wasm) {
                    view.set(wasmMemoryU8.subarray(pointer, pointer + len));
                }
                else {
                    wasmMemoryU8.set(view, pointer);
                }
                return latestView;
            }
            throw new TypeError('emnapiSyncMemory expect ArrayBuffer or ArrayBufferView as first parameter');
        }
        /**
         * @__sig ipippp
         */
        function emnapi_sync_memory(env, js_to_wasm, arraybuffer_or_view, offset, len) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer_or_view)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var handleId = HEAP_DATA_VIEW.getInt32(arraybuffer_or_view, true);
                var handle = envObject.ctx.handleStore.get(handleId);
                if (!handle.isArrayBuffer() && !handle.isTypedArray() && !handle.isDataView()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var ret = $emnapiSyncMemory(Boolean(js_to_wasm), handle.value, offset, len);
                if (handle.value !== ret) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(arraybuffer_or_view, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        function $emnapiGetMemoryAddress(arrayBufferOrView) {
            var isArrayBuffer = arrayBufferOrView instanceof ArrayBuffer;
            var isDataView = arrayBufferOrView instanceof DataView;
            var isTypedArray = ArrayBuffer.isView(arrayBufferOrView) && !isDataView;
            if (!isArrayBuffer && !isTypedArray && !isDataView) {
                throw new TypeError('emnapiGetMemoryAddress expect ArrayBuffer or ArrayBufferView as first parameter');
            }
            var info;
            if (isArrayBuffer) {
                info = emnapiExternalMemory.getArrayBufferPointer(arrayBufferOrView, false);
            }
            else {
                info = emnapiExternalMemory.getViewPointer(arrayBufferOrView, false);
            }
            return {
                address: info.address,
                ownership: info.ownership,
                runtimeAllocated: info.runtimeAllocated
            };
        }
        /**
         * @__sig ipppp
         */
        function emnapi_get_memory_address(env, arraybuffer_or_view, address, ownership, runtime_allocated) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var p, runtimeAllocated, ownershipOut;
            var info;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer_or_view)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!address && !ownership && !runtime_allocated) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var handle = envObject.ctx.handleStore.get(arraybuffer_or_view);
                info = $emnapiGetMemoryAddress(handle.value);
                p = info.address;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (address) {
                    HEAP_DATA_VIEW.setInt32(address, p, true);
                }
                if (ownership) {
                    ownershipOut = info.ownership;
                    HEAP_DATA_VIEW.setInt32(ownership, ownershipOut, true);
                }
                if (runtime_allocated) {
                    runtimeAllocated = info.runtimeAllocated;
                    HEAP_DATA_VIEW.setInt8(runtime_allocated, runtimeAllocated, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipp
         */
        function emnapi_get_runtime_version(env, version) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!version)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var runtimeVersion;
            try {
                runtimeVersion = emnapiCtx.getRuntimeVersions().version;
            }
            catch (_) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var versions = runtimeVersion.split('.')
                .map(function (n) { return Number(n); });
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(version, versions[0], true);
            HEAP_DATA_VIEW.setUint32(version + 4, versions[1], true);
            HEAP_DATA_VIEW.setUint32(version + 8, versions[2], true);
            return envObject.clearLastError();
        }
        var emnapiMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            $emnapiGetMemoryAddress: $emnapiGetMemoryAddress,
            $emnapiSyncMemory: $emnapiSyncMemory,
            emnapi_create_memory_view: emnapi_create_memory_view,
            emnapi_get_memory_address: emnapi_get_memory_address,
            emnapi_get_runtime_version: emnapi_get_runtime_version,
            emnapi_is_node_binding_available: emnapi_is_node_binding_available,
            emnapi_is_support_bigint: emnapi_is_support_bigint,
            emnapi_is_support_weakref: emnapi_is_support_weakref,
            emnapi_sync_memory: emnapi_sync_memory
        });
        /**
         * @__sig ipp
         */
        function napi_create_array(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope([]).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_create_array_with_length(env, length, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            length = length >>> 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(new Array(length)).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        function emnapiCreateArrayBuffer(byte_length, data) {
            byte_length = byte_length >>> 0;
            var arrayBuffer = new ArrayBuffer(byte_length);
            if (data) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = emnapiExternalMemory.getArrayBufferPointer(arrayBuffer, true).address;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(data, p, true);
            }
            return arrayBuffer;
        }
        /**
         * @__sig ipppp
         */
        function napi_create_arraybuffer(env, byte_length, data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var arrayBuffer = emnapiCreateArrayBuffer(byte_length, data);
                value = emnapiCtx.addToCurrentScope(arrayBuffer).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipdp
         */
        function napi_create_date(env, time, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(new Date(time)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_external(env, data, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('napi_create_external', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var externalHandle = emnapiCtx.getCurrentScope().addExternal(data);
                if (finalize_cb) {
                    emnapiCtx.createReferenceWithFinalizer(envObject, externalHandle.id, 0, 0 /* ReferenceOwnership.kRuntime */, finalize_cb, data, finalize_hint);
                }
                value = externalHandle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_create_external_arraybuffer(env, external_data, byte_length, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                if (!external_data) {
                    byte_length = 0;
                }
                if ((external_data + byte_length) > wasmMemory.buffer.byteLength) {
                    throw new RangeError('Memory out of range');
                }
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('napi_create_external_arraybuffer', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var arrayBuffer = new ArrayBuffer(byte_length);
                if (byte_length === 0) {
                    try {
                        var MessageChannel_1 = emnapiCtx.feature.MessageChannel;
                        var messageChannel = new MessageChannel_1();
                        messageChannel.port1.postMessage(arrayBuffer, [arrayBuffer]);
                    }
                    catch (_) { }
                }
                else {
                    var u8arr = new Uint8Array(arrayBuffer);
                    u8arr.set(new Uint8Array(wasmMemory.buffer).subarray(external_data, external_data + byte_length));
                    emnapiExternalMemory.table.set(arrayBuffer, {
                        address: external_data,
                        ownership: 1 /* ReferenceOwnership.kUserland */,
                        runtimeAllocated: 0
                    });
                }
                var handle = emnapiCtx.addToCurrentScope(arrayBuffer);
                if (finalize_cb) {
                    var status_1 = napi_add_finalizer(env, handle.id, external_data, finalize_cb, finalize_hint, /* NULL */ 0);
                    if (status_1 === 10 /* napi_status.napi_pending_exception */) {
                        var err = envObject.tryCatch.extractException();
                        envObject.clearLastError();
                        throw err;
                    }
                    else if (status_1 !== 0 /* napi_status.napi_ok */) {
                        return envObject.setLastError(status_1);
                    }
                }
                value = handle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipp
         */
        function napi_create_object(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope({}).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_create_symbol(env, description, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!description) {
                // eslint-disable-next-line symbol-description, @typescript-eslint/no-unused-vars
                var value = emnapiCtx.addToCurrentScope(Symbol()).id;
                HEAP_DATA_VIEW.setInt32(result, value, true);
            }
            else {
                var handle = emnapiCtx.handleStore.get(description);
                var desc = handle.value;
                if (typeof desc !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = emnapiCtx.addToCurrentScope(Symbol(desc)).id;
                HEAP_DATA_VIEW.setInt32(result, v, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipipppp
         */
        function napi_create_typedarray(env, type, length, arraybuffer, byte_offset, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                if (!handle.isArrayBuffer()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var buffer = handle.value;
                var createTypedArray = function (envObject, Type, size_of_element, buffer, byte_offset, length) {
                    var _a;
                    byte_offset = byte_offset >>> 0;
                    length = length >>> 0;
                    if (size_of_element > 1) {
                        if ((byte_offset) % (size_of_element) !== 0) {
                            var err = new RangeError("start offset of ".concat((_a = Type.name) !== null && _a !== void 0 ? _a : '', " should be a multiple of ").concat(size_of_element));
                            err.code = 'ERR_NAPI_INVALID_TYPEDARRAY_ALIGNMENT';
                            envObject.tryCatch.setError(err);
                            return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                        }
                    }
                    if (((length * size_of_element) + byte_offset) > buffer.byteLength) {
                        var err = new RangeError('Invalid typed array length');
                        err.code = 'ERR_NAPI_INVALID_TYPEDARRAY_LENGTH';
                        envObject.tryCatch.setError(err);
                        return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                    }
                    var out = new Type(buffer, byte_offset, length);
                    if (buffer === wasmMemory.buffer) {
                        if (!emnapiExternalMemory.wasmMemoryViewTable.has(out)) {
                            emnapiExternalMemory.wasmMemoryViewTable.set(out, {
                                Ctor: Type,
                                address: byte_offset,
                                length: length,
                                ownership: 1 /* ReferenceOwnership.kUserland */,
                                runtimeAllocated: 0
                            });
                        }
                    }
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    value = emnapiCtx.addToCurrentScope(out).id;
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                    return envObject.getReturnStatus();
                };
                switch (type) {
                    case 0 /* napi_typedarray_type.napi_int8_array */:
                        return createTypedArray(envObject, Int8Array, 1, buffer, byte_offset, length);
                    case 1 /* napi_typedarray_type.napi_uint8_array */:
                        return createTypedArray(envObject, Uint8Array, 1, buffer, byte_offset, length);
                    case 2 /* napi_typedarray_type.napi_uint8_clamped_array */:
                        return createTypedArray(envObject, Uint8ClampedArray, 1, buffer, byte_offset, length);
                    case 3 /* napi_typedarray_type.napi_int16_array */:
                        return createTypedArray(envObject, Int16Array, 2, buffer, byte_offset, length);
                    case 4 /* napi_typedarray_type.napi_uint16_array */:
                        return createTypedArray(envObject, Uint16Array, 2, buffer, byte_offset, length);
                    case 5 /* napi_typedarray_type.napi_int32_array */:
                        return createTypedArray(envObject, Int32Array, 4, buffer, byte_offset, length);
                    case 6 /* napi_typedarray_type.napi_uint32_array */:
                        return createTypedArray(envObject, Uint32Array, 4, buffer, byte_offset, length);
                    case 7 /* napi_typedarray_type.napi_float32_array */:
                        return createTypedArray(envObject, Float32Array, 4, buffer, byte_offset, length);
                    case 8 /* napi_typedarray_type.napi_float64_array */:
                        return createTypedArray(envObject, Float64Array, 8, buffer, byte_offset, length);
                    case 9 /* napi_typedarray_type.napi_bigint64_array */:
                        return createTypedArray(envObject, BigInt64Array, 8, buffer, byte_offset, length);
                    case 10 /* napi_typedarray_type.napi_biguint64_array */:
                        return createTypedArray(envObject, BigUint64Array, 8, buffer, byte_offset, length);
                    default:
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__deps malloc
         * @__sig ippp
         */
        function napi_create_buffer(env, size, data, result) {
            var _a;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value, pointer;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('napi_create_buffer', '');
                }
                var buffer = void 0;
                size = size >>> 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (!data || (size === 0)) {
                    buffer = Buffer.alloc(size);
                    value = emnapiCtx.addToCurrentScope(buffer).id;
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                }
                else {
                    pointer = _malloc(size);
                    if (!pointer)
                        throw new Error('Out of memory');
                    new Uint8Array(wasmMemory.buffer).subarray(pointer, pointer + size).fill(0);
                    var buffer_1 = Buffer.from(wasmMemory.buffer, pointer, size);
                    var viewDescriptor = {
                        Ctor: Buffer,
                        address: pointer,
                        length: size,
                        ownership: emnapiExternalMemory.registry ? 0 /* ReferenceOwnership.kRuntime */ : 1 /* ReferenceOwnership.kUserland */,
                        runtimeAllocated: 1
                    };
                    emnapiExternalMemory.wasmMemoryViewTable.set(buffer_1, viewDescriptor);
                    (_a = emnapiExternalMemory.registry) === null || _a === void 0 ? void 0 : _a.register(viewDescriptor, pointer);
                    value = emnapiCtx.addToCurrentScope(buffer_1).id;
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                    HEAP_DATA_VIEW.setInt32(data, pointer, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_buffer_copy(env, length, data, result_data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('napi_create_buffer_copy', '');
                }
                var arrayBuffer = emnapiCreateArrayBuffer(length, result_data);
                var buffer = Buffer.from(arrayBuffer);
                buffer.set(new Uint8Array(wasmMemory.buffer).subarray(data, data + length));
                value = emnapiCtx.addToCurrentScope(buffer).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_create_external_buffer(env, length, data, finalize_cb, finalize_hint, result) {
            return emnapi_create_memory_view(env, -2 /* emnapi_memory_view_type.emnapi_buffer */, data, length, finalize_cb, finalize_hint, result);
        }
        /**
         * @__sig ippppp
         */
        function node_api_create_buffer_from_arraybuffer(env, arraybuffer, byte_offset, byte_length, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_offset = byte_offset >>> 0;
                byte_length = byte_length >>> 0;
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                if (!handle.isArrayBuffer()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var buffer = handle.value;
                if ((byte_length + byte_offset) > buffer.byteLength) {
                    var err = new RangeError('The byte offset + length is out of range');
                    err.code = 'ERR_OUT_OF_RANGE';
                    throw err;
                }
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('node_api_create_buffer_from_arraybuffer', '');
                }
                var out = Buffer.from(buffer, byte_offset, byte_length);
                if (buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(out)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(out, {
                            Ctor: Buffer,
                            address: byte_offset,
                            length: byte_length,
                            ownership: 1 /* ReferenceOwnership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(out).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_dataview(env, byte_length, arraybuffer, byte_offset, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                byte_offset = byte_offset >>> 0;
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                if (!handle.isArrayBuffer()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var buffer = handle.value;
                if ((byte_length + byte_offset) > buffer.byteLength) {
                    var err = new RangeError('byte_offset + byte_length should be less than or equal to the size in bytes of the array passed in');
                    err.code = 'ERR_NAPI_INVALID_DATAVIEW_ARGS';
                    throw err;
                }
                var dataview = new DataView(buffer, byte_offset, byte_length);
                if (buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(dataview)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(dataview, {
                            Ctor: DataView,
                            address: byte_offset,
                            length: byte_length,
                            ownership: 1 /* ReferenceOwnership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(dataview).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function node_api_symbol_for(env, utf8description, length, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var autoLength = length === -1;
            var sizelength = length >>> 0;
            if (length !== 0) {
                if (!utf8description)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            if (!(autoLength || (sizelength <= 2147483647))) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var descriptionString = emnapiString.UTF8ToString(utf8description, length);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(Symbol.for(descriptionString)).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var createMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_array: napi_create_array,
            napi_create_array_with_length: napi_create_array_with_length,
            napi_create_arraybuffer: napi_create_arraybuffer,
            napi_create_buffer: napi_create_buffer,
            napi_create_buffer_copy: napi_create_buffer_copy,
            napi_create_dataview: napi_create_dataview,
            napi_create_date: napi_create_date,
            napi_create_external: napi_create_external,
            napi_create_external_arraybuffer: napi_create_external_arraybuffer,
            napi_create_external_buffer: napi_create_external_buffer,
            napi_create_object: napi_create_object,
            napi_create_symbol: napi_create_symbol,
            napi_create_typedarray: napi_create_typedarray,
            node_api_create_buffer_from_arraybuffer: node_api_create_buffer_from_arraybuffer,
            node_api_symbol_for: node_api_symbol_for
        });
        /** @__sig ipip */
        function napi_get_boolean(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = value === 0 ? 3 /* GlobalHandle.FALSE */ : 4 /* GlobalHandle.TRUE */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_global(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 5 /* GlobalHandle.GLOBAL */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_null(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 2 /* GlobalHandle.NULL */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_undefined(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 1 /* GlobalHandle.UNDEFINED */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var globalMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_boolean: napi_get_boolean,
            napi_get_global: napi_get_global,
            napi_get_null: napi_get_null,
            napi_get_undefined: napi_get_undefined
        });
        /** @__sig ipppp */
        function napi_set_instance_data(env, data, finalize_cb, finalize_hint) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            envObject.setInstanceData(data, finalize_cb, finalize_hint);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_instance_data(env, data) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!data)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = envObject.getInstanceData();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(data, value, true);
            return envObject.clearLastError();
        }
        var envMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_instance_data: napi_get_instance_data,
            napi_set_instance_data: napi_set_instance_data
        });
        /** @__sig vpppp */
        function _emnapi_get_last_error_info(env, error_code, engine_error_code, engine_reserved) {
            var envObject = emnapiCtx.envStore.get(env);
            var lastError = envObject.lastError;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var errorCode = lastError.errorCode;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var engineErrorCode = lastError.engineErrorCode >>> 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var engineReserved = lastError.engineReserved;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(error_code, errorCode, true);
            HEAP_DATA_VIEW.setUint32(engine_error_code, engineErrorCode, true);
            HEAP_DATA_VIEW.setInt32(engine_reserved, engineReserved, true);
        }
        /** @__sig ipp */
        function napi_throw(env, error) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!error)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                envObject.tryCatch.setError(emnapiCtx.handleStore.get(error).value);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new Error(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_type_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new TypeError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_range_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new RangeError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function node_api_throw_syntax_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new SyntaxError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_is_exception_pending(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = envObject.tryCatch.hasCaught();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new Error(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_type_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new TypeError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_range_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new RangeError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function node_api_create_syntax_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new SyntaxError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_and_clear_last_exception(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!envObject.tryCatch.hasCaught()) {
                HEAP_DATA_VIEW.setInt32(result, 1, true); // ID_UNDEFINED
                return envObject.clearLastError();
            }
            else {
                var err = envObject.tryCatch.exception();
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = envObject.ensureHandleId(err);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                envObject.tryCatch.reset();
            }
            return envObject.clearLastError();
        }
        /** @__sig vpppp */
        function napi_fatal_error(location, location_len, message, message_len) {
            var locationStr = emnapiString.UTF8ToString(location, location_len);
            var messageStr = emnapiString.UTF8ToString(message, message_len);
            if (emnapiNodeBinding) {
                emnapiNodeBinding.napi.fatalError(locationStr, messageStr);
            }
            else {
                abort('FATAL ERROR: ' + locationStr + ' ' + messageStr);
            }
        }
        /** @__sig ipp */
        function napi_fatal_exception(env, err) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!err)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = envObject.ctx.handleStore.get(err);
                try {
                    envObject.triggerFatalException(error.value);
                }
                catch (_) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var errorMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_get_last_error_info: _emnapi_get_last_error_info,
            napi_create_error: napi_create_error,
            napi_create_range_error: napi_create_range_error,
            napi_create_type_error: napi_create_type_error,
            napi_fatal_error: napi_fatal_error,
            napi_fatal_exception: napi_fatal_exception,
            napi_get_and_clear_last_exception: napi_get_and_clear_last_exception,
            napi_is_exception_pending: napi_is_exception_pending,
            napi_throw: napi_throw,
            napi_throw_error: napi_throw_error,
            napi_throw_range_error: napi_throw_range_error,
            napi_throw_type_error: napi_throw_type_error,
            node_api_create_syntax_error: node_api_create_syntax_error,
            node_api_throw_syntax_error: node_api_throw_syntax_error
        });
        /** @__sig ipppppp */
        function napi_create_function(env, utf8name, length, cb, data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!cb)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var fresult = emnapiCreateFunction(envObject, utf8name, length, cb, data);
                if (fresult.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(fresult.status);
                var f = fresult.f;
                var valueHandle = emnapiCtx.addToCurrentScope(f);
                value = valueHandle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppppp */
        function napi_get_cb_info(env, cbinfo, argc, argv, this_arg, data) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!cbinfo)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var cbinfoValue = emnapiCtx.scopeStore.get(cbinfo).callbackInfo;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (argv) {
                if (!argc)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var argcValue = HEAP_DATA_VIEW.getUint32(argc, true);
                var len = cbinfoValue.args.length;
                var arrlen = argcValue < len ? argcValue : len;
                var i = 0;
                for (; i < arrlen; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var argVal = envObject.ensureHandleId(cbinfoValue.args[i]);
                    HEAP_DATA_VIEW.setInt32(argv + i * 4, argVal, true);
                }
                if (i < argcValue) {
                    for (; i < argcValue; i++) {
                        HEAP_DATA_VIEW.setInt32(argv + i * 4, 1, true);
                    }
                }
            }
            if (argc) {
                HEAP_DATA_VIEW.setUint32(argc, cbinfoValue.args.length, true);
            }
            if (this_arg) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = envObject.ensureHandleId(cbinfoValue.thiz);
                HEAP_DATA_VIEW.setInt32(this_arg, v, true);
            }
            if (data) {
                HEAP_DATA_VIEW.setInt32(data, cbinfoValue.data, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ipppppp */
        function napi_call_function(env, recv, func, argc, argv, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!recv)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                argc = argc >>> 0;
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var v8recv = emnapiCtx.handleStore.get(recv).value;
                if (!func)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var v8func = emnapiCtx.handleStore.get(func).value;
                if (typeof v8func !== 'function')
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var args = [];
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (; i < argc; i++) {
                    var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                    args.push(emnapiCtx.handleStore.get(argVal).value);
                }
                var ret = v8func.apply(v8recv, args);
                if (result) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippppp */
        function napi_new_instance(env, constructor, argc, argv, result) {
            var i;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                argc = argc >>> 0;
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Ctor = emnapiCtx.handleStore.get(constructor).value;
                if (typeof Ctor !== 'function')
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var ret = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (emnapiCtx.feature.supportReflect) {
                    var argList = Array(argc);
                    for (i = 0; i < argc; i++) {
                        var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                        argList[i] = emnapiCtx.handleStore.get(argVal).value;
                    }
                    ret = Reflect.construct(Ctor, argList, Ctor);
                }
                else {
                    var args = Array(argc + 1);
                    args[0] = undefined;
                    for (i = 0; i < argc; i++) {
                        var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                        args[i + 1] = emnapiCtx.handleStore.get(argVal).value;
                    }
                    var BoundCtor = Ctor.bind.apply(Ctor, args);
                    ret = new BoundCtor();
                }
                if (result) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_get_new_target(env, cbinfo, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!cbinfo)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var cbinfoValue = emnapiCtx.scopeStore.get(cbinfo).callbackInfo;
            var thiz = cbinfoValue.thiz, fn = cbinfoValue.fn;
            var value = thiz == null || thiz.constructor == null
                ? 0
                : thiz instanceof fn
                    ? envObject.ensureHandleId(thiz.constructor)
                    : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var functionMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_call_function: napi_call_function,
            napi_create_function: napi_create_function,
            napi_get_cb_info: napi_get_cb_info,
            napi_get_new_target: napi_get_new_target,
            napi_new_instance: napi_new_instance
        });
        /** @__sig ipp */
        function napi_open_handle_scope(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var scope = emnapiCtx.openScope(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, scope.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_close_handle_scope(env, scope) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if ((envObject.openHandleScopes === 0)) {
                return 13 /* napi_status.napi_handle_scope_mismatch */;
            }
            emnapiCtx.closeScope(envObject);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_open_escapable_handle_scope(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var scope = emnapiCtx.openScope(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, scope.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_close_escapable_handle_scope(env, scope) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if ((envObject.openHandleScopes === 0)) {
                return 13 /* napi_status.napi_handle_scope_mismatch */;
            }
            emnapiCtx.closeScope(envObject);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_escape_handle(env, scope, escapee, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!escapee)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var scopeObject = emnapiCtx.scopeStore.get(scope);
            if (!scopeObject.escapeCalled()) {
                var newHandle = scopeObject.escape(escapee);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = newHandle ? newHandle.id : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            }
            return envObject.setLastError(12 /* napi_status.napi_escape_called_twice */);
        }
        /** @__sig ippip */
        function napi_create_reference(env, value, initial_refcount, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (envObject.moduleApiVersion < 10) {
                if (!(handle.isObject() || handle.isFunction() || handle.isSymbol())) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var ref = emnapiCtx.createReference(envObject, handle.id, initial_refcount >>> 0, 1 /* ReferenceOwnership.kUserland */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, ref.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_delete_reference(env, ref) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.refStore.get(ref).dispose();
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_reference_ref(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var count = emnapiCtx.refStore.get(ref).ref();
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, count, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_reference_unref(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var reference = emnapiCtx.refStore.get(ref);
            var refcount = reference.refcount();
            if (refcount === 0) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var count = reference.unref();
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, count, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_get_reference_value(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var reference = emnapiCtx.refStore.get(ref);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var handleId = reference.get(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, handleId, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_add_env_cleanup_hook(env, fun, arg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!fun)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.addCleanupHook(envObject, fun, arg);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ippp */
        function napi_remove_env_cleanup_hook(env, fun, arg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!fun)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.removeCleanupHook(envObject, fun, arg);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig vp */
        function _emnapi_env_ref(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.ref();
        }
        /** @__sig vp */
        function _emnapi_env_unref(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.unref();
        }
        var lifeMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_env_ref: _emnapi_env_ref,
            _emnapi_env_unref: _emnapi_env_unref,
            napi_add_env_cleanup_hook: napi_add_env_cleanup_hook,
            napi_close_escapable_handle_scope: napi_close_escapable_handle_scope,
            napi_close_handle_scope: napi_close_handle_scope,
            napi_create_reference: napi_create_reference,
            napi_delete_reference: napi_delete_reference,
            napi_escape_handle: napi_escape_handle,
            napi_get_reference_value: napi_get_reference_value,
            napi_open_escapable_handle_scope: napi_open_escapable_handle_scope,
            napi_open_handle_scope: napi_open_handle_scope,
            napi_reference_ref: napi_reference_ref,
            napi_reference_unref: napi_reference_unref,
            napi_remove_env_cleanup_hook: napi_remove_env_cleanup_hook
        });
        /** @__sig ippi */
        function _emnapi_get_filename(env, buf, len) {
            var envObject = emnapiCtx.envStore.get(env);
            var filename = envObject.filename;
            if (!buf) {
                return emnapiString.lengthBytesUTF8(filename);
            }
            return emnapiString.stringToUTF8(filename, buf, len);
        }
        var miscellaneousMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_get_filename: _emnapi_get_filename
        });
        /** @__sig ippp */
        function napi_create_promise(env, deferred, promise) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var deferredObjectId, value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!promise)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var p = new Promise(function (resolve, reject) {
                    var deferredObject = emnapiCtx.createDeferred({ resolve: resolve, reject: reject });
                    deferredObjectId = deferredObject.id;
                    HEAP_DATA_VIEW.setInt32(deferred, deferredObjectId, true);
                });
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(p).id;
                HEAP_DATA_VIEW.setInt32(promise, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_resolve_deferred(env, deferred, resolution) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!resolution)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var deferredObject = emnapiCtx.deferredStore.get(deferred);
                deferredObject.resolve(emnapiCtx.handleStore.get(resolution).value);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_reject_deferred(env, deferred, resolution) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!resolution)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var deferredObject = emnapiCtx.deferredStore.get(deferred);
                deferredObject.reject(emnapiCtx.handleStore.get(resolution).value);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_is_promise(env, value, is_promise) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!is_promise)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isPromise() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(is_promise, r, true);
            return envObject.clearLastError();
        }
        var promiseMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_promise: napi_create_promise,
            napi_is_promise: napi_is_promise,
            napi_reject_deferred: napi_reject_deferred,
            napi_resolve_deferred: napi_resolve_deferred
        });
        /** @__sig ippiiip */
        function napi_get_all_property_names(env, object, key_mode, key_filter, key_conversion, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var obj = void 0;
                try {
                    obj = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (key_mode !== 0 /* napi_key_collection_mode.napi_key_include_prototypes */ && key_mode !== 1 /* napi_key_collection_mode.napi_key_own_only */) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (key_conversion !== 0 /* napi_key_conversion.napi_key_keep_numbers */ && key_conversion !== 1 /* napi_key_conversion.napi_key_numbers_to_strings */) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var props = [];
                var names = void 0;
                var symbols = void 0;
                var i = void 0;
                var own = true;
                var integerIndiceRegex = /^(0|[1-9][0-9]*)$/;
                do {
                    names = Object.getOwnPropertyNames(obj);
                    symbols = Object.getOwnPropertySymbols(obj);
                    for (i = 0; i < names.length; i++) {
                        props.push({
                            name: integerIndiceRegex.test(names[i]) ? Number(names[i]) : names[i],
                            desc: Object.getOwnPropertyDescriptor(obj, names[i]),
                            own: own
                        });
                    }
                    for (i = 0; i < symbols.length; i++) {
                        props.push({
                            name: symbols[i],
                            desc: Object.getOwnPropertyDescriptor(obj, symbols[i]),
                            own: own
                        });
                    }
                    if (key_mode === 1 /* napi_key_collection_mode.napi_key_own_only */) {
                        break;
                    }
                    obj = Object.getPrototypeOf(obj);
                    own = false;
                } while (obj);
                var ret = [];
                var addName = function (ret, name, key_filter, conversion_mode) {
                    if (ret.indexOf(name) !== -1)
                        return;
                    if (conversion_mode === 0 /* napi_key_conversion.napi_key_keep_numbers */) {
                        ret.push(name);
                    }
                    else if (conversion_mode === 1 /* napi_key_conversion.napi_key_numbers_to_strings */) {
                        var realName = typeof name === 'number' ? String(name) : name;
                        if (typeof realName === 'string') {
                            if (!(key_filter & 8 /* napi_key_filter.napi_key_skip_strings */)) {
                                ret.push(realName);
                            }
                        }
                        else {
                            ret.push(realName);
                        }
                    }
                };
                for (i = 0; i < props.length; i++) {
                    var prop = props[i];
                    var name_1 = prop.name;
                    var desc = prop.desc;
                    if (key_filter === 0 /* napi_key_filter.napi_key_all_properties */) {
                        addName(ret, name_1, key_filter, key_conversion);
                    }
                    else {
                        if (key_filter & 8 /* napi_key_filter.napi_key_skip_strings */ && typeof name_1 === 'string') {
                            continue;
                        }
                        if (key_filter & 16 /* napi_key_filter.napi_key_skip_symbols */ && typeof name_1 === 'symbol') {
                            continue;
                        }
                        var shouldAdd = true;
                        switch (key_filter & 7) {
                            case 1 /* napi_key_filter.napi_key_writable */: {
                                shouldAdd = Boolean(desc.writable);
                                break;
                            }
                            case 2 /* napi_key_filter.napi_key_enumerable */: {
                                shouldAdd = Boolean(desc.enumerable);
                                break;
                            }
                            case (1 /* napi_key_filter.napi_key_writable */ | 2 /* napi_key_filter.napi_key_enumerable */): {
                                shouldAdd = Boolean(desc.writable && desc.enumerable);
                                break;
                            }
                            case 4 /* napi_key_filter.napi_key_configurable */: {
                                shouldAdd = Boolean(desc.configurable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 1 /* napi_key_filter.napi_key_writable */): {
                                shouldAdd = Boolean(desc.configurable && desc.writable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 2 /* napi_key_filter.napi_key_enumerable */): {
                                shouldAdd = Boolean(desc.configurable && desc.enumerable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 2 /* napi_key_filter.napi_key_enumerable */ | 1 /* napi_key_filter.napi_key_writable */): {
                                shouldAdd = Boolean(desc.configurable && desc.enumerable && desc.writable);
                                break;
                            }
                        }
                        if (shouldAdd) {
                            addName(ret, name_1, key_filter, key_conversion);
                        }
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(ret).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_get_property_names(env, object, result) {
            return napi_get_all_property_names(env, object, 0 /* napi_key_collection_mode.napi_key_include_prototypes */, 2 /* napi_key_filter.napi_key_enumerable */ | 16 /* napi_key_filter.napi_key_skip_symbols */, 1 /* napi_key_conversion.napi_key_numbers_to_strings */, result);
        }
        /** @__sig ipppp */
        function napi_set_property(env, object, key, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                h.value[emnapiCtx.handleStore.get(key).value] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = (emnapiCtx.handleStore.get(key).value in v) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_get_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[emnapiCtx.handleStore.get(key).value]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_delete_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var propertyKey = emnapiCtx.handleStore.get(key).value;
                if (emnapiCtx.feature.supportReflect) {
                    r = Reflect.deleteProperty(h.value, propertyKey);
                }
                else {
                    try {
                        r = delete h.value[propertyKey];
                    }
                    catch (_) {
                        r = false;
                    }
                }
                if (result) {
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_own_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var prop = emnapiCtx.handleStore.get(key).value;
                if (typeof prop !== 'string' && typeof prop !== 'symbol') {
                    return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                }
                r = Object.prototype.hasOwnProperty.call(v, emnapiCtx.handleStore.get(key).value);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_set_named_property(env, object, cname, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (!cname) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                emnapiCtx.handleStore.get(object).value[emnapiString.UTF8ToString(cname, -1)] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_named_property(env, object, utf8name, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!utf8name) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = emnapiString.UTF8ToString(utf8name, -1) in v;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_get_named_property(env, object, utf8name, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!utf8name) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[emnapiString.UTF8ToString(utf8name, -1)]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_set_element(env, object, index, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                h.value[index >>> 0] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_has_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = ((index >>> 0) in v) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_get_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[index >>> 0]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_delete_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (emnapiCtx.feature.supportReflect) {
                    r = Reflect.deleteProperty(h.value, index >>> 0);
                }
                else {
                    try {
                        r = delete h.value[index >>> 0];
                    }
                    catch (_) {
                        r = false;
                    }
                }
                if (result) {
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_define_properties(env, object, property_count, properties) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var propPtr, attributes;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                property_count = property_count >>> 0;
                if (property_count > 0) {
                    if (!properties)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var propertyName = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < property_count; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    propPtr = properties + (i * (4 * 8));
                    var utf8Name = HEAP_DATA_VIEW.getInt32(propPtr, true);
                    var name_2 = HEAP_DATA_VIEW.getInt32(propPtr + 4, true);
                    var method = HEAP_DATA_VIEW.getInt32(propPtr + 8, true);
                    var getter = HEAP_DATA_VIEW.getInt32(propPtr + 12, true);
                    var setter = HEAP_DATA_VIEW.getInt32(propPtr + 16, true);
                    var value = HEAP_DATA_VIEW.getInt32(propPtr + 20, true);
                    attributes = HEAP_DATA_VIEW.getInt32(propPtr + 24, true);
                    var data = HEAP_DATA_VIEW.getInt32(propPtr + 28, true);
                    if (utf8Name) {
                        propertyName = emnapiString.UTF8ToString(utf8Name, -1);
                    }
                    else {
                        if (!name_2) {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                        propertyName = emnapiCtx.handleStore.get(name_2).value;
                        if (typeof propertyName !== 'string' && typeof propertyName !== 'symbol') {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                    }
                    emnapiDefineProperty(envObject, maybeObject, propertyName, method, getter, setter, value, attributes, data);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_object_freeze(env, object) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                Object.freeze(maybeObject);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_object_seal(env, object) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                Object.seal(maybeObject);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var propertyMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_define_properties: napi_define_properties,
            napi_delete_element: napi_delete_element,
            napi_delete_property: napi_delete_property,
            napi_get_all_property_names: napi_get_all_property_names,
            napi_get_element: napi_get_element,
            napi_get_named_property: napi_get_named_property,
            napi_get_property: napi_get_property,
            napi_get_property_names: napi_get_property_names,
            napi_has_element: napi_has_element,
            napi_has_named_property: napi_has_named_property,
            napi_has_own_property: napi_has_own_property,
            napi_has_property: napi_has_property,
            napi_object_freeze: napi_object_freeze,
            napi_object_seal: napi_object_seal,
            napi_set_element: napi_set_element,
            napi_set_named_property: napi_set_named_property,
            napi_set_property: napi_set_property
        });
        /** @__sig ippp */
        function napi_run_script(env, script, result) {
            var status;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!script)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var v8Script = emnapiCtx.handleStore.get(script);
                if (!v8Script.isString()) {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                var g = emnapiCtx.handleStore.get(5 /* GlobalHandle.GLOBAL */).value;
                var ret = g.eval(v8Script.value);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(ret);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                status = envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
            return status;
        }
        var scriptMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_run_script: napi_run_script
        });
        /** @__sig ippp */
        function napi_typeof(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var v = emnapiCtx.handleStore.get(value);
            var r;
            if (v.isNumber()) {
                r = 3 /* napi_valuetype.napi_number */;
            }
            else if (v.isBigInt()) {
                r = 9 /* napi_valuetype.napi_bigint */;
            }
            else if (v.isString()) {
                r = 4 /* napi_valuetype.napi_string */;
            }
            else if (v.isFunction()) {
                // This test has to come before IsObject because IsFunction
                // implies IsObject
                r = 7 /* napi_valuetype.napi_function */;
            }
            else if (v.isExternal()) {
                // This test has to come before IsObject because IsExternal
                // implies IsObject
                r = 8 /* napi_valuetype.napi_external */;
            }
            else if (v.isObject()) {
                r = 6 /* napi_valuetype.napi_object */;
            }
            else if (v.isBoolean()) {
                r = 2 /* napi_valuetype.napi_boolean */;
            }
            else if (v.isUndefined()) {
                r = 0 /* napi_valuetype.napi_undefined */;
            }
            else if (v.isSymbol()) {
                r = 5 /* napi_valuetype.napi_symbol */;
            }
            else if (v.isNull()) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                r = 1 /* napi_valuetype.napi_null */;
            }
            else {
                // Should not get here unless V8 has added some new kind of value.
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_coerce_to_bool(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                v = handle.value ? 4 /* GlobalHandle.TRUE */ : 3 /* GlobalHandle.FALSE */;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_number(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.isBigInt()) {
                    throw new TypeError('Cannot convert a BigInt value to a number');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = emnapiCtx.addToCurrentScope(Number(handle.value)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_object(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = envObject.ensureHandleId(Object(handle.value));
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_string(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.isSymbol()) {
                    throw new TypeError('Cannot convert a Symbol value to a string');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = emnapiCtx.addToCurrentScope(String(handle.value)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_instanceof(env, object, constructor, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, 0, true);
                var ctor = emnapiCtx.handleStore.get(constructor);
                if (!ctor.isFunction()) {
                    return envObject.setLastError(5 /* napi_status.napi_function_expected */);
                }
                var val = emnapiCtx.handleStore.get(object).value;
                var ret = val instanceof ctor.value;
                r = ret ? 1 : 0;
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_is_array(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isArray() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_arraybuffer(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isArrayBuffer() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_date(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isDate() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_error(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var val = emnapiCtx.handleStore.get(value).value;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = (val instanceof Error) ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_typedarray(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isTypedArray() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_buffer(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isBuffer(emnapiCtx.feature.Buffer) ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_dataview(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isDataView() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_strict_equals(env, lhs, rhs, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!lhs)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!rhs)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var lv = emnapiCtx.handleStore.get(lhs).value;
                var rv = emnapiCtx.handleStore.get(rhs).value;
                r = (lv === rv) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_detach_arraybuffer(env, arraybuffer) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!arraybuffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var value = emnapiCtx.handleStore.get(arraybuffer).value;
            if (!(value instanceof ArrayBuffer)) {
                if (typeof SharedArrayBuffer === 'function' && (value instanceof SharedArrayBuffer)) {
                    return envObject.setLastError(20 /* napi_status.napi_detachable_arraybuffer_expected */);
                }
                return envObject.setLastError(19 /* napi_status.napi_arraybuffer_expected */);
            }
            try {
                var MessageChannel_1 = emnapiCtx.feature.MessageChannel;
                var messageChannel = new MessageChannel_1();
                messageChannel.port1.postMessage(value, [value]);
            }
            catch (_) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_detached_arraybuffer(env, arraybuffer, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion >= 10 ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(arraybuffer);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (h.isArrayBuffer() && h.value.byteLength === 0) {
                    try {
                        // eslint-disable-next-line no-new
                        new Uint8Array(h.value);
                    }
                    catch (_) {
                        HEAP_DATA_VIEW.setInt8(result, 1, true);
                        return envObject.getReturnStatus();
                    }
                }
                HEAP_DATA_VIEW.setInt8(result, 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var valueOperationMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_coerce_to_bool: napi_coerce_to_bool,
            napi_coerce_to_number: napi_coerce_to_number,
            napi_coerce_to_object: napi_coerce_to_object,
            napi_coerce_to_string: napi_coerce_to_string,
            napi_detach_arraybuffer: napi_detach_arraybuffer,
            napi_instanceof: napi_instanceof,
            napi_is_array: napi_is_array,
            napi_is_arraybuffer: napi_is_arraybuffer,
            napi_is_buffer: napi_is_buffer,
            napi_is_dataview: napi_is_dataview,
            napi_is_date: napi_is_date,
            napi_is_detached_arraybuffer: napi_is_detached_arraybuffer,
            napi_is_error: napi_is_error,
            napi_is_typedarray: napi_is_typedarray,
            napi_strict_equals: napi_strict_equals,
            napi_typeof: napi_typeof
        });
        /** @__sig ipp */
        function napi_get_version(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var NODE_API_SUPPORTED_VERSION_MAX = 10 /* Version.NODE_API_SUPPORTED_VERSION_MAX */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(result, NODE_API_SUPPORTED_VERSION_MAX, true);
            return envObject.clearLastError();
        }
        var versionMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_version: napi_get_version
        });
        emnapiAWST.init();
        emnapiExternalMemory.init();
        emnapiString.init();
        emnapiTSFN.init();
        PThread.init();
        napiModule.emnapi.syncMemory = $emnapiSyncMemory;
        napiModule.emnapi.getMemoryAddress = $emnapiGetMemoryAddress;
        function addImports(mod) {
            var keys = Object.keys(mod);
            for (var i = 0; i < keys.length; ++i) {
                var k = keys[i];
                if (k.indexOf('$') === 0)
                    continue;
                if (k.indexOf('emnapi_') === 0) {
                    napiModule.imports.emnapi[k] = mod[k];
                }
                else if (k.indexOf('_emnapi_') === 0 || k === 'napi_set_last_error' || k === 'napi_clear_last_error') {
                    napiModule.imports.env[k] = mod[k];
                }
                else {
                    napiModule.imports.napi[k] = mod[k];
                }
            }
        }
        addImports(asyncMod);
        addImports(memoryMod);
        addImports(asyncWorkMod);
        addImports(utilMod);
        addImports(convert2cMod);
        addImports(convert2napiMod);
        addImports(createMod);
        addImports(globalMod);
        addImports(wrapMod);
        addImports(envMod);
        addImports(emnapiMod);
        addImports(errorMod);
        addImports(functionMod);
        addImports(lifeMod);
        addImports(miscellaneousMod);
        addImports(nodeMod);
        addImports(promiseMod);
        addImports(propertyMod);
        addImports(scriptMod);
        addImports(valueOperationMod);
        addImports(versionMod);
        napiModule.imports.napi.napi_create_threadsafe_function = napi_create_threadsafe_function;
        napiModule.imports.napi.napi_get_threadsafe_function_context = napi_get_threadsafe_function_context;
        napiModule.imports.napi.napi_call_threadsafe_function = napi_call_threadsafe_function;
        napiModule.imports.napi.napi_acquire_threadsafe_function = napi_acquire_threadsafe_function;
        napiModule.imports.napi.napi_release_threadsafe_function = napi_release_threadsafe_function;
        napiModule.imports.napi.napi_unref_threadsafe_function = napi_unref_threadsafe_function;
        napiModule.imports.napi.napi_ref_threadsafe_function = napi_ref_threadsafe_function;
        return napiModule;
    })();
    return napiModule;
}

function loadNapiModuleImpl(loadFn, userNapiModule, wasmInput, options) {
    // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
    options = options !== null && options !== void 0 ? options : {};
    var getMemory = options.getMemory;
    var getTable = options.getTable;
    var beforeInit = options.beforeInit;
    if (getMemory != null && typeof getMemory !== 'function') {
        throw new TypeError('options.getMemory is not a function');
    }
    if (getTable != null && typeof getTable !== 'function') {
        throw new TypeError('options.getTable is not a function');
    }
    if (beforeInit != null && typeof beforeInit !== 'function') {
        throw new TypeError('options.beforeInit is not a function');
    }
    var napiModule;
    {
        napiModule = createNapiModule(options);
    }
    var wasi = options.wasi;
    var wasiThreads;
    var importObject = {
        env: napiModule.imports.env,
        napi: napiModule.imports.napi,
        emnapi: napiModule.imports.emnapi
    };
    if (wasi) {
        wasiThreads = new WASIThreads(napiModule.childThread
            ? {
                wasi: wasi,
                childThread: true,
                postMessage: napiModule.postMessage
            }
            : {
                wasi: wasi,
                threadManager: napiModule.PThread,
                waitThreadStart: napiModule.waitThreadStart
            });
        Object.assign(importObject, typeof wasi.getImportObject === 'function'
            ? wasi.getImportObject()
            : { wasi_snapshot_preview1: wasi.wasiImport });
        Object.assign(importObject, wasiThreads.getImportObject());
    }
    var overwriteImports = options.overwriteImports;
    if (typeof overwriteImports === 'function') {
        var newImportObject = overwriteImports(importObject);
        if (typeof newImportObject === 'object' && newImportObject !== null) {
            importObject = newImportObject;
        }
    }
    return loadFn(wasmInput, importObject, function (err, source) {
        if (err) {
            throw err;
        }
        var originalInstance = source.instance;
        var instance = originalInstance;
        var originalExports = originalInstance.exports;
        var exportMemory = 'memory' in originalExports;
        var importMemory = 'memory' in importObject.env;
        var memory = getMemory
            ? getMemory(originalExports)
            : exportMemory
                ? originalExports.memory
                : importMemory
                    ? importObject.env.memory
                    : undefined;
        if (!memory) {
            throw new Error('memory is neither exported nor imported');
        }
        var table = getTable ? getTable(originalExports) : originalExports.__indirect_function_table;
        if (wasi && !exportMemory) {
            var exports_1 = Object.create(null);
            Object.assign(exports_1, originalExports, { memory: memory });
            instance = { exports: exports_1 };
        }
        var module = source.module;
        if (wasi) {
            instance = wasiThreads.initialize(instance, module, memory);
        }
        else {
            napiModule.PThread.setup(module, memory);
        }
        var emnapiInit = function () {
            if (beforeInit) {
                beforeInit({
                    instance: originalInstance,
                    module: module
                });
            }
            napiModule.init({
                instance: instance,
                module: module,
                memory: memory,
                table: table
            });
            var ret = {
                instance: originalInstance,
                module: module,
                usedInstance: instance
            };
            {
                ret.napiModule = napiModule;
            }
            return ret;
        };
        if (napiModule.PThread.shouldPreloadWorkers()) {
            var poolReady = napiModule.PThread.loadWasmModuleToAllWorkers();
            if (loadFn === loadCallback) {
                return poolReady.then(emnapiInit);
            }
            else {
                throw new Error('Synchronous loading is not supported with worker pool (reuseWorker.size > 0)');
            }
        }
        return emnapiInit();
    });
}
function loadCallback(wasmInput, importObject, callback) {
    return load(wasmInput, importObject).then(function (source) {
        return callback(null, source);
    }, function (err) {
        return callback(err);
    });
}
function loadSyncCallback(wasmInput, importObject, callback) {
    var source;
    try {
        source = loadSync(wasmInput, importObject);
    }
    catch (err) {
        return callback(err);
    }
    return callback(null, source);
}
/** @public */
function instantiateNapiModule(
/** Only support `BufferSource` or `WebAssembly.Module` on Node.js */
wasmInput, options) {
    return loadNapiModuleImpl(loadCallback, undefined, wasmInput, options);
}
/** @public */
function instantiateNapiModuleSync(wasmInput, options) {
    return loadNapiModuleImpl(loadSyncCallback, undefined, wasmInput, options);
}

/** @public */
var MessageHandler = /*#__PURE__*/ (function (_super) {
    __extends(MessageHandler, _super);
    function MessageHandler(options) {
        var _this = this;
        if (typeof options.onLoad !== 'function') {
            throw new TypeError('options.onLoad is not a function');
        }
        _this = _super.call(this, options) || this;
        _this.napiModule = undefined;
        return _this;
    }
    MessageHandler.prototype.instantiate = function (data) {
        var _this = this;
        var source = this.onLoad(data);
        var then = source.then;
        if (typeof then === 'function') {
            return source.then(function (result) {
                _this.napiModule = result.napiModule;
                return result;
            });
        }
        this.napiModule = source.napiModule;
        return source;
    };
    MessageHandler.prototype.handle = function (e) {
        var _this = this;
        var _a;
        _super.prototype.handle.call(this, e);
        if ((_a = e === null || e === void 0 ? void 0 : e.data) === null || _a === void 0 ? void 0 : _a.__emnapi__) {
            var type = e.data.__emnapi__.type;
            var payload_1 = e.data.__emnapi__.payload;
            if (type === 'async-worker-init') {
                this.handleAfterLoad(e, function () {
                    _this.napiModule.initWorker(payload_1.arg);
                });
            }
            else if (type === 'async-work-execute') {
                this.handleAfterLoad(e, function () {
                    _this.napiModule.executeAsyncWork(payload_1.work);
                });
            }
        }
    };
    return MessageHandler;
}(ThreadMessageHandler));

var externalValue = new WeakMap();
/** @public */
function isExternal(object) {
    return externalValue.has(object);
}
/** @public */ // eslint-disable-next-line @typescript-eslint/no-redeclare
var External = (function () {
    function External(value) {
        Object.setPrototypeOf(this, null);
        externalValue.set(this, value);
    }
    External.prototype = null;
    return External;
})();
/** @public */
function getExternalValue(external) {
    if (!isExternal(external)) {
        throw new TypeError('not external');
    }
    return externalValue.get(external);
}

var supportNewFunction = /*#__PURE__*/ (function () {
    var f;
    try {
        f = new Function();
    }
    catch (_) {
        return false;
    }
    return typeof f === 'function';
})();
var _global = /*#__PURE__*/ (function () {
    if (typeof globalThis !== 'undefined')
        return globalThis;
    var g = (function () { return this; })();
    if (!g && supportNewFunction) {
        try {
            g = new Function('return this')();
        }
        catch (_) { }
    }
    if (!g) {
        {
            if (typeof global !== 'undefined')
                return global;
        }
        if (typeof window !== 'undefined')
            return window;
        if (typeof self !== 'undefined')
            return self;
    }
    return g;
})();
var TryCatch = /*#__PURE__*/ (function () {
    function TryCatch() {
        this._exception = undefined;
        this._caught = false;
    }
    TryCatch.prototype.isEmpty = function () {
        return !this._caught;
    };
    TryCatch.prototype.hasCaught = function () {
        return this._caught;
    };
    TryCatch.prototype.exception = function () {
        return this._exception;
    };
    TryCatch.prototype.setError = function (err) {
        this._caught = true;
        this._exception = err;
    };
    TryCatch.prototype.reset = function () {
        this._caught = false;
        this._exception = undefined;
    };
    TryCatch.prototype.extractException = function () {
        var e = this._exception;
        this.reset();
        return e;
    };
    return TryCatch;
}());
var canSetFunctionName = /*#__PURE__*/ (function () {
    var _a;
    try {
        return Boolean((_a = Object.getOwnPropertyDescriptor(Function.prototype, 'name')) === null || _a === void 0 ? void 0 : _a.configurable);
    }
    catch (_) {
        return false;
    }
})();
var supportReflect = typeof Reflect === 'object';
var supportFinalizer = (typeof FinalizationRegistry !== 'undefined') && (typeof WeakRef !== 'undefined');
var supportWeakSymbol = /*#__PURE__*/ (function () {
    try {
        // eslint-disable-next-line symbol-description
        var sym = Symbol();
        // eslint-disable-next-line no-new
        new WeakRef(sym);
        new WeakMap().set(sym, undefined);
    }
    catch (_) {
        return false;
    }
    return true;
})();
var supportBigInt = typeof BigInt !== 'undefined';
var _require = /*#__PURE__*/ (function () {
    var nativeRequire;
    {
        nativeRequire = (function () {
            return (typeof require !== 'undefined' ? require : undefined);
        })();
    }
    return nativeRequire;
})();
var _MessageChannel = typeof MessageChannel === 'function'
    ? MessageChannel
    : /*#__PURE__*/ (function () {
        try {
            return _require('worker_threads').MessageChannel;
        }
        catch (_) { }
        return undefined;
    })();
var _setImmediate = typeof setImmediate === 'function'
    ? setImmediate
    : function (callback) {
        if (typeof callback !== 'function') {
            throw new TypeError('The "callback" argument must be of type function');
        }
        if (_MessageChannel) {
            var channel_1 = new _MessageChannel();
            channel_1.port1.onmessage = function () {
                channel_1.port1.onmessage = null;
                channel_1 = undefined;
                callback();
            };
            channel_1.port2.postMessage(null);
        }
        else {
            setTimeout(callback, 0);
        }
    };
var _Buffer = typeof Buffer === 'function'
    ? Buffer
    : /*#__PURE__*/ (function () {
        try {
            return _require('buffer').Buffer;
        }
        catch (_) { }
        return undefined;
    })();
var version = "1.4.3";
var NODE_API_SUPPORTED_VERSION_MAX = 10 /* Version.NODE_API_SUPPORTED_VERSION_MAX */;
var NAPI_VERSION_EXPERIMENTAL = 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */;
var NODE_API_DEFAULT_MODULE_API_VERSION = 8 /* Version.NODE_API_DEFAULT_MODULE_API_VERSION */;

var Handle = /*#__PURE__*/ (function () {
    function Handle(id, value) {
        this.id = id;
        this.value = value;
    }
    Handle.prototype.data = function () {
        return getExternalValue(this.value);
    };
    Handle.prototype.isNumber = function () {
        return typeof this.value === 'number';
    };
    Handle.prototype.isBigInt = function () {
        return typeof this.value === 'bigint';
    };
    Handle.prototype.isString = function () {
        return typeof this.value === 'string';
    };
    Handle.prototype.isFunction = function () {
        return typeof this.value === 'function';
    };
    Handle.prototype.isExternal = function () {
        return isExternal(this.value);
    };
    Handle.prototype.isObject = function () {
        return typeof this.value === 'object' && this.value !== null;
    };
    Handle.prototype.isArray = function () {
        return Array.isArray(this.value);
    };
    Handle.prototype.isArrayBuffer = function () {
        return (this.value instanceof ArrayBuffer);
    };
    Handle.prototype.isTypedArray = function () {
        return (ArrayBuffer.isView(this.value)) && !(this.value instanceof DataView);
    };
    Handle.prototype.isBuffer = function (BufferConstructor) {
        if (ArrayBuffer.isView(this.value))
            return true;
        BufferConstructor !== null && BufferConstructor !== void 0 ? BufferConstructor : (BufferConstructor = _Buffer);
        return typeof BufferConstructor === 'function' && BufferConstructor.isBuffer(this.value);
    };
    Handle.prototype.isDataView = function () {
        return (this.value instanceof DataView);
    };
    Handle.prototype.isDate = function () {
        return (this.value instanceof Date);
    };
    Handle.prototype.isPromise = function () {
        return (this.value instanceof Promise);
    };
    Handle.prototype.isBoolean = function () {
        return typeof this.value === 'boolean';
    };
    Handle.prototype.isUndefined = function () {
        return this.value === undefined;
    };
    Handle.prototype.isSymbol = function () {
        return typeof this.value === 'symbol';
    };
    Handle.prototype.isNull = function () {
        return this.value === null;
    };
    Handle.prototype.dispose = function () {
        this.value = undefined;
    };
    return Handle;
}());
var ConstHandle = /*#__PURE__*/ (function (_super) {
    __extends(ConstHandle, _super);
    function ConstHandle(id, value) {
        return _super.call(this, id, value) || this;
    }
    ConstHandle.prototype.dispose = function () { };
    return ConstHandle;
}(Handle));
var HandleStore = /*#__PURE__*/ (function () {
    function HandleStore() {
        this._values = [
            undefined,
            HandleStore.UNDEFINED,
            HandleStore.NULL,
            HandleStore.FALSE,
            HandleStore.TRUE,
            HandleStore.GLOBAL
        ];
        this._next = HandleStore.MIN_ID;
    }
    HandleStore.prototype.push = function (value) {
        var h;
        var next = this._next;
        var values = this._values;
        if (next < values.length) {
            h = values[next];
            h.value = value;
        }
        else {
            h = new Handle(next, value);
            values[next] = h;
        }
        this._next++;
        return h;
    };
    HandleStore.prototype.erase = function (start, end) {
        this._next = start;
        var values = this._values;
        for (var i = start; i < end; ++i) {
            values[i].dispose();
        }
    };
    HandleStore.prototype.get = function (id) {
        return this._values[id];
    };
    HandleStore.prototype.swap = function (a, b) {
        var values = this._values;
        var h = values[a];
        values[a] = values[b];
        values[a].id = Number(a);
        values[b] = h;
        h.id = Number(b);
    };
    HandleStore.prototype.dispose = function () {
        this._values.length = HandleStore.MIN_ID;
        this._next = HandleStore.MIN_ID;
    };
    HandleStore.UNDEFINED = new ConstHandle(1 /* GlobalHandle.UNDEFINED */, undefined);
    HandleStore.NULL = new ConstHandle(2 /* GlobalHandle.NULL */, null);
    HandleStore.FALSE = new ConstHandle(3 /* GlobalHandle.FALSE */, false);
    HandleStore.TRUE = new ConstHandle(4 /* GlobalHandle.TRUE */, true);
    HandleStore.GLOBAL = new ConstHandle(5 /* GlobalHandle.GLOBAL */, _global);
    HandleStore.MIN_ID = 6;
    return HandleStore;
}());

var HandleScope = /*#__PURE__*/ (function () {
    function HandleScope(handleStore, id, parentScope, start, end) {
        if (end === void 0) { end = start; }
        this.handleStore = handleStore;
        this.id = id;
        this.parent = parentScope;
        this.child = null;
        if (parentScope !== null)
            parentScope.child = this;
        this.start = start;
        this.end = end;
        this._escapeCalled = false;
        this.callbackInfo = {
            thiz: undefined,
            data: 0,
            args: undefined,
            fn: undefined
        };
    }
    HandleScope.prototype.add = function (value) {
        var h = this.handleStore.push(value);
        this.end++;
        return h;
    };
    HandleScope.prototype.addExternal = function (data) {
        return this.add(new External(data));
    };
    HandleScope.prototype.dispose = function () {
        if (this._escapeCalled)
            this._escapeCalled = false;
        if (this.start === this.end)
            return;
        this.handleStore.erase(this.start, this.end);
    };
    HandleScope.prototype.escape = function (handle) {
        if (this._escapeCalled)
            return null;
        this._escapeCalled = true;
        if (handle < this.start || handle >= this.end) {
            return null;
        }
        this.handleStore.swap(handle, this.start);
        var h = this.handleStore.get(this.start);
        this.start++;
        this.parent.end++;
        return h;
    };
    HandleScope.prototype.escapeCalled = function () {
        return this._escapeCalled;
    };
    return HandleScope;
}());

var ScopeStore = /*#__PURE__*/ (function () {
    function ScopeStore() {
        this._rootScope = new HandleScope(null, 0, null, 1, HandleStore.MIN_ID);
        this.currentScope = this._rootScope;
        this._values = [undefined];
    }
    ScopeStore.prototype.get = function (id) {
        return this._values[id];
    };
    ScopeStore.prototype.openScope = function (envObject) {
        var currentScope = this.currentScope;
        var scope = currentScope.child;
        if (scope !== null) {
            scope.start = scope.end = currentScope.end;
        }
        else {
            var id = currentScope.id + 1;
            scope = new HandleScope(envObject.ctx.handleStore, id, currentScope, currentScope.end);
            this._values[id] = scope;
        }
        this.currentScope = scope;
        envObject.openHandleScopes++;
        return scope;
    };
    ScopeStore.prototype.closeScope = function (envObject) {
        if (envObject.openHandleScopes === 0)
            return;
        var scope = this.currentScope;
        this.currentScope = scope.parent;
        scope.dispose();
        envObject.openHandleScopes--;
    };
    ScopeStore.prototype.dispose = function () {
        this.currentScope = this._rootScope;
        this._values.length = 1;
    };
    return ScopeStore;
}());

var RefTracker = /*#__PURE__*/ (function () {
    function RefTracker() {
        this._next = null;
        this._prev = null;
    }
    /** @virtual */
    RefTracker.prototype.dispose = function () { };
    /** @virtual */
    RefTracker.prototype.finalize = function () { };
    RefTracker.prototype.link = function (list) {
        this._prev = list;
        this._next = list._next;
        if (this._next !== null) {
            this._next._prev = this;
        }
        list._next = this;
    };
    RefTracker.prototype.unlink = function () {
        if (this._prev !== null) {
            this._prev._next = this._next;
        }
        if (this._next !== null) {
            this._next._prev = this._prev;
        }
        this._prev = null;
        this._next = null;
    };
    RefTracker.finalizeAll = function (list) {
        while (list._next !== null) {
            list._next.finalize();
        }
    };
    return RefTracker;
}());

var Finalizer = /*#__PURE__*/ (function () {
    function Finalizer(envObject, _finalizeCallback, _finalizeData, _finalizeHint) {
        if (_finalizeCallback === void 0) { _finalizeCallback = 0; }
        if (_finalizeData === void 0) { _finalizeData = 0; }
        if (_finalizeHint === void 0) { _finalizeHint = 0; }
        this.envObject = envObject;
        this._finalizeCallback = _finalizeCallback;
        this._finalizeData = _finalizeData;
        this._finalizeHint = _finalizeHint;
        this._makeDynCall_vppp = envObject.makeDynCall_vppp;
    }
    Finalizer.prototype.callback = function () { return this._finalizeCallback; };
    Finalizer.prototype.data = function () { return this._finalizeData; };
    Finalizer.prototype.hint = function () { return this._finalizeHint; };
    Finalizer.prototype.resetEnv = function () {
        this.envObject = undefined;
    };
    Finalizer.prototype.resetFinalizer = function () {
        this._finalizeCallback = 0;
        this._finalizeData = 0;
        this._finalizeHint = 0;
    };
    Finalizer.prototype.callFinalizer = function () {
        var finalize_callback = this._finalizeCallback;
        var finalize_data = this._finalizeData;
        var finalize_hint = this._finalizeHint;
        this.resetFinalizer();
        if (!finalize_callback)
            return;
        var fini = Number(finalize_callback);
        if (!this.envObject) {
            this._makeDynCall_vppp(fini)(0, finalize_data, finalize_hint);
        }
        else {
            this.envObject.callFinalizer(fini, finalize_data, finalize_hint);
        }
    };
    Finalizer.prototype.dispose = function () {
        this.envObject = undefined;
        this._makeDynCall_vppp = undefined;
    };
    return Finalizer;
}());

var TrackedFinalizer = /*#__PURE__*/ (function (_super) {
    __extends(TrackedFinalizer, _super);
    function TrackedFinalizer(envObject, finalize_callback, finalize_data, finalize_hint) {
        var _this = _super.call(this) || this;
        _this._finalizer = new Finalizer(envObject, finalize_callback, finalize_data, finalize_hint);
        return _this;
    }
    TrackedFinalizer.create = function (envObject, finalize_callback, finalize_data, finalize_hint) {
        var finalizer = new TrackedFinalizer(envObject, finalize_callback, finalize_data, finalize_hint);
        finalizer.link(envObject.finalizing_reflist);
        return finalizer;
    };
    TrackedFinalizer.prototype.data = function () {
        return this._finalizer.data();
    };
    TrackedFinalizer.prototype.dispose = function () {
        if (!this._finalizer)
            return;
        this.unlink();
        this._finalizer.envObject.dequeueFinalizer(this);
        this._finalizer.dispose();
        this._finalizer = undefined;
        _super.prototype.dispose.call(this);
    };
    TrackedFinalizer.prototype.finalize = function () {
        this.unlink();
        var error;
        var caught = false;
        try {
            this._finalizer.callFinalizer();
        }
        catch (err) {
            caught = true;
            error = err;
        }
        this.dispose();
        if (caught) {
            throw error;
        }
    };
    return TrackedFinalizer;
}(RefTracker));

function throwNodeApiVersionError(moduleName, moduleApiVersion) {
    var errorMessage = "".concat(moduleName, " requires Node-API version ").concat(moduleApiVersion, ", but this version of Node.js only supports version ").concat(NODE_API_SUPPORTED_VERSION_MAX, " add-ons.");
    throw new Error(errorMessage);
}
function handleThrow(envObject, value) {
    if (envObject.terminatedOrTerminating()) {
        return;
    }
    throw value;
}
var Env = /*#__PURE__*/ (function () {
    function Env(ctx, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort) {
        this.ctx = ctx;
        this.moduleApiVersion = moduleApiVersion;
        this.makeDynCall_vppp = makeDynCall_vppp;
        this.makeDynCall_vp = makeDynCall_vp;
        this.abort = abort;
        this.openHandleScopes = 0;
        this.instanceData = null;
        this.tryCatch = new TryCatch();
        this.refs = 1;
        this.reflist = new RefTracker();
        this.finalizing_reflist = new RefTracker();
        this.pendingFinalizers = [];
        this.lastError = {
            errorCode: 0 /* napi_status.napi_ok */,
            engineErrorCode: 0,
            engineReserved: 0
        };
        this.inGcFinalizer = false;
        this._bindingMap = new WeakMap();
        this.id = 0;
    }
    /** @virtual */
    Env.prototype.canCallIntoJs = function () {
        return true;
    };
    Env.prototype.terminatedOrTerminating = function () {
        return !this.canCallIntoJs();
    };
    Env.prototype.ref = function () {
        this.refs++;
    };
    Env.prototype.unref = function () {
        this.refs--;
        if (this.refs === 0) {
            this.dispose();
        }
    };
    Env.prototype.ensureHandle = function (value) {
        return this.ctx.ensureHandle(value);
    };
    Env.prototype.ensureHandleId = function (value) {
        return this.ensureHandle(value).id;
    };
    Env.prototype.clearLastError = function () {
        var lastError = this.lastError;
        if (lastError.errorCode !== 0 /* napi_status.napi_ok */)
            lastError.errorCode = 0 /* napi_status.napi_ok */;
        if (lastError.engineErrorCode !== 0)
            lastError.engineErrorCode = 0;
        if (lastError.engineReserved !== 0)
            lastError.engineReserved = 0;
        return 0 /* napi_status.napi_ok */;
    };
    Env.prototype.setLastError = function (error_code, engine_error_code, engine_reserved) {
        if (engine_error_code === void 0) { engine_error_code = 0; }
        if (engine_reserved === void 0) { engine_reserved = 0; }
        var lastError = this.lastError;
        if (lastError.errorCode !== error_code)
            lastError.errorCode = error_code;
        if (lastError.engineErrorCode !== engine_error_code)
            lastError.engineErrorCode = engine_error_code;
        if (lastError.engineReserved !== engine_reserved)
            lastError.engineReserved = engine_reserved;
        return error_code;
    };
    Env.prototype.getReturnStatus = function () {
        return !this.tryCatch.hasCaught() ? 0 /* napi_status.napi_ok */ : this.setLastError(10 /* napi_status.napi_pending_exception */);
    };
    Env.prototype.callIntoModule = function (fn, handleException) {
        if (handleException === void 0) { handleException = handleThrow; }
        var openHandleScopesBefore = this.openHandleScopes;
        this.clearLastError();
        var r = fn(this);
        if (openHandleScopesBefore !== this.openHandleScopes) {
            this.abort('open_handle_scopes != open_handle_scopes_before');
        }
        if (this.tryCatch.hasCaught()) {
            var err = this.tryCatch.extractException();
            handleException(this, err);
        }
        return r;
    };
    Env.prototype.invokeFinalizerFromGC = function (finalizer) {
        if (this.moduleApiVersion !== NAPI_VERSION_EXPERIMENTAL) {
            this.enqueueFinalizer(finalizer);
        }
        else {
            var saved = this.inGcFinalizer;
            this.inGcFinalizer = true;
            try {
                finalizer.finalize();
            }
            finally {
                this.inGcFinalizer = saved;
            }
        }
    };
    Env.prototype.checkGCAccess = function () {
        if (this.moduleApiVersion === NAPI_VERSION_EXPERIMENTAL && this.inGcFinalizer) {
            this.abort('Finalizer is calling a function that may affect GC state.\n' +
                'The finalizers are run directly from GC and must not affect GC ' +
                'state.\n' +
                'Use `node_api_post_finalizer` from inside of the finalizer to work ' +
                'around this issue.\n' +
                'It schedules the call as a new task in the event loop.');
        }
    };
    /** @virtual */
    Env.prototype.enqueueFinalizer = function (finalizer) {
        if (this.pendingFinalizers.indexOf(finalizer) === -1) {
            this.pendingFinalizers.push(finalizer);
        }
    };
    /** @virtual */
    Env.prototype.dequeueFinalizer = function (finalizer) {
        var index = this.pendingFinalizers.indexOf(finalizer);
        if (index !== -1) {
            this.pendingFinalizers.splice(index, 1);
        }
    };
    /** @virtual */
    Env.prototype.deleteMe = function () {
        RefTracker.finalizeAll(this.finalizing_reflist);
        RefTracker.finalizeAll(this.reflist);
        this.tryCatch.extractException();
        this.ctx.envStore.remove(this.id);
    };
    Env.prototype.dispose = function () {
        if (this.id === 0)
            return;
        this.deleteMe();
        this.finalizing_reflist.dispose();
        this.reflist.dispose();
        this.id = 0;
    };
    Env.prototype.initObjectBinding = function (value) {
        var binding = {
            wrapped: 0,
            tag: null
        };
        this._bindingMap.set(value, binding);
        return binding;
    };
    Env.prototype.getObjectBinding = function (value) {
        if (this._bindingMap.has(value)) {
            return this._bindingMap.get(value);
        }
        return this.initObjectBinding(value);
    };
    Env.prototype.setInstanceData = function (data, finalize_cb, finalize_hint) {
        if (this.instanceData) {
            this.instanceData.dispose();
        }
        this.instanceData = TrackedFinalizer.create(this, finalize_cb, data, finalize_hint);
    };
    Env.prototype.getInstanceData = function () {
        return this.instanceData ? this.instanceData.data() : 0;
    };
    return Env;
}());
var NodeEnv = /*#__PURE__*/ (function (_super) {
    __extends(NodeEnv, _super);
    function NodeEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
        var _this = _super.call(this, ctx, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort) || this;
        _this.filename = filename;
        _this.nodeBinding = nodeBinding;
        _this.destructing = false;
        _this.finalizationScheduled = false;
        return _this;
    }
    NodeEnv.prototype.deleteMe = function () {
        this.destructing = true;
        this.drainFinalizerQueue();
        _super.prototype.deleteMe.call(this);
    };
    NodeEnv.prototype.canCallIntoJs = function () {
        return _super.prototype.canCallIntoJs.call(this) && this.ctx.canCallIntoJs();
    };
    NodeEnv.prototype.triggerFatalException = function (err) {
        if (this.nodeBinding) {
            this.nodeBinding.napi.fatalException(err);
        }
        else {
            {
                throw err;
            }
        }
    };
    NodeEnv.prototype.callbackIntoModule = function (enforceUncaughtExceptionPolicy, fn) {
        return this.callIntoModule(fn, function (envObject, err) {
            if (envObject.terminatedOrTerminating()) {
                return;
            }
            if (envObject.moduleApiVersion < 10 && true && !enforceUncaughtExceptionPolicy) {
                var warn = function (warning, type, code) {
                        if (warning instanceof Error) {
                            console.warn(warning.toString());
                        }
                        else {
                            var prefix = code ? "[".concat(code, "] ") : '';
                            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                            console.warn("".concat(prefix).concat(type || 'Warning', ": ").concat(warning));
                        }
                    };
                warn('Uncaught N-API callback exception detected, please run node with option --force-node-api-uncaught-exceptions-policy=true to handle those exceptions properly.', 'DeprecationWarning', 'DEP0168');
                return;
            }
            envObject.triggerFatalException(err);
        });
    };
    NodeEnv.prototype.callFinalizer = function (cb, data, hint) {
        this.callFinalizerInternal(1, cb, data, hint);
    };
    NodeEnv.prototype.callFinalizerInternal = function (forceUncaught, cb, data, hint) {
        var f = this.makeDynCall_vppp(cb);
        var env = this.id;
        var scope = this.ctx.openScope(this);
        try {
            this.callbackIntoModule(Boolean(forceUncaught), function () { f(env, data, hint); });
        }
        finally {
            this.ctx.closeScope(this, scope);
        }
    };
    NodeEnv.prototype.enqueueFinalizer = function (finalizer) {
        var _this = this;
        _super.prototype.enqueueFinalizer.call(this, finalizer);
        if (!this.finalizationScheduled && !this.destructing) {
            this.finalizationScheduled = true;
            this.ref();
            _setImmediate(function () {
                _this.finalizationScheduled = false;
                _this.unref();
                _this.drainFinalizerQueue();
            });
        }
    };
    NodeEnv.prototype.drainFinalizerQueue = function () {
        while (this.pendingFinalizers.length > 0) {
            var refTracker = this.pendingFinalizers.shift();
            refTracker.finalize();
        }
    };
    return NodeEnv;
}(Env));
function newEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
    moduleApiVersion = typeof moduleApiVersion !== 'number' ? NODE_API_DEFAULT_MODULE_API_VERSION : moduleApiVersion;
    // Validate module_api_version.
    if (moduleApiVersion < NODE_API_DEFAULT_MODULE_API_VERSION) {
        moduleApiVersion = NODE_API_DEFAULT_MODULE_API_VERSION;
    }
    else if (moduleApiVersion > NODE_API_SUPPORTED_VERSION_MAX && moduleApiVersion !== NAPI_VERSION_EXPERIMENTAL) {
        throwNodeApiVersionError(filename, moduleApiVersion);
    }
    var env = new NodeEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding);
    ctx.envStore.add(env);
    ctx.addCleanupHook(env, function () { env.unref(); }, 0);
    return env;
}

var EmnapiError = /*#__PURE__*/ (function (_super) {
    __extends(EmnapiError, _super);
    function EmnapiError(message) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, message) || this;
        var ErrorConstructor = _newTarget;
        var proto = ErrorConstructor.prototype;
        if (!(_this instanceof EmnapiError)) {
            var setPrototypeOf = Object.setPrototypeOf;
            if (typeof setPrototypeOf === 'function') {
                setPrototypeOf.call(Object, _this, proto);
            }
            else {
                // eslint-disable-next-line no-proto
                _this.__proto__ = proto;
            }
            if (typeof Error.captureStackTrace === 'function') {
                Error.captureStackTrace(_this, ErrorConstructor);
            }
        }
        return _this;
    }
    return EmnapiError;
}(Error));
Object.defineProperty(EmnapiError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'EmnapiError'
});
var NotSupportWeakRefError = /*#__PURE__*/ (function (_super) {
    __extends(NotSupportWeakRefError, _super);
    function NotSupportWeakRefError(api, message) {
        return _super.call(this, "".concat(api, ": The current runtime does not support \"FinalizationRegistry\" and \"WeakRef\".").concat(message ? " ".concat(message) : '')) || this;
    }
    return NotSupportWeakRefError;
}(EmnapiError));
Object.defineProperty(NotSupportWeakRefError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'NotSupportWeakRefError'
});
var NotSupportBufferError = /*#__PURE__*/ (function (_super) {
    __extends(NotSupportBufferError, _super);
    function NotSupportBufferError(api, message) {
        return _super.call(this, "".concat(api, ": The current runtime does not support \"Buffer\". Consider using buffer polyfill to make sure `globalThis.Buffer` is defined.").concat(message ? " ".concat(message) : '')) || this;
    }
    return NotSupportBufferError;
}(EmnapiError));
Object.defineProperty(NotSupportBufferError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'NotSupportBufferError'
});

var StrongRef = /*#__PURE__*/ (function () {
    function StrongRef(value) {
        this._value = value;
    }
    StrongRef.prototype.deref = function () {
        return this._value;
    };
    StrongRef.prototype.dispose = function () {
        this._value = undefined;
    };
    return StrongRef;
}());
var Persistent = /*#__PURE__*/ (function () {
    function Persistent(value) {
        this._ref = new StrongRef(value);
    }
    Persistent.prototype.setWeak = function (param, callback) {
        if (!supportFinalizer || this._ref === undefined || this._ref instanceof WeakRef)
            return;
        var value = this._ref.deref();
        try {
            Persistent._registry.register(value, this, this);
            var weakRef = new WeakRef(value);
            this._ref.dispose();
            this._ref = weakRef;
            this._param = param;
            this._callback = callback;
        }
        catch (err) {
            if (typeof value === 'symbol') ;
            else {
                throw err;
            }
        }
    };
    Persistent.prototype.clearWeak = function () {
        if (!supportFinalizer || this._ref === undefined)
            return;
        if (this._ref instanceof WeakRef) {
            try {
                Persistent._registry.unregister(this);
            }
            catch (_) { }
            this._param = undefined;
            this._callback = undefined;
            var value = this._ref.deref();
            if (value === undefined) {
                this._ref = value;
            }
            else {
                this._ref = new StrongRef(value);
            }
        }
    };
    Persistent.prototype.reset = function () {
        if (supportFinalizer) {
            try {
                Persistent._registry.unregister(this);
            }
            catch (_) { }
        }
        this._param = undefined;
        this._callback = undefined;
        if (this._ref instanceof StrongRef) {
            this._ref.dispose();
        }
        this._ref = undefined;
    };
    Persistent.prototype.isEmpty = function () {
        return this._ref === undefined;
    };
    Persistent.prototype.deref = function () {
        if (this._ref === undefined)
            return undefined;
        return this._ref.deref();
    };
    Persistent._registry = supportFinalizer
        ? new FinalizationRegistry(function (value) {
            value._ref = undefined;
            var callback = value._callback;
            var param = value._param;
            value._callback = undefined;
            value._param = undefined;
            if (typeof callback === 'function') {
                callback(param);
            }
        })
        : undefined;
    return Persistent;
}());

var ReferenceOwnership;
(function (ReferenceOwnership) {
    ReferenceOwnership[ReferenceOwnership["kRuntime"] = 0] = "kRuntime";
    ReferenceOwnership[ReferenceOwnership["kUserland"] = 1] = "kUserland";
})(ReferenceOwnership || (ReferenceOwnership = {}));
function canBeHeldWeakly(value) {
    return value.isObject() || value.isFunction() || value.isSymbol();
}
var Reference = /*#__PURE__*/ (function (_super) {
    __extends(Reference, _super);
    function Reference(envObject, handle_id, initialRefcount, ownership) {
        var _this = _super.call(this) || this;
        _this.envObject = envObject;
        _this._refcount = initialRefcount;
        _this._ownership = ownership;
        var handle = envObject.ctx.handleStore.get(handle_id);
        _this.canBeWeak = canBeHeldWeakly(handle);
        _this.persistent = new Persistent(handle.value);
        _this.id = 0;
        if (initialRefcount === 0) {
            _this._setWeak();
        }
        return _this;
    }
    Reference.weakCallback = function (ref) {
        ref.persistent.reset();
        ref.invokeFinalizerFromGC();
    };
    Reference.create = function (envObject, handle_id, initialRefcount, ownership, _unused1, _unused2, _unused3) {
        var ref = new Reference(envObject, handle_id, initialRefcount, ownership);
        envObject.ctx.refStore.add(ref);
        ref.link(envObject.reflist);
        return ref;
    };
    Reference.prototype.ref = function () {
        if (this.persistent.isEmpty()) {
            return 0;
        }
        if (++this._refcount === 1 && this.canBeWeak) {
            this.persistent.clearWeak();
        }
        return this._refcount;
    };
    Reference.prototype.unref = function () {
        if (this.persistent.isEmpty() || this._refcount === 0) {
            return 0;
        }
        if (--this._refcount === 0) {
            this._setWeak();
        }
        return this._refcount;
    };
    Reference.prototype.get = function (envObject) {
        if (envObject === void 0) { envObject = this.envObject; }
        if (this.persistent.isEmpty()) {
            return 0;
        }
        var obj = this.persistent.deref();
        var handle = envObject.ensureHandle(obj);
        return handle.id;
    };
    /** @virtual */
    Reference.prototype.resetFinalizer = function () { };
    /** @virtual */
    Reference.prototype.data = function () { return 0; };
    Reference.prototype.refcount = function () { return this._refcount; };
    Reference.prototype.ownership = function () { return this._ownership; };
    /** @virtual */
    Reference.prototype.callUserFinalizer = function () { };
    /** @virtual */
    Reference.prototype.invokeFinalizerFromGC = function () {
        this.finalize();
    };
    Reference.prototype._setWeak = function () {
        if (this.canBeWeak) {
            this.persistent.setWeak(this, Reference.weakCallback);
        }
        else {
            this.persistent.reset();
        }
    };
    Reference.prototype.finalize = function () {
        this.persistent.reset();
        var deleteMe = this._ownership === ReferenceOwnership.kRuntime;
        this.unlink();
        this.callUserFinalizer();
        if (deleteMe) {
            this.dispose();
        }
    };
    Reference.prototype.dispose = function () {
        if (this.id === 0)
            return;
        this.unlink();
        this.persistent.reset();
        this.envObject.ctx.refStore.remove(this.id);
        _super.prototype.dispose.call(this);
        this.envObject = undefined;
        this.id = 0;
    };
    return Reference;
}(RefTracker));
var ReferenceWithData = /*#__PURE__*/ (function (_super) {
    __extends(ReferenceWithData, _super);
    function ReferenceWithData(envObject, value, initialRefcount, ownership, _data) {
        var _this = _super.call(this, envObject, value, initialRefcount, ownership) || this;
        _this._data = _data;
        return _this;
    }
    ReferenceWithData.create = function (envObject, value, initialRefcount, ownership, data) {
        var reference = new ReferenceWithData(envObject, value, initialRefcount, ownership, data);
        envObject.ctx.refStore.add(reference);
        reference.link(envObject.reflist);
        return reference;
    };
    ReferenceWithData.prototype.data = function () {
        return this._data;
    };
    return ReferenceWithData;
}(Reference));
var ReferenceWithFinalizer = /*#__PURE__*/ (function (_super) {
    __extends(ReferenceWithFinalizer, _super);
    function ReferenceWithFinalizer(envObject, value, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        var _this = _super.call(this, envObject, value, initialRefcount, ownership) || this;
        _this._finalizer = new Finalizer(envObject, finalize_callback, finalize_data, finalize_hint);
        return _this;
    }
    ReferenceWithFinalizer.create = function (envObject, value, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        var reference = new ReferenceWithFinalizer(envObject, value, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint);
        envObject.ctx.refStore.add(reference);
        reference.link(envObject.finalizing_reflist);
        return reference;
    };
    ReferenceWithFinalizer.prototype.resetFinalizer = function () {
        this._finalizer.resetFinalizer();
    };
    ReferenceWithFinalizer.prototype.data = function () {
        return this._finalizer.data();
    };
    ReferenceWithFinalizer.prototype.callUserFinalizer = function () {
        this._finalizer.callFinalizer();
    };
    ReferenceWithFinalizer.prototype.invokeFinalizerFromGC = function () {
        this._finalizer.envObject.invokeFinalizerFromGC(this);
    };
    ReferenceWithFinalizer.prototype.dispose = function () {
        if (!this._finalizer)
            return;
        this._finalizer.envObject.dequeueFinalizer(this);
        this._finalizer.dispose();
        _super.prototype.dispose.call(this);
        this._finalizer = undefined;
    };
    return ReferenceWithFinalizer;
}(Reference));

var Deferred = /*#__PURE__*/ (function () {
    function Deferred(ctx, value) {
        this.id = 0;
        this.ctx = ctx;
        this.value = value;
    }
    Deferred.create = function (ctx, value) {
        var deferred = new Deferred(ctx, value);
        ctx.deferredStore.add(deferred);
        return deferred;
    };
    Deferred.prototype.resolve = function (value) {
        this.value.resolve(value);
        this.dispose();
    };
    Deferred.prototype.reject = function (reason) {
        this.value.reject(reason);
        this.dispose();
    };
    Deferred.prototype.dispose = function () {
        this.ctx.deferredStore.remove(this.id);
        this.id = 0;
        this.value = null;
        this.ctx = null;
    };
    return Deferred;
}());

var Store = /*#__PURE__*/ (function () {
    function Store() {
        this._values = [undefined];
        this._values.length = 4;
        this._size = 1;
        this._freeList = [];
    }
    Store.prototype.add = function (value) {
        var id;
        if (this._freeList.length) {
            id = this._freeList.shift();
        }
        else {
            id = this._size;
            this._size++;
            var capacity = this._values.length;
            if (id >= capacity) {
                this._values.length = capacity + (capacity >> 1) + 16;
            }
        }
        value.id = id;
        this._values[id] = value;
    };
    Store.prototype.get = function (id) {
        return this._values[id];
    };
    Store.prototype.has = function (id) {
        return this._values[id] !== undefined;
    };
    Store.prototype.remove = function (id) {
        var value = this._values[id];
        if (value) {
            value.id = 0;
            this._values[id] = undefined;
            this._freeList.push(Number(id));
        }
    };
    Store.prototype.dispose = function () {
        for (var i = 1; i < this._size; ++i) {
            var value = this._values[i];
            value === null || value === void 0 ? void 0 : value.dispose();
        }
        this._values = [undefined];
        this._size = 1;
        this._freeList = [];
    };
    return Store;
}());

var CleanupHookCallback = /*#__PURE__*/ (function () {
    function CleanupHookCallback(envObject, fn, arg, order) {
        this.envObject = envObject;
        this.fn = fn;
        this.arg = arg;
        this.order = order;
    }
    return CleanupHookCallback;
}());
var CleanupQueue = /*#__PURE__*/ (function () {
    function CleanupQueue() {
        this._cleanupHooks = [];
        this._cleanupHookCounter = 0;
    }
    CleanupQueue.prototype.empty = function () {
        return this._cleanupHooks.length === 0;
    };
    CleanupQueue.prototype.add = function (envObject, fn, arg) {
        if (this._cleanupHooks.filter(function (hook) { return (hook.envObject === envObject && hook.fn === fn && hook.arg === arg); }).length > 0) {
            throw new Error('Can not add same fn and arg twice');
        }
        this._cleanupHooks.push(new CleanupHookCallback(envObject, fn, arg, this._cleanupHookCounter++));
    };
    CleanupQueue.prototype.remove = function (envObject, fn, arg) {
        for (var i = 0; i < this._cleanupHooks.length; ++i) {
            var hook = this._cleanupHooks[i];
            if (hook.envObject === envObject && hook.fn === fn && hook.arg === arg) {
                this._cleanupHooks.splice(i, 1);
                return;
            }
        }
    };
    CleanupQueue.prototype.drain = function () {
        var hooks = this._cleanupHooks.slice();
        hooks.sort(function (a, b) { return (b.order - a.order); });
        for (var i = 0; i < hooks.length; ++i) {
            var cb = hooks[i];
            if (typeof cb.fn === 'number') {
                cb.envObject.makeDynCall_vp(cb.fn)(cb.arg);
            }
            else {
                cb.fn(cb.arg);
            }
            this._cleanupHooks.splice(this._cleanupHooks.indexOf(cb), 1);
        }
    };
    CleanupQueue.prototype.dispose = function () {
        this._cleanupHooks.length = 0;
        this._cleanupHookCounter = 0;
    };
    return CleanupQueue;
}());
var Context = /*#__PURE__*/ (function () {
    function Context() {
        this._isStopping = false;
        this._canCallIntoJs = true;
        this._suppressDestroy = false;
        this.envStore = new Store();
        this.scopeStore = new ScopeStore();
        this.refStore = new Store();
        this.deferredStore = new Store();
        this.handleStore = new HandleStore();
        this.feature = {
            supportReflect: supportReflect,
            supportFinalizer: supportFinalizer,
            supportWeakSymbol: supportWeakSymbol,
            supportBigInt: supportBigInt,
            supportNewFunction: supportNewFunction,
            canSetFunctionName: canSetFunctionName,
            setImmediate: _setImmediate,
            Buffer: _Buffer,
            MessageChannel: _MessageChannel
        };
        this.cleanupQueue = new CleanupQueue();
    }
    /**
     * Suppress the destroy on `beforeExit` event in Node.js.
     * Call this method if you want to keep the context and
     * all associated {@link Env | Env} alive,
     * this also means that cleanup hooks will not be called.
     * After call this method, you should call
     * {@link Context.destroy | `Context.prototype.destroy`} method manually.
     */
    Context.prototype.suppressDestroy = function () {
        this._suppressDestroy = true;
    };
    // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
    Context.prototype.getRuntimeVersions = function () {
        return {
            version: version,
            NODE_API_SUPPORTED_VERSION_MAX: NODE_API_SUPPORTED_VERSION_MAX,
            NAPI_VERSION_EXPERIMENTAL: NAPI_VERSION_EXPERIMENTAL,
            NODE_API_DEFAULT_MODULE_API_VERSION: NODE_API_DEFAULT_MODULE_API_VERSION
        };
    };
    Context.prototype.createNotSupportWeakRefError = function (api, message) {
        return new NotSupportWeakRefError(api, message);
    };
    Context.prototype.createNotSupportBufferError = function (api, message) {
        return new NotSupportBufferError(api, message);
    };
    Context.prototype.createReference = function (envObject, handle_id, initialRefcount, ownership) {
        return Reference.create(envObject, handle_id, initialRefcount, ownership);
    };
    Context.prototype.createReferenceWithData = function (envObject, handle_id, initialRefcount, ownership, data) {
        return ReferenceWithData.create(envObject, handle_id, initialRefcount, ownership, data);
    };
    Context.prototype.createReferenceWithFinalizer = function (envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        if (finalize_callback === void 0) { finalize_callback = 0; }
        if (finalize_data === void 0) { finalize_data = 0; }
        if (finalize_hint === void 0) { finalize_hint = 0; }
        return ReferenceWithFinalizer.create(envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint);
    };
    Context.prototype.createDeferred = function (value) {
        return Deferred.create(this, value);
    };
    Context.prototype.createEnv = function (filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
        return newEnv(this, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding);
    };
    Context.prototype.createTrackedFinalizer = function (envObject, finalize_callback, finalize_data, finalize_hint) {
        return TrackedFinalizer.create(envObject, finalize_callback, finalize_data, finalize_hint);
    };
    Context.prototype.getCurrentScope = function () {
        return this.scopeStore.currentScope;
    };
    Context.prototype.addToCurrentScope = function (value) {
        return this.scopeStore.currentScope.add(value);
    };
    Context.prototype.openScope = function (envObject) {
        return this.scopeStore.openScope(envObject);
    };
    Context.prototype.closeScope = function (envObject, _scope) {
        this.scopeStore.closeScope(envObject);
    };
    Context.prototype.ensureHandle = function (value) {
        switch (value) {
            case undefined: return HandleStore.UNDEFINED;
            case null: return HandleStore.NULL;
            case true: return HandleStore.TRUE;
            case false: return HandleStore.FALSE;
            case _global: return HandleStore.GLOBAL;
        }
        return this.addToCurrentScope(value);
    };
    Context.prototype.addCleanupHook = function (envObject, fn, arg) {
        this.cleanupQueue.add(envObject, fn, arg);
    };
    Context.prototype.removeCleanupHook = function (envObject, fn, arg) {
        this.cleanupQueue.remove(envObject, fn, arg);
    };
    Context.prototype.runCleanup = function () {
        while (!this.cleanupQueue.empty()) {
            this.cleanupQueue.drain();
        }
    };
    Context.prototype.increaseWaitingRequestCounter = function () {
        var _a;
        (_a = this.refCounter) === null || _a === void 0 ? void 0 : _a.increase();
    };
    Context.prototype.decreaseWaitingRequestCounter = function () {
        var _a;
        (_a = this.refCounter) === null || _a === void 0 ? void 0 : _a.decrease();
    };
    Context.prototype.setCanCallIntoJs = function (value) {
        this._canCallIntoJs = value;
    };
    Context.prototype.setStopping = function (value) {
        this._isStopping = value;
    };
    Context.prototype.canCallIntoJs = function () {
        return this._canCallIntoJs && !this._isStopping;
    };
    /**
     * Destroy the context and call cleanup hooks.
     * Associated {@link Env | Env} will be destroyed.
     */
    Context.prototype.destroy = function () {
        this.setStopping(true);
        this.setCanCallIntoJs(false);
        this.runCleanup();
    };
    return Context;
}());
var defaultContext;
function createContext() {
    return new Context();
}
function getDefaultContext() {
    if (!defaultContext) {
        defaultContext = createContext();
    }
    return defaultContext;
}

const _WebAssembly = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
if (!_WebAssembly) {
    throw new Error('WebAssembly is not supported in this environment');
}

/* eslint-disable spaced-comment */

function validateObject(value, name) {
    if (value === null || typeof value !== 'object') {
        throw new TypeError(`${name} must be an object. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateArray(value, name) {
    if (!Array.isArray(value)) {
        throw new TypeError(`${name} must be an array. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateBoolean(value, name) {
    if (typeof value !== 'boolean') {
        throw new TypeError(`${name} must be a boolean. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateString(value, name) {
    if (typeof value !== 'string') {
        throw new TypeError(`${name} must be a string. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateFunction(value, name) {
    if (typeof value !== 'function') {
        throw new TypeError(`${name} must be a function. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateUndefined(value, name) {
    if (value !== undefined) {
        throw new TypeError(`${name} must be undefined. Received ${value === null ? 'null' : typeof value}`);
    }
}
function isPromiseLike(obj) {
    return !!(obj && (typeof obj === 'object' || typeof obj === 'function') && typeof obj.then === 'function');
}
function unsharedSlice(view, start, end) {
    return ((typeof SharedArrayBuffer === 'function' && view.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(view.buffer.constructor) === '[object SharedArrayBuffer]'))
        ? view.slice(start, end)
        : view.subarray(start, end);
}

const CHAR_DOT = 46; /* . */
const CHAR_FORWARD_SLASH = 47; /* / */
function isPosixPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH;
}
function normalizeString(path, allowAboveRoot, separator, isPathSeparator) {
    let res = '';
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code = 0;
    for (let i = 0; i <= path.length; ++i) {
        if (i < path.length) {
            code = path.charCodeAt(i);
        }
        else if (isPathSeparator(code)) {
            break;
        }
        else {
            code = CHAR_FORWARD_SLASH;
        }
        if (isPathSeparator(code)) {
            if (lastSlash === i - 1 || dots === 1) ;
            else if (dots === 2) {
                if (res.length < 2 || lastSegmentLength !== 2 ||
                    res.charCodeAt(res.length - 1) !== CHAR_DOT ||
                    res.charCodeAt(res.length - 2) !== CHAR_DOT) {
                    if (res.length > 2) {
                        const lastSlashIndex = res.indexOf(separator);
                        if (lastSlashIndex === -1) {
                            res = '';
                            lastSegmentLength = 0;
                        }
                        else {
                            res = res.slice(0, lastSlashIndex);
                            lastSegmentLength =
                                res.length - 1 - res.indexOf(separator);
                        }
                        lastSlash = i;
                        dots = 0;
                        continue;
                    }
                    else if (res.length !== 0) {
                        res = '';
                        lastSegmentLength = 0;
                        lastSlash = i;
                        dots = 0;
                        continue;
                    }
                }
                if (allowAboveRoot) {
                    res += res.length > 0 ? `${separator}..` : '..';
                    lastSegmentLength = 2;
                }
            }
            else {
                if (res.length > 0) {
                    res += `${separator}${path.slice(lastSlash + 1, i)}`;
                }
                else {
                    res = path.slice(lastSlash + 1, i);
                }
                lastSegmentLength = i - lastSlash - 1;
            }
            lastSlash = i;
            dots = 0;
        }
        else if (code === CHAR_DOT && dots !== -1) {
            ++dots;
        }
        else {
            dots = -1;
        }
    }
    return res;
}
function resolve(...args) {
    let resolvedPath = '';
    let resolvedAbsolute = false;
    for (let i = args.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        const path = i >= 0 ? args[i] : '/';
        validateString(path, 'path');
        // Skip empty entries
        if (path.length === 0) {
            continue;
        }
        resolvedPath = `${path}/${resolvedPath}`;
        resolvedAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    }
    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)
    // Normalize the path
    resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, '/', isPosixPathSeparator);
    if (resolvedAbsolute) {
        return `/${resolvedPath}`;
    }
    return resolvedPath.length > 0 ? resolvedPath : '.';
}

const FD_DATASYNC = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(0));
const FD_READ = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(1));
const FD_SEEK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(2));
const FD_FDSTAT_SET_FLAGS = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(3));
const FD_SYNC = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(4));
const FD_TELL = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(5));
const FD_WRITE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(6));
const FD_ADVISE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(7));
const FD_ALLOCATE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(8));
const PATH_CREATE_DIRECTORY = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(9));
const PATH_CREATE_FILE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(10));
const PATH_LINK_SOURCE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(11));
const PATH_LINK_TARGET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(12));
const PATH_OPEN = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(13));
const FD_READDIR = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(14));
const PATH_READLINK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(15));
const PATH_RENAME_SOURCE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(16));
const PATH_RENAME_TARGET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(17));
const PATH_FILESTAT_GET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(18));
const PATH_FILESTAT_SET_SIZE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(19));
const PATH_FILESTAT_SET_TIMES = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(20));
const FD_FILESTAT_GET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(21));
const FD_FILESTAT_SET_SIZE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(22));
const FD_FILESTAT_SET_TIMES = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(23));
const PATH_SYMLINK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(24));
const PATH_REMOVE_DIRECTORY = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(25));
const PATH_UNLINK_FILE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(26));
const POLL_FD_READWRITE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(27));
const SOCK_SHUTDOWN = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(28));
const SOCK_ACCEPT = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(29));
const WasiRights = {
    FD_DATASYNC,
    FD_READ,
    FD_SEEK,
    FD_FDSTAT_SET_FLAGS,
    FD_SYNC,
    FD_TELL,
    FD_WRITE,
    FD_ADVISE,
    FD_ALLOCATE,
    PATH_CREATE_DIRECTORY,
    PATH_CREATE_FILE,
    PATH_LINK_SOURCE,
    PATH_LINK_TARGET,
    PATH_OPEN,
    FD_READDIR,
    PATH_READLINK,
    PATH_RENAME_SOURCE,
    PATH_RENAME_TARGET,
    PATH_FILESTAT_GET,
    PATH_FILESTAT_SET_SIZE,
    PATH_FILESTAT_SET_TIMES,
    FD_FILESTAT_GET,
    FD_FILESTAT_SET_SIZE,
    FD_FILESTAT_SET_TIMES,
    PATH_SYMLINK,
    PATH_REMOVE_DIRECTORY,
    PATH_UNLINK_FILE,
    POLL_FD_READWRITE,
    SOCK_SHUTDOWN,
    SOCK_ACCEPT
};

function strerror(errno) {
    switch (errno) {
        case 0 /* WasiErrno.ESUCCESS */: return 'Success';
        case 1 /* WasiErrno.E2BIG */: return 'Argument list too long';
        case 2 /* WasiErrno.EACCES */: return 'Permission denied';
        case 3 /* WasiErrno.EADDRINUSE */: return 'Address in use';
        case 4 /* WasiErrno.EADDRNOTAVAIL */: return 'Address not available';
        case 5 /* WasiErrno.EAFNOSUPPORT */: return 'Address family not supported by protocol';
        case 6 /* WasiErrno.EAGAIN */: return 'Resource temporarily unavailable';
        case 7 /* WasiErrno.EALREADY */: return 'Operation already in progress';
        case 8 /* WasiErrno.EBADF */: return 'Bad file descriptor';
        case 9 /* WasiErrno.EBADMSG */: return 'Bad message';
        case 10 /* WasiErrno.EBUSY */: return 'Resource busy';
        case 11 /* WasiErrno.ECANCELED */: return 'Operation canceled';
        case 12 /* WasiErrno.ECHILD */: return 'No child null';
        case 13 /* WasiErrno.ECONNABORTED */: return 'Connection aborted';
        case 14 /* WasiErrno.ECONNREFUSED */: return 'Connection refused';
        case 15 /* WasiErrno.ECONNRESET */: return 'Connection reset by peer';
        case 16 /* WasiErrno.EDEADLK */: return 'Resource deadlock would occur';
        case 17 /* WasiErrno.EDESTADDRREQ */: return 'Destination address required';
        case 18 /* WasiErrno.EDOM */: return 'Domain error';
        case 19 /* WasiErrno.EDQUOT */: return 'Quota exceeded';
        case 20 /* WasiErrno.EEXIST */: return 'File exists';
        case 21 /* WasiErrno.EFAULT */: return 'Bad address';
        case 22 /* WasiErrno.EFBIG */: return 'File too large';
        case 23 /* WasiErrno.EHOSTUNREACH */: return 'Host is unreachable';
        case 24 /* WasiErrno.EIDRM */: return 'Identifier removed';
        case 25 /* WasiErrno.EILSEQ */: return 'Illegal byte sequence';
        case 26 /* WasiErrno.EINPROGRESS */: return 'Operation in progress';
        case 27 /* WasiErrno.EINTR */: return 'Interrupted system call';
        case 28 /* WasiErrno.EINVAL */: return 'Invalid argument';
        case 29 /* WasiErrno.EIO */: return 'I/O error';
        case 30 /* WasiErrno.EISCONN */: return 'Socket is connected';
        case 31 /* WasiErrno.EISDIR */: return 'Is a directory';
        case 32 /* WasiErrno.ELOOP */: return 'Symbolic link loop';
        case 33 /* WasiErrno.EMFILE */: return 'No file descriptors available';
        case 34 /* WasiErrno.EMLINK */: return 'Too many links';
        case 35 /* WasiErrno.EMSGSIZE */: return 'Message too large';
        case 36 /* WasiErrno.EMULTIHOP */: return 'Multihop attempted';
        case 37 /* WasiErrno.ENAMETOOLONG */: return 'Filename too long';
        case 38 /* WasiErrno.ENETDOWN */: return 'Network is down';
        case 39 /* WasiErrno.ENETRESET */: return 'Connection reset by network';
        case 40 /* WasiErrno.ENETUNREACH */: return 'Network unreachable';
        case 41 /* WasiErrno.ENFILE */: return 'Too many files open in system';
        case 42 /* WasiErrno.ENOBUFS */: return 'No buffer space available';
        case 43 /* WasiErrno.ENODEV */: return 'No such device';
        case 44 /* WasiErrno.ENOENT */: return 'No such file or directory';
        case 45 /* WasiErrno.ENOEXEC */: return 'Exec format error';
        case 46 /* WasiErrno.ENOLCK */: return 'No locks available';
        case 47 /* WasiErrno.ENOLINK */: return 'Link has been severed';
        case 48 /* WasiErrno.ENOMEM */: return 'Out of memory';
        case 49 /* WasiErrno.ENOMSG */: return 'No message of the desired type';
        case 50 /* WasiErrno.ENOPROTOOPT */: return 'Protocol not available';
        case 51 /* WasiErrno.ENOSPC */: return 'No space left on device';
        case 52 /* WasiErrno.ENOSYS */: return 'Function not implemented';
        case 53 /* WasiErrno.ENOTCONN */: return 'Socket not connected';
        case 54 /* WasiErrno.ENOTDIR */: return 'Not a directory';
        case 55 /* WasiErrno.ENOTEMPTY */: return 'Directory not empty';
        case 56 /* WasiErrno.ENOTRECOVERABLE */: return 'State not recoverable';
        case 57 /* WasiErrno.ENOTSOCK */: return 'Not a socket';
        case 58 /* WasiErrno.ENOTSUP */: return 'Not supported';
        case 59 /* WasiErrno.ENOTTY */: return 'Not a tty';
        case 60 /* WasiErrno.ENXIO */: return 'No such device or address';
        case 61 /* WasiErrno.EOVERFLOW */: return 'Value too large for data type';
        case 62 /* WasiErrno.EOWNERDEAD */: return 'Previous owner died';
        case 63 /* WasiErrno.EPERM */: return 'Operation not permitted';
        case 64 /* WasiErrno.EPIPE */: return 'Broken pipe';
        case 65 /* WasiErrno.EPROTO */: return 'Protocol error';
        case 66 /* WasiErrno.EPROTONOSUPPORT */: return 'Protocol not supported';
        case 67 /* WasiErrno.EPROTOTYPE */: return 'Protocol wrong type for socket';
        case 68 /* WasiErrno.ERANGE */: return 'Result not representable';
        case 69 /* WasiErrno.EROFS */: return 'Read-only file system';
        case 70 /* WasiErrno.ESPIPE */: return 'Invalid seek';
        case 71 /* WasiErrno.ESRCH */: return 'No such null';
        case 72 /* WasiErrno.ESTALE */: return 'Stale file handle';
        case 73 /* WasiErrno.ETIMEDOUT */: return 'Operation timed out';
        case 74 /* WasiErrno.ETXTBSY */: return 'Text file busy';
        case 75 /* WasiErrno.EXDEV */: return 'Cross-device link';
        case 76 /* WasiErrno.ENOTCAPABLE */: return 'Capabilities insufficient';
        default: return 'Unknown error';
    }
}
class WasiError extends Error {
    constructor(message, errno) {
        super(message);
        this.errno = errno;
    }
    getErrorMessage() {
        return strerror(this.errno);
    }
}
Object.defineProperty(WasiError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'WasiError'
});

const RIGHTS_ALL = WasiRights.FD_DATASYNC |
    WasiRights.FD_READ |
    WasiRights.FD_SEEK |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_TELL |
    WasiRights.FD_WRITE |
    WasiRights.FD_ADVISE |
    WasiRights.FD_ALLOCATE |
    WasiRights.PATH_CREATE_DIRECTORY |
    WasiRights.PATH_CREATE_FILE |
    WasiRights.PATH_LINK_SOURCE |
    WasiRights.PATH_LINK_TARGET |
    WasiRights.PATH_OPEN |
    WasiRights.FD_READDIR |
    WasiRights.PATH_READLINK |
    WasiRights.PATH_RENAME_SOURCE |
    WasiRights.PATH_RENAME_TARGET |
    WasiRights.PATH_FILESTAT_GET |
    WasiRights.PATH_FILESTAT_SET_SIZE |
    WasiRights.PATH_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_SET_SIZE |
    WasiRights.PATH_SYMLINK |
    WasiRights.PATH_UNLINK_FILE |
    WasiRights.PATH_REMOVE_DIRECTORY |
    WasiRights.POLL_FD_READWRITE |
    WasiRights.SOCK_SHUTDOWN |
    WasiRights.SOCK_ACCEPT;
const BLOCK_DEVICE_BASE = RIGHTS_ALL;
const BLOCK_DEVICE_INHERITING = RIGHTS_ALL;
const CHARACTER_DEVICE_BASE = RIGHTS_ALL;
const CHARACTER_DEVICE_INHERITING = RIGHTS_ALL;
const REGULAR_FILE_BASE = WasiRights.FD_DATASYNC |
    WasiRights.FD_READ |
    WasiRights.FD_SEEK |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_TELL |
    WasiRights.FD_WRITE |
    WasiRights.FD_ADVISE |
    WasiRights.FD_ALLOCATE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_SIZE |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.POLL_FD_READWRITE;
const REGULAR_FILE_INHERITING = /*#__PURE__*/ BigInt(0);
const DIRECTORY_BASE = WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_ADVISE |
    WasiRights.PATH_CREATE_DIRECTORY |
    WasiRights.PATH_CREATE_FILE |
    WasiRights.PATH_LINK_SOURCE |
    WasiRights.PATH_LINK_TARGET |
    WasiRights.PATH_OPEN |
    WasiRights.FD_READDIR |
    WasiRights.PATH_READLINK |
    WasiRights.PATH_RENAME_SOURCE |
    WasiRights.PATH_RENAME_TARGET |
    WasiRights.PATH_FILESTAT_GET |
    WasiRights.PATH_FILESTAT_SET_SIZE |
    WasiRights.PATH_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.PATH_SYMLINK |
    WasiRights.PATH_UNLINK_FILE |
    WasiRights.PATH_REMOVE_DIRECTORY |
    WasiRights.POLL_FD_READWRITE;
const DIRECTORY_INHERITING = DIRECTORY_BASE | REGULAR_FILE_BASE;
const SOCKET_BASE = (WasiRights.FD_READ |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_WRITE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.POLL_FD_READWRITE |
    WasiRights.SOCK_SHUTDOWN);
const SOCKET_INHERITING = RIGHTS_ALL;
const TTY_BASE = WasiRights.FD_READ |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_WRITE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.POLL_FD_READWRITE;
const TTY_INHERITING = /*#__PURE__*/ BigInt(0);
function getRights(stdio, fd, flags, type) {
    const ret = {
        base: BigInt(0),
        inheriting: BigInt(0)
    };
    if (type === 0 /* WasiFileType.UNKNOWN */) {
        throw new WasiError('Unknown file type', 28 /* WasiErrno.EINVAL */);
    }
    switch (type) {
        case 4 /* WasiFileType.REGULAR_FILE */:
            ret.base = REGULAR_FILE_BASE;
            ret.inheriting = REGULAR_FILE_INHERITING;
            break;
        case 3 /* WasiFileType.DIRECTORY */:
            ret.base = DIRECTORY_BASE;
            ret.inheriting = DIRECTORY_INHERITING;
            break;
        case 6 /* WasiFileType.SOCKET_STREAM */:
        case 5 /* WasiFileType.SOCKET_DGRAM */:
            ret.base = SOCKET_BASE;
            ret.inheriting = SOCKET_INHERITING;
            break;
        case 2 /* WasiFileType.CHARACTER_DEVICE */:
            if (stdio.indexOf(fd) !== -1) {
                ret.base = TTY_BASE;
                ret.inheriting = TTY_INHERITING;
            }
            else {
                ret.base = CHARACTER_DEVICE_BASE;
                ret.inheriting = CHARACTER_DEVICE_INHERITING;
            }
            break;
        case 1 /* WasiFileType.BLOCK_DEVICE */:
            ret.base = BLOCK_DEVICE_BASE;
            ret.inheriting = BLOCK_DEVICE_INHERITING;
            break;
        default:
            ret.base = BigInt(0);
            ret.inheriting = BigInt(0);
    }
    /* Disable read/write bits depending on access mode. */
    const read_or_write_only = flags & (0 | 1 | 2);
    if (read_or_write_only === 0) {
        ret.base &= ~WasiRights.FD_WRITE;
    }
    else if (read_or_write_only === 1) {
        ret.base &= ~WasiRights.FD_READ;
    }
    return ret;
}

function concatBuffer(buffers, size) {
    let total = 0;
    {
        for (let i = 0; i < buffers.length; i++) {
            const buffer = buffers[i];
            total += buffer.length;
        }
    }
    let pos = 0;
    const ret = new Uint8Array(total);
    for (let i = 0; i < buffers.length; i++) {
        const buffer = buffers[i];
        ret.set(buffer, pos);
        pos += buffer.length;
    }
    return ret;
}
class FileDescriptor {
    constructor(id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen) {
        this.id = id;
        this.fd = fd;
        this.path = path;
        this.realPath = realPath;
        this.type = type;
        this.rightsBase = rightsBase;
        this.rightsInheriting = rightsInheriting;
        this.preopen = preopen;
        this.pos = BigInt(0);
        this.size = BigInt(0);
    }
    seek(offset, whence) {
        if (whence === 0 /* WasiWhence.SET */) {
            this.pos = BigInt(offset);
        }
        else if (whence === 1 /* WasiWhence.CUR */) {
            this.pos += BigInt(offset);
        }
        else if (whence === 2 /* WasiWhence.END */) {
            this.pos = BigInt(this.size) - BigInt(offset);
        }
        else {
            throw new WasiError('Unknown whence', 29 /* WasiErrno.EIO */);
        }
        return this.pos;
    }
}
class StandardOutput extends FileDescriptor {
    constructor(log, id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen) {
        super(id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen);
        this._log = log;
        this._buf = null;
    }
    write(buffer) {
        const originalBuffer = buffer;
        if (this._buf) {
            buffer = concatBuffer([this._buf, buffer]);
            this._buf = null;
        }
        if (buffer.indexOf(10) === -1) {
            this._buf = buffer;
            return originalBuffer.byteLength;
        }
        let written = 0;
        let lastBegin = 0;
        let index;
        while ((index = buffer.indexOf(10, written)) !== -1) {
            const str = new TextDecoder().decode(buffer.subarray(lastBegin, index));
            this._log(str);
            written += index - lastBegin + 1;
            lastBegin = index + 1;
        }
        if (written < buffer.length) {
            this._buf = buffer.slice(written);
        }
        return originalBuffer.byteLength;
    }
}
function toFileType(stat) {
    if (stat.isBlockDevice())
        return 1 /* WasiFileType.BLOCK_DEVICE */;
    if (stat.isCharacterDevice())
        return 2 /* WasiFileType.CHARACTER_DEVICE */;
    if (stat.isDirectory())
        return 3 /* WasiFileType.DIRECTORY */;
    if (stat.isSocket())
        return 6 /* WasiFileType.SOCKET_STREAM */;
    if (stat.isFile())
        return 4 /* WasiFileType.REGULAR_FILE */;
    if (stat.isSymbolicLink())
        return 7 /* WasiFileType.SYMBOLIC_LINK */;
    return 0 /* WasiFileType.UNKNOWN */;
}
function toFileStat(view, buf, stat) {
    view.setBigUint64(buf, stat.dev, true);
    view.setBigUint64(buf + 8, stat.ino, true);
    view.setBigUint64(buf + 16, BigInt(toFileType(stat)), true);
    view.setBigUint64(buf + 24, stat.nlink, true);
    view.setBigUint64(buf + 32, stat.size, true);
    view.setBigUint64(buf + 40, stat.atimeMs * BigInt(1000000), true);
    view.setBigUint64(buf + 48, stat.mtimeMs * BigInt(1000000), true);
    view.setBigUint64(buf + 56, stat.ctimeMs * BigInt(1000000), true);
}
class FileDescriptorTable {
    constructor(options) {
        this.used = 0;
        this.size = options.size;
        this.fds = Array(options.size);
        this.stdio = [options.in, options.out, options.err];
        this.print = options.print;
        this.printErr = options.printErr;
        this.insertStdio(options.in, 0, '<stdin>');
        this.insertStdio(options.out, 1, '<stdout>');
        this.insertStdio(options.err, 2, '<stderr>');
    }
    insertStdio(fd, expected, name) {
        const type = 2 /* WasiFileType.CHARACTER_DEVICE */;
        const { base, inheriting } = getRights(this.stdio, fd, 2 /* FileControlFlag.O_RDWR */, type);
        const wrap = this.insert(fd, name, name, type, base, inheriting, 0);
        if (wrap.id !== expected) {
            throw new WasiError(`id: ${wrap.id} !== expected: ${expected}`, 8 /* WasiErrno.EBADF */);
        }
        return wrap;
    }
    insert(fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen) {
        var _a, _b;
        let index = -1;
        if (this.used >= this.size) {
            const newSize = this.size * 2;
            this.fds.length = newSize;
            index = this.size;
            this.size = newSize;
        }
        else {
            for (let i = 0; i < this.size; ++i) {
                if (this.fds[i] == null) {
                    index = i;
                    break;
                }
            }
        }
        let entry;
        if (mappedPath === '<stdout>') {
            entry = new StandardOutput((_a = this.print) !== null && _a !== void 0 ? _a : console.log, index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        else if (mappedPath === '<stderr>') {
            entry = new StandardOutput((_b = this.printErr) !== null && _b !== void 0 ? _b : console.error, index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        else {
            entry = new FileDescriptor(index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        this.fds[index] = entry;
        this.used++;
        return entry;
    }
    get(id, base, inheriting) {
        if (id >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const entry = this.fds[id];
        if (!entry || entry.id !== id) {
            throw new WasiError('Bad file descriptor', 8 /* WasiErrno.EBADF */);
        }
        /* Validate that the fd has the necessary rights. */
        if ((~entry.rightsBase & base) !== BigInt(0) || (~entry.rightsInheriting & inheriting) !== BigInt(0)) {
            throw new WasiError('Capabilities insufficient', 76 /* WasiErrno.ENOTCAPABLE */);
        }
        return entry;
    }
    remove(id) {
        if (id >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const entry = this.fds[id];
        if (!entry || entry.id !== id) {
            throw new WasiError('Bad file descriptor', 8 /* WasiErrno.EBADF */);
        }
        this.fds[id] = undefined;
        this.used--;
    }
}
class SyncTable extends FileDescriptorTable {
    constructor(options) {
        super(options);
        this.fs = options.fs;
    }
    getFileTypeByFd(fd) {
        const stats = this.fs.fstatSync(fd, { bigint: true });
        return toFileType(stats);
    }
    insertPreopen(fd, mappedPath, realPath) {
        const type = this.getFileTypeByFd(fd);
        if (type !== 3 /* WasiFileType.DIRECTORY */) {
            throw new WasiError(`Preopen not dir: ["${mappedPath}", "${realPath}"]`, 54 /* WasiErrno.ENOTDIR */);
        }
        const result = getRights(this.stdio, fd, 0, type);
        return this.insert(fd, mappedPath, realPath, type, result.base, result.inheriting, 1);
    }
    renumber(dst, src) {
        if (dst === src)
            return;
        if (dst >= this.size || src >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const dstEntry = this.fds[dst];
        const srcEntry = this.fds[src];
        if (!dstEntry || !srcEntry || dstEntry.id !== dst || srcEntry.id !== src) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        this.fs.closeSync(dstEntry.fd);
        this.fds[dst] = this.fds[src];
        this.fds[dst].id = dst;
        this.fds[src] = undefined;
        this.used--;
    }
}
class AsyncTable extends FileDescriptorTable {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(options) {
        super(options);
    }
    async getFileTypeByFd(fd) {
        const stats = await fd.stat({ bigint: true });
        return toFileType(stats);
    }
    async insertPreopen(fd, mappedPath, realPath) {
        const type = await this.getFileTypeByFd(fd);
        if (type !== 3 /* WasiFileType.DIRECTORY */) {
            throw new WasiError(`Preopen not dir: ["${mappedPath}", "${realPath}"]`, 54 /* WasiErrno.ENOTDIR */);
        }
        const result = getRights(this.stdio, fd.fd, 0, type);
        return this.insert(fd, mappedPath, realPath, type, result.base, result.inheriting, 1);
    }
    async renumber(dst, src) {
        if (dst === src)
            return;
        if (dst >= this.size || src >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const dstEntry = this.fds[dst];
        const srcEntry = this.fds[src];
        if (!dstEntry || !srcEntry || dstEntry.id !== dst || srcEntry.id !== src) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        await dstEntry.fd.close();
        this.fds[dst] = this.fds[src];
        this.fds[dst].id = dst;
        this.fds[src] = undefined;
        this.used--;
    }
}

/** @public */
const WebAssemblyMemory = /*#__PURE__*/ (function () { return _WebAssembly.Memory; })();
/** @public */
class Memory extends WebAssemblyMemory {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(descriptor) {
        super(descriptor);
    }
    get HEAP8() { return new Int8Array(super.buffer); }
    get HEAPU8() { return new Uint8Array(super.buffer); }
    get HEAP16() { return new Int16Array(super.buffer); }
    get HEAPU16() { return new Uint16Array(super.buffer); }
    get HEAP32() { return new Int32Array(super.buffer); }
    get HEAPU32() { return new Uint32Array(super.buffer); }
    get HEAP64() { return new BigInt64Array(super.buffer); }
    get HEAPU64() { return new BigUint64Array(super.buffer); }
    get HEAPF32() { return new Float32Array(super.buffer); }
    get HEAPF64() { return new Float64Array(super.buffer); }
    get view() { return new DataView(super.buffer); }
}
/** @public */
function extendMemory(memory) {
    if (Object.getPrototypeOf(memory) === _WebAssembly.Memory.prototype) {
        Object.setPrototypeOf(memory, Memory.prototype);
    }
    return memory;
}

function checkWebAssemblyFunction() {
    const WebAssemblyFunction = _WebAssembly.Function;
    if (typeof WebAssemblyFunction !== 'function') {
        throw new Error('WebAssembly.Function is not supported in this environment.' +
            ' If you are using V8 based browser like Chrome, try to specify' +
            ' --js-flags="--wasm-staging --experimental-wasm-stack-switching"');
    }
    return WebAssemblyFunction;
}
/** @public */
function wrapAsyncImport(f, parameterType, returnType) {
    const WebAssemblyFunction = checkWebAssemblyFunction();
    if (typeof f !== 'function') {
        throw new TypeError('Function required');
    }
    const parameters = parameterType.slice(0);
    parameters.unshift('externref');
    return new WebAssemblyFunction({ parameters, results: returnType }, f, { suspending: 'first' });
}

function copyMemory(targets, src) {
    if (targets.length === 0 || src.length === 0)
        return 0;
    let copied = 0;
    let left = src.length - copied;
    for (let i = 0; i < targets.length; ++i) {
        const target = targets[i];
        if (left < target.length) {
            target.set(src.subarray(copied, copied + left), 0);
            copied += left;
            left = 0;
            return copied;
        }
        target.set(src.subarray(copied, copied + target.length), 0);
        copied += target.length;
        left -= target.length;
    }
    return copied;
}
const _memory = new WeakMap();
const _wasi = new WeakMap();
const _fs = new WeakMap();
function getMemory(wasi) {
    return _memory.get(wasi);
}
function getFs(wasi) {
    const fs = _fs.get(wasi);
    if (!fs)
        throw new Error('filesystem is unavailable');
    return fs;
}
function handleError(err) {
    if (err instanceof WasiError) {
        return err.errno;
    }
    switch (err.code) {
        case 'ENOENT': return 44 /* WasiErrno.ENOENT */;
        case 'EBADF': return 8 /* WasiErrno.EBADF */;
        case 'EINVAL': return 28 /* WasiErrno.EINVAL */;
        case 'EPERM': return 63 /* WasiErrno.EPERM */;
        case 'EPROTO': return 65 /* WasiErrno.EPROTO */;
        case 'EEXIST': return 20 /* WasiErrno.EEXIST */;
        case 'ENOTDIR': return 54 /* WasiErrno.ENOTDIR */;
        case 'EMFILE': return 33 /* WasiErrno.EMFILE */;
        case 'EACCES': return 2 /* WasiErrno.EACCES */;
        case 'EISDIR': return 31 /* WasiErrno.EISDIR */;
        case 'ENOTEMPTY': return 55 /* WasiErrno.ENOTEMPTY */;
        case 'ENOSYS': return 52 /* WasiErrno.ENOSYS */;
    }
    throw err;
}
function defineName(name, f) {
    Object.defineProperty(f, 'name', { value: name });
    return f;
}
function syscallWrap(self, name, f) {
    return defineName(name, function () {
        let r;
        try {
            r = f.apply(self, arguments);
        }
        catch (err) {
            return handleError(err);
        }
        if (isPromiseLike(r)) {
            return r.then(_ => _, handleError);
        }
        return r;
    });
}
function resolvePathSync(fs, fileDescriptor, path, flags) {
    let resolvedPath = resolve(fileDescriptor.realPath, path);
    if ((flags & 1) === 1) {
        try {
            resolvedPath = fs.readlinkSync(resolvedPath);
        }
        catch (err) {
            if (err.code !== 'EINVAL' && err.code !== 'ENOENT') {
                throw err;
            }
        }
    }
    return resolvedPath;
}
async function resolvePathAsync(fs, fileDescriptor, path, flags) {
    let resolvedPath = resolve(fileDescriptor.realPath, path);
    if ((flags & 1) === 1) {
        try {
            resolvedPath = await fs.promises.readlink(resolvedPath);
        }
        catch (err) {
            if (err.code !== 'EINVAL' && err.code !== 'ENOENT') {
                throw err;
            }
        }
    }
    return resolvedPath;
}
// eslint-disable-next-line spaced-comment
const encoder = /*#__PURE__*/ new TextEncoder();
// eslint-disable-next-line spaced-comment
const decoder = /*#__PURE__*/ new TextDecoder();
const INT64_MAX = (BigInt(1) << BigInt(63)) - BigInt(1);
function readStdin() {
    const value = window.prompt();
    if (value === null)
        return new Uint8Array();
    const buffer = new TextEncoder().encode(value + '\n');
    return buffer;
}
function validateFstFlagsOrReturn(flags) {
    return (Boolean((flags) & -16) ||
        ((flags) & (1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */)) ===
            (1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */) ||
        ((flags) & (4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */)) ===
            (4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */));
}
class WASI$1 {
    constructor(args, env, fds, asyncFs, fs, asyncify) {
        this.args_get = syscallWrap(this, 'args_get', function (argv, argv_buf) {
            argv = Number(argv);
            argv_buf = Number(argv_buf);
            if (argv === 0 || argv_buf === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const args = wasi.args;
            for (let i = 0; i < args.length; ++i) {
                const arg = args[i];
                view.setInt32(argv, argv_buf, true);
                argv += 4;
                const data = encoder.encode(arg + '\0');
                HEAPU8.set(data, argv_buf);
                argv_buf += data.length;
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.args_sizes_get = syscallWrap(this, 'args_sizes_get', function (argc, argv_buf_size) {
            argc = Number(argc);
            argv_buf_size = Number(argv_buf_size);
            if (argc === 0 || argv_buf_size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            const wasi = _wasi.get(this);
            const args = wasi.args;
            view.setUint32(argc, args.length, true);
            view.setUint32(argv_buf_size, encoder.encode(args.join('\0') + '\0').length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.environ_get = syscallWrap(this, 'environ_get', function (environ, environ_buf) {
            environ = Number(environ);
            environ_buf = Number(environ_buf);
            if (environ === 0 || environ_buf === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const env = wasi.env;
            for (let i = 0; i < env.length; ++i) {
                const pair = env[i];
                view.setInt32(environ, environ_buf, true);
                environ += 4;
                const data = encoder.encode(pair + '\0');
                HEAPU8.set(data, environ_buf);
                environ_buf += data.length;
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.environ_sizes_get = syscallWrap(this, 'environ_sizes_get', function (len, buflen) {
            len = Number(len);
            buflen = Number(buflen);
            if (len === 0 || buflen === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            const wasi = _wasi.get(this);
            view.setUint32(len, wasi.env.length, true);
            view.setUint32(buflen, encoder.encode(wasi.env.join('\0') + '\0').length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.clock_res_get = syscallWrap(this, 'clock_res_get', function (id, resolution) {
            resolution = Number(resolution);
            if (resolution === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            switch (id) {
                case 0 /* WasiClockid.REALTIME */:
                    view.setBigUint64(resolution, BigInt(1000000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                case 1 /* WasiClockid.MONOTONIC */:
                case 2 /* WasiClockid.PROCESS_CPUTIME_ID */:
                case 3 /* WasiClockid.THREAD_CPUTIME_ID */:
                    view.setBigUint64(resolution, BigInt(1000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                default: return 28 /* WasiErrno.EINVAL */;
            }
        });
        this.clock_time_get = syscallWrap(this, 'clock_time_get', function (id, _percision, time) {
            time = Number(time);
            if (time === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            switch (id) {
                case 0 /* WasiClockid.REALTIME */:
                    view.setBigUint64(time, BigInt(Date.now()) * BigInt(1000000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                case 1 /* WasiClockid.MONOTONIC */:
                case 2 /* WasiClockid.PROCESS_CPUTIME_ID */:
                case 3 /* WasiClockid.THREAD_CPUTIME_ID */: {
                    const t = performance.now();
                    const s = Math.trunc(t);
                    const ms = Math.floor((t - s) * 1000);
                    const result = BigInt(s) * BigInt(1000000000) + BigInt(ms) * BigInt(1000000);
                    view.setBigUint64(time, result, true);
                    return 0 /* WasiErrno.ESUCCESS */;
                }
                default: return 28 /* WasiErrno.EINVAL */;
            }
        });
        this.fd_advise = syscallWrap(this, 'fd_advise', function (_fd, _offset, _len, _advice) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.fd_fdstat_get = syscallWrap(this, 'fd_fdstat_get', function (fd, fdstat) {
            fdstat = Number(fdstat);
            if (fdstat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            const { view } = getMemory(this);
            view.setUint16(fdstat, fileDescriptor.type, true);
            view.setUint16(fdstat + 2, 0, true);
            view.setBigUint64(fdstat + 8, fileDescriptor.rightsBase, true);
            view.setBigUint64(fdstat + 16, fileDescriptor.rightsInheriting, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_fdstat_set_flags = syscallWrap(this, 'fd_fdstat_set_flags', function (_fd, _flags) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.fd_fdstat_set_rights = syscallWrap(this, 'fd_fdstat_set_rights', function (fd, rightsBase, rightsInheriting) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            if ((rightsBase | fileDescriptor.rightsBase) > fileDescriptor.rightsBase) {
                return 76 /* WasiErrno.ENOTCAPABLE */;
            }
            if ((rightsInheriting | fileDescriptor.rightsInheriting) >
                fileDescriptor.rightsInheriting) {
                return 76 /* WasiErrno.ENOTCAPABLE */;
            }
            fileDescriptor.rightsBase = rightsBase;
            fileDescriptor.rightsInheriting = rightsInheriting;
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_prestat_get = syscallWrap(this, 'fd_prestat_get', function (fd, prestat) {
            prestat = Number(prestat);
            if (prestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let fileDescriptor;
            try {
                fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            }
            catch (err) {
                if (err instanceof WasiError)
                    return err.errno;
                throw err;
            }
            if (fileDescriptor.preopen !== 1)
                return 28 /* WasiErrno.EINVAL */;
            const { view } = getMemory(this);
            // preopen type is dir(0)
            view.setUint32(prestat, 0, true);
            view.setUint32(prestat + 4, encoder.encode(fileDescriptor.path).length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_prestat_dir_name = syscallWrap(this, 'fd_prestat_dir_name', function (fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            if (fileDescriptor.preopen !== 1)
                return 8 /* WasiErrno.EBADF */;
            const buffer = encoder.encode(fileDescriptor.path);
            const size = buffer.length;
            if (size > path_len)
                return 42 /* WasiErrno.ENOBUFS */;
            const { HEAPU8 } = getMemory(this);
            HEAPU8.set(buffer, path);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_seek = syscallWrap(this, 'fd_seek', function (fd, offset, whence, newOffset) {
            newOffset = Number(newOffset);
            if (newOffset === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            if (fd === 0 || fd === 1 || fd === 2)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SEEK, BigInt(0));
            const r = fileDescriptor.seek(offset, whence);
            const { view } = getMemory(this);
            view.setBigUint64(newOffset, r, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_tell = syscallWrap(this, 'fd_tell', function (fd, offset) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_TELL, BigInt(0));
            const pos = BigInt(fileDescriptor.pos);
            const { view } = getMemory(this);
            view.setBigUint64(Number(offset), pos, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.poll_oneoff = syscallWrap(this, 'poll_oneoff', function (in_ptr, out_ptr, nsubscriptions, nevents) {
            in_ptr = Number(in_ptr);
            out_ptr = Number(out_ptr);
            nevents = Number(nevents);
            nsubscriptions = Number(nsubscriptions);
            nsubscriptions = nsubscriptions >>> 0;
            if (in_ptr === 0 || out_ptr === 0 || nsubscriptions === 0 || nevents === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            view.setUint32(nevents, 0, true);
            let i = 0;
            let timer_userdata = BigInt(0);
            let cur_timeout = BigInt(0);
            let has_timeout = 0;
            let min_timeout = BigInt(0);
            let sub;
            const subscriptions = Array(nsubscriptions);
            for (i = 0; i < nsubscriptions; i++) {
                sub = in_ptr + i * 48;
                const userdata = view.getBigUint64(sub, true);
                const type = view.getUint8(sub + 8);
                const clockIdOrFd = view.getUint32(sub + 16, true);
                const timeout = view.getBigUint64(sub + 24, true);
                const precision = view.getBigUint64(sub + 32, true);
                const flags = view.getUint16(sub + 40, true);
                subscriptions[i] = {
                    userdata,
                    type,
                    u: {
                        clock: {
                            clock_id: clockIdOrFd,
                            timeout,
                            precision,
                            flags
                        },
                        fd_readwrite: {
                            fd: clockIdOrFd
                        }
                    }
                };
            }
            const fdevents = [];
            for (i = 0; i < nsubscriptions; i++) {
                sub = subscriptions[i];
                switch (sub.type) {
                    case 0 /* WasiEventType.CLOCK */: {
                        if (sub.u.clock.flags === 1 /* WasiSubclockflags.ABSTIME */) {
                            /* Convert absolute time to relative delay. */
                            const now = BigInt(Date.now()) * BigInt(1000000);
                            cur_timeout = sub.u.clock.timeout - now;
                        }
                        else {
                            cur_timeout = sub.u.clock.timeout;
                        }
                        if (has_timeout === 0 || cur_timeout < min_timeout) {
                            min_timeout = cur_timeout;
                            timer_userdata = sub.userdata;
                            has_timeout = 1;
                        }
                        break;
                    }
                    case 1 /* WasiEventType.FD_READ */:
                    case 2 /* WasiEventType.FD_WRITE */:
                        fdevents.push(sub);
                        break;
                    default: return 28 /* WasiErrno.EINVAL */;
                }
            }
            if (fdevents.length > 0) {
                for (i = 0; i < fdevents.length; i++) {
                    const fdevent = fdevents[i];
                    const event = out_ptr + 32 * i;
                    view.setBigUint64(event, fdevent.userdata, true);
                    view.setUint32(event + 8, 52 /* WasiErrno.ENOSYS */, true);
                    view.setUint32(event + 12, fdevent.type, true);
                    view.setBigUint64(event + 16, BigInt(0), true);
                    view.setUint16(event + 24, 0, true);
                    view.setUint32(nevents, 1, true);
                }
                view.setUint32(nevents, fdevents.length, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            if (has_timeout) {
                Number(min_timeout / BigInt(1000000));
                // } else {
                //   const buf = new SharedArrayBuffer(4)
                //   const arr = new Int32Array(buf)
                //   postMsg({
                //     __tybys_wasm_util_wasi__: {
                //       type: 'set-timeout',
                //       payload: {
                //         buffer: buf,
                //         delay
                //       }
                //     }
                //   })
                //   Atomics.wait(arr, 0, 0)
                // }
                const event = out_ptr;
                view.setBigUint64(event, timer_userdata, true);
                view.setUint32(event + 8, 0 /* WasiErrno.ESUCCESS */, true);
                view.setUint32(event + 12, 0 /* WasiEventType.CLOCK */, true);
                view.setUint32(nevents, 1, true);
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.proc_exit = syscallWrap(this, 'proc_exit', function (rval) {
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.proc_raise = syscallWrap(this, 'proc_raise', function (_sig) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.sched_yield = syscallWrap(this, 'sched_yield', function () {
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.random_get = typeof crypto !== 'undefined' && typeof crypto.getRandomValues === 'function'
            ? syscallWrap(this, 'random_get', function (buf, buf_len) {
                buf = Number(buf);
                if (buf === 0) {
                    return 28 /* WasiErrno.EINVAL */;
                }
                buf_len = Number(buf_len);
                const { HEAPU8, view } = getMemory(this);
                if ((typeof SharedArrayBuffer === 'function' && HEAPU8.buffer instanceof SharedArrayBuffer) ||
                    (Object.prototype.toString.call(HEAPU8.buffer) === '[object SharedArrayBuffer]')) {
                    for (let i = buf; i < buf + buf_len; ++i) {
                        view.setUint8(i, Math.floor(Math.random() * 256));
                    }
                    return 0 /* WasiErrno.ESUCCESS */;
                }
                let pos;
                const stride = 65536;
                for (pos = 0; pos + stride < buf_len; pos += stride) {
                    crypto.getRandomValues(HEAPU8.subarray(buf + pos, buf + pos + stride));
                }
                crypto.getRandomValues(HEAPU8.subarray(buf + pos, buf + buf_len));
                return 0 /* WasiErrno.ESUCCESS */;
            })
            : syscallWrap(this, 'random_get', function (buf, buf_len) {
                buf = Number(buf);
                if (buf === 0) {
                    return 28 /* WasiErrno.EINVAL */;
                }
                buf_len = Number(buf_len);
                const { view } = getMemory(this);
                for (let i = buf; i < buf + buf_len; ++i) {
                    view.setUint8(i, Math.floor(Math.random() * 256));
                }
                return 0 /* WasiErrno.ESUCCESS */;
            });
        this.sock_recv = syscallWrap(this, 'sock_recv', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_send = syscallWrap(this, 'sock_send', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_shutdown = syscallWrap(this, 'sock_shutdown', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_accept = syscallWrap(this, 'sock_accept', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        _wasi.set(this, {
            fds,
            args,
            env
        });
        if (fs)
            _fs.set(this, fs);
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        const _this = this;
        function defineImport(name, syncVersion, asyncVersion, parameterType, returnType) {
            if (asyncFs) {
                if (asyncify) {
                    _this[name] = asyncify.wrapImportFunction(syscallWrap(_this, name, asyncVersion));
                }
                else {
                    _this[name] = wrapAsyncImport(syscallWrap(_this, name, asyncVersion), parameterType, returnType);
                }
            }
            else {
                _this[name] = syscallWrap(_this, name, syncVersion);
            }
        }
        defineImport('fd_allocate', function fd_allocate(fd, offset, len) {
            const wasi = _wasi.get(this);
            const fs = getFs(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_ALLOCATE, BigInt(0));
            const stat = fs.fstatSync(fileDescriptor.fd, { bigint: true });
            if (stat.size < offset + len) {
                fs.ftruncateSync(fileDescriptor.fd, Number(offset + len));
            }
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_allocate(fd, offset, len) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_ALLOCATE, BigInt(0));
            const h = fileDescriptor.fd;
            const stat = await h.stat({ bigint: true });
            if (stat.size < offset + len) {
                await h.truncate(Number(offset + len));
            }
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64', 'f64'], ['i32']);
        defineImport('fd_close', function fd_close(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            const fs = getFs(this);
            fs.closeSync(fileDescriptor.fd);
            wasi.fds.remove(fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_close(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            await fileDescriptor.fd.close();
            wasi.fds.remove(fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_datasync', function fd_datasync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_DATASYNC, BigInt(0));
            const fs = getFs(this);
            fs.fdatasyncSync(fileDescriptor.fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_datasync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_DATASYNC, BigInt(0));
            await fileDescriptor.fd.datasync();
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_filestat_get', function fd_filestat_get(fd, buf) {
            buf = Number(buf);
            if (buf === 0)
                return 28 /* WasiErrno.EINVAL */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_GET, BigInt(0));
            const fs = getFs(this);
            const stat = fs.fstatSync(fileDescriptor.fd, { bigint: true });
            const { view } = getMemory(this);
            toFileStat(view, buf, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_get(fd, buf) {
            buf = Number(buf);
            if (buf === 0)
                return 28 /* WasiErrno.EINVAL */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_GET, BigInt(0));
            const h = fileDescriptor.fd;
            const stat = await h.stat({ bigint: true });
            const { view } = getMemory(this);
            toFileStat(view, buf, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32'], ['i32']);
        defineImport('fd_filestat_set_size', function fd_filestat_set_size(fd, size) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_SIZE, BigInt(0));
            const fs = getFs(this);
            fs.ftruncateSync(fileDescriptor.fd, Number(size));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_set_size(fd, size) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_SIZE, BigInt(0));
            const h = fileDescriptor.fd;
            await h.truncate(Number(size));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64'], ['i32']);
        function fdFilestatGetTimes(fd, atim, mtim, flags) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_TIMES, BigInt(0));
            if ((flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            return { fileDescriptor, atim, mtim };
        }
        defineImport('fd_filestat_set_times', function fd_filestat_set_times(fd, atim, mtim, flags) {
            if (validateFstFlagsOrReturn(flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { fileDescriptor, atim: atimRes, mtim: mtimRes } = fdFilestatGetTimes.call(this, fd, atim, mtim, flags);
            const fs = getFs(this);
            fs.futimesSync(fileDescriptor.fd, Number(atimRes), Number(mtimRes));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_set_times(fd, atim, mtim, flags) {
            if (validateFstFlagsOrReturn(flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { fileDescriptor, atim: atimRes, mtim: mtimRes } = fdFilestatGetTimes.call(this, fd, atim, mtim, flags);
            const h = fileDescriptor.fd;
            await h.utimes(Number(atimRes), Number(mtimRes));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64', 'i64', 'i32'], ['i32']);
        defineImport('fd_pread', function fd_pread(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let nread = 0;
            const buffer = (() => {
                try {
                    return new Uint8Array(new SharedArrayBuffer(totalSize));
                }
                catch (_) {
                    return new Uint8Array(totalSize);
                }
            })();
            buffer._isBuffer = true;
            const fs = getFs(this);
            const bytesRead = fs.readSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(offset));
            nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function (fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let nread = 0;
            const buffer = new Uint8Array(totalSize);
            buffer._isBuffer = true;
            const { bytesRead } = await fileDescriptor.fd.read(buffer, 0, buffer.length, Number(offset));
            nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_pwrite', function fd_pwrite(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            const fs = getFs(this);
            const nwritten = fs.writeSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(offset));
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_pwrite(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            const { bytesWritten } = await fileDescriptor.fd.write(buffer, 0, buffer.length, Number(offset));
            view.setUint32(size, bytesWritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_read', function fd_read(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let buffer;
            let nread = 0;
            if (fd === 0) {
                if (typeof window === 'undefined' || typeof window.prompt !== 'function') {
                    return 58 /* WasiErrno.ENOTSUP */;
                }
                buffer = readStdin();
                nread = buffer ? copyMemory(ioVecs, buffer) : 0;
            }
            else {
                buffer = (() => {
                    try {
                        return new Uint8Array(new SharedArrayBuffer(totalSize));
                    }
                    catch (_) {
                        return new Uint8Array(totalSize);
                    }
                })();
                buffer._isBuffer = true;
                const fs = getFs(this);
                const bytesRead = fs.readSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(fileDescriptor.pos));
                nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
                fileDescriptor.pos += BigInt(nread);
            }
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_read(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let buffer;
            let nread = 0;
            if (fd === 0) {
                if (typeof window === 'undefined' || typeof window.prompt !== 'function') {
                    return 58 /* WasiErrno.ENOTSUP */;
                }
                buffer = readStdin();
                nread = buffer ? copyMemory(ioVecs, buffer) : 0;
            }
            else {
                buffer = new Uint8Array(totalSize);
                buffer._isBuffer = true;
                const { bytesRead } = await fileDescriptor.fd.read(buffer, 0, buffer.length, Number(fileDescriptor.pos));
                nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
                fileDescriptor.pos += BigInt(nread);
            }
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('fd_readdir', function fd_readdir(fd, buf, buf_len, cookie, bufused) {
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (buf === 0 || bufused === 0)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READDIR, BigInt(0));
            const fs = getFs(this);
            const entries = fs.readdirSync(fileDescriptor.realPath, { withFileTypes: true });
            const { HEAPU8, view } = getMemory(this);
            let bufferUsed = 0;
            for (let i = Number(cookie); i < entries.length; i++) {
                const nameData = encoder.encode(entries[i].name);
                const entryInfo = fs.statSync(resolve(fileDescriptor.realPath, entries[i].name), { bigint: true });
                const entryData = new Uint8Array(24 + nameData.byteLength);
                const entryView = new DataView(entryData.buffer);
                entryView.setBigUint64(0, BigInt(i + 1), true);
                entryView.setBigUint64(8, BigInt(entryInfo.ino ? entryInfo.ino : 0), true);
                entryView.setUint32(16, nameData.byteLength, true);
                let type;
                if (entries[i].isFile()) {
                    type = 4 /* WasiFileType.REGULAR_FILE */;
                }
                else if (entries[i].isDirectory()) {
                    type = 3 /* WasiFileType.DIRECTORY */;
                }
                else if (entries[i].isSymbolicLink()) {
                    type = 7 /* WasiFileType.SYMBOLIC_LINK */;
                }
                else if (entries[i].isCharacterDevice()) {
                    type = 2 /* WasiFileType.CHARACTER_DEVICE */;
                }
                else if (entries[i].isBlockDevice()) {
                    type = 1 /* WasiFileType.BLOCK_DEVICE */;
                }
                else if (entries[i].isSocket()) {
                    type = 6 /* WasiFileType.SOCKET_STREAM */;
                }
                else {
                    type = 0 /* WasiFileType.UNKNOWN */;
                }
                entryView.setUint8(20, type);
                entryData.set(nameData, 24);
                const data = entryData.slice(0, Math.min(entryData.length, buf_len - bufferUsed));
                HEAPU8.set(data, buf + bufferUsed);
                bufferUsed += data.byteLength;
            }
            view.setUint32(bufused, bufferUsed, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_readdir(fd, buf, buf_len, cookie, bufused) {
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (buf === 0 || bufused === 0)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READDIR, BigInt(0));
            const fs = getFs(this);
            const entries = await fs.promises.readdir(fileDescriptor.realPath, { withFileTypes: true });
            const { HEAPU8, view } = getMemory(this);
            let bufferUsed = 0;
            for (let i = Number(cookie); i < entries.length; i++) {
                const nameData = encoder.encode(entries[i].name);
                const entryInfo = await fs.promises.stat(resolve(fileDescriptor.realPath, entries[i].name), { bigint: true });
                const entryData = new Uint8Array(24 + nameData.byteLength);
                const entryView = new DataView(entryData.buffer);
                entryView.setBigUint64(0, BigInt(i + 1), true);
                entryView.setBigUint64(8, BigInt(entryInfo.ino ? entryInfo.ino : 0), true);
                entryView.setUint32(16, nameData.byteLength, true);
                let type;
                if (entries[i].isFile()) {
                    type = 4 /* WasiFileType.REGULAR_FILE */;
                }
                else if (entries[i].isDirectory()) {
                    type = 3 /* WasiFileType.DIRECTORY */;
                }
                else if (entries[i].isSymbolicLink()) {
                    type = 7 /* WasiFileType.SYMBOLIC_LINK */;
                }
                else if (entries[i].isCharacterDevice()) {
                    type = 2 /* WasiFileType.CHARACTER_DEVICE */;
                }
                else if (entries[i].isBlockDevice()) {
                    type = 1 /* WasiFileType.BLOCK_DEVICE */;
                }
                else if (entries[i].isSocket()) {
                    type = 6 /* WasiFileType.SOCKET_STREAM */;
                }
                else {
                    type = 0 /* WasiFileType.UNKNOWN */;
                }
                entryView.setUint8(20, type);
                entryData.set(nameData, 24);
                const data = entryData.slice(0, Math.min(entryData.length, buf_len - bufferUsed));
                HEAPU8.set(data, buf + bufferUsed);
                bufferUsed += data.byteLength;
            }
            view.setUint32(bufused, bufferUsed, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_renumber', function fd_renumber(from, to) {
            const wasi = _wasi.get(this);
            wasi.fds.renumber(to, from);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_renumber(from, to) {
            const wasi = _wasi.get(this);
            await wasi.fds.renumber(to, from);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32'], ['i32']);
        defineImport('fd_sync', function fd_sync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SYNC, BigInt(0));
            const fs = getFs(this);
            fs.fsyncSync(fileDescriptor.fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_sync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SYNC, BigInt(0));
            await fileDescriptor.fd.sync();
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_write', function fd_write(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            let nwritten;
            if (fd === 1 || fd === 2) {
                nwritten = fileDescriptor.write(buffer);
            }
            else {
                const fs = getFs(this);
                nwritten = fs.writeSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(fileDescriptor.pos));
                fileDescriptor.pos += BigInt(nwritten);
            }
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_write(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            let nwritten;
            if (fd === 1 || fd === 2) {
                nwritten = fileDescriptor.write(buffer);
            }
            else {
                nwritten = await (await (fileDescriptor.fd.write(buffer, 0, buffer.length, Number(fileDescriptor.pos)))).bytesWritten;
                fileDescriptor.pos += BigInt(nwritten);
            }
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_create_directory', function path_create_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_CREATE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.mkdirSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_create_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_CREATE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.mkdir(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        defineImport('path_filestat_get', function path_filestat_get(fd, flags, path, path_len, filestat) {
            path = Number(path);
            path_len = Number(path_len);
            filestat = Number(filestat);
            if (path === 0 || filestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_GET, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            pathString = resolve(fileDescriptor.realPath, pathString);
            let stat;
            if ((flags & 1) === 1) {
                stat = fs.statSync(pathString, { bigint: true });
            }
            else {
                stat = fs.lstatSync(pathString, { bigint: true });
            }
            toFileStat(view, filestat, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_filestat_get(fd, flags, path, path_len, filestat) {
            path = Number(path);
            path_len = Number(path_len);
            filestat = Number(filestat);
            if (path === 0 || filestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_GET, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            pathString = resolve(fileDescriptor.realPath, pathString);
            let stat;
            if ((flags & 1) === 1) {
                stat = await fs.promises.stat(pathString, { bigint: true });
            }
            else {
                stat = await fs.promises.lstat(pathString, { bigint: true });
            }
            toFileStat(view, filestat, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_filestat_set_times', function path_filestat_set_times(fd, flags, path, path_len, atim, mtim, fst_flags) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0)
                return 28 /* WasiErrno.EINVAL */;
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_SET_TIMES, BigInt(0));
            if (validateFstFlagsOrReturn(fst_flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const fs = getFs(this);
            const resolvedPath = resolvePathSync(fs, fileDescriptor, decoder.decode(unsharedSlice(HEAPU8, path, path + path_len)), flags);
            if ((fst_flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((fst_flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            fs.utimesSync(resolvedPath, Number(atim), Number(mtim));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_filestat_set_times(fd, flags, path, path_len, atim, mtim, fst_flags) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0)
                return 28 /* WasiErrno.EINVAL */;
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_SET_TIMES, BigInt(0));
            if (validateFstFlagsOrReturn(fst_flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const fs = getFs(this);
            const resolvedPath = await resolvePathAsync(fs, fileDescriptor, decoder.decode(unsharedSlice(HEAPU8, path, path + path_len)), flags);
            if ((fst_flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((fst_flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            await fs.promises.utimes(resolvedPath, Number(atim), Number(mtim));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i64', 'i64', 'i32'], ['i32']);
        defineImport('path_link', function path_link(old_fd, old_flags, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE | WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const fs = getFs(this);
            const resolvedOldPath = resolvePathSync(fs, oldWrap, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)), old_flags);
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            fs.linkSync(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_link(old_fd, old_flags, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE | WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const fs = getFs(this);
            const resolvedOldPath = await resolvePathAsync(fs, oldWrap, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)), old_flags);
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            await fs.promises.link(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        function pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags) {
            const read = (fs_rights_base & (WasiRights.FD_READ |
                WasiRights.FD_READDIR)) !== BigInt(0);
            const write = (fs_rights_base & (WasiRights.FD_DATASYNC |
                WasiRights.FD_WRITE |
                WasiRights.FD_ALLOCATE |
                WasiRights.FD_FILESTAT_SET_SIZE)) !== BigInt(0);
            let flags = write ? read ? 2 /* FileControlFlag.O_RDWR */ : 1 /* FileControlFlag.O_WRONLY */ : 0 /* FileControlFlag.O_RDONLY */;
            let needed_base = WasiRights.PATH_OPEN;
            let needed_inheriting = fs_rights_base | fs_rights_inheriting;
            if ((o_flags & 1 /* WasiFileControlFlag.O_CREAT */) !== 0) {
                flags |= 64 /* FileControlFlag.O_CREAT */;
                needed_base |= WasiRights.PATH_CREATE_FILE;
            }
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0) {
                flags |= 65536 /* FileControlFlag.O_DIRECTORY */;
            }
            if ((o_flags & 4 /* WasiFileControlFlag.O_EXCL */) !== 0) {
                flags |= 128 /* FileControlFlag.O_EXCL */;
            }
            if ((o_flags & 8 /* WasiFileControlFlag.O_TRUNC */) !== 0) {
                flags |= 512 /* FileControlFlag.O_TRUNC */;
                needed_base |= WasiRights.PATH_FILESTAT_SET_SIZE;
            }
            if ((fs_flags & 1 /* WasiFdFlag.APPEND */) !== 0) {
                flags |= 1024 /* FileControlFlag.O_APPEND */;
            }
            if ((fs_flags & 2 /* WasiFdFlag.DSYNC */) !== 0) {
                // flags |= FileControlFlag.O_DSYNC;
                needed_inheriting |= WasiRights.FD_DATASYNC;
            }
            if ((fs_flags & 4 /* WasiFdFlag.NONBLOCK */) !== 0) {
                flags |= 2048 /* FileControlFlag.O_NONBLOCK */;
            }
            if ((fs_flags & 8 /* WasiFdFlag.RSYNC */) !== 0) {
                flags |= 1052672 /* FileControlFlag.O_SYNC */;
                needed_inheriting |= WasiRights.FD_SYNC;
            }
            if ((fs_flags & 16 /* WasiFdFlag.SYNC */) !== 0) {
                flags |= 1052672 /* FileControlFlag.O_SYNC */;
                needed_inheriting |= WasiRights.FD_SYNC;
            }
            if (write && (flags & (1024 /* FileControlFlag.O_APPEND */ | 512 /* FileControlFlag.O_TRUNC */)) === 0) {
                needed_inheriting |= WasiRights.FD_SEEK;
            }
            return { flags, needed_base, needed_inheriting };
        }
        defineImport('path_open', function path_open(dirfd, dirflags, path, path_len, o_flags, fs_rights_base, fs_rights_inheriting, fs_flags, fd) {
            path = Number(path);
            fd = Number(fd);
            if (path === 0 || fd === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            path_len = Number(path_len);
            fs_rights_base = BigInt(fs_rights_base);
            fs_rights_inheriting = BigInt(fs_rights_inheriting);
            const { flags: flagsRes, needed_base: neededBase, needed_inheriting: neededInheriting } = pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(dirfd, neededBase, neededInheriting);
            const memory = getMemory(this);
            const HEAPU8 = memory.HEAPU8;
            const pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            const resolved_path = resolvePathSync(fs, fileDescriptor, pathString, dirflags);
            const r = fs.openSync(resolved_path, flagsRes, 0o666);
            const filetype = wasi.fds.getFileTypeByFd(r);
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0 && filetype !== 3 /* WasiFileType.DIRECTORY */) {
                return 54 /* WasiErrno.ENOTDIR */;
            }
            const { base: max_base, inheriting: max_inheriting } = getRights(wasi.fds.stdio, r, flagsRes, filetype);
            const wrap = wasi.fds.insert(r, resolved_path, resolved_path, filetype, fs_rights_base & max_base, fs_rights_inheriting & max_inheriting, 0);
            const stat = fs.fstatSync(r, { bigint: true });
            if (stat.isFile()) {
                wrap.size = stat.size;
                if ((flagsRes & 1024 /* FileControlFlag.O_APPEND */) !== 0) {
                    wrap.pos = stat.size;
                }
            }
            const view = memory.view;
            view.setInt32(fd, wrap.id, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_open(dirfd, dirflags, path, path_len, o_flags, fs_rights_base, fs_rights_inheriting, fs_flags, fd) {
            path = Number(path);
            fd = Number(fd);
            if (path === 0 || fd === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            path_len = Number(path_len);
            fs_rights_base = BigInt(fs_rights_base);
            fs_rights_inheriting = BigInt(fs_rights_inheriting);
            const { flags: flagsRes, needed_base: neededBase, needed_inheriting: neededInheriting } = pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(dirfd, neededBase, neededInheriting);
            const memory = getMemory(this);
            const HEAPU8 = memory.HEAPU8;
            const pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            const resolved_path = await resolvePathAsync(fs, fileDescriptor, pathString, dirflags);
            const r = await fs.promises.open(resolved_path, flagsRes, 0o666);
            const filetype = await wasi.fds.getFileTypeByFd(r);
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0 && filetype !== 3 /* WasiFileType.DIRECTORY */) {
                return 54 /* WasiErrno.ENOTDIR */;
            }
            const { base: max_base, inheriting: max_inheriting } = getRights(wasi.fds.stdio, r.fd, flagsRes, filetype);
            const wrap = wasi.fds.insert(r, resolved_path, resolved_path, filetype, fs_rights_base & max_base, fs_rights_inheriting & max_inheriting, 0);
            const stat = await r.stat({ bigint: true });
            if (stat.isFile()) {
                wrap.size = stat.size;
                if ((flagsRes & 1024 /* FileControlFlag.O_APPEND */) !== 0) {
                    wrap.pos = stat.size;
                }
            }
            const view = memory.view;
            view.setInt32(fd, wrap.id, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i64', 'i64', 'i32', 'i32'], ['i32']);
        defineImport('path_readlink', function path_readlink(fd, path, path_len, buf, buf_len, bufused) {
            path = Number(path);
            path_len = Number(path_len);
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (path === 0 || buf === 0 || bufused === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_READLINK, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            const link = fs.readlinkSync(pathString);
            const linkData = encoder.encode(link);
            const len = Math.min(linkData.length, buf_len);
            if (len >= buf_len)
                return 42 /* WasiErrno.ENOBUFS */;
            HEAPU8.set(linkData.subarray(0, len), buf);
            HEAPU8[buf + len] = 0;
            view.setUint32(bufused, len, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_readlink(fd, path, path_len, buf, buf_len, bufused) {
            path = Number(path);
            path_len = Number(path_len);
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (path === 0 || buf === 0 || bufused === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_READLINK, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            const link = await fs.promises.readlink(pathString);
            const linkData = encoder.encode(link);
            const len = Math.min(linkData.length, buf_len);
            if (len >= buf_len)
                return 42 /* WasiErrno.ENOBUFS */;
            HEAPU8.set(linkData.subarray(0, len), buf);
            HEAPU8[buf + len] = 0;
            view.setUint32(bufused, len, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_remove_directory', function path_remove_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_REMOVE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.rmdirSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_remove_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_REMOVE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.rmdir(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        defineImport('path_rename', function path_rename(old_fd, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE | WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const resolvedOldPath = resolve(oldWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)));
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            const fs = getFs(this);
            fs.renameSync(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_rename(old_fd, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE | WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const resolvedOldPath = resolve(oldWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)));
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            const fs = getFs(this);
            await fs.promises.rename(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_symlink', function path_symlink(old_path, old_path_len, fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_SYMLINK, BigInt(0));
            const oldPath = decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len));
            let newPath = decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len));
            newPath = resolve(fileDescriptor.realPath, newPath);
            const fs = getFs(this);
            fs.symlinkSync(oldPath, newPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_symlink(old_path, old_path_len, fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_SYMLINK, BigInt(0));
            const oldPath = decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len));
            let newPath = decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len));
            newPath = resolve(fileDescriptor.realPath, newPath);
            const fs = getFs(this);
            await fs.promises.symlink(oldPath, newPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_unlink_file', function path_unlink_file(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_UNLINK_FILE, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.unlinkSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_unlink_file(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_UNLINK_FILE, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.unlink(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        this._setMemory = function setMemory(m) {
            if (!(m instanceof _WebAssembly.Memory)) {
                throw new TypeError('"instance.exports.memory" property must be a WebAssembly.Memory');
            }
            _memory.set(_this, extendMemory(m));
        };
    }
    static createSync(args, env, preopens, stdio, fs, print, printErr) {
        const fds = new SyncTable({
            size: 3,
            in: stdio[0],
            out: stdio[1],
            err: stdio[2],
            fs,
            print,
            printErr
        });
        const _this = new WASI$1(args, env, fds, false, fs);
        if (preopens.length > 0) {
            for (let i = 0; i < preopens.length; ++i) {
                const realPath = fs.realpathSync(preopens[i].realPath, 'utf8');
                const fd = fs.openSync(realPath, 'r', 0o666);
                fds.insertPreopen(fd, preopens[i].mappedPath, realPath);
            }
        }
        return _this;
    }
    static async createAsync(args, env, preopens, stdio, fs, print, printErr, asyncify) {
        const fds = new AsyncTable({
            size: 3,
            in: stdio[0],
            out: stdio[1],
            err: stdio[2],
            print,
            printErr
        });
        const _this = new WASI$1(args, env, fds, true, fs, asyncify);
        if (preopens.length > 0) {
            for (let i = 0; i < preopens.length; ++i) {
                const entry = preopens[i];
                const realPath = await fs.promises.realpath(entry.realPath);
                const fd = await fs.promises.open(realPath, 'r', 0o666);
                await fds.insertPreopen(fd, entry.mappedPath, realPath);
            }
        }
        return _this;
    }
}

// eslint-disable-next-line spaced-comment
const kEmptyObject = /*#__PURE__*/ Object.freeze(/*#__PURE__*/ Object.create(null));
const kExitCode = Symbol('kExitCode');
const kSetMemory = Symbol('kSetMemory');
const kStarted = Symbol('kStarted');
const kInstance = Symbol('kInstance');
const kBindingName = Symbol('kBindingName');
function setupInstance(self, instance) {
    validateObject(instance, 'instance');
    validateObject(instance.exports, 'instance.exports');
    self[kInstance] = instance;
    self[kSetMemory](instance.exports.memory);
}
function validateOptions(options) {
    var _a;
    validateObject(options, 'options');
    let _WASI;
    if (options.version !== undefined) {
        validateString(options.version, 'options.version');
        switch (options.version) {
            case 'unstable':
                _WASI = WASI$1;
                this[kBindingName] = 'wasi_unstable';
                break;
            case 'preview1':
                _WASI = WASI$1;
                this[kBindingName] = 'wasi_snapshot_preview1';
                break;
            default:
                throw new TypeError(`unsupported WASI version "${options.version}"`);
        }
    }
    else {
        _WASI = WASI$1;
        this[kBindingName] = 'wasi_snapshot_preview1';
    }
    if (options.args !== undefined) {
        validateArray(options.args, 'options.args');
    }
    const args = ((_a = options.args) !== null && _a !== void 0 ? _a : []).map(String);
    const env = [];
    if (options.env !== undefined) {
        validateObject(options.env, 'options.env');
        Object.entries(options.env).forEach(({ 0: key, 1: value }) => {
            if (value !== undefined) {
                env.push(`${key}=${value}`);
            }
        });
    }
    const preopens = [];
    if (options.preopens !== undefined) {
        validateObject(options.preopens, 'options.preopens');
        Object.entries(options.preopens).forEach(({ 0: key, 1: value }) => preopens.push({ mappedPath: String(key), realPath: String(value) }));
    }
    if (preopens.length > 0) {
        if (options.fs === undefined) {
            throw new Error('filesystem is disabled, can not preopen directory');
        }
        try {
            validateObject(options.fs, 'options.fs');
        }
        catch (_) {
            throw new TypeError('Node.js fs like implementation is not provided');
        }
    }
    // if (options.filesystem !== undefined) {
    //   validateObject(options.filesystem, 'options.filesystem')
    //   validateString(options.filesystem.type, 'options.filesystem.type')
    //   if (options.filesystem.type !== 'memfs' && options.filesystem.type !== 'file-system-access-api') {
    //     throw new Error(`Filesystem type ${(options.filesystem as any).type as string} is not supported, only "memfs" and "file-system-access-api" is supported currently`)
    //   }
    //   try {
    //     validateObject(options.filesystem.fs, 'options.filesystem.fs')
    //   } catch (_) {
    //     throw new Error('Node.js fs like implementation is not provided')
    //   }
    // }
    if (options.print !== undefined)
        validateFunction(options.print, 'options.print');
    if (options.printErr !== undefined)
        validateFunction(options.printErr, 'options.printErr');
    if (options.returnOnExit !== undefined) {
        validateBoolean(options.returnOnExit, 'options.returnOnExit');
    }
    // const { stdin = 0, stdout = 1, stderr = 2 } = options
    // validateInt32(stdin, 'options.stdin', 0)
    // validateInt32(stdout, 'options.stdout', 0)
    // validateInt32(stderr, 'options.stderr', 0)
    // const stdio = [stdin, stdout, stderr] as const
    const stdio = [0, 1, 2];
    return {
        args,
        env,
        preopens,
        stdio,
        _WASI
    };
}
function initWASI(setMemory, wrap) {
    this[kSetMemory] = setMemory;
    this.wasiImport = wrap;
    this[kStarted] = false;
    this[kExitCode] = 0;
    this[kInstance] = undefined;
}
/** @public */
class WASI {
    constructor(options = kEmptyObject) {
        const { args, env, preopens, stdio, _WASI } = validateOptions.call(this, options);
        const wrap = _WASI.createSync(args, env, preopens, stdio, options.fs, options.print, options.printErr);
        const setMemory = wrap._setMemory;
        delete wrap._setMemory;
        initWASI.call(this, setMemory, wrap);
        if (options.returnOnExit) {
            wrap.proc_exit = wasiReturnOnProcExit.bind(this);
        }
    }
    // Must not export _initialize, must export _start
    start(instance) {
        if (this[kStarted]) {
            throw new Error('WASI instance has already started');
        }
        this[kStarted] = true;
        setupInstance(this, instance);
        const { _start, _initialize } = this[kInstance].exports;
        validateFunction(_start, 'instance.exports._start');
        validateUndefined(_initialize, 'instance.exports._initialize');
        let ret;
        try {
            ret = _start();
        }
        catch (err) {
            if (err !== kExitCode) {
                throw err;
            }
        }
        if (ret instanceof Promise) {
            return ret.then(() => this[kExitCode], (err) => {
                if (err !== kExitCode) {
                    throw err;
                }
                return this[kExitCode];
            });
        }
        return this[kExitCode];
    }
    // Must not export _start, may optionally export _initialize
    initialize(instance) {
        if (this[kStarted]) {
            throw new Error('WASI instance has already started');
        }
        this[kStarted] = true;
        setupInstance(this, instance);
        const { _start, _initialize } = this[kInstance].exports;
        validateUndefined(_start, 'instance.exports._start');
        if (_initialize !== undefined) {
            validateFunction(_initialize, 'instance.exports._initialize');
            return _initialize();
        }
    }
    getImportObject() {
        return { [this[kBindingName]]: this.wasiImport };
    }
}
function wasiReturnOnProcExit(rval) {
    this[kExitCode] = rval;
    // eslint-disable-next-line @typescript-eslint/no-throw-literal
    throw kExitCode;
}

var fsProxy = {};

var hasRequiredFsProxy;

function requireFsProxy () {
	if (hasRequiredFsProxy) return fsProxy;
	hasRequiredFsProxy = 1;
	// @ts-check

	/**
	 * @param {unknown} value
	 */
	const getType = (value) => {
	  if (value === undefined) return 0
	  if (value === null) return 1
	  const t = typeof value;
	  if (t === 'boolean') return 2
	  if (t === 'number') return 3
	  if (t === 'string') return 4
	  if (t === 'object') return 6
	  if (t === 'bigint') return 9
	  return -1
	};

	/**
	 * @param {import('memfs').IFs} memfs
	 * @param {any} value
	 * @param {ReturnType<typeof getType>} type
	 * @returns {Uint8Array}
	 */
	const encodeValue = (memfs, value, type) => {
	  switch (type) {
	    case 0:
	    case 1:
	      return new Uint8Array(0)
	    case 2: {
	      const view = new Int32Array(1);
	      view[0] = value ? 1 : 0;
	      return new Uint8Array(view.buffer)
	    }
	    case 3: {
	      const view = new Float64Array(1);
	      view[0] = value;
	      return new Uint8Array(view.buffer)
	    }
	    case 4: {
	      const view = new TextEncoder().encode(value);
	      return view
	    }
	    case 6: {
	      const [entry] = Object.entries(memfs).filter(([_, v]) => v === value.constructor)[0] ?? [];
	      if (entry) {
	        Object.defineProperty(value, '__constructor__', {
	          configurable: true,
	          writable: true,
	          enumerable: true,
	          value: entry
	        });
	      }

	      const json = JSON.stringify(value, (_, value) => {
	        if (typeof value === 'bigint') {
	          return `BigInt(${String(value)})`
	        }
	        if (value instanceof Error) {
	          return {
	            ...value,
	            message: value.message,
	            stack: value.stack,
	            __error__: value.constructor.name,
	          }
	        }
	        return value
	      });
	      const view = new TextEncoder().encode(json);
	      return view
	    }
	    case 9: {
	      const view = new BigInt64Array(1);
	      view[0] = value;
	      return new Uint8Array(view.buffer)
	    }
	    case -1:
	    default:
	      throw new Error('unsupported data')
	  }
	};

	/**
	 * @param {typeof import('memfs')} memfs
	 * @param {Uint8Array} payload
	 * @param {number} type
	 * @returns {any}
	 */
	const decodeValue = (memfs, payload, type) => {
	  if (type === 0) return undefined
	  if (type === 1) return null
	  if (type === 2) return Boolean(new Int32Array(payload.buffer, payload.byteOffset, 1)[0])
	  if (type === 3) return new Float64Array(payload.buffer, payload.byteOffset, 1)[0]
	  if (type === 4) return new TextDecoder().decode(payload.slice())
	  if (type === 6) {
	    const obj = JSON.parse(new TextDecoder().decode(payload.slice()), (_key, value) => {
	      if (typeof value === 'string') {
	        const matched = value.match(/^BigInt\((-?\d+)\)$/);
	        if (matched && matched[1]) {
	          return BigInt(matched[1])
	        }
	      }
	      return value
	    });
	    if (obj.__constructor__) {
	      const ctor = obj.__constructor__;
	      delete obj.__constructor__;
	      Object.setPrototypeOf(obj, memfs[ctor].prototype);
	    }
	    if (obj.__error__) {
	      const name = obj.__error__;
	      const ErrorConstructor = globalThis[name] || Error;
	      delete obj.__error__;
	      const err = new ErrorConstructor(obj.message);
	      Object.defineProperty(err, 'stack', {
	        configurable: true,
	        enumerable: false,
	        writable: true,
	        value: err.stack
	      });
	      Object.defineProperty(err, Symbol.toStringTag, {
	        configurable: true,
	        enumerable: false,
	        writable: true,
	        value: name
	      });
	      for (const [k, v] of Object.entries(obj)) {
	        if (k === 'message' || k === 'stack') continue
	        err[k] = v;
	      }
	      return err
	    }
	    return obj
	  }
	  if (type === 9) return new BigInt64Array(payload.buffer, payload.byteOffset, 1)[0]
	  throw new Error('unsupported data')
	};

	/**
	 * @param {import('memfs').IFs} fs
	 * @returns {(e: { data: { __fs__: { sab: Int32Array, type: keyof import('memfs').IFs, payload: any[] } } }) => void}
	 */
	// oxlint-disable-next-line no-unused-vars -- fixed in an upcoming release
	fsProxy.createOnMessage = (fs) => function onMessage(e) {
	  if (e.data.__fs__) {
	    /**
	     * 0..4                    status(int32_t):        21(waiting) 0(success) 1(error)
	     * 5..8                    type(napi_valuetype):   0(undefined) 1(null) 2(boolean) 3(number) 4(string) 6(jsonstring) 9(bigint) -1(unsupported)
	     * 9..16                   payload_size(uint32_t)  <= 1024
	     * 16..16 + payload_size   payload_content
	     */
	    const { sab, type, payload } = e.data.__fs__;
	    const fn = fs[type];
	    try {
	      const ret = fn.apply(fs, payload);
	      const t = getType(ret);
	      Atomics.store(sab, 1, t);
	      const v = encodeValue(fs, ret, t);
	      Atomics.store(sab, 2, v.length);
	      new Uint8Array(sab.buffer).set(v, 16);
	      Atomics.store(sab, 0, 0); // success

	    } catch (/** @type {any} */ err) {
	      const t = getType(err);
	      Atomics.store(sab, 1, t);
	      const v = encodeValue(fs, err, t);
	      Atomics.store(sab, 2, v.length);
	      new Uint8Array(sab.buffer).set(v, 16);
	      Atomics.store(sab, 0, 1); // error
	    } finally {
	      Atomics.notify(sab, 0);
	    }
	  }
	};

	/**
	 * @param {typeof import('memfs')} memfs
	 */
	fsProxy.createFsProxy = (memfs) => new Proxy({}, {
	  get (_target, p, _receiver) {
	    /**
	     * @param {any[]} args
	     */
	    return function (...args) {
	      const sab = new SharedArrayBuffer(16 + 10240);
	      const i32arr = new Int32Array(sab);
	      Atomics.store(i32arr, 0, 21);

	      postMessage({
	        __fs__: {
	          sab: i32arr,
	          type: p,
	          payload: args
	        }
	      });

	      Atomics.wait(i32arr, 0, 21);

	      const status = Atomics.load(i32arr, 0);
	      const type = Atomics.load(i32arr, 1);
	      const size = Atomics.load(i32arr, 2);
	      const content = new Uint8Array(sab, 16, size);
	      const value = decodeValue(memfs, content, type);
	      if (status === 1) {
	        throw value
	      }
	      return value
	    }
	  }
	});
	return fsProxy;
}

var fsProxyExports = requireFsProxy();

var createFsProxy = fsProxyExports.createFsProxy;
var createOnMessage = fsProxyExports.createOnMessage;
export { MessageHandler, WASI, createFsProxy, createOnMessage, getDefaultContext, instantiateNapiModule, instantiateNapiModuleSync };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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