import {
  readFile,
  writeFile,
  copyFile,
  mkdir,
  unlink,
  stat,
  readdir,
} from 'node:fs'
import { createRequire } from 'node:module'
import { promisify } from 'node:util'

import { debug } from './log.js'

const require = createRequire(import.meta.url)
// NOTE:
//   import pkgJson from '@napi-rs/cli/package.json' assert { type: 'json' }
//   is experimental feature now, avoid using it.
//   see: https://nodejs.org/api/esm.html#import-assertions
// eslint-disable-next-line import/no-extraneous-dependencies
const pkgJson = require('@napi-rs/cli/package.json')

export const readFileAsync = promisify(readFile)
export const writeFileAsync = promisify(writeFile)
export const unlinkAsync = promisify(unlink)
export const copyFileAsync = promisify(copyFile)
export const mkdirAsync = promisify(mkdir)
export const statAsync = promisify(stat)
export const readdirAsync = promisify(readdir)

export async function fileExists(path: string) {
  const exists = await statAsync(path)
    .then(() => true)
    .catch(() => false)
  return exists
}

export function pick<O, K extends keyof O>(o: O, ...keys: K[]): Pick<O, K> {
  return keys.reduce((acc, key) => {
    acc[key] = o[key]
    return acc
  }, {} as O)
}

export async function updatePackageJson(
  path: string,
  partial: Record<string, any>,
) {
  const exists = await fileExists(path)
  if (!exists) {
    debug(`File not exists ${path}`)
    return
  }
  const old = require(path)
  await writeFileAsync(path, JSON.stringify({ ...old, ...partial }, null, 2))
}

export const CLI_VERSION = pkgJson.version
