// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion'

export abstract class BaseUniversalizeCommand extends Command {
  static paths = [['universalize']]

  static usage = Command.Usage({
    description: 'Combile built binaries into one universal binary',
  })

  cwd = Option.String('--cwd', process.cwd(), {
    description:
      'The working directory of where napi command will be executed in, all other paths options are relative to this path',
  })

  configPath?: string = Option.String('--config-path,-c', {
    description: 'Path to `napi` config json file',
  })

  packageJsonPath = Option.String('--package-json-path', 'package.json', {
    description: 'Path to `package.json`',
  })

  outputDir = Option.String('--output-dir,-o', './', {
    description:
      'Path to the folder where all built `.node` files put, same as `--output-dir` of build command',
  })

  getOptions() {
    return {
      cwd: this.cwd,
      configPath: this.configPath,
      packageJsonPath: this.packageJsonPath,
      outputDir: this.outputDir,
    }
  }
}

/**
 * Combile built binaries into one universal binary
 */
export interface UniversalizeOptions {
  /**
   * The working directory of where napi command will be executed in, all other paths options are relative to this path
   *
   * @default process.cwd()
   */
  cwd?: string
  /**
   * Path to `napi` config json file
   */
  configPath?: string
  /**
   * Path to `package.json`
   *
   * @default 'package.json'
   */
  packageJsonPath?: string
  /**
   * Path to the folder where all built `.node` files put, same as `--output-dir` of build command
   *
   * @default './'
   */
  outputDir?: string
}

export function applyDefaultUniversalizeOptions(options: UniversalizeOptions) {
  return {
    cwd: process.cwd(),
    packageJsonPath: 'package.json',
    outputDir: './',
    ...options,
  }
}
