// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion'

export abstract class BaseRenameCommand extends Command {
  static paths = [['rename']]

  static usage = Command.Usage({
    description: 'Rename the NAPI-RS project',
  })

  cwd = Option.String('--cwd', process.cwd(), {
    description:
      'The working directory of where napi command will be executed in, all other paths options are relative to this path',
  })

  configPath?: string = Option.String('--config-path,-c', {
    description: 'Path to `napi` config json file',
  })

  packageJsonPath = Option.String('--package-json-path', 'package.json', {
    description: 'Path to `package.json`',
  })

  npmDir = Option.String('--npm-dir', 'npm', {
    description: 'Path to the folder where the npm packages put',
  })

  $$name?: string = Option.String('--name,-n', {
    description: 'The new name of the project',
  })

  binaryName?: string = Option.String('--binary-name,-b', {
    description: 'The new binary name *.node files',
  })

  packageName?: string = Option.String('--package-name', {
    description: 'The new package name of the project',
  })

  manifestPath = Option.String('--manifest-path', 'Cargo.toml', {
    description: 'Path to `Cargo.toml`',
  })

  repository?: string = Option.String('--repository', {
    description: 'The new repository of the project',
  })

  description?: string = Option.String('--description', {
    description: 'The new description of the project',
  })

  getOptions() {
    return {
      cwd: this.cwd,
      configPath: this.configPath,
      packageJsonPath: this.packageJsonPath,
      npmDir: this.npmDir,
      name: this.$$name,
      binaryName: this.binaryName,
      packageName: this.packageName,
      manifestPath: this.manifestPath,
      repository: this.repository,
      description: this.description,
    }
  }
}

/**
 * Rename the NAPI-RS project
 */
export interface RenameOptions {
  /**
   * The working directory of where napi command will be executed in, all other paths options are relative to this path
   *
   * @default process.cwd()
   */
  cwd?: string
  /**
   * Path to `napi` config json file
   */
  configPath?: string
  /**
   * Path to `package.json`
   *
   * @default 'package.json'
   */
  packageJsonPath?: string
  /**
   * Path to the folder where the npm packages put
   *
   * @default 'npm'
   */
  npmDir?: string
  /**
   * The new name of the project
   */
  name?: string
  /**
   * The new binary name *.node files
   */
  binaryName?: string
  /**
   * The new package name of the project
   */
  packageName?: string
  /**
   * Path to `Cargo.toml`
   *
   * @default 'Cargo.toml'
   */
  manifestPath?: string
  /**
   * The new repository of the project
   */
  repository?: string
  /**
   * The new description of the project
   */
  description?: string
}

export function applyDefaultRenameOptions(options: RenameOptions) {
  return {
    cwd: process.cwd(),
    packageJsonPath: 'package.json',
    npmDir: 'npm',
    manifestPath: 'Cargo.toml',
    ...options,
  }
}
