// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion'

export abstract class BasePrePublishCommand extends Command {
  static paths = [['pre-publish'], ['prepublish']]

  static usage = Command.Usage({
    description:
      'Update package.json and copy addons into per platform packages',
  })

  cwd = Option.String('--cwd', process.cwd(), {
    description:
      'The working directory of where napi command will be executed in, all other paths options are relative to this path',
  })

  configPath?: string = Option.String('--config-path,-c', {
    description: 'Path to `napi` config json file',
  })

  packageJsonPath = Option.String('--package-json-path', 'package.json', {
    description: 'Path to `package.json`',
  })

  npmDir = Option.String('--npm-dir,-p', 'npm', {
    description: 'Path to the folder where the npm packages put',
  })

  tagStyle = Option.String('--tag-style,--tagstyle,-t', 'lerna', {
    description: 'git tag style, `npm` or `lerna`',
  })

  ghRelease = Option.Boolean('--gh-release', true, {
    description: 'Whether create GitHub release',
  })

  ghReleaseName?: string = Option.String('--gh-release-name', {
    description: 'GitHub release name',
  })

  ghReleaseId?: string = Option.String('--gh-release-id', {
    description: 'Existing GitHub release id',
  })

  dryRun = Option.Boolean('--dry-run', false, {
    description: 'Dry run without touching file system',
  })

  getOptions() {
    return {
      cwd: this.cwd,
      configPath: this.configPath,
      packageJsonPath: this.packageJsonPath,
      npmDir: this.npmDir,
      tagStyle: this.tagStyle,
      ghRelease: this.ghRelease,
      ghReleaseName: this.ghReleaseName,
      ghReleaseId: this.ghReleaseId,
      dryRun: this.dryRun,
    }
  }
}

/**
 * Update package.json and copy addons into per platform packages
 */
export interface PrePublishOptions {
  /**
   * The working directory of where napi command will be executed in, all other paths options are relative to this path
   *
   * @default process.cwd()
   */
  cwd?: string
  /**
   * Path to `napi` config json file
   */
  configPath?: string
  /**
   * Path to `package.json`
   *
   * @default 'package.json'
   */
  packageJsonPath?: string
  /**
   * Path to the folder where the npm packages put
   *
   * @default 'npm'
   */
  npmDir?: string
  /**
   * git tag style, `npm` or `lerna`
   *
   * @default 'lerna'
   */
  tagStyle?: 'npm' | 'lerna'
  /**
   * Whether create GitHub release
   *
   * @default true
   */
  ghRelease?: boolean
  /**
   * GitHub release name
   */
  ghReleaseName?: string
  /**
   * Existing GitHub release id
   */
  ghReleaseId?: string
  /**
   * Dry run without touching file system
   *
   * @default false
   */
  dryRun?: boolean
}

export function applyDefaultPrePublishOptions(options: PrePublishOptions) {
  return {
    cwd: process.cwd(),
    packageJsonPath: 'package.json',
    npmDir: 'npm',
    tagStyle: 'lerna',
    ghRelease: true,
    dryRun: false,
    ...options,
  }
}
