// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion'
import * as typanion from 'typanion'

export abstract class BaseNewCommand extends Command {
  static paths = [['new']]

  static usage = Command.Usage({
    description: 'Create a new project with pre-configured boilerplate',
  })

  $$path = Option.String({ required: false })

  $$name?: string = Option.String('--name,-n', {
    description:
      'The name of the project, default to the name of the directory if not provided',
  })

  minNodeApiVersion = Option.String('--min-node-api,-v', '4', {
    validator: typanion.isNumber(),
    description: 'The minimum Node-API version to support',
  })

  packageManager = Option.String('--package-manager', 'yarn', {
    description: 'The package manager to use. Only support yarn 4.x for now.',
  })

  license = Option.String('--license,-l', 'MIT', {
    description: 'License for open-sourced project',
  })

  targets = Option.Array('--targets,-t', [], {
    description: 'All targets the crate will be compiled for.',
  })

  enableDefaultTargets = Option.Boolean('--enable-default-targets', true, {
    description: 'Whether enable default targets',
  })

  enableAllTargets = Option.Boolean('--enable-all-targets', false, {
    description: 'Whether enable all targets',
  })

  enableTypeDef = Option.Boolean('--enable-type-def', true, {
    description:
      'Whether enable the `type-def` feature for typescript definitions auto-generation',
  })

  enableGithubActions = Option.Boolean('--enable-github-actions', true, {
    description: 'Whether generate preconfigured GitHub Actions workflow',
  })

  testFramework = Option.String('--test-framework', 'ava', {
    description:
      'The JavaScript test framework to use, only support `ava` for now',
  })

  dryRun = Option.Boolean('--dry-run', false, {
    description: 'Whether to run the command in dry-run mode',
  })

  getOptions() {
    return {
      path: this.$$path,
      name: this.$$name,
      minNodeApiVersion: this.minNodeApiVersion,
      packageManager: this.packageManager,
      license: this.license,
      targets: this.targets,
      enableDefaultTargets: this.enableDefaultTargets,
      enableAllTargets: this.enableAllTargets,
      enableTypeDef: this.enableTypeDef,
      enableGithubActions: this.enableGithubActions,
      testFramework: this.testFramework,
      dryRun: this.dryRun,
    }
  }
}

/**
 * Create a new project with pre-configured boilerplate
 */
export interface NewOptions {
  /**
   * The path where the NAPI-RS project will be created.
   */
  path?: string
  /**
   * The name of the project, default to the name of the directory if not provided
   */
  name?: string
  /**
   * The minimum Node-API version to support
   *
   * @default 4
   */
  minNodeApiVersion?: number
  /**
   * The package manager to use. Only support yarn 4.x for now.
   *
   * @default 'yarn'
   */
  packageManager?: string
  /**
   * License for open-sourced project
   *
   * @default 'MIT'
   */
  license?: string
  /**
   * All targets the crate will be compiled for.
   *
   * @default []
   */
  targets?: string[]
  /**
   * Whether enable default targets
   *
   * @default true
   */
  enableDefaultTargets?: boolean
  /**
   * Whether enable all targets
   *
   * @default false
   */
  enableAllTargets?: boolean
  /**
   * Whether enable the `type-def` feature for typescript definitions auto-generation
   *
   * @default true
   */
  enableTypeDef?: boolean
  /**
   * Whether generate preconfigured GitHub Actions workflow
   *
   * @default true
   */
  enableGithubActions?: boolean
  /**
   * The JavaScript test framework to use, only support `ava` for now
   *
   * @default 'ava'
   */
  testFramework?: string
  /**
   * Whether to run the command in dry-run mode
   *
   * @default false
   */
  dryRun?: boolean
}

export function applyDefaultNewOptions(options: NewOptions) {
  return {
    minNodeApiVersion: 4,
    packageManager: 'yarn',
    license: 'MIT',
    targets: [],
    enableDefaultTargets: true,
    enableAllTargets: false,
    enableTypeDef: true,
    enableGithubActions: true,
    testFramework: 'ava',
    dryRun: false,
    ...options,
  }
}
