// This file is generated by codegen/index.ts
// Do not edit this file manually
import { Command, Option } from 'clipanion'

export abstract class BaseCreateNpmDirsCommand extends Command {
  static paths = [['create-npm-dirs']]

  static usage = Command.Usage({
    description: 'Create npm package dirs for different platforms',
  })

  cwd = Option.String('--cwd', process.cwd(), {
    description:
      'The working directory of where napi command will be executed in, all other paths options are relative to this path',
  })

  configPath?: string = Option.String('--config-path,-c', {
    description: 'Path to `napi` config json file',
  })

  packageJsonPath = Option.String('--package-json-path', 'package.json', {
    description: 'Path to `package.json`',
  })

  npmDir = Option.String('--npm-dir', 'npm', {
    description: 'Path to the folder where the npm packages put',
  })

  dryRun = Option.Boolean('--dry-run', false, {
    description: 'Dry run without touching file system',
  })

  getOptions() {
    return {
      cwd: this.cwd,
      configPath: this.configPath,
      packageJsonPath: this.packageJsonPath,
      npmDir: this.npmDir,
      dryRun: this.dryRun,
    }
  }
}

/**
 * Create npm package dirs for different platforms
 */
export interface CreateNpmDirsOptions {
  /**
   * The working directory of where napi command will be executed in, all other paths options are relative to this path
   *
   * @default process.cwd()
   */
  cwd?: string
  /**
   * Path to `napi` config json file
   */
  configPath?: string
  /**
   * Path to `package.json`
   *
   * @default 'package.json'
   */
  packageJsonPath?: string
  /**
   * Path to the folder where the npm packages put
   *
   * @default 'npm'
   */
  npmDir?: string
  /**
   * Dry run without touching file system
   *
   * @default false
   */
  dryRun?: boolean
}

export function applyDefaultCreateNpmDirsOptions(
  options: CreateNpmDirsOptions,
) {
  return {
    cwd: process.cwd(),
    packageJsonPath: 'package.json',
    npmDir: 'npm',
    dryRun: false,
    ...options,
  }
}
