import { execSync } from 'node:child_process';
import fs from 'node:fs';
export function parseMetadata(manifestPath) {
    if (!fs.existsSync(manifestPath)) {
        throw new Error(`No crate found in manifest: ${manifestPath}`);
    }
    const cmd = `cargo metadata --manifest-path ${manifestPath} --format-version 1 --no-deps`;
    try {
        const output = execSync(cmd, {
            encoding: 'utf-8',
        });
        return JSON.parse(output);
    }
    catch (e) {
        throw new Error(`Failed to parse cargo metadata output by command: ${cmd}`, {
            cause: e,
        });
    }
}
//# sourceMappingURL=metadata.js.map