export type CrateTargetKind = 'bin' | 'example' | 'test' | 'bench' | 'lib' | 'rlib' | 'cdylib' | 'custom-build';
export interface CrateTarget {
    name: string;
    kind: CrateTargetKind[];
    crate_types: CrateTargetKind[];
}
export interface Crate {
    id: string;
    name: string;
    src_path: string;
    version: string;
    edition: string;
    targets: CrateTarget[];
    features: Record<string, string[]>;
    manifest_path: string;
}
export interface CargoWorkspaceMetadata {
    version: number;
    packages: Crate[];
    workspace_members: string[];
    target_directory: string;
    workspace_root: string;
}
export declare function parseMetadata(manifestPath: string): CargoWorkspaceMetadata;
