import * as colors from 'colorette';
import rawDebug from 'debug';
// debug('%i', 'This is an info')
rawDebug.formatters.i = (v) => {
    return colors.green(v);
};
export const debugFactory = (namespace) => {
    const debug = rawDebug(`napi:${namespace}`);
    debug.info = (...args) => console.error(colors.black(colors.bgGreen(' INFO ')), ...args);
    debug.warn = (...args) => console.error(colors.black(colors.bgYellow(' WARNING ')), ...args);
    debug.error = (...args) => console.error(colors.white(colors.bgRed(' ERROR ')), ...args.map((arg) => arg instanceof Error ? arg.stack ?? arg.message : arg));
    return debug;
};
export const debug = debugFactory('utils');
//# sourceMappingURL=log.js.map